/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictAdjust;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.predictAdjust.PredictAdjustCondition;
import com.tcbj.crm.predictAdjust.PredictAdjustExcelController;
import com.tcbj.crm.predictAdjust.PredictAdjustService;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.predictConfig.PredictConfigService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/predictAdjust"})
public class PredictAdjustController
extends BaseController {
    @Autowired
    PredictAdjustService service;
    @Autowired
    PredictConfigService predictConfigService;
    @Autowired
    PredictApplyService predictApplyService;
    @Autowired
    PredictAdjustExcelController predictAdjustExcelController;

    @RequestMapping(value={"/list.do"})
    public String list(@ModelAttribute(value="condition") PredictConfigCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        if (con.getState() == null) {
            con.setState("2");
        }
        con.setPredictType("A");
        con.setOrgId(em.getCurrentPartner().getOrganizationid());
        Page page = this.predictConfigService.list(con);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("page", (Object)page);
        return "predictAdjust/list.ftl";
    }

    @RequestMapping(value={"/adjust.do"})
    public String adjust(String configId, Model model) {
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(configId);
        model.addAttribute("predictConfig", (Object)predictConfig);
        return "predictAdjust/adjust.ftl";
    }

    @RequestMapping(value={"/view.do"})
    public String view(String configId, Model model) {
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(configId);
        model.addAttribute("predictConfig", (Object)predictConfig);
        return "predictAdjust/view.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(String configId, Model model) {
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(configId);
        model.addAttribute("predictConfig", (Object)predictConfig);
        return "predictAdjust/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(String configId, String auditOpinion) {
        String state = "";
        if ("approvePass".equals(auditOpinion)) {
            state = "6";
        } else if ("approveNoPass".equals(auditOpinion)) {
            state = "7";
        } else {
            throw new AppException("0010", "\u8bf7\u63d0\u4ea4\u6b63\u786e\u7684\u5ba1\u6279\u610f\u89c1\uff01");
        }
        this.service.approve(configId, state);
        return this.getSuccessResult(null);
    }

    @ResponseBody
    @RequestMapping(value={"/getAdjustData.do"})
    public Page getAdjustData(PredictAdjustCondition con, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        Page page = this.service.queryPredictAdjustItem(con, pageno, rowsize);
        return page;
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody PredictAdjustCondition predictAdjustCon, Model model) throws Exception {
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(predictAdjustCon.getConfigId());
        this.predictAdjustExcelController.savePredictAdjustItems(predictConfig, predictAdjustCon.getPredictAdjustItems(), this.getCurrentEmployee());
        return this.getSuccessResult(null);
    }
}

