/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictAdjust;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.entity.PredictAdjustPartner;
import com.tcbj.crm.entity.PredictAdjustTotal;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.predictAdjust.PredictAdjustCondition;
import com.tcbj.crm.predictAdjust.PredictAdjustExcelService;
import com.tcbj.crm.predictAdjust.PredictAdjustItem;
import com.tcbj.crm.predictAdjust.PredictAdjustService;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.predictConfig.PredictConfigService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.StringUtils;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/predictAdjust"})
public class PredictAdjustExcelController
extends BaseController {
    @Autowired
    PredictAdjustExcelService service;
    @Autowired
    PredictAdjustService predictAdjustService;
    @Autowired
    PredictConfigService predictConfigService;
    @Autowired
    PredictApplyService predictApplyService;

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.POST})
    public String intoExcel(String configId, Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "predictApplyItem");
        String url = "";
        if (filelist.size() <= 0) {
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(" \u8bf7\u4e0a\u4f20Excel\u6587\u4ef6")));
            return "common/iframeRtn.ftl";
        }
        url = filelist.get(0).getRealPath();
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(configId);
        String excelTemplateType = "product";
        if ("0".equals(predictConfig.getAllowAdjust())) {
            excelTemplateType = "customer";
        }
        ArrayList<PredictAdjustItem> predictAdjustItems = new ArrayList<PredictAdjustItem>();
        List<Map<String, Object>> excelDatas = this.service.readSheetByExcel(url, excelTemplateType);
        List<AdjustStockUtil> msglist = this.service.validationExcelData(excelDatas, excelTemplateType, predictAdjustItems, me);
        if (msglist.size() > 0) {
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            rtn.put("code", "-1");
            rtn.put("data", msglist);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        if (StringUtils.isNull(msglist)) {
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6")));
            return "common/iframeRtn.ftl";
        }
        this.savePredictAdjustItems(predictConfig, predictAdjustItems, me);
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        if (excelTemplateType.equals("customer")) {
            rtn.put("code", "100");
            rtn.put("data", predictAdjustItems);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        rtn.put("code", "200");
        rtn.put("data", predictAdjustItems);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }

    public void savePredictAdjustItems(PredictConfig predictConfig, List<PredictAdjustItem> predictAdjustItems, Employee me) throws Exception {
        Class clazz = PredictAdjustTotal.class;
        if ("0".equals(predictConfig.getAllowAdjust())) {
            clazz = PredictAdjustPartner.class;
        }
        this.service.resetPredictAdjust(predictConfig.getId(), this.toBeans(predictConfig.getId(), me, predictAdjustItems, clazz));
    }

    public <T> List<T> toBeans(String configId, Employee me, List<PredictAdjustItem> predictAdjustItems, Class<T> clazz) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            for (String month : monthsQuantity.keySet()) {
                Map<String, Double> adjustTypes = monthsQuantity.get(month);
                for (String adjustType : adjustTypes.keySet()) {
                    Double quantity = Beans.isEmpty((Object)adjustTypes.get(adjustType)) ? null : Double.valueOf(Double.parseDouble(String.valueOf(adjustTypes.get(adjustType))));
                    HashMap<String, Object> beanMap = new HashMap<String, Object>();
                    beanMap.put("productId", predictAdjustItem.getProductId());
                    beanMap.put("orgId", me.getCurrentPartner().getOrganizationid());
                    beanMap.put("month", month);
                    beanMap.put("configId", configId);
                    beanMap.put("quantity", quantity);
                    beanMap.put("adjustType", adjustType);
                    beanMap.put("partnerId", predictAdjustItem.getPartnerId());
                    beanMap.put("partnerNo", predictAdjustItem.getPartnerNo());
                    Method fillInitDataMethod = clazz.getMethod("fillInitData", me.getClass());
                    T bean = clazz.newInstance();
                    fillInitDataMethod.invoke(bean, me);
                    Beans.copy(bean, beanMap);
                    list.add(bean);
                }
            }
        }
        return list;
    }

    @RequestMapping(value={"/exportExcelTemplate.do"}, method={RequestMethod.GET})
    public void exportExcelTemplate(PredictAdjustCondition condition, HttpServletResponse response) throws Exception {
        String queryType = "product";
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(condition.getConfigId());
        HashMap<String, Integer> titleIndex = new HashMap<String, Integer>();
        XSSFWorkbook workbook = new XSSFWorkbook();
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 0);
        CellStyle mediateStyle = workbook.createCellStyle();
        mediateStyle.setAlignment((short)2);
        mediateStyle.setVerticalAlignment((short)1);
        CellStyle redBackgroundStyle = workbook.createCellStyle();
        redBackgroundStyle.cloneStyleFrom(mediateStyle);
        redBackgroundStyle.setFillPattern((short)1);
        redBackgroundStyle.setFillForegroundColor((short)10);
        Sheet sheet = workbook.createSheet();
        Row titleRow_1 = sheet.createRow(0);
        Row titleRow_2 = sheet.createRow(1);
        LinkedHashMap fixationTitle = new LinkedHashMap(){
            {
                this.put("productNo", "\u4ea7\u54c1\u7f16\u7801");
                this.put("productName", "\u4ea7\u54c1\u540d\u79f0");
            }
        };
        if ("0".equals(predictConfig.getAllowAdjust())) {
            fixationTitle.put("partnerNo", "\u5ba2\u6237\u7f16\u7801");
            fixationTitle.put("partnerName", "\u5ba2\u6237\u540d\u79f0");
            queryType = "customer";
        }
        int y = 0;
        for (String key : fixationTitle.keySet()) {
            cellRangeAddress.setFirstRow(0);
            cellRangeAddress.setLastRow(1);
            cellRangeAddress.setFirstColumn(y);
            cellRangeAddress.setLastColumn(y);
            sheet.addMergedRegion(cellRangeAddress);
            Cell titleCell = titleRow_1.createCell(y);
            titleCell.setCellStyle(mediateStyle);
            titleCell.setCellValue((String)fixationTitle.get(key));
            titleIndex.put(key, y);
            ++y;
        }
        LinkedHashMap dynamicTitles = new LinkedHashMap(){
            {
                this.put("customer", new HashMap<String, String>(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.put("name", "\u5ba2\u6237\u9884\u6d4b\u503c");
                        this.put("markedRed", "false");
                    }
                });
                this.put("system", new HashMap<String, String>(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.put("name", "\u7cfb\u7edf\u5efa\u8bae\u503c");
                        this.put("markedRed", "true");
                    }
                });
                this.put("channel", new HashMap<String, String>(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.put("name", "\u6e20\u9053\u90e8\u8c03\u6574\u503c");
                        this.put("markedRed", "true");
                    }
                });
            }
        };
        List<String> months = this.predictConfigService.getMonths(predictConfig);
        int i = 0;
        while (i < months.size()) {
            cellRangeAddress.setFirstRow(0);
            cellRangeAddress.setLastRow(0);
            int FirstColumnIndex = i == 0 ? fixationTitle.keySet().size() : fixationTitle.keySet().size() + i * dynamicTitles.keySet().size();
            int lastColumnIndex = fixationTitle.keySet().size() - 1 + dynamicTitles.keySet().size() * (i + 1);
            cellRangeAddress.setFirstColumn(FirstColumnIndex);
            cellRangeAddress.setLastColumn(lastColumnIndex);
            sheet.addMergedRegion(cellRangeAddress);
            Cell titleCell = titleRow_1.createCell(FirstColumnIndex);
            titleCell.setCellStyle(mediateStyle);
            titleCell.setCellValue(String.valueOf(months.get(i)) + "\u6708\u4efd");
            int j = 0;
            for (String key : dynamicTitles.keySet()) {
                Cell dynamicTitleCell = titleRow_2.createCell(FirstColumnIndex + j);
                Map dynamicTitle = (Map)dynamicTitles.get(key);
                dynamicTitleCell.setCellValue((String)dynamicTitle.get("name"));
                dynamicTitleCell.setCellStyle(mediateStyle);
                if ("true".equals(dynamicTitle.get("markedRed"))) {
                    dynamicTitleCell.setCellStyle(redBackgroundStyle);
                }
                titleIndex.put(String.valueOf(months.get(i)) + "|" + key, FirstColumnIndex + j);
                ++j;
            }
            ++i;
        }
        condition.setQueryType(queryType);
        List predictAdjustItems = this.predictAdjustService.queryPredictAdjustItem(condition, 1, Integer.MAX_VALUE).getList();
        int line = 2;
        for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
            Row row = sheet.createRow(line);
            row.createCell(((Integer)titleIndex.get("productNo")).intValue()).setCellValue(predictAdjustItem.getProductNo());
            row.createCell(((Integer)titleIndex.get("productName")).intValue()).setCellValue(predictAdjustItem.getProductName());
            if ("0".equals(predictConfig.getAllowAdjust())) {
                row.createCell(((Integer)titleIndex.get("partnerNo")).intValue()).setCellValue(predictAdjustItem.getPartnerNo());
                row.createCell(((Integer)titleIndex.get("partnerName")).intValue()).setCellValue(predictAdjustItem.getPartnerName());
            }
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            for (String month : monthsQuantity.keySet()) {
                Map<String, Double> quantitys = monthsQuantity.get(month);
                for (String quantity : quantitys.keySet()) {
                    Integer index = (Integer)titleIndex.get(String.valueOf(month) + "|" + quantity);
                    if (index == null || !Beans.isNotEmpty((Object)quantitys.get(quantity))) continue;
                    row.createCell(index.intValue()).setCellValue(quantitys.get(quantity).doubleValue());
                }
            }
            ++line;
        }
        int i2 = 0;
        while (i2 < sheet.getRow(0).getPhysicalNumberOfCells()) {
            sheet.autoSizeColumn(i2, true);
            ++i2;
        }
        String fileName = URLDecoder.decode("\u9700\u6c42\u9884\u6d4b\u8c03\u6574\u5bfc\u5165\u6a21\u677f", "gbk");
        fileName = new String(fileName.getBytes("gbk"), "iso8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        workbook.write((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/exportPredictProductExcel.do"}, method={RequestMethod.GET})
    public void exportPredictProductExcel(String configId, HttpServletResponse response) throws Exception {
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(configId);
        List<PredictAdjustItem> predictAdjustItems = this.predictAdjustService.getPredictAdjustItemByPredictConfig(predictConfig, "product", null);
        LinkedHashMap<String, String> titleNameMap = new LinkedHashMap<String, String>();
        titleNameMap.put("productEasNo", "\u4ea7\u54c1\u7f16\u7801(\u957f\u7f16\u7801)");
        titleNameMap.put("productNo", "\u4ea7\u54c1\u7f16\u7801(\u77ed\u7f16\u7801)");
        titleNameMap.put("productName", "\u4ea7\u54c1\u540d\u79f0");
        titleNameMap.put("productPrice", "\u4ea7\u54c1\u4ef7\u683c");
        titleNameMap.put("productUnit", "\u5242\u578b");
        titleNameMap.put("productSubTypeName", "\u4ea7\u54c1\u5b50\u7c7b\u578b");
        titleNameMap.put("monthAverage", "\u6708\u5747\u53d1\u8d27\u91cf");
        List<String> months = this.predictConfigService.getMonths(predictConfig);
        for (String month : months) {
            titleNameMap.put(String.valueOf(month) + "_finality", String.valueOf(month) + "\u6708\u4efd\uff08\u6700\u7ec8\u91cf\uff09");
        }
        for (String month : months) {
            titleNameMap.put(String.valueOf(month) + "_customer", String.valueOf(month) + "\u6708\u4efd\uff08\u5ba2\u6237\u9884\u6d4b\u503c\uff09");
        }
        ArrayList listExcel = new ArrayList();
        for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("productEasNo", predictAdjustItem.getProductEasNo());
            itemMap.put("productNo", predictAdjustItem.getProductNo());
            itemMap.put("productName", predictAdjustItem.getProductName());
            itemMap.put("productPrice", predictAdjustItem.getProductPrice());
            itemMap.put("productUnit", predictAdjustItem.getProductUnit());
            itemMap.put("productSubTypeName", predictAdjustItem.getProductSubTypeName());
            itemMap.put("monthAverage", predictAdjustItem.getMonthAverage());
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            for (String month : monthsQuantity.keySet()) {
                Map<String, Double> quantitys = monthsQuantity.get(month);
                itemMap.put(String.valueOf(month) + "_finality", quantitys.get("finality"));
                itemMap.put(String.valueOf(month) + "_customer", quantitys.get("customer"));
            }
            listExcel.add(itemMap);
        }
        String[] titles = new String[titleNameMap.size()];
        String[] pop = new String[titleNameMap.size()];
        int i = 0;
        for (Map.Entry e : titleNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u9700\u6c42\u9884\u6d4b\u8ba1\u5212(\u4ea7\u54c1\u603b\u91cf)-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u9700\u6c42\u9884\u6d4b\u8ba1\u5212(\u4ea7\u54c1\u603b\u91cf)", ".xlsx", titles, listExcel, pop, response);
    }

    @RequestMapping(value={"/exportPredictCustomerExcel.do"}, method={RequestMethod.GET})
    public void exportPredictCustomerExcel(String configId, HttpServletResponse response) throws Exception {
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(configId);
        List<PredictAdjustItem> predictAdjustItems = this.predictAdjustService.getPredictAdjustItemByPredictConfig(predictConfig, "customer", null);
        LinkedHashMap<String, String> titleNameMap = new LinkedHashMap<String, String>();
        titleNameMap.put("bigArea", "\u5927\u533a");
        titleNameMap.put("area", "\u533a\u57df");
        titleNameMap.put("partnerNo", "\u7ecf\u9500\u5546\u7f16\u7801");
        titleNameMap.put("partnerName", "\u7ecf\u9500\u5546\u540d\u79f0");
        titleNameMap.put("productEasNo", "\u4ea7\u54c1\u7f16\u7801(\u957f\u7f16\u7801)");
        titleNameMap.put("productNo", "\u4ea7\u54c1\u7f16\u7801(\u77ed\u7f16\u7801)");
        titleNameMap.put("productName", "\u4ea7\u54c1\u540d\u79f0");
        titleNameMap.put("productPrice", "\u4ea7\u54c1\u4ef7\u683c");
        titleNameMap.put("productUnit", "\u5242\u578b");
        titleNameMap.put("productSubTypeName", "\u4ea7\u54c1\u5b50\u7c7b\u578b");
        titleNameMap.put("monthAverage", "\u6708\u5747\u53d1\u8d27\u91cf");
        List<String> months = this.predictConfigService.getMonths(predictConfig);
        for (String month : months) {
            titleNameMap.put(String.valueOf(month) + "_finality", String.valueOf(month) + "\u6708\u4efd\uff08\u6700\u7ec8\u91cf\uff09");
        }
        for (String month : months) {
            titleNameMap.put(String.valueOf(month) + "_customer", String.valueOf(month) + "\u6708\u4efd\uff08\u5ba2\u6237\u9884\u6d4b\u503c\uff09");
        }
        ArrayList listExcel = new ArrayList();
        for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("bigArea", predictAdjustItem.getPartnerBigAreaName());
            itemMap.put("area", predictAdjustItem.getPartnerAreaName());
            itemMap.put("partnerNo", predictAdjustItem.getPartnerNo());
            itemMap.put("partnerName", predictAdjustItem.getPartnerName());
            itemMap.put("productEasNo", predictAdjustItem.getProductEasNo());
            itemMap.put("productNo", predictAdjustItem.getProductNo());
            itemMap.put("productName", predictAdjustItem.getProductName());
            itemMap.put("productPrice", predictAdjustItem.getProductPrice());
            itemMap.put("productUnit", predictAdjustItem.getProductUnit());
            itemMap.put("productSubTypeName", predictAdjustItem.getProductSubTypeName());
            itemMap.put("monthAverage", predictAdjustItem.getMonthAverage());
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            for (String month : monthsQuantity.keySet()) {
                Map<String, Double> quantitys = monthsQuantity.get(month);
                itemMap.put(String.valueOf(month) + "_finality", quantitys.get("finality"));
                itemMap.put(String.valueOf(month) + "_customer", quantitys.get("customer"));
            }
            listExcel.add(itemMap);
        }
        String[] titles = new String[titleNameMap.size()];
        String[] pop = new String[titleNameMap.size()];
        int i = 0;
        for (Map.Entry e : titleNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u9700\u6c42\u9884\u6d4b\u8ba1\u5212(\u5ba2\u6237\u7ef4\u5ea6)-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u9700\u6c42\u9884\u6d4b\u8ba1\u5212(\u5ba2\u6237\u7ef4\u5ea6)", ".xlsx", titles, listExcel, pop, response);
    }

    @RequestMapping(value={"/exportExcels.do"}, method={RequestMethod.GET})
    public String exportExcels(String configId, Model model) {
        model.addAttribute("configId", (Object)configId);
        return "predictAdjust/exportExcels.ftl";
    }
}

