/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictAdjust;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.PredictAdjustPartner;
import com.tcbj.crm.entity.PredictAdjustTotal;
import com.tcbj.crm.entity.base.BaseEntity;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.predictAdjust.PredictAdjustItem;
import com.tcbj.crm.predictAdjust.PredictAdjustService;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ValidataUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="predictAdjustExcelService")
public class PredictAdjustExcelService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PredictAdjustService predictAdjustService;
    @Autowired
    PredictApplyService predictApplyService;

    public String getExcelTemplate(String configId) {
        return null;
    }

    public List<Map<String, Object>> readSheetByExcel(String filePath, String excelTemplateType) throws Exception {
        new FileInputStream(filePath);
        Workbook wb = WorkbookFactory.create((File)new File(filePath));
        Sheet sheet = wb.getSheetAt(0);
        HashMap<String, Integer> fixationTitle = new HashMap<String, Integer>();
        if ("product".equals(excelTemplateType)) {
            fixationTitle.put("productNo", 0);
            fixationTitle.put("productName", 1);
        } else if ("customer".equals(excelTemplateType)) {
            fixationTitle.put("productNo", 0);
            fixationTitle.put("productName", 1);
            fixationTitle.put("customerNo", 2);
            fixationTitle.put("customerName", 3);
        }
        HashMap monthMap = new HashMap();
        Row titleRow = sheet.getRow(0);
        for (Cell c : titleRow) {
            String titleName = this.getCellValue(c);
            if (!titleName.contains("\u6708\u4efd")) continue;
            String month = titleName.split("\u6708\u4efd")[0];
            HashMap<String, Integer> quantitys = new HashMap<String, Integer>();
            quantitys.put("system", c.getColumnIndex() + 1);
            quantitys.put("channel", c.getColumnIndex() + 2);
            monthMap.put(month, quantitys);
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        int line = 2;
        while (line <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(line);
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            for (String title : fixationTitle.keySet()) {
                rowData.put(title, this.getCellValue(row.getCell(((Integer)fixationTitle.get(title)).intValue())));
            }
            HashMap monthsQuantity = new HashMap();
            rowData.put("monthsQuantity", monthsQuantity);
            for (String month : monthMap.keySet()) {
                HashMap<String, String> quantitys = new HashMap<String, String>();
                monthsQuantity.put(month, quantitys);
                Map quantityTitles = (Map)monthMap.get(month);
                for (String quantityTitle : quantityTitles.keySet()) {
                    quantitys.put(quantityTitle, this.getCellValue(row.getCell(((Integer)quantityTitles.get(quantityTitle)).intValue())));
                }
            }
            datas.add(rowData);
            ++line;
        }
        return datas;
    }

    public List<AdjustStockUtil> validationExcelData(List<Map<String, Object>> excelDatas, String excelTemplateType, List<PredictAdjustItem> predictAdjustItems, Employee me) {
        ArrayList<AdjustStockUtil> msgs = new ArrayList<AdjustStockUtil>();
        int line = 3;
        for (Map<String, Object> rowData : excelDatas) {
            int currentErrorCount = msgs.size();
            PredictAdjustItem predictAdjustItem = new PredictAdjustItem();
            if (this.addErrorMeg(line, "\u4ea7\u54c1\u7f16\u7801", ValidataUtils.validataString((Object)rowData.get("productNo")), msgs)) {
                Product product = Cache.getProductByNo((String)rowData.get("productNo"));
                if (Beans.isEmpty((Object)product)) {
                    this.addErrorMeg(line, "\u4ea7\u54c1\u7f16\u7801", "\u4e0d\u6b63\u786e", msgs);
                } else {
                    predictAdjustItem.setProductId(product.getId());
                }
            }
            if ("customer".equals(excelTemplateType) && this.addErrorMeg(line, "\u5ba2\u6237\u7f16\u7801", ValidataUtils.validataString((Object)rowData.get("customerNo")), msgs)) {
                Partner partner = Cache.getPartnerByNo((String)rowData.get("customerNo"));
                if (Beans.isEmpty((Object)partner)) {
                    this.addErrorMeg(line, "\u5ba2\u6237\u7f16\u7801", "\u4e0d\u6b63\u786e", msgs);
                } else {
                    predictAdjustItem.setPartnerId(partner.getId());
                }
            }
            predictAdjustItem.setMonthsQuantity((Map)rowData.get("monthsQuantity"));
            if (currentErrorCount == msgs.size()) {
                predictAdjustItems.add(predictAdjustItem);
            }
            ++line;
        }
        return msgs;
    }

    private boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        int i = 0;
        while (i < sheetMergeCount) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row >= firstRow && row <= lastRow && column >= firstColumn && column <= lastColumn) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        int i = 0;
        while (i < sheetMergeCount) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row >= firstRow && row <= lastRow && column >= firstColumn && column <= lastColumn) {
                Row fRow = sheet.getRow(firstRow);
                Cell fCell = fRow.getCell(firstColumn);
                return this.getCellValue(fCell);
            }
            ++i;
        }
        return null;
    }

    public String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 2) {
            return cell.getCellFormula();
        }
        if (cell.getCellType() == 0) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return "";
    }

    protected boolean addErrorMeg(int line, String title, String message, List<AdjustStockUtil> msgs) {
        if (StringUtils.isEmpty(message)) {
            return true;
        }
        AdjustStockUtil adjustStock = new AdjustStockUtil("Excel\u4e2d\u7b2c" + line + "\u884c," + title + message);
        msgs.add(adjustStock);
        return false;
    }

    public void resetPredictAdjust(String configId, List<T> list) {
        for (T t : list) {
            BaseEntity p;
            if (t instanceof PredictAdjustPartner) {
                p = (PredictAdjustPartner)t;
                if (Beans.isEmpty((Object)((PredictAdjustPartner)p).getProductId()) || Beans.isEmpty((Object)((PredictAdjustPartner)p).getConfigId()) || Beans.isEmpty((Object)((PredictAdjustPartner)p).getPartnerId()) || Beans.isEmpty((Object)((PredictAdjustPartner)p).getMonth())) {
                    throw new AppException("7008");
                }
                this.baseDao.executeHQL("delete PredictAdjustPartner where productId = ? and configId = ? and adjustType = ? and month = ? and partnerId = ? and orgId = ? ", new Object[]{((PredictAdjustPartner)p).getProductId(), ((PredictAdjustPartner)p).getConfigId(), ((PredictAdjustPartner)p).getAdjustType(), ((PredictAdjustPartner)p).getMonth(), ((PredictAdjustPartner)p).getPartnerId(), ((PredictAdjustPartner)p).getOrgId()});
                continue;
            }
            p = (PredictAdjustTotal)t;
            if (Beans.isEmpty((Object)((PredictAdjustTotal)p).getProductId()) || Beans.isEmpty((Object)((PredictAdjustTotal)p).getConfigId()) || Beans.isEmpty((Object)((PredictAdjustTotal)p).getAdjustType()) || Beans.isEmpty((Object)((PredictAdjustTotal)p).getMonth())) {
                throw new AppException("7008");
            }
            this.baseDao.executeHQL("delete PredictAdjustTotal where productId = ? and configId = ? and adjustType = ? and month = ?  and orgId = ? ", new Object[]{((PredictAdjustTotal)p).getProductId(), ((PredictAdjustTotal)p).getConfigId(), ((PredictAdjustTotal)p).getAdjustType(), ((PredictAdjustTotal)p).getMonth(), ((PredictAdjustTotal)p).getOrgId()});
        }
        this.baseDao.save(list);
    }
}

