/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictAdjust;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PredictAdjustItem {
    private String productId;
    private String bigAreaId;
    private String areaId;
    private String partnerId;
    private Double monthAverage;
    private Map<String, Map<String, Double>> monthsQuantity = new HashMap<String, Map<String, Double>>();

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getBigAreaId() {
        return this.bigAreaId;
    }

    public void setBigAreaId(String bigAreaId) {
        this.bigAreaId = bigAreaId;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getPartnerEasNo() {
        Partner partner = Cache.getPartner(this.getPartnerId());
        if (partner != null) {
            return partner.getClientAppNo();
        }
        return "";
    }

    public String getPartnerName() {
        return Cache.getPartnerName(this.partnerId);
    }

    public String getPartnerNo() {
        return Cache.getPartnerNo(this.partnerId);
    }

    public String getPartnerBigAreaName() {
        Partner partner = Cache.getPartner(this.getPartnerId());
        if (partner != null) {
            return partner.getBigAreaName();
        }
        return "";
    }

    public String getPartnerAreaName() {
        Partner partner = Cache.getPartner(this.getPartnerId());
        if (partner != null) {
            return partner.getAreaName();
        }
        return "";
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public Map<String, Map<String, Double>> getMonthsQuantity() {
        return this.monthsQuantity;
    }

    public void setMonthsQuantity(Map<String, Map<String, Double>> monthsQuantity) {
        this.monthsQuantity = monthsQuantity;
    }

    public String getProductName() {
        return Cache.getProductName(this.productId);
    }

    public String getProductNo() {
        return Cache.getProductNo(this.productId);
    }

    public String getProductType() {
        return Cache.getProduct(this.getProductId()).getTypeName();
    }

    public String getProductSubTypeName() {
        return Cache.getProduct(this.getProductId()).getSubTypeName();
    }

    public String getProductEasNo() {
        Product product = Cache.getProduct(this.productId);
        if (product != null) {
            return product.getEasNo();
        }
        return "";
    }

    public Double getProductPrice() {
        Product product = Cache.getProduct(this.productId);
        if (product != null) {
            return product.getPrice();
        }
        return null;
    }

    public String getBigAreaName() {
        return Cache.getRegionsName(this.getBigAreaId());
    }

    public String getAreaName() {
        return Cache.getRegionsName(this.getAreaId());
    }

    public Double getMonthAverage() {
        return this.monthAverage;
    }

    public void setMonthAverage(Double monthAverage) {
        this.monthAverage = monthAverage;
    }

    public String getProductUnit() {
        return Cache.getProductUnit(this.productId);
    }
}

