/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictAdjust;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.PredictAdjustPartner;
import com.tcbj.crm.entity.PredictAdjustTotal;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.PredictConfigProduct;
import com.tcbj.crm.predictAdjust.PredictAdjustCondition;
import com.tcbj.crm.predictAdjust.PredictAdjustExcelService;
import com.tcbj.crm.predictAdjust.PredictAdjustItem;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.predictConfig.PredictConfigService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="predictAdjustService")
public class PredictAdjustService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PredictApplyService predictApplyService;
    @Autowired
    PredictConfigService predictConfigService;
    @Autowired
    PredictAdjustExcelService predictAdjustExcelService;

    public Page queryPredictAdjustItem(PredictAdjustCondition con, int pageno, int rowsize) {
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(con.getConfigId());
        Page page = this.getPredictAdjustItemByQueryType(con, pageno, rowsize);
        this.fillMonth(predictConfig, page.getList());
        this.addCustomerQuantitys(con.getQueryType(), con.getConfigId(), page.getList());
        if ("1".equals(predictConfig.getAllowAdjust()) && "product".equals(con.getQueryType())) {
            this.addPredictAdjust(page.getList(), con.getConfigId());
        } else if ("0".equals(predictConfig.getAllowAdjust())) {
            this.addPredictAdjustPartner(con.getQueryType(), con.getConfigId(), page.getList(), null);
        }
        this.addFinality(page.getList());
        return page;
    }

    public Page getPredictAdjustItemByQueryType(PredictAdjustCondition con, int pageno, int rowsize) {
        Page page;
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("   FROM CX_AWK_PRTNR_ACCOUNTLIST_VIEW C ,CX_PREDICT_CONFIG_CUS_REGION PCCR WHERE ( C.PARTNERID = PCCR.BUSINESS_ID OR C.REGIONID = PCCR.BUSINESS_ID  OR C.DISTRICTID = PCCR.BUSINESS_ID )");
        hql.append("   AND PCCR.CONFIG_ID = ? ");
        args.add(con.getConfigId());
        ArrayList<PredictAdjustItem> predictAdjustItems = new ArrayList<PredictAdjustItem>();
        String queryType = con.getQueryType();
        if ("customer".equals(queryType)) {
            hql.insert(0, "SELECT C.PARTNERID ");
            hql.append(" AND C.REGIONID = ? ");
            args.add(con.getAreaId());
            hql.append(" GROUP BY C.PARTNERID ");
            page = this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null);
            for (Object item : page.getList()) {
                String id = item instanceof Object[] ? ((Object[])item)[0].toString() : (String)item;
                Partner partner = Cache.getPartnerById(id);
                PredictAdjustItem predictAdjustItem = new PredictAdjustItem();
                predictAdjustItem.setPartnerId(partner.getId());
                predictAdjustItem.setAreaId(partner.getAreaCode());
                predictAdjustItem.setBigAreaId(partner.getBigAreaCode());
                predictAdjustItem.setProductId(con.getProductId());
                predictAdjustItems.add(predictAdjustItem);
            }
        } else if ("areaId".equals(queryType)) {
            hql.insert(0, "SELECT C.REGIONID ");
            hql.append(" AND C.DISTRICTID = ? ");
            args.add(con.getBigAreaId());
            hql.append(" GROUP BY C.REGIONID ");
            page = this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null);
            for (Object item : page.getList()) {
                String id = item instanceof Object[] ? ((Object[])item)[0].toString() : (String)item;
                PredictAdjustItem predictAdjustItem = new PredictAdjustItem();
                predictAdjustItem.setAreaId(id);
                predictAdjustItem.setBigAreaId(con.getBigAreaId());
                predictAdjustItem.setProductId(con.getProductId());
                predictAdjustItems.add(predictAdjustItem);
            }
        } else if ("bigAreaId".equals(queryType)) {
            hql.insert(0, "SELECT C.DISTRICTID ");
            hql.append(" GROUP BY  C.DISTRICTID ");
            page = this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null);
            for (Object item : page.getList()) {
                String id = item instanceof Object[] ? ((Object[])item)[0].toString() : (String)item;
                PredictAdjustItem predictAdjustItem = new PredictAdjustItem();
                predictAdjustItem.setBigAreaId(id);
                predictAdjustItem.setProductId(con.getProductId());
                predictAdjustItems.add(predictAdjustItem);
            }
        } else {
            page = this.baseDao.search(" from PredictConfigProduct where configId=? order by orderNum ", new Object[]{con.getConfigId()}, rowsize, pageno);
            List products = page.getList();
            for (PredictConfigProduct item : products) {
                PredictAdjustItem predictAdjustItem = new PredictAdjustItem();
                predictAdjustItem.setProductId(item.getProductId());
                predictAdjustItems.add(predictAdjustItem);
            }
        }
        page.setList(predictAdjustItems);
        return page;
    }

    public void addCustomerQuantitys(String queryType, String configId, List<PredictAdjustItem> predictAdjustItems) {
        for (PredictAdjustItem item : predictAdjustItems) {
            StringBuffer sql = new StringBuffer();
            ArrayList<String> args = new ArrayList<String>();
            sql.append("SELECT PRODUCT_ID, PREDICT_MONTH, SUM(quantity) as QUANTITY");
            sql.append(" from CX_PREDICT_APPLY_ITEM PAI, SIEBEL.S_ORG_BU P where PAI.APPLYER_ID = P.ORG_ID ");
            sql.append(" AND pai.config_Id = ? ");
            args.add(configId);
            if ("customer".equals(queryType)) {
                sql.append(" AND P.ORG_ID = ? ");
                args.add(item.getPartnerId());
            } else if ("bigAreaId".equals(queryType)) {
                sql.append(" AND P.X_DISTRICT_ID = ? ");
                args.add(item.getBigAreaId());
            } else if ("areaId".equals(queryType)) {
                sql.append(" AND P.X_REGION_ID = ? ");
                args.add(item.getAreaId());
            }
            sql.append(" AND PAI.PRODUCT_ID = ? ");
            args.add(item.getProductId());
            sql.append("GROUP BY PRODUCT_ID, PREDICT_MONTH");
            List datas = this.baseDao.findBySql(sql.toString(), args.toArray());
            for (Object[] data : datas) {
                String predictMonth = data[1].toString();
                String quantity = data[2].toString();
                Map<String, Map<String, Double>> monthsQuantity = item.getMonthsQuantity();
                Map<String, Double> quantitys = monthsQuantity.get(predictMonth);
                quantitys.put("customer", Double.valueOf(quantity));
            }
        }
    }

    public void addFinality(List<PredictAdjustItem> predictAdjustItems) {
        for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            for (Map<String, Double> quantityMap : monthsQuantity.values()) {
                if (quantityMap.get("channel") != null) {
                    quantityMap.put("finality", quantityMap.get("channel"));
                    continue;
                }
                if (quantityMap.get("customer") != null) {
                    quantityMap.put("finality", quantityMap.get("customer"));
                    continue;
                }
                if (quantityMap.get("system") != null) {
                    quantityMap.put("finality", quantityMap.get("system"));
                    continue;
                }
                quantityMap.put("finality", 0.0);
            }
        }
    }

    public void addPredictAdjust(List<PredictAdjustItem> predictAdjustItems, String configId) {
        List<PredictAdjustTotal> adjustTotals;
        List<PredictAdjustTotal> predictAdjustTotals = this.getPredictAdjustTotalByConfigId(configId);
        if (Beans.isEmpty(predictAdjustTotals)) {
            return;
        }
        HashMap<String, ArrayList<PredictAdjustTotal>> map = new HashMap<String, ArrayList<PredictAdjustTotal>>();
        for (PredictAdjustTotal predictAdjustTotal : predictAdjustTotals) {
            adjustTotals = (ArrayList<PredictAdjustTotal>)map.get(predictAdjustTotal.getProductId());
            if (Beans.isEmpty((Object)adjustTotals)) {
                adjustTotals = new ArrayList<PredictAdjustTotal>();
                map.put(predictAdjustTotal.getProductId(), (ArrayList<PredictAdjustTotal>)adjustTotals);
            }
            adjustTotals.add(predictAdjustTotal);
        }
        for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
            adjustTotals = (List)map.get(predictAdjustItem.getProductId());
            if (Beans.isEmpty(adjustTotals)) continue;
            for (PredictAdjustTotal total : adjustTotals) {
                Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
                Map<String, Double> quantitys = monthsQuantity.get(total.getMonth());
                if (quantitys == null) continue;
                quantitys.put(total.getAdjustType(), total.getQuantity());
            }
        }
    }

    public void addPredictAdjustPartner(String queryType, String configId, List<PredictAdjustItem> predictAdjustItems, Employee em) {
        List<PredictAdjustPartner> adjustPartnerList = this.getPredictAdjustPartnerByConfigId(configId, em);
        if (Beans.isEmpty(adjustPartnerList)) {
            return;
        }
        HashMap<String, PredictAdjustItem> predictAdjustItemMap = new HashMap<String, PredictAdjustItem>();
        for (PredictAdjustItem item : predictAdjustItems) {
            String key = "";
            if ("customer".equals(queryType)) {
                key = String.valueOf(item.getPartnerId()) + "|";
            } else if ("bigAreaId".equals(queryType)) {
                key = String.valueOf(item.getBigAreaId()) + "|";
            } else if ("areaId".equals(queryType)) {
                key = String.valueOf(item.getAreaId()) + "|";
            }
            key = String.valueOf(key) + item.getProductId();
            predictAdjustItemMap.put(key, item);
        }
        for (PredictAdjustPartner predictAdjustPartner : adjustPartnerList) {
            Double customerQuantity;
            Partner partner = Cache.getPartnerById(predictAdjustPartner.getPartnerId());
            String key = "";
            if ("customer".equals(queryType)) {
                key = String.valueOf(partner.getId()) + "|";
            } else if ("bigAreaId".equals(queryType)) {
                key = String.valueOf(partner.getBigAreaCode()) + "|";
            } else if ("areaId".equals(queryType)) {
                key = String.valueOf(partner.getAreaCode()) + "|";
            }
            key = String.valueOf(key) + predictAdjustPartner.getProductId();
            PredictAdjustItem predictAdjustItem = (PredictAdjustItem)predictAdjustItemMap.get(key);
            if (predictAdjustItem == null) continue;
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            Map<String, Double> quantitys = monthsQuantity.get(predictAdjustPartner.getMonth());
            if (quantitys == null) {
                quantitys = new HashMap<String, Double>();
                monthsQuantity.put(predictAdjustPartner.getMonth(), quantitys);
            }
            Double d = customerQuantity = quantitys.get(predictAdjustPartner.getAdjustType()) == null ? null : quantitys.get(predictAdjustPartner.getAdjustType());
            customerQuantity = Beans.isNotEmpty(customerQuantity) ? Double.valueOf(predictAdjustPartner.getQuantity() == null ? customerQuantity : customerQuantity + predictAdjustPartner.getQuantity()) : (predictAdjustPartner.getQuantity() == null ? null : predictAdjustPartner.getQuantity());
            quantitys.put(predictAdjustPartner.getAdjustType(), customerQuantity);
        }
    }

    public List<PredictAdjustTotal> getPredictAdjustTotalByConfigId(String configId) {
        return this.baseDao.findEntity("from PredictAdjustTotal where configId = ? ", new Object[]{configId}, PredictAdjustTotal.class);
    }

    public List<PredictAdjustPartner> getPredictAdjustPartnerByConfigId(String configId, Employee em) {
        if (Beans.isEmpty((Object)em)) {
            return this.baseDao.findEntity("from PredictAdjustPartner where configId = ? ", new Object[]{configId}, PredictAdjustPartner.class);
        }
        return this.baseDao.findEntity("from PredictAdjustPartner where configId = ? and partnerId = ? ", new Object[]{configId, em.getCurrentPartner().getId()}, PredictAdjustPartner.class);
    }

    public void approve(String id, String state) {
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(id);
        predictConfig.setState(state);
        this.baseDao.update((Object)predictConfig);
        if ("6".equals(predictConfig.getState())) {
            this.saveFinalityQuantity(predictConfig);
        }
    }

    public void saveFinalityQuantity(PredictConfig predictConfig) {
        Map<String, Map<String, Double>> monthsQuantity;
        String type = "product";
        if ("0".equals(predictConfig.getAllowAdjust())) {
            type = "customer";
        }
        List<PredictAdjustItem> predictAdjustItems = this.getPredictAdjustItemByPredictConfig(predictConfig, type, null);
        ArrayList<T> predictAdjustTotals = new ArrayList<T>();
        ArrayList<T> predictAdjustPartners = new ArrayList<T>();
        if ("product".equals(type)) {
            for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
                monthsQuantity = predictAdjustItem.getMonthsQuantity();
                for (String month : monthsQuantity.keySet()) {
                    PredictAdjustTotal predictAdjustTotal = new PredictAdjustTotal();
                    predictAdjustTotal.setCreateDt(new Date());
                    predictAdjustTotal.setProductId(predictAdjustItem.getProductId());
                    predictAdjustTotal.setOrgId(predictConfig.getOrgId());
                    predictAdjustTotal.setConfigId(predictConfig.getId());
                    predictAdjustTotal.setQuantity(monthsQuantity.get(month).get("finality"));
                    predictAdjustTotal.setMonth(month);
                    predictAdjustTotal.setAdjustType("finality");
                    predictAdjustTotals.add((T)predictAdjustTotal);
                }
            }
        }
        if ("customer".equals(type)) {
            for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
                monthsQuantity = predictAdjustItem.getMonthsQuantity();
                for (String month : monthsQuantity.keySet()) {
                    PredictAdjustPartner predictAdjustPartner = new PredictAdjustPartner();
                    predictAdjustPartner.setCreateDt(new Date());
                    predictAdjustPartner.setProductId(predictAdjustItem.getProductId());
                    predictAdjustPartner.setOrgId(predictConfig.getOrgId());
                    predictAdjustPartner.setConfigId(predictConfig.getId());
                    predictAdjustPartner.setQuantity(monthsQuantity.get(month).get("finality"));
                    predictAdjustPartner.setMonth(month);
                    predictAdjustPartner.setAdjustType("finality");
                    predictAdjustPartner.setPartnerId(predictAdjustItem.getPartnerId());
                    predictAdjustPartner.setPartnerNo(predictAdjustItem.getPartnerNo());
                    predictAdjustPartners.add((T)predictAdjustPartner);
                }
            }
        }
        this.predictAdjustExcelService.resetPredictAdjust(predictConfig.getId(), predictAdjustTotals);
        this.predictAdjustExcelService.resetPredictAdjust(predictConfig.getId(), predictAdjustPartners);
    }

    public List<PredictAdjustItem> getPredictAdjustItemByPredictConfig(PredictConfig predictConfig, String type, Employee em) {
        ArrayList<PredictAdjustItem> predictAdjustItems = new ArrayList<PredictAdjustItem>();
        if ("product".equals(type)) {
            List products = this.baseDao.findEntity(" from PredictConfigProduct where configId=? order by orderNum ", new Object[]{predictConfig.getId()}, PredictConfigProduct.class);
            for (PredictConfigProduct item : products) {
                PredictAdjustItem predictAdjustItem = new PredictAdjustItem();
                predictAdjustItem.setProductId(item.getProductId());
                predictAdjustItems.add(predictAdjustItem);
            }
        } else if ("customer".equals(type)) {
            StringBuffer sql = new StringBuffer();
            ArrayList<String> args = new ArrayList<String>();
            sql.append(" SELECT C.PARTNERID, PCP.PRODUCT_ID ");
            sql.append(" FROM CX_AWK_PRTNR_ACCOUNTLIST_VIEW C, CX_PREDICT_CONFIG_PRODUCT PCP WHERE EXISTS( SELECT 1 FROM CX_PREDICT_CONFIG_CUS_REGION PCCR WHERE (C.PARTNERID = PCCR.BUSINESS_ID OR C.REGIONID = PCCR.BUSINESS_ID OR C.DISTRICTID = PCCR.BUSINESS_ID)");
            sql.append(" AND PCCR.CONFIG_ID = PCP.CONFIG_ID) ");
            sql.append(" AND PCP.CONFIG_ID = ? ");
            args.add(predictConfig.getId());
            sql.append(" GROUP BY C.PARTNERID, PCP.PRODUCT_ID, PCP.ORDER_NUM ORDER BY PCP.ORDER_NUM  ");
            List list = this.baseDao.findBySql(sql.toString(), args.toArray());
            for (Object[] data : list) {
                String partnerId = String.valueOf(data[0]);
                String productId = String.valueOf(data[1]);
                PredictAdjustItem predictAdjustItem = new PredictAdjustItem();
                predictAdjustItem.setPartnerId(partnerId);
                predictAdjustItem.setProductId(productId);
                predictAdjustItems.add(predictAdjustItem);
            }
        }
        this.fillMonth(predictConfig, predictAdjustItems);
        this.addCustomerQuantitys(type, predictConfig.getId(), predictAdjustItems);
        if ("product".equals(type)) {
            this.addPredictAdjust(predictAdjustItems, predictConfig.getId());
        } else if ("customer".equals(type)) {
            this.addPredictAdjustPartner(type, predictConfig.getId(), predictAdjustItems, em);
        }
        this.addFinality(predictAdjustItems);
        return predictAdjustItems;
    }

    public void fillMonth(PredictConfig predictConfig, List<PredictAdjustItem> predictAdjustItems) {
        List<String> months = this.predictConfigService.getMonths(predictConfig);
        for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            for (String month : months) {
                monthsQuantity.put(month, new HashMap());
            }
        }
    }
}

