/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictApply;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.entity.AnnualPredictApply;
import com.tcbj.crm.entity.AnnualPredictItem;
import com.tcbj.crm.predictApply.AnnualPredictCondition;
import com.tcbj.crm.predictApply.AnnualPredictService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Excels;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"annualPredict"})
public class AnnualPredictController
extends BaseController {
    @Autowired
    AnnualPredictService service;
    @Autowired
    OrderNoService orderNoService;

    @RequestMapping(value={"/applys.do"})
    public String myApplys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AnnualPredictCondition con, Model model) {
        Page page = this.service.findAnnualPredictApply(con, this.getCurrentEmployee(), pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "predictApply/annualApplys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply_get(String id, Model model) {
        AnnualPredictApply apply;
        Employee me = this.getCurrentEmployee();
        if (Beans.isEmpty((Object)id)) {
            apply = new AnnualPredictApply();
            apply.setNo(this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "predictApply"));
            apply.setCreateDate(new Date());
            apply.setPredictYear(String.valueOf(DateUtils.getYear()));
            apply.setState("1");
            model.addAttribute("pageType", (Object)"add");
        } else {
            apply = this.service.getAnnualPredictApplyById(id);
            model.addAttribute("pageType", (Object)"edit");
        }
        model.addAttribute("apply", (Object)apply);
        return "predictApply/annualApply.ftl";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(String id, Model model) {
        AnnualPredictApply apply = this.service.getAnnualPredictApplyById(id);
        model.addAttribute("pageType", (Object)"view");
        model.addAttribute("apply", (Object)apply);
        return "predictApply/annualApply.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete(String id, Model model) {
        this.service.deleteByAnnualPredict(id);
        return "redirect:annualPredict/applys.do";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_post(@Valid @RequestBody AnnualPredictApply apply, Model model) {
        apply.setState("2");
        this.service.saveOrUpdate(apply);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/getPredictItems.do"})
    @ResponseBody
    public Page getPredictItems(String applyId, int page) {
        Employee em = this.getCurrentEmployee();
        Page result = this.service.findAnnualPredictItemsById(applyId, em, page);
        return result;
    }

    private AnnualPredictApply getApply(HttpServletRequest request) {
        AnnualPredictApply apply = new AnnualPredictApply();
        apply.setId(request.getParameter("id"));
        apply.setNo(request.getParameter("no"));
        apply.setPredictYear(request.getParameter("predictYear"));
        apply.setState(request.getParameter("state"));
        return apply;
    }

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.POST})
    public String importExcel(Model model, HttpServletRequest request) throws IOException {
        ArrayList<AnnualPredictItem> uploadItems;
        AnnualPredictApply apply = this.getApply(request);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = multipartRequest.getFile("mediaFile");
        if (file.isEmpty()) {
            HashMap<String, String> rtn = new HashMap<String, String>();
            rtn.put("code", "200");
            rtn.put("data", "\u6587\u4ef6\u4e3a\u7a7a");
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        String[] header = new String[]{"productNo", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        List datas = Excels.readExcel((String)file.getOriginalFilename(), (InputStream)file.getInputStream(), (String[])header);
        List<AdjustStockUtil> msglist = this.service.validateExcelData(datas, uploadItems = new ArrayList<AnnualPredictItem>(), this.getCurrentEmployee());
        if (msglist.size() > 0) {
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            rtn.put("code", "-1");
            rtn.put("data", msglist);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        String id = this.service.saveApplyAndItems(apply, uploadItems, this.getCurrentEmployee());
        HashMap<String, String> rtn = new HashMap<String, String>();
        rtn.put("code", "200");
        rtn.put("data", id);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }
}

