/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictApply;

import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.AnnualPredictApply;
import com.tcbj.crm.entity.AnnualPredictItem;
import com.tcbj.crm.predictApply.AnnualPredictCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ValidataUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="annualPredictService")
public class AnnualPredictService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    OrderNoService orderNoService;

    public Page findAnnualPredictApply(AnnualPredictCondition con, Employee currentEmployee, int pageno) {
        StringBuilder sb = new StringBuilder("");
        ArrayList<Object> args = new ArrayList<Object>();
        sb.append(" from AnnualPredictApply apl where apl.orgId = ? ");
        args.add(ConfigFactory.get().get("auto_orgId"));
        if (Beans.isNotEmpty((Object)con.getApplyNo())) {
            sb.append(" and apl.no = ? ");
            args.add(con.getApplyNo());
        }
        if (Beans.isNotEmpty((Object)con.getYear())) {
            sb.append(" and apl.predictYear  = ? ");
            args.add(con.getYear());
        }
        if (Beans.isNotEmpty((Object)con.getStartDate())) {
            sb.append(" and apl.createDate >= ? ");
            args.add(con.getStartDate());
        }
        if (Beans.isNotEmpty((Object)con.getEndDate())) {
            sb.append(" and apl.createDate <= ? ");
            args.add(con.getEndDate());
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            sb.append(" and apl.state = ? ");
            args.add(con.getState());
        }
        Page p = this.baseDao.search(sb.toString(), args.toArray(), 10, pageno);
        return p;
    }

    public AnnualPredictApply getAnnualPredictApplyById(String applyId) {
        AnnualPredictApply apply = (AnnualPredictApply)this.baseDao.get(AnnualPredictApply.class, (Serializable)((Object)applyId));
        return apply;
    }

    public void deleteByAnnualPredict(String id) {
        String hql = " delete from AnnualPredictApply apply where apply.id = '" + id + "'";
        this.baseDao.executeHQL(hql);
        String hql2 = " delete from AnnualPredictItem item where item.applyId = '" + id + "'";
        this.baseDao.executeHQL(hql2);
    }

    public Page findAnnualPredictItemsById(String applyId, Employee em, int page) {
        String hql = " from AnnualPredictItem item where item.applyId = '" + applyId + "'";
        Page p = this.baseDao.search(hql, 10, page);
        return p;
    }

    public void saveOrUpdate(AnnualPredictApply apply) {
        this.baseDao.saveOrUpdate((Object)apply);
    }

    public String saveApplyAndItems(AnnualPredictApply apply, List<AnnualPredictItem> uploadItems, Employee me) {
        if (Beans.isEmpty((Object)apply.getId())) {
            apply.setOrgId(ConfigFactory.get().get("auto_orgId"));
            apply.setCreateDate(new Date());
            apply.setCreator(me.getId());
            this.baseDao.save((Object)apply);
            for (AnnualPredictItem item : uploadItems) {
                item.setApplyId(apply.getId());
                item.setCreateDate(new Date());
                item.setOrgId(ConfigFactory.get().get("auto_orgId"));
            }
            this.baseDao.save(uploadItems);
        } else {
            String hql = " delete from AnnualPredictItem item where item.applyId = '" + apply.getId() + "'";
            this.baseDao.executeHQL(hql);
            for (AnnualPredictItem item : uploadItems) {
                item.setApplyId(apply.getId());
                item.setCreateDate(new Date());
                item.setOrgId(ConfigFactory.get().get("auto_orgId"));
            }
            this.baseDao.save(uploadItems);
        }
        return apply.getId();
    }

    public List<AdjustStockUtil> validateExcelData(List<Map> data, List<AnnualPredictItem> uploadItems, Employee me) {
        ArrayList<AdjustStockUtil> msgs = new ArrayList<AdjustStockUtil>();
        int line = 2;
        for (Map rowData : data) {
            AnnualPredictItem item = new AnnualPredictItem();
            if (this.addErrorMeg(line, "\u4ea7\u54c1\u7f16\u7801", ValidataUtils.validataString(rowData.get("productNo")), msgs)) {
                Product product = Cache.getProductByNo((String)rowData.get("productNo"));
                if (Beans.isEmpty((Object)product)) {
                    this.addErrorMeg(line, "\u4ea7\u54c1\u7f16\u7801", "\u4e0d\u6b63\u786e", msgs);
                    continue;
                }
                item.setProductId(product.getId());
                item.setProductNo(this.trim(rowData.get("productNo")));
            }
            item.setJan(this.trim(rowData.get("jan")));
            item.setFeb(this.trim(rowData.get("feb")));
            item.setMar(this.trim(rowData.get("mar")));
            item.setApr(this.trim(rowData.get("apr")));
            item.setMay(this.trim(rowData.get("may")));
            item.setJun(this.trim(rowData.get("jun")));
            item.setJul(this.trim(rowData.get("jul")));
            item.setAug(this.trim(rowData.get("aug")));
            item.setSep(this.trim(rowData.get("sep")));
            item.setOct(this.trim(rowData.get("oct")));
            item.setNov(this.trim(rowData.get("nov")));
            item.setDec(this.trim(rowData.get("dec")));
            uploadItems.add(item);
        }
        return msgs;
    }

    private String trim(Object obj) {
        if (Beans.isEmpty((Object)obj)) {
            return "";
        }
        return String.valueOf(obj);
    }

    protected boolean addErrorMeg(int line, String title, String message, List<AdjustStockUtil> msgs) {
        if (StringUtils.isEmpty(message)) {
            return true;
        }
        AdjustStockUtil adjustStock = new AdjustStockUtil("Excel\u4e2d\u7b2c" + line + "\u884c," + title + message);
        msgs.add(adjustStock);
        return false;
    }
}

