/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictApply;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.PredictApply;
import com.tcbj.crm.entity.PredictApplyItem;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.predictAdjust.PredictAdjustItem;
import com.tcbj.crm.predictAdjust.PredictAdjustService;
import com.tcbj.crm.predictApply.PredictApplyCondition;
import com.tcbj.crm.predictApply.PredictApplyItemCondition;
import com.tcbj.crm.predictApply.PredictApplyItemDto;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.predictConfig.PredictConfigService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"predictApply"})
public class PredictApplyController
extends BaseController {
    @Autowired
    PredictApplyService service;
    @Autowired
    PredictConfigService predictConfigService;
    @Autowired
    PredictAdjustService predictAdjustService;

    @RequestMapping(value={"/myApplys.do"})
    public String myApplys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PredictApplyCondition con, Model model) {
        Page page = this.service.findMyPredictApply(con, this.getCurrentEmployee(), pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "predictApply/myApplys.ftl";
    }

    @RequestMapping(value={"/customerApplys.do"})
    public String customerApplys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PredictApplyCondition con, Model model) {
        Page page = this.service.findCustomerPredictApply(con, this.getCurrentEmployee(), pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "predictApply/customerApplys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(String id, Model model) {
        PredictApply predictApply = new PredictApply();
        PredictConfig predictConfig = new PredictConfig();
        String pageType = "add";
        if (StringUtils.isNotEmpty(id)) {
            predictApply = this.service.getPredictApplyById(id);
            predictConfig = this.service.getPredictConfigById(predictApply.getConfigId());
            pageType = "edit";
        }
        model.addAttribute("pageType", (Object)pageType);
        model.addAttribute("predictConfig", (Object)predictConfig);
        model.addAttribute("predictApply", (Object)predictApply);
        model.addAttribute("predictApplyItemJson", (Object)JSON.toJSONString(this.toPredictApplyItemDto(predictApply.getPredictApplyItem())));
        return "predictApply/apply.ftl";
    }

    @RequestMapping(value={"/myApply.do"}, method={RequestMethod.GET})
    public String myApply(String id, Model model) {
        PredictApply predictApply = new PredictApply();
        PredictConfig predictConfig = new PredictConfig();
        String pageType = "add";
        if (StringUtils.isNotEmpty(id)) {
            predictApply = this.service.getPredictApplyById(id);
            predictConfig = this.service.getPredictConfigById(predictApply.getConfigId());
            pageType = "edit";
        }
        model.addAttribute("pageType", (Object)pageType);
        model.addAttribute("predictConfig", (Object)predictConfig);
        model.addAttribute("predictApply", (Object)predictApply);
        List<PredictApplyItemDto> predictApplyItemDtos = this.toPredictApplyItemDto(predictApply.getPredictApplyItem());
        if (StringUtils.isNotEmpty(id)) {
            this.service.setMonthAverage(predictApplyItemDtos);
        }
        model.addAttribute("predictApplyItemJson", (Object)JSON.toJSONString(predictApplyItemDtos));
        return "predictApply/myApply.ftl";
    }

    public List<PredictApplyItemDto> toPredictApplyItemDto(List<PredictApplyItem> predictApplyItems) {
        HashMap<String, PredictApplyItemDto> itemDtoMap = new HashMap<String, PredictApplyItemDto>();
        for (PredictApplyItem item : predictApplyItems) {
            PredictApplyItemDto itemDto = (PredictApplyItemDto)itemDtoMap.get(String.valueOf(item.getApplyerId()) + "|" + item.getProductId());
            if (itemDto == null) {
                itemDto = new PredictApplyItemDto();
                Beans.copy((Object)itemDto, (Object)item);
                itemDtoMap.put(String.valueOf(itemDto.getApplyerId()) + "|" + itemDto.getProductId(), itemDto);
            }
            Map<String, String> predictMonths = itemDto.getPredictMonths();
            predictMonths.put(item.getPredictMonth(), Double.toString(item.getQuantity()));
        }
        return new ArrayList<PredictApplyItemDto>(itemDtoMap.values());
    }

    @RequestMapping(value={"/selectPredictConfig.do"}, method={RequestMethod.GET})
    public String selectPredictConfigView(Model model) {
        return "predictApply/selectPredictConfigs.ftl";
    }

    @RequestMapping(value={"/selectPredictConfigDatas.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<PredictConfig> selectPredictConfigDatas(@ModelAttribute(value="prductCondition") PredictConfigCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        return this.service.getSelectPredictConfig(con, me);
    }

    @RequestMapping(value={"/getPredictApplyItem.do"})
    @ResponseBody
    public Page getPredictApplyItem(PredictApplyItemCondition con) {
        Page page = this.service.getPredictApplyItemByPredictConfig(con, this.getCurrentEmployee(), Page.class);
        return page;
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody PredictApplyCondition predictApplyCon, Model model) {
        this.saveOrUpdatePredictApplys(predictApplyCon.getConfigId(), predictApplyCon.getPredictApplyItems());
        return this.getSuccessResult(null);
    }

    protected void saveOrUpdatePredictApplys(String predictConfigId, List<PredictApplyItemDto> PredictApplyItemDtos) {
        List<PredictApplyItem> predictApplyItems = this.toPredictApplyItems(PredictApplyItemDtos);
        List<PredictApply> predictApply = this.toPredictApply(predictApplyItems);
        this.service.saveOrUpdatePredictApplys(predictConfigId, predictApply, this.getCurrentEmployee());
    }

    protected List<PredictApply> toPredictApply(List<PredictApplyItem> predictApplyItems) {
        HashMap<String, PredictApply> customerPredictApply = new HashMap<String, PredictApply>();
        for (PredictApplyItem predictApplyItem : predictApplyItems) {
            PredictApply apply = (PredictApply)customerPredictApply.get(predictApplyItem.getApplyerId());
            if (apply == null) {
                apply = new PredictApply();
                apply.setApplyerId(predictApplyItem.getApplyerId());
                customerPredictApply.put(predictApplyItem.getApplyerId(), apply);
            }
            apply.getPredictApplyItem().add(predictApplyItem);
        }
        ArrayList<PredictApply> predictApplys = new ArrayList<PredictApply>(customerPredictApply.values());
        return predictApplys;
    }

    protected List<PredictApplyItem> toPredictApplyItems(List<PredictApplyItemDto> predictApplyItemDtos) {
        ArrayList<PredictApplyItem> predictApplyItems = new ArrayList<PredictApplyItem>();
        for (PredictApplyItemDto predictApplyItemDto : predictApplyItemDtos) {
            Map<String, String> predictMonths = predictApplyItemDto.getPredictMonths();
            for (String month : predictMonths.keySet()) {
                PredictApplyItem predictApplyItem = new PredictApplyItem();
                Beans.copy((Object)predictApplyItem, (Object)predictApplyItemDto);
                predictApplyItem.setPredictMonth(month);
                String quantity = predictMonths.get(month);
                if (StringUtils.isEmpty(quantity)) {
                    quantity = "0";
                }
                predictApplyItem.setQuantity(Double.parseDouble(quantity));
                predictApplyItems.add(predictApplyItem);
            }
        }
        return predictApplyItems;
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(String id, Model model) {
        PredictApply predictApply = this.service.getPredictApplyById(id);
        PredictConfig predictConfig = this.service.getPredictConfigById(predictApply.getConfigId());
        model.addAttribute("predictConfig", (Object)predictConfig);
        model.addAttribute("predictApply", (Object)predictApply);
        List<PredictApplyItemDto> predictApplyItemDtos = this.toPredictApplyItemDto(predictApply.getPredictApplyItem());
        this.service.setMonthAverage(predictApplyItemDtos);
        model.addAttribute("predictApplyItemJson", (Object)JSON.toJSONString(predictApplyItemDtos));
        return "predictApply/view.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(String id, Model model) {
        PredictApply predictApply = this.service.getPredictApplyById(id);
        PredictConfig predictConfig = this.service.getPredictConfigById(predictApply.getConfigId());
        model.addAttribute("predictConfig", (Object)predictConfig);
        model.addAttribute("predictApply", (Object)predictApply);
        model.addAttribute("predictApplyItemJson", (Object)JSON.toJSONString(this.toPredictApplyItemDto(predictApply.getPredictApplyItem())));
        return "predictApply/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(String id, String auditOpinion) {
        if (!Constant.PredictApplyState.approvePass.value.equals(auditOpinion) && !Constant.PredictApplyState.approveNoPass.value.equals(auditOpinion)) {
            throw new AppException("0010", "\u8bf7\u63d0\u4ea4\u6b63\u786e\u7684\u5ba1\u6279\u610f\u89c1\uff01");
        }
        this.service.approve(id, auditOpinion);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/exportExcelTemplate.do"}, method={RequestMethod.GET})
    public void exportExcelTemplate(String configId, Model model, HttpServletResponse response) throws Exception {
        PredictConfig predictConfig = this.service.getPredictConfigById(configId);
        PredictApplyItemCondition con = new PredictApplyItemCondition();
        con.setConfigId(configId);
        List predictApplyItems = this.service.getPredictApplyItemByPredictConfig(con, this.getCurrentEmployee(), List.class);
        Employee me = this.getCurrentEmployee();
        LinkedHashMap<String, String> filedNameMap = new LinkedHashMap<String, String>();
        filedNameMap.put("applyerId", "\u5ba2\u6237\u7f16\u53f7" + (me.isInnerPerson() ? "(\u5fc5\u586b)" : ""));
        filedNameMap.put("applyerName", "\u5ba2\u6237\u540d\u79f0");
        filedNameMap.put("productId", "\u4ea7\u54c1\u7f16\u7801(\u5fc5\u586b)");
        filedNameMap.put("productName", "\u4ea7\u54c1\u540d\u79f0");
        filedNameMap.put("productType", "\u4ea7\u54c1\u5b50\u7c7b\u578b");
        filedNameMap.put("monthAverage", "\u6708\u5747\u53d1\u8d27\u91cf");
        List<String> months = this.predictConfigService.getMonths(predictConfig);
        for (String month : months) {
            filedNameMap.put(month, String.valueOf(month) + "\u6708\u4efd");
        }
        ArrayList<Map<String, Object>> listExcel = new ArrayList<Map<String, Object>>();
        for (PredictApplyItemDto predictApplyItem : predictApplyItems) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("applyerName", predictApplyItem.getApplyerName());
            itemMap.put("applyerId", predictApplyItem.getApplyerNo());
            itemMap.put("productId", predictApplyItem.getProductNo());
            itemMap.put("productName", predictApplyItem.getProductName());
            itemMap.put("productType", predictApplyItem.getProductSubTypeName());
            itemMap.put("monthAverage", predictApplyItem.getMonthAverage());
            Map<String, String> predictMonths = predictApplyItem.getPredictMonths();
            for (String month : months) {
                itemMap.put(month, predictMonths.get(month));
            }
            listExcel.add(itemMap);
        }
        String[] titles = new String[filedNameMap.size()];
        String[] pop = new String[filedNameMap.size()];
        int i = 0;
        for (Map.Entry e : filedNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportBigExcel("\u9700\u6c42\u8ba1\u5212\u7533\u8bf7\u5355\u660e\u7ec6\u5bfc\u5165\u6a21\u677f-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u7533\u8bf7\u5355\u660e\u7ec6", titles, listExcel, pop, response);
    }

    @RequestMapping(value={"/excelData.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcelError(String data, HttpServletResponse response) throws Exception {
        ArrayList listMap = new ArrayList();
        List<String> list = StringUtils.stringToList(data, ",");
        for (String s : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("error", s);
            listMap.add(map);
        }
        String[] titles = new String[]{"\u9519\u8bef\u4fe1\u606f"};
        String[] pop = new String[]{"error"};
        ExcelUtils.exportExcelNew("\u66f4\u591a\u9519\u8bef\u4fe1\u606f" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u9519\u8bef\u4fe1\u606f", ".xlsx", titles, listMap, pop, response);
    }

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.POST})
    public String intoExcel(String configId, Model model, HttpServletRequest request) throws Exception {
        ArrayList<PredictApplyItemDto> predictApplyItemDtos;
        block11: {
            List<AdjustStockUtil> msglist;
            List<IUploadFile> filelist;
            block10: {
                ArrayList<Map<String, Object>> excelDatas;
                List predictApplyItems;
                Employee me;
                block9: {
                    String url;
                    try {
                        me = this.getCurrentEmployee();
                        filelist = this.uploadFile(request, "predictApplyItem");
                        url = "";
                        if (filelist.size() <= 0) {
                            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(" \u8bf7\u4e0a\u4f20Excel\u6587\u4ef6")));
                            return "common/iframeRtn.ftl";
                        }
                        url = filelist.get(0).getRealPath();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(" \u7cfb\u7edf\u5f02\u5e38\uff0c\u5bfc\u5165\u5931\u8d25")));
                        return "common/iframeRtn.ftl";
                    }
                    predictApplyItemDtos = new ArrayList<PredictApplyItemDto>();
                    PredictApplyItemCondition con = new PredictApplyItemCondition();
                    con.setConfigId(configId);
                    predictApplyItems = this.service.getPredictApplyItemByPredictConfig(con, this.getCurrentEmployee(), List.class);
                    excelDatas = new ArrayList();
                    if (!url.contains(".xlsx")) {
                        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(" \u8bf7\u9009\u62e92007\u7248\u6216\u4ee5\u4e0a\u7248\u672c\u683c\u5f0f\u7684Excel\u6587\u4ef6")));
                        return "common/iframeRtn.ftl";
                    }
                    excelDatas = this.service.readSheetByExcel(url);
                    if (!Beans.isEmpty(excelDatas)) break block9;
                    model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(" \u5bf9\u4e0d\u8d77\u60a8\u9009\u62e9\u7684\u6587\u4ef6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\u5bfc\u5165\uff01")));
                    return "common/iframeRtn.ftl";
                }
                msglist = this.service.validationExcelData(excelDatas, predictApplyItemDtos, predictApplyItems, me);
                if (msglist.size() <= 0) break block10;
                HashMap<String, Object> rtn = new HashMap<String, Object>();
                rtn.put("code", "-1");
                rtn.put("data", msglist);
                model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
                return "common/iframeRtn.ftl";
            }
            if (!StringUtils.isNull(msglist)) break block11;
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6")));
            return "common/iframeRtn.ftl";
        }
        this.saveOrUpdatePredictApplys(configId, predictApplyItemDtos);
        HashMap<String, String> rtn = new HashMap<String, String>();
        rtn.put("code", "200");
        rtn.put("data", null);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/exportExcels.do"}, method={RequestMethod.GET})
    public void exportExcels(String configId, HttpServletResponse response) throws Exception {
        Employee em = this.getCurrentEmployee();
        PredictConfig predictConfig = this.service.getPredictConfigById(configId);
        List<PredictAdjustItem> predictAdjustItems = this.predictAdjustService.getPredictAdjustItemByPredictConfig(predictConfig, "customer", em);
        ArrayList<PredictAdjustItem> newPredictAdjustItems = new ArrayList<PredictAdjustItem>();
        for (PredictAdjustItem p : predictAdjustItems) {
            if (!em.getCurrentPartner().getId().equals(p.getPartnerId())) continue;
            newPredictAdjustItems.add(p);
        }
        LinkedHashMap<String, String> titleNameMap = new LinkedHashMap<String, String>();
        titleNameMap.put("bigArea", "\u5927\u533a");
        titleNameMap.put("area", "\u533a\u57df");
        titleNameMap.put("partnerNo", "\u7ecf\u9500\u5546\u7f16\u7801");
        titleNameMap.put("partnerName", "\u7ecf\u9500\u5546\u540d\u79f0");
        titleNameMap.put("productEasNo", "\u4ea7\u54c1\u7f16\u7801(\u957f\u7f16\u7801)");
        titleNameMap.put("productNo", "\u4ea7\u54c1\u7f16\u7801(\u77ed\u7f16\u7801)");
        titleNameMap.put("productName", "\u4ea7\u54c1\u540d\u79f0");
        titleNameMap.put("productPrice", "\u4ea7\u54c1\u4ef7\u683c");
        titleNameMap.put("productUnit", "\u5242\u578b");
        titleNameMap.put("productSubTypeName", "\u4ea7\u54c1\u5b50\u7c7b\u578b");
        titleNameMap.put("monthAverage", "\u6708\u5747\u53d1\u8d27\u91cf");
        List<String> months = this.predictConfigService.getMonths(predictConfig);
        for (String month : months) {
            titleNameMap.put(String.valueOf(month) + "_finality", String.valueOf(month) + "\u6708\u4efd\uff08\u6700\u7ec8\u91cf\uff09");
        }
        for (String month : months) {
            titleNameMap.put(String.valueOf(month) + "_customer", String.valueOf(month) + "\u6708\u4efd\uff08\u5ba2\u6237\u9884\u6d4b\u503c\uff09");
        }
        ArrayList listExcel = new ArrayList();
        for (PredictAdjustItem predictAdjustItem : newPredictAdjustItems) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("bigArea", predictAdjustItem.getPartnerBigAreaName());
            itemMap.put("area", predictAdjustItem.getPartnerAreaName());
            itemMap.put("partnerNo", predictAdjustItem.getPartnerNo());
            itemMap.put("partnerName", predictAdjustItem.getPartnerName());
            itemMap.put("productEasNo", predictAdjustItem.getProductEasNo());
            itemMap.put("productNo", predictAdjustItem.getProductNo());
            itemMap.put("productName", predictAdjustItem.getProductName());
            itemMap.put("productPrice", predictAdjustItem.getProductPrice());
            itemMap.put("productUnit", predictAdjustItem.getProductUnit());
            itemMap.put("productSubTypeName", predictAdjustItem.getProductSubTypeName());
            itemMap.put("monthAverage", predictAdjustItem.getMonthAverage());
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            for (String month : monthsQuantity.keySet()) {
                Map<String, Double> quantitys = monthsQuantity.get(month);
                itemMap.put(String.valueOf(month) + "_finality", quantitys.get("finality"));
                itemMap.put(String.valueOf(month) + "_customer", quantitys.get("customer"));
            }
            listExcel.add(itemMap);
        }
        String[] titles = new String[titleNameMap.size()];
        String[] pop = new String[titleNameMap.size()];
        int i = 0;
        for (Map.Entry e : titleNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u9700\u6c42\u9884\u6d4b\u8ba1\u5212(\u5ba2\u6237\u7ef4\u5ea6)-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u9700\u6c42\u9884\u6d4b\u8ba1\u5212(\u5ba2\u6237\u7ef4\u5ea6)", ".xlsx", titles, listExcel, pop, response);
    }
}

