/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictApply;

import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PredictApply;
import com.tcbj.crm.entity.PredictApplyItem;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.PredictConfigProduct;
import com.tcbj.crm.predictApply.PredictApplyCondition;
import com.tcbj.crm.predictApply.PredictApplyItemCondition;
import com.tcbj.crm.predictApply.PredictApplyItemDto;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.util.RequestHelper;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ValidataUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="predictApplyService")
public class PredictApplyService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    OrderNoService orderNoService;

    public Page findMyPredictApply(PredictApplyCondition con, Employee me, int pageno) {
        return this.findPredictApply(con, me, pageno, "myPredictApply");
    }

    public Page findCustomerPredictApply(PredictApplyCondition con, Employee me, int pageno) {
        return this.findPredictApply(con, me, pageno, "customerPredictApply");
    }

    public List<PredictApply> findPredictApplyByConfigId(String configId) {
        return this.baseDao.findEntity("from PredictApply where configId = ? ", new Object[]{configId}, PredictApply.class);
    }

    protected Page findPredictApply(PredictApplyCondition con, Employee me, int pageno, String range) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from PredictApply pa, PredictConfig pc where pa.configId = pc.id ");
        if ("myPredictApply".equals(range)) {
            hql.append(" and pa.applyerId = ? ");
            args.add(me.getCurrentPartner().getId());
        } else if ("customerPredictApply".equals(range)) {
            String sb = this.personnelService.getFRegionsByUserId(me.getId());
            hql.append(" and exists (select 1 from Customer c where c.supplierId=? ");
            args.add(me.getCurrentPartner().getId());
            hql.append(" and (c.bigAreaCode in ( ");
            hql.append(sb);
            hql.append(") or c.areaCode in ( ");
            hql.append(sb);
            hql.append(" )) ");
            hql.append(" and c.applyerId = pa.applyerId )");
        }
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            hql.append(" and pa.applyerId = ? ");
            args.add(con.getApplyerId());
        }
        if (StringUtils.isNotEmpty(con.getApplyNo())) {
            hql.append(" and pa.applyNo like ? ");
            args.add("%" + con.getApplyNo() + "%");
        }
        if (StringUtils.isNotEmpty(con.getConfigId())) {
            hql.append(" and pa.configId = ? ");
            args.add(con.getConfigId());
        }
        if (StringUtils.isNotEmpty(con.getState())) {
            hql.append(" and pa.state = ? ");
            args.add(con.getState());
        }
        if (StringUtils.isNotEmpty(con.getSupplierId())) {
            hql.append(" and pa.supplierId = ? ");
            args.add(con.getSupplierId());
        }
        if (StringUtils.isNotEmpty(con.getPredictConfigState())) {
            hql.append(" and pc.state = ? ");
            args.add(con.getPredictConfigState());
        }
        hql.append(" and pa.orgId = ? ");
        args.add(me.getCurrentPartner().getOrganizationid());
        hql.append(" order by pa.createDt desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<PredictApply> predictApplies = new ArrayList<PredictApply>();
        for (Object object : page.getList()) {
            Object[] objs = (Object[])object;
            PredictApply predictApply = (PredictApply)objs[0];
            PredictConfig predictConfig = (PredictConfig)objs[1];
            predictApply.setPredictConfig(predictConfig);
            predictApplies.add(predictApply);
        }
        page.setList(predictApplies);
        return page;
    }

    public PredictApply getPredictApplyById(String id) {
        PredictApply predictApply = (PredictApply)this.baseDao.findFirstEntity("from PredictApply where id = ?", new Object[]{id}, PredictApply.class);
        if (Beans.isNotEmpty((Object)predictApply)) {
            List<PredictApplyItem> predictApplyItems = this.getPredictApplyItemsByApplyerIdAndConfigId(predictApply.getId(), predictApply.getConfigId());
            predictApply.setPredictApplyItem(predictApplyItems);
        }
        return predictApply;
    }

    public List<PredictApplyItem> queryPredictApplyItems(PredictApplyItemCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from PredictApplyItem pai where 1=1 ");
        if (StringUtils.isNotEmpty(con.getConfigId())) {
            hql.append(" and pai.configId = ? ");
            args.add(con.getConfigId());
        }
        if (StringUtils.isNotEmpty(con.getApplyId())) {
            hql.append(" and pai.applyId = ? ");
            args.add(con.getApplyId());
        }
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            hql.append(" and pai.applyerId = ? ");
            args.add(con.getApplyerId());
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), PredictApplyItem.class);
    }

    public List<PredictApplyItem> getPredictApplyItemsByApplyerIdAndConfigId(String applyId, String configId) {
        PredictApplyItemCondition condition = new PredictApplyItemCondition();
        condition.setApplyId(applyId);
        condition.setConfigId(configId);
        return this.queryPredictApplyItems(condition);
    }

    public List<PredictApplyItem> getPredictApplyItemsByConfigId(String configId) {
        PredictApplyItemCondition condition = new PredictApplyItemCondition();
        condition.setConfigId(configId);
        return this.queryPredictApplyItems(condition);
    }

    public <T> T findPredictConfig(PredictConfigCondition con, Employee me, Class<T> format) {
        String sb;
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select pc from PredictConfig pc where 1=1 ");
        hql.append(" and exists ( select 1 from PredictConfigCustomerRegion pccr where 1=1 ");
        if ("A".equals(con.getPredictType())) {
            hql.append(" and exists (select 1 from Customer c where 1=1 ");
            if (!me.isInnerPerson()) {
                hql.append(" and c.applyerId = ? ");
                args.add(me.getCurrentPartner().getId());
            } else {
                sb = this.personnelService.getFRegionsByUserId(me.getId());
                hql.append(" and c.supplierId=?  ");
                args.add(me.getCurrentPartner().getId());
                hql.append(" and (c.bigAreaCode in ( ");
                hql.append(sb);
                hql.append(") or c.areaCode in ( ");
                hql.append(sb);
                hql.append(" )) ");
            }
            hql.append(" and (c.applyerId = pccr.businessId or c.bigAreaCode = pccr.businessId or c.areaCode = pccr.businessId) )");
        }
        if ("B".equals(con.getPredictType())) {
            hql.append(" and pccr.businessId in ( ");
            sb = this.personnelService.getFRegionsByUserId(me.getId());
            hql.append(sb);
            hql.append(" ) ");
        }
        hql.append(" and pccr.configId = pc.id ) ");
        if (Beans.isNotEmpty((Object)con.getPredictType())) {
            hql.append(" and pc.predictType = ? ");
            args.add(con.getPredictType());
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            hql.append(" and pc.state = ? ");
            args.add(con.getState());
        }
        if (Beans.isNotEmpty((Object)con.getStartDate())) {
            hql.append(" and pc.startDate <= ? ");
            args.add(con.getStartDate());
        }
        if (Beans.isNotEmpty((Object)con.getEndDate())) {
            hql.append(" and pc.endDate >= ? ");
            args.add(con.getEndDate());
        }
        hql.append(" order by pc.createDate DESC");
        Object queryData = null;
        if (format == Page.class) {
            queryData = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, con.getPageno().intValue());
        } else if (format == List.class) {
            queryData = this.baseDao.findEntity(hql.toString(), args.toArray(), PredictConfig.class);
        }
        return (T)queryData;
    }

    public List<PredictConfig> getSelectPredictConfig(PredictConfigCondition con, Employee me) {
        con.setStartDate(new Date());
        con.setEndDate(new Date());
        con.setPredictType("A");
        con.setState("2");
        return this.findPredictConfig(con, me, List.class);
    }

    public List<PredictConfigProduct> getPredictConfigProductByPredictConfig(String predictConfigId) {
        return this.baseDao.findEntity(" from PredictConfigProduct where configId=? order by orderNum ", new Object[]{predictConfigId}, PredictConfigProduct.class);
    }

    public <T> T predictConfigToPredictApplyItem(PredictApplyItemCondition condition, Employee me, Class<T> clazz) {
        List objs;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sql.append("SELECT P.ORG_ID AS PARTNER_ID, PCP.Product_Id FROM CX_PREDICT_CONFIG_PRODUCT PCP,");
        sql.append("(SELECT DISTINCT P.ORG_ID FROM SIEBEL.S_ORG_BU P, CX_PREDICT_CONFIG_CUS_REGION PCCR WHERE (P.ORG_ID = PCCR.BUSINESS_ID or P.X_DISTRICT_ID = PCCR.BUSINESS_ID or P.X_REGION_ID = PCCR.BUSINESS_ID)");
        if (Beans.isNotEmpty((Object)me) && me.isInnerPerson()) {
            String sb = this.personnelService.getFRegionsByUserId(me.getId());
            sql.append(" AND (P.X_DISTRICT_ID in ( ");
            sql.append(sb);
            sql.append(") OR P.X_REGION_ID in ( ");
            sql.append(sb);
            sql.append(" )) ");
        } else {
            sql.append(" and P.ORG_ID = ? ");
            args.add(me.getCurrentPartner().getId());
        }
        sql.append("AND PCCR.CONFIG_ID = ?) P ");
        args.add(condition.getConfigId());
        sql.append("WHERE PCP.CONFIG_ID = ? ORDER BY PCP.ORDER_NUM ");
        args.add(condition.getConfigId());
        Object t = null;
        if (clazz == Page.class) {
            Page page = this.baseDao.searchBySql(sql.toString(), args.toArray(), condition.getRowsize().intValue(), condition.getPageno().intValue(), null);
            objs = page.getList();
            t = page;
        } else {
            objs = this.baseDao.findBySql(sql.toString(), args.toArray());
        }
        ArrayList<PredictApplyItem> predictApplyItems = new ArrayList<PredictApplyItem>();
        for (Object[] obj : objs) {
            String partnerId = (String)obj[0];
            String productId = (String)obj[1];
            PredictApplyItem predictApplyItem = new PredictApplyItem();
            predictApplyItem.setProductId(productId);
            predictApplyItem.setConfigId(condition.getConfigId());
            predictApplyItem.setApplyerId(partnerId);
            predictApplyItems.add(predictApplyItem);
        }
        if (clazz == Page.class) {
            Page page = t;
            page.setList(predictApplyItems);
        } else {
            t = predictApplyItems;
        }
        return (T)t;
    }

    public <T> T getPredictApplyItemByPredictConfig(PredictApplyItemCondition condition, Employee me, Class<T> clazz) {
        ArrayList<PredictApplyItemDto> predictApplyItemDtos = new ArrayList<PredictApplyItemDto>();
        HashMap<String, PredictApplyItemDto> itemDtoMap = new HashMap<String, PredictApplyItemDto>();
        List predictApplyItems = new ArrayList();
        Object t = this.predictConfigToPredictApplyItem(condition, me, clazz);
        if (t instanceof Page) {
            Page page = (Page)t;
            predictApplyItems = page.getList();
        } else {
            predictApplyItems = (List)t;
        }
        for (PredictApplyItem predictApplyItem : predictApplyItems) {
            PredictApplyItemDto itemDto = new PredictApplyItemDto();
            Beans.copy((Object)itemDto, (Object)predictApplyItem);
            predictApplyItemDtos.add(itemDto);
            itemDtoMap.put(String.valueOf(itemDto.getApplyerId()) + "|" + itemDto.getProductId(), itemDto);
        }
        List<PredictApplyItem> applyItems = this.getPredictApplyItemsByConfigId(condition.getConfigId());
        for (PredictApplyItem applyItem : applyItems) {
            PredictApplyItemDto predictApplyItemDto = (PredictApplyItemDto)itemDtoMap.get(String.valueOf(applyItem.getApplyerId()) + "|" + applyItem.getProductId());
            if (predictApplyItemDto == null) continue;
            Map<String, String> predictMonths = predictApplyItemDto.getPredictMonths();
            predictMonths.put(applyItem.getPredictMonth(), Double.toString(applyItem.getQuantity()));
        }
        this.setMonthAverage(predictApplyItemDtos);
        if (t instanceof Page) {
            Page page = (Page)t;
            page.setList(predictApplyItemDtos);
        } else {
            t = predictApplyItemDtos;
        }
        return t;
    }

    public void setMonthAverage(List<PredictApplyItemDto> predictApplyItemDtos) {
        Map<String, Double> monthAverageShipment = this.getMonthAverageShipmentByProductAndPartner(predictApplyItemDtos);
        for (PredictApplyItemDto predictApplyItemDto : predictApplyItemDtos) {
            Double monthAverage = monthAverageShipment.get(String.valueOf(predictApplyItemDto.getProductId()) + "_" + predictApplyItemDto.getApplyerId());
            if (monthAverage == null) continue;
            predictApplyItemDto.setMonthAverage(monthAverage);
        }
    }

    public void saveOrUpdatePredictApplys(String predictConfigId, List<PredictApply> predictApplys, Employee me) {
        List<PredictApply> applys = this.findPredictApplyByConfigId(predictConfigId);
        HashMap<String, PredictApply> customerPredictApply = new HashMap<String, PredictApply>();
        for (PredictApply apply : applys) {
            customerPredictApply.put(apply.getApplyerId(), apply);
        }
        ArrayList<PredictApply> updatePredictApply = new ArrayList<PredictApply>();
        ArrayList<PredictApply> addPredictApply = new ArrayList<PredictApply>();
        for (PredictApply apply : predictApplys) {
            PredictApply predictApply = (PredictApply)customerPredictApply.get(apply.getApplyerId());
            if (predictApply != null) {
                predictApply.setPredictApplyItem(apply.getPredictApplyItem());
                updatePredictApply.add(predictApply);
                continue;
            }
            addPredictApply.add(apply);
        }
        for (PredictApply apply : addPredictApply) {
            apply.fillInitData(me);
            apply.setApplyNo(this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "PA"));
            apply.setSupplierId(me.getCurrentPartner().getOrganizationid());
            apply.setState(Constant.PredictApplyState.waitApprove.value);
            apply.setConfigId(predictConfigId);
            apply.setOrgId(ConfigFactory.get().get("auto_orgId"));
        }
        for (PredictApply apply : updatePredictApply) {
            apply.updateLastData(me);
            apply.setState(Constant.PredictApplyState.waitApprove.value);
        }
        this.baseDao.save(addPredictApply);
        this.baseDao.update(updatePredictApply);
        ArrayList<PredictApply> allPredictApply = new ArrayList<PredictApply>();
        allPredictApply.addAll(addPredictApply);
        allPredictApply.addAll(updatePredictApply);
        for (PredictApply apply : updatePredictApply) {
            for (PredictApplyItem item : apply.getPredictApplyItem()) {
                String hql = "delete PredictApplyItem where applyId = ? and productId = ? and predictMonth = ? ";
                Object[] args = new Object[]{apply.getId(), item.getProductId(), item.getPredictMonth()};
                this.baseDao.executeHQL(hql, args);
            }
        }
        ArrayList<PredictApplyItem> allPredictApplyItem = new ArrayList<PredictApplyItem>();
        for (PredictApply apply : allPredictApply) {
            List<PredictApplyItem> predictApplyItem = apply.getPredictApplyItem();
            for (PredictApplyItem item : predictApplyItem) {
                item.fillInitData(me);
                item.setApplyId(apply.getId());
                item.setConfigId(apply.getConfigId());
                item.setApplyerId(apply.getApplyerId());
                item.setOrgId(apply.getOrgId());
            }
            allPredictApplyItem.addAll(predictApplyItem);
        }
        this.baseDao.save(allPredictApplyItem);
    }

    public PredictConfig getPredictConfigById(String configId) {
        return (PredictConfig)this.baseDao.findFirstEntity("from PredictConfig where id = ? ", new Object[]{configId}, PredictConfig.class);
    }

    public List<Map<String, Object>> readSheetByExcel(String filePath) throws Exception {
        FileInputStream is = new FileInputStream(filePath);
        XSSFWorkbook rwb = new XSSFWorkbook((InputStream)is);
        XSSFSheet st = rwb.getSheetAt(0);
        int rowsNumber = st.getPhysicalNumberOfRows();
        HashMap<String, Integer> monthInCellNo = new HashMap<String, Integer>();
        XSSFRow row = st.getRow(0);
        if (Beans.isEmpty((Object)row)) {
            return null;
        }
        int i = 6;
        while (i < row.getPhysicalNumberOfCells()) {
            XSSFCell title = row.getCell(i);
            String titleContents = this.getCellValue((Cell)title);
            if (titleContents.contains("\u6708\u4efd")) {
                String[] month = titleContents.split("\u6708\u4efd");
                monthInCellNo.put(month[0], i);
            }
            ++i;
        }
        ArrayList<Map<String, Object>> rowsDatas = new ArrayList<Map<String, Object>>();
        int j = 1;
        while (j < rowsNumber) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            XSSFRow dataRow = st.getRow(j);
            rowData.put("applyNo", this.getCellValue((Cell)dataRow.getCell(0)));
            rowData.put("productNo", this.getCellValue((Cell)dataRow.getCell(2)));
            HashMap<String, String> predictMonths = new HashMap<String, String>();
            for (String month : monthInCellNo.keySet()) {
                predictMonths.put(month, this.getCellValue((Cell)dataRow.getCell(((Integer)monthInCellNo.get(month)).intValue())));
            }
            rowData.put("predictMonths", predictMonths);
            rowsDatas.add(rowData);
            ++j;
        }
        return rowsDatas;
    }

    public String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 2) {
            return cell.getCellFormula();
        }
        if (cell.getCellType() == 0) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return "";
    }

    public List<AdjustStockUtil> validationExcelData(List<Map<String, Object>> excelDatas, List<PredictApplyItemDto> predictApplyItemDtos, List<PredictApplyItemDto> predictApplyItems, Employee me) {
        ArrayList<AdjustStockUtil> msgs = new ArrayList<AdjustStockUtil>();
        HashMap<String, PredictApplyItemDto> maps = new HashMap<String, PredictApplyItemDto>();
        for (PredictApplyItemDto itemDto : predictApplyItems) {
            maps.put(String.valueOf(itemDto.getApplyerNo()) + "|" + itemDto.getProductNo(), itemDto);
        }
        int line = 2;
        for (Map<String, Object> rowData : excelDatas) {
            int currentErrorCount = msgs.size();
            PredictApplyItemDto predictApplyItemDto = new PredictApplyItemDto();
            if (me.isInnerPerson() && this.addErrorMeg(line, "\u5ba2\u6237\u7f16\u7801", ValidataUtils.validataString((Object)rowData.get("applyNo")), msgs)) {
                Partner partner = Cache.getPartnerByNo((String)rowData.get("applyNo"));
                if (Beans.isEmpty((Object)partner)) {
                    this.addErrorMeg(line, "\u5ba2\u6237\u7f16\u7801", "\u4e0d\u6b63\u786e", msgs);
                } else {
                    predictApplyItemDto.setApplyerId(partner.getId());
                }
            } else if (!me.isInnerPerson()) {
                predictApplyItemDto.setApplyerId(me.getCurrentPartner().getId());
            }
            if (this.addErrorMeg(line, "\u4ea7\u54c1\u7f16\u7801", ValidataUtils.validataString((Object)rowData.get("productNo")), msgs)) {
                Product product = Cache.getProductByNo((String)rowData.get("productNo"));
                if (Beans.isEmpty((Object)product)) {
                    this.addErrorMeg(line, "\u4ea7\u54c1\u7f16\u7801", "\u4e0d\u6b63\u786e", msgs);
                } else {
                    predictApplyItemDto.setProductId(product.getId());
                }
            }
            if (me.isInnerPerson() && StringUtils.isNotEmpty(predictApplyItemDto.getApplyerId()) && StringUtils.isNotEmpty(predictApplyItemDto.getProductId()) && maps.get(String.valueOf(predictApplyItemDto.getApplyerNo()) + "|" + predictApplyItemDto.getProductNo()) == null) {
                this.addErrorMeg(line, "\u5ba2\u6237\u7f16\u7801 + \u4ea7\u54c1\u7f16\u7801", "\u4e0d\u5728\u914d\u7f6e\u8303\u56f4\u5185", msgs);
            }
            Map predictMonths = (Map)rowData.get("predictMonths");
            for (String month : predictMonths.keySet()) {
                String quantity = (String)predictMonths.get(month);
                if (quantity == null || !this.addErrorMeg(line, String.valueOf(month) + "\u6708\u4efd", ValidataUtils.validataString((Object)quantity), msgs)) continue;
                if (Double.parseDouble(quantity) < 0.0) {
                    this.addErrorMeg(line, String.valueOf(month) + "\u6708\u4efd", "\u4e0d\u80fd\u4e3a\u8d1f\u6570", msgs);
                }
                if (String.valueOf(Math.round(Double.parseDouble(quantity))).length() <= 15) continue;
                this.addErrorMeg(line, String.valueOf(month) + "\u6708\u4efd", "\u4e0d\u80fd\u5927\u4e8e15\u4f4d\u6570\u503c", msgs);
            }
            predictApplyItemDto.setPredictMonths((Map)rowData.get("predictMonths"));
            if (currentErrorCount == msgs.size()) {
                predictApplyItemDtos.add(predictApplyItemDto);
            }
            ++line;
        }
        return msgs;
    }

    protected boolean addErrorMeg(int line, String title, String message, List<AdjustStockUtil> msgs) {
        if (StringUtils.isEmpty(message)) {
            return true;
        }
        AdjustStockUtil adjustStock = new AdjustStockUtil("Excel\u4e2d\u7b2c" + line + "\u884c\uff0c" + title + message);
        msgs.add(adjustStock);
        return false;
    }

    public void approve(String id, String auditOpinion) {
        PredictApply predictApply = this.getPredictApplyById(id);
        predictApply.setState(auditOpinion);
        this.baseDao.update((Object)predictApply);
    }

    public Map<String, Double> getMonthAverageShipmentByProduct() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        int months = 6;
        String selectSql = " substr(FMATERIALNUMBER, instr(FMATERIALNUMBER, '.', -1) + 1)  as productNo, round(sum(FQTY)/" + months + ",0) as quantity ";
        List<String> preMonths = PredictApplyService.getPreMonths(months);
        String whereSql = " where FBIZDATE in('" + StringUtils.listToString(preMonths, "','") + "') group by FMATERIALNUMBER";
        param.put("where", whereSql);
        param.put("sql", selectSql);
        param.put("currentPage", 1);
        param.put("pageSize", 1000);
        List rtn = (List)RequestHelper.getInstance().sendRequest(String.valueOf(ConfigFactory.get().get("eas_stock")) + "queryIssueQtyAmountNoCustomer", param);
        if (Beans.isNotEmpty((Object)rtn)) {
            for (Map stock : rtn) {
                Product p = Cache.getProductByNo(stock.get("PRODUCTNO").toString());
                if (!Beans.isNotEmpty((Object)p)) continue;
                result.put(p.getId(), Beans.isEmpty(stock.get("QUANTITY")) ? 0.0 : Double.valueOf(stock.get("QUANTITY").toString()));
            }
        }
        return result;
    }

    public Map<String, Double> getMonthAverageShipmentByProductAndPartner(List<PredictApplyItemDto> predictApplyItemDtos) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashSet<String> cusNums = new HashSet<String>();
        HashSet<String> proNums = new HashSet<String>();
        ArrayList<String> cusNumList = new ArrayList<String>();
        ArrayList<String> proNumsList = new ArrayList<String>();
        for (PredictApplyItemDto item : predictApplyItemDtos) {
            Product prod;
            Partner p = Cache.getPartner(item.getApplyerId());
            if (Beans.isNotEmpty((Object)p)) {
                cusNums.add(p.getClientAppNo());
            }
            if (!Beans.isNotEmpty((Object)(prod = Cache.getProduct(item.getProductId())))) continue;
            proNums.add(prod.getEasNo());
        }
        if (Beans.isNotEmpty(cusNums)) {
            cusNumList.addAll(cusNums);
        }
        if (Beans.isNotEmpty(proNums)) {
            proNumsList.addAll(proNums);
        }
        int months = 6;
        String selectSql = " substr(FMATERIALNUMBER, instr(FMATERIALNUMBER, '.', -1) + 1)  as productNo, FCUSTOMERNUMBER as cusNo, round(sum(FQTY)/" + months + ",0) as quantity";
        List<String> preMonths = PredictApplyService.getPreMonths(months);
        StringBuilder whereSql = new StringBuilder(" where FBIZDATE in('" + StringUtils.listToString(preMonths, "','") + "')");
        if (Beans.isNotEmpty(proNumsList)) {
            whereSql.append(" and FMATERIALNUMBER in ('" + StringUtils.listToString(proNumsList, "','") + "') ");
        }
        if (Beans.isNotEmpty(cusNumList)) {
            whereSql.append(" and FCUSTOMERNUMBER in ('" + StringUtils.listToString(cusNumList, "','") + "') ");
        }
        whereSql.append(" and FCUSTOMERNUMBER is not null group by FMATERIALNUMBER,FCUSTOMERNUMBER");
        param.put("where", whereSql);
        param.put("sql", selectSql);
        param.put("currentPage", 1);
        param.put("pageSize", 2000);
        List rtn = (List)EasRequestHelper.getInstance().sendRequest(String.valueOf(ConfigFactory.get().get("eas_stock")) + "queryIssueQtyAmount", param);
        if (Beans.isNotEmpty((Object)rtn)) {
            for (Map stock : rtn) {
                Product p = Cache.getProductByNo(stock.get("PRODUCTNO").toString());
                if (!Beans.isNotEmpty((Object)p)) continue;
                String shortCode = stock.get("CUSNO").toString().lastIndexOf(".") > -1 ? stock.get("CUSNO").toString().substring(stock.get("CUSNO").toString().lastIndexOf(".") + 1) : "";
                List<Partner> partners = Cache.getPartnerByShortExtCode(shortCode);
                for (Partner pt : partners) {
                    result.put(String.valueOf(p.getId()) + "_" + pt.getId(), Beans.isEmpty(stock.get("QUANTITY")) ? 0.0 : Double.valueOf(stock.get("QUANTITY").toString()));
                }
            }
        }
        return result;
    }

    private static List<String> getPreMonths(int preMonthCount) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String dateString = sdf.format(cal.getTime());
        ArrayList<String> rqList = new ArrayList<String>();
        System.out.println("\u5012\u5e8f\u524d\n");
        int i = 0;
        while (i < 6) {
            dateString = sdf.format(cal.getTime());
            rqList.add(dateString.substring(0, 7));
            cal.add(2, -1);
            ++i;
        }
        return rqList;
    }
}

