/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictConfig;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.PredictConfigProduct;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.predictConfig.PredictConfigService;
import com.tcbj.crm.predictConfig.PredictPartnerService;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/predictConfig"})
public class PredictConfigController
extends BaseController {
    @Autowired
    PredictConfigService predictConfigService;
    @Autowired
    PredictPartnerService predictPartnerService;
    @Autowired
    OrderNoService orderNoService;

    @RequestMapping(value={"/list.do"})
    public String list(@ModelAttribute(value="condition") PredictConfigCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        con.setOrgId(em.getCurrentPartner().getOrganizationid());
        Page page = this.predictConfigService.list(con);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("page", (Object)page);
        return "predictConfig/list.ftl";
    }

    @RequestMapping(value={"/add.do"})
    public String add(@RequestParam(value="id", required=false) String id, Model model) {
        Employee em = this.getCurrentEmployee();
        PredictConfig pc = null;
        if (Beans.isEmpty((Object)id)) {
            pc = new PredictConfig();
            pc.setState(TCBJEnum.ConfigTpye.ready.getValue());
            model.addAttribute("predictType", (Object)"true");
            model.addAttribute("hidden", (Object)"false");
        } else {
            pc = this.predictConfigService.getPredictConfigById(id, em);
            model.addAttribute("productData", (Object)JSON.toJSONStringWithDateFormat(pc.getProductList(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
            model.addAttribute("partnerData", (Object)JSON.toJSONStringWithDateFormat(pc.getPartnerList(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
            model.addAttribute("hidden", (Object)"false");
        }
        model.addAttribute("em", (Object)em);
        model.addAttribute("predictConfig", (Object)pc);
        model.addAttribute("canEdit", (Object)"true");
        return "predictConfig/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addPost(@Valid @RequestBody PredictConfig pc) {
        Employee em = this.getCurrentEmployee();
        this.predictConfigService.setProducts(pc, em);
        this.predictConfigService.setPartners(pc, em);
        if (Beans.isEmpty((Object)pc.getId())) {
            this.fillInitData(pc, em);
            this.predictConfigService.add(pc);
        } else {
            this.predictConfigService.update(pc, em);
        }
        return this.getSuccessResult(null);
    }

    public void fillInitData(PredictConfig pc, Employee em) {
        pc.fillInitData(em);
        pc.setState(TCBJEnum.ConfigTpye.ready.getValue());
        if ("A".equals(pc.getPredictType())) {
            pc.setPredictDate(DateUtils.getStartTime((Date)pc.getPredictDate()));
        }
        pc.setStartDate(DateUtils.getStartTime((Date)pc.getStartDate()));
        pc.setEndDate(DateUtils.getEndTime((Date)pc.getEndDate()));
        String configNo = this.orderNoService.maxNoPredictConfig("SOP");
        pc.setConfigNo(configNo);
        if (pc.getPredictType().equals("B")) {
            pc.setAllowAdjust(null);
            pc.setRollMonth(null);
            pc.setPredictDate(null);
        }
    }

    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=true) String id) {
        Employee em = this.getCurrentEmployee();
        this.predictConfigService.del(id, em);
        return "redirect:/predictConfig/list.do";
    }

    @RequestMapping(value={"/cancel.do"})
    public String cancel(@RequestParam(value="id", required=true) String id, Model model) {
        Employee em = this.getCurrentEmployee();
        if (this.predictConfigService.haveAdditionByConfigId(id, em)) {
            model.addAttribute("rtn", (Object)"<script language=\"javascript\">alert('\u8be5\u914d\u7f6e\u6709\u5f85OA\u5ba1\u6279\u6216OA\u5ba1\u6279\u901a\u8fc7\u7684\u8ffd\u52a0\u5355\uff0c\u60a8\u65e0\u6cd5\u505c\u7528\u8be5\u914d\u7f6e\uff01');window.location.href=base+'/predictConfig/list.do'</script>");
            return "common/iframeRtn.ftl";
        }
        this.predictConfigService.updateState(id, TCBJEnum.ConfigTpye.stop.getValue(), em);
        return "redirect:/predictConfig/list.do";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=true) String id, @RequestParam(value="type", required=false) String type, Model model) {
        Employee em = this.getCurrentEmployee();
        PredictConfig pc = this.predictConfigService.getPredictConfigById(id, em);
        if (Beans.isNotEmpty((Object)type) && "publish".equals(type)) {
            model.addAttribute("type", (Object)"publish");
        }
        model.addAttribute("em", (Object)em);
        model.addAttribute("predictConfig", (Object)pc);
        model.addAttribute("productData", (Object)JSON.toJSONStringWithDateFormat(pc.getProductList(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("partnerData", (Object)JSON.toJSONStringWithDateFormat(pc.getPartnerList(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("canEdit", (Object)"false");
        model.addAttribute("hidden", (Object)"true");
        return "predictConfig/view.ftl";
    }

    @RequestMapping(value={"/publish.do"})
    public String publish(@RequestParam(value="id", required=true) String id) {
        Employee em = this.getCurrentEmployee();
        this.predictConfigService.updateState(id, TCBJEnum.ConfigTpye.going.getValue(), em);
        return "redirect:/predictConfig/list.do";
    }

    @RequestMapping(value={"/partnerTree.do"})
    public String tree(HttpServletRequest request, String ids, String type, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        String tree = this.predictPartnerService.getOrgTree(e.getCurrentPartner().getId(), ids, type);
        model.addAttribute("tree", (Object)tree);
        return "predictConfig/partnerTree.ftl";
    }

    @RequestMapping(value={"/ajaxGetChildNode.do"})
    public void ajaxGetChildNode(String parentId, String level, String check, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        try {
            String result = this.predictPartnerService.getChildNodeTree(parentId, level, check, em);
            response.getWriter().write(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/getProducts.do"})
    public String getProducts() {
        return "predictConfig/selectProduct.ftl";
    }

    @RequestMapping(value={"/selectProduct.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page selectProduct(ProductCondition con) {
        try {
            if (Beans.isNotEmpty((Object)con.getProdname())) {
                con.setProdname(new String(con.getProdname().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Employee em = this.getCurrentEmployee();
        Page products = this.predictConfigService.getProducts(con, em);
        return products;
    }

    @RequestMapping(value={"/getPartners.do"})
    public String getPartners() {
        return "predictConfig/selectPartner.ftl";
    }

    @RequestMapping(value={"/selectPartner.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page get_page(PartnerCondition con) {
        try {
            if (Beans.isNotEmpty((Object)con.getName())) {
                con.setName(new String(con.getName().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Employee me = this.getCurrentEmployee();
        Page partners = this.predictConfigService.findPartners(con, me);
        return partners;
    }

    @RequestMapping(value={"/productImport.do"}, method={RequestMethod.POST})
    public String productImport(Model model, HttpServletRequest request) {
        this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "productImport");
        String url = "";
        if (filelist.size() > 0) {
            for (IUploadFile file : filelist) {
                if (!file.getFieldName().equals("uploadfile_1")) continue;
                url = file.getRealPath();
            }
        } else {
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult("\u8bf7\u4e0a\u4f20Excel\u6587\u4ef6")));
            return "common/iframeRtn.ftl";
        }
        ArrayList<PredictConfigProduct> products = new ArrayList<PredictConfigProduct>();
        List<String> errorMsgs = this.predictConfigService.readProductsByExcel(url, products);
        if (errorMsgs.size() > 0) {
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            rtn.put("code", "-1");
            rtn.put("data", errorMsgs);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        rtn.put("code", "200");
        rtn.put("data", products);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/partnerImport.do"}, method={RequestMethod.POST})
    public String partnerImport(Model model, HttpServletRequest request) {
        this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "partnerImport");
        String url = "";
        if (filelist.size() > 0) {
            for (IUploadFile file : filelist) {
                if (!file.getFieldName().equals("uploadfile_2")) continue;
                url = file.getRealPath();
            }
        } else {
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getErrorResult("\u8bf7\u4e0a\u4f20Excel\u6587\u4ef6")));
            return "common/iframeRtn.ftl";
        }
        ArrayList<Partner> partners = new ArrayList<Partner>();
        List<String> errorMsgs = this.predictConfigService.readPartnersByExcel(url, partners);
        if (errorMsgs.size() > 0) {
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            rtn.put("code", "-1");
            rtn.put("data", errorMsgs);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        rtn.put("code", "200");
        rtn.put("data", partners);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }
}

