/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictConfig;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.PredictAdditionApply;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.PredictConfigCustomerRegion;
import com.tcbj.crm.entity.PredictConfigProduct;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Excels;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="predictConfigService")
public class PredictConfigService {
    @Autowired
    BaseDao baseDao;

    public Page list(PredictConfigCondition con) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select config from PredictConfig config where 1=1 ");
        ArrayList<Object> args = new ArrayList<Object>();
        if (Beans.isNotEmpty((Object)con.getStartDate())) {
            sb.append(" and config.startDate >= ?");
            args.add(DateUtils.getStartTime((Date)con.getStartDate()));
        }
        if (Beans.isNotEmpty((Object)con.getEndDate())) {
            sb.append(" and config.startDate <= ?");
            args.add(DateUtils.getEndTime((Date)con.getEndDate()));
        }
        if (Beans.isNotEmpty((Object)con.getConfigNo())) {
            sb.append(" and config.configNo like ?");
            args.add("%" + con.getConfigNo().trim() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getConfigName())) {
            sb.append(" and config.configName like ?");
            args.add("%" + con.getConfigName().trim() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getPredictType())) {
            sb.append(" and config.predictType = ?");
            args.add(con.getPredictType());
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            sb.append(" and config.state = ?");
            args.add(con.getState());
        }
        if (Beans.isNotEmpty((Object)con.getOrgId())) {
            sb.append(" and config.orgId = ?");
            args.add(con.getOrgId());
        }
        sb.append(" order by config.lastUpdateDate desc ");
        Page page = this.baseDao.search(sb.toString(), args.toArray(), Constant.DEFAULT_ROWS, con.getPageno().intValue());
        return page;
    }

    public Page getProducts(ProductCondition con, Employee em) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Product where orgId='" + em.getCurrentPartner().getOrganizationid() + "' ");
        if (Beans.isNotEmpty((Object)con.getNo())) {
            HQL.append(" and no like ?");
            args.add("%" + con.getNo() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getNoList())) {
            String[] nolist = con.getNoList().split(",");
            HQL.append(" and no in (");
            int i = 0;
            while (i < nolist.length) {
                String s = i == nolist.length - 1 ? "'" + nolist[i].trim() + "')" : "'" + nolist[i].trim() + "',";
                HQL.append(s);
                ++i;
            }
        }
        if (Beans.isNotEmpty((Object)con.getProdname())) {
            HQL.append(" and name like ?");
            args.add("%" + con.getProdname() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getSubType())) {
            HQL.append(" and subType = ?");
            args.add(con.getSubType());
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), con.getRowsize().intValue(), con.getPageno().intValue());
    }

    public void setProducts(PredictConfig pc, Employee em) {
        List list = (List)Jsons.toBean((String)pc.getProductJson(), List.class);
        ArrayList<PredictConfigProduct> productList = new ArrayList<PredictConfigProduct>();
        for (Map map : list) {
            String prodId = map.get("productId").toString();
            String orderNum = map.get("orderNum").toString();
            PredictConfigProduct productConfig = new PredictConfigProduct();
            Product product = this.findProdById(prodId);
            productConfig.fillInitData(product, em);
            productConfig.setOrderNum(Double.valueOf(orderNum));
            productList.add(productConfig);
        }
        pc.setProductList(productList);
    }

    public Product findProdById(String prodId) {
        return (Product)this.baseDao.get(Product.class, (Serializable)((Object)prodId));
    }

    public void setPartners(PredictConfig pc, Employee em) {
        List list = (List)Jsons.toBean((String)pc.getPartnerJson(), List.class);
        ArrayList<PredictConfigCustomerRegion> partnerList = new ArrayList<PredictConfigCustomerRegion>();
        for (Map map : list) {
            Partner p;
            PredictConfigCustomerRegion partnerConfig;
            Region region;
            Date endDate;
            String level = map.get("level") == null ? "" : map.get("level").toString();
            String businessNo = map.get("businessNo") == null ? "" : map.get("businessNo").toString();
            String businessId = map.get("businessId") == null ? "" : map.get("businessId").toString();
            Date startDate = this.objToString(map.get("startDate")) == "" ? null : DateUtils.formDate((String)this.objToString(map.get("startDate")), (String)"yyyy-MM-dd");
            Date date = endDate = this.objToString(map.get("endDate")) == "" ? null : DateUtils.formDate((String)this.objToString(map.get("endDate")), (String)"yyyy-MM-dd");
            if ("1".equals(level)) {
                List<Region> regions = this.findRegionsByChannelType(businessId, em);
                if (!Beans.isNotEmpty(regions)) continue;
                for (Region r : regions) {
                    PredictConfigCustomerRegion partnerConfig2 = new PredictConfigCustomerRegion();
                    partnerConfig2.fillInitData(r, em, startDate, endDate);
                    partnerConfig2.setBusinessType("2");
                    partnerList.add(partnerConfig2);
                }
                continue;
            }
            if ("2".equals(level)) {
                region = this.findRegionById(businessId, em);
                if (!Beans.isNotEmpty((Object)region)) continue;
                partnerConfig = new PredictConfigCustomerRegion();
                partnerConfig.fillInitData(region, em, startDate, endDate);
                partnerConfig.setBusinessType("2");
                partnerList.add(partnerConfig);
                continue;
            }
            if ("3".equals(level)) {
                region = this.findRegionById(businessId, em);
                if (!Beans.isNotEmpty((Object)region)) continue;
                partnerConfig = new PredictConfigCustomerRegion();
                partnerConfig.fillInitData(region, em, startDate, endDate);
                partnerConfig.setBusinessType("3");
                partnerList.add(partnerConfig);
                continue;
            }
            if (!"4".equals(level) || !Beans.isNotEmpty((Object)(p = this.findPartnersById(businessNo, em)))) continue;
            partnerConfig = new PredictConfigCustomerRegion();
            partnerConfig.fillInitData(p, em, startDate, endDate);
            partnerConfig.setBusinessType("4");
            partnerList.add(partnerConfig);
        }
        pc.setPartnerList(partnerList);
    }

    private Partner findPartnersById(String businessNo, Employee em) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" from Partner p where p.no = ? and p.masterOuId = ? ");
        args.add(businessNo);
        args.add(em.getCurrentPartner().getOrganizationid());
        return (Partner)this.baseDao.findFirstEntity(sb.toString(), args.toArray(), Partner.class);
    }

    public Region findRegionById(String businessId, Employee em) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" from Region r where r.id = ? and r.orgId = ? ");
        args.add(businessId);
        args.add(em.getCurrentPartner().getOrganizationid());
        return (Region)this.baseDao.findFirstEntity(sb.toString(), args.toArray(), Region.class);
    }

    public List<Region> findRegionsByChannelType(String businessId, Employee em) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" from Region r where r.channelCode = ? and r.orgId = ? ");
        args.add(businessId);
        args.add(em.getCurrentPartner().getOrganizationid());
        return this.baseDao.findEntity(sb.toString(), args.toArray(), Region.class);
    }

    public void add(PredictConfig pc) {
        this.baseDao.save((Object)pc);
        for (PredictConfigProduct product : pc.getProductList()) {
            product.setConfigId(pc.getId());
            this.baseDao.save((Object)product);
        }
        for (PredictConfigCustomerRegion partner : pc.getPartnerList()) {
            partner.setConfigId(pc.getId());
            this.baseDao.save((Object)partner);
        }
    }

    public PredictConfig getPredictConfigById(String id, Employee em) {
        PredictConfig pc = (PredictConfig)this.baseDao.get(PredictConfig.class, (Serializable)((Object)id));
        pc.setProductList(this.getProductList(id, em));
        pc.setPartnerList(this.getPartnerList(id, em));
        return pc;
    }

    public List<PredictConfigCustomerRegion> getPartnerList(String id, Employee em) {
        String hql = " from PredictConfigCustomerRegion where configId = ? and orgId = ? ";
        return this.baseDao.findEntity(hql, new Object[]{id, em.getCurrentPartner().getOrganizationid()}, PredictConfigCustomerRegion.class);
    }

    public List<PredictConfigProduct> getProductList(String id, Employee em) {
        String hql = " from PredictConfigProduct where configId = ? and orgId = ? order by orderNum ";
        return this.baseDao.findEntity(hql, new Object[]{id, em.getCurrentPartner().getOrganizationid()}, PredictConfigProduct.class);
    }

    public void update(PredictConfig pc, Employee em) {
        Object[] args = new Object[]{pc.getId(), em.getCurrentPartner().getOrganizationid()};
        PredictConfig predictConfig = (PredictConfig)this.baseDao.get(PredictConfig.class, (Serializable)((Object)pc.getId()));
        predictConfig.setConfigName(pc.getConfigName());
        predictConfig.setStartDate(DateUtils.getStartTime((Date)pc.getStartDate()));
        predictConfig.setEndDate(DateUtils.getEndTime((Date)pc.getEndDate()));
        predictConfig.setRemark(pc.getRemark());
        predictConfig.setPredictType(pc.getPredictType());
        predictConfig.setAllowAdjust(pc.getAllowAdjust());
        predictConfig.setState(TCBJEnum.ConfigTpye.ready.getValue());
        predictConfig.setRollMonth(pc.getRollMonth());
        predictConfig.setPredictDate(pc.getPredictDate());
        predictConfig.setLastUpdateDate(new Date());
        this.baseDao.executeHQL("delete PredictConfigProduct where configId = ? and orgId = ? ", args);
        this.baseDao.executeHQL("delete PredictConfigCustomerRegion where configId = ? and orgId = ? ", args);
        for (PredictConfigProduct product : pc.getProductList()) {
            product.setConfigId(pc.getId());
            this.baseDao.save((Object)product);
        }
        for (PredictConfigCustomerRegion partner : pc.getPartnerList()) {
            partner.setConfigId(pc.getId());
            this.baseDao.save((Object)partner);
        }
    }

    public void del(String id, Employee em) {
        Object[] args = new Object[]{id, em.getCurrentPartner().getOrganizationid()};
        this.baseDao.executeHQL("delete PredictConfigCustomerRegion where configId = ? and orgId = ? ", args);
        this.baseDao.executeHQL("delete PredictConfigProduct where configId = ? and orgId = ? ", args);
        this.baseDao.executeHQL("delete PredictConfig where id = ? and orgId = ? ", args);
    }

    public void updateState(String id, String state, Employee em) {
        Object[] args = new Object[]{state, id, em.getCurrentPartner().getOrganizationid()};
        this.baseDao.executeHQL("update PredictConfig set state = ? where id = ? and orgId = ? ", args);
    }

    public Page findPartners(PartnerCondition con, Employee me) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Partner p where p.masterOuId = ? and p.parentPartnerId = ?  ");
        args.add(me.getCurrentPartner().getOrganizationid());
        args.add(me.getCurrentPartner().getOrganizationid());
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getNoList())) {
            String[] nolist = con.getNoList().split(",");
            hql.append(" and p.no in (");
            int i = 0;
            while (i < nolist.length) {
                String s = i == nolist.length - 1 ? "'" + nolist[i].trim() + "')" : "'" + nolist[i].trim() + "',";
                hql.append(s);
                ++i;
            }
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql.append(" and p.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql.append(" and p.areaCode = ?");
            args.add(con.getAreaCode());
        }
        hql.append(" order by p.no");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), con.getRowsize().intValue(), con.getPageno().intValue());
        return page;
    }

    public String objToString(Object o) {
        if (Beans.isNotEmpty((Object)o)) {
            return o.toString();
        }
        return "";
    }

    public boolean haveAdditionByConfigId(String id, Employee em) {
        String s = " from PredictAdditionApply pa where pa.configId = ? and pa.orgId = ? and pa.state in (?) ";
        Object[] args = new Object[]{id, em.getCurrentPartner().getOrganizationid(), Constant.PredictAdditionApplyState.approvePass.value};
        List applys = this.baseDao.findEntity(s, args, PredictAdditionApply.class);
        return Beans.isNotEmpty((Object)applys) && applys.size() > 0;
    }

    public List<String> getMonths(PredictConfig predictConfig) {
        ArrayList<String> months = new ArrayList<String>();
        String predictMonth = DateUtils.formartDate((Date)predictConfig.getPredictDate(), (String)"MM");
        Double rollMonth = predictConfig.getRollMonth();
        if (Beans.isEmpty((Object)predictMonth) || Beans.isEmpty((Object)rollMonth)) {
            return months;
        }
        int i = 1;
        while ((double)i <= rollMonth) {
            Integer month = Integer.parseInt(predictMonth) + i;
            if (month > 12) {
                month = month - 12;
            }
            months.add(month.toString());
            ++i;
        }
        return months;
    }

    public List<String> readProductsByExcel(String url, List<PredictConfigProduct> products) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        try {
            String[] headers = new String[]{"orderNum", "productNo"};
            List datas = Excels.readExcel((String)url, (InputStream)new FileInputStream(url), (String[])headers);
            if (Beans.isEmpty((Object)datas)) {
                errorMsgs.add("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u5bfc\u5165\u7684\u8868\u4e2d\u6ca1\u6709\u6570\u636e\u3002\u8bf7\u91cd\u65b0\u5bfc\u5165\uff01");
                return errorMsgs;
            }
            int j = 1;
            for (Map data : datas) {
                String errorMsg = null;
                ++j;
                Product p = null;
                PredictConfigProduct pcp = new PredictConfigProduct();
                if (Beans.isEmpty(data.get("orderNum"))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                } else if (!StringUtils.isNumeric(String.valueOf(data.get("orderNum")))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u7f16\u53f7\u9700\u4e3a\u6574\u6570\uff01";
                } else {
                    pcp.setOrderNum(Double.valueOf(String.valueOf(data.get("orderNum"))));
                }
                if (Beans.isEmpty(data.get("productNo"))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                } else {
                    p = Cache.getProductByNo(String.valueOf(data.get("productNo")));
                    if (Beans.isEmpty((Object)p)) {
                        errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u4ea7\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u627e\u4e0d\u5230\u76f8\u5173\u4ea7\u54c1\uff01";
                    } else {
                        pcp.setProductId(p.getId());
                        pcp.setProductName(p.getName());
                        pcp.setProductNo(p.getNo());
                        pcp.setOrgId(p.getOrgId());
                        pcp.setProductType(p.getSubType());
                    }
                }
                if (Beans.isNotEmpty((Object)errorMsg)) {
                    errorMsgs.add(errorMsg);
                    continue;
                }
                products.add(pcp);
            }
            if (Beans.isEmpty(errorMsgs) && Beans.isNotEmpty(products)) {
                Collections.sort(products, new Comparator<PredictConfigProduct>(){

                    @Override
                    public int compare(PredictConfigProduct p1, PredictConfigProduct p2) {
                        if (p1.getOrderNum() > p2.getOrderNum()) {
                            return 1;
                        }
                        if (p1.getOrderNum() == p2.getOrderNum()) {
                            return 0;
                        }
                        return -1;
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorMsgs;
    }

    public List<String> readPartnersByExcel(String url, List<Partner> partners) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        try {
            String[] headers = new String[]{"partnerNo"};
            List datas = Excels.readExcel((String)url, (InputStream)new FileInputStream(url), (String[])headers);
            if (Beans.isEmpty((Object)datas)) {
                errorMsgs.add("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u5bfc\u5165\u7684\u8868\u4e2d\u6ca1\u6709\u6570\u636e\u3002\u8bf7\u91cd\u65b0\u5bfc\u5165\uff01");
                return errorMsgs;
            }
            int j = 1;
            for (Map data : datas) {
                String errorMsg = null;
                ++j;
                Partner p = null;
                if (Beans.isEmpty(data.get("partnerNo"))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                    errorMsgs.add(errorMsg);
                    continue;
                }
                p = Cache.getPartnerByNo(String.valueOf(data.get("partnerNo")));
                if (Beans.isEmpty((Object)p)) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u627e\u4e0d\u5230\u76f8\u5173\u7ecf\u9500\u5546\uff01";
                }
                if (Beans.isNotEmpty(errorMsg)) {
                    errorMsgs.add(errorMsg);
                    continue;
                }
                partners.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorMsgs;
    }
}

