/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictReport;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.predictReport.PredictExcelDto;
import com.tcbj.crm.predictReport.PredictReportCondition;
import com.tcbj.crm.predictReport.PredictReportService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/predictReport"})
public class PredictReportController
extends BaseController {
    @Autowired
    PredictReportService predictReportService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@ModelAttribute(value="condition") PredictReportCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        model.addAttribute("condition", (Object)con);
        if (!em.isInnerPerson()) {
            Page page = this.predictReportService.customerList(con, em, Constant.DEFAULT_ROWS);
            model.addAttribute("page", (Object)page);
            return "predictReport/customerList.ftl";
        }
        Page page = this.predictReportService.list(con, em, Constant.DEFAULT_ROWS);
        model.addAttribute("page", (Object)page);
        return "predictReport/totallist.ftl";
    }

    @RequestMapping(value={"/listCustomerExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void listCustomerExcel(@ModelAttribute(value="condition") PredictReportCondition con, Model model, HttpServletResponse response) throws Exception {
        Employee em = this.getCurrentEmployee();
        Page page = this.predictReportService.customerList(con, em, Integer.MAX_VALUE);
        List dtos = page.getList();
        LinkedHashMap<String, String> titleMap = new LinkedHashMap<String, String>();
        titleMap.put("bigArea", "\u5927\u533a");
        titleMap.put("area", "\u533a\u57df");
        titleMap.put("partnerNo", "\u7ecf\u9500\u5546\u7f16\u7801");
        titleMap.put("partnerName", "\u7ecf\u9500\u5546\u540d\u79f0");
        titleMap.put("productNo", "\u4ea7\u54c1\u7f16\u7801");
        titleMap.put("productName", "\u4ea7\u54c1\u540d\u79f0");
        titleMap.put("customerQuantity", "\u7ecf\u9500\u5546\u9884\u6d4b");
        titleMap.put("realQuantity", "\u5b9e\u9645\u53d1\u8d27");
        titleMap.put("customerRate", "\u9884\u6d4b\u51c6\u786e\u6027(%)");
        ArrayList listExcel = new ArrayList();
        if (Beans.isNotEmpty((Object)dtos)) {
            for (PredictExcelDto dto : dtos) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                itemMap.put("bigArea", dto.getBigAreaName());
                itemMap.put("area", dto.getAreaName());
                itemMap.put("partnerNo", dto.getPartnerNo());
                itemMap.put("partnerName", dto.getPartnerName());
                itemMap.put("productNo", dto.getProductNo());
                itemMap.put("productName", dto.getProductName());
                itemMap.put("customerQuantity", dto.getCustomerQuantity());
                itemMap.put("realQuantity", dto.getRealQuantity());
                itemMap.put("customerRate", dto.getCustomerRate());
                listExcel.add(itemMap);
            }
        }
        String[] titles = new String[titleMap.size()];
        String[] pops = new String[titleMap.size()];
        int i = 0;
        for (Map.Entry e : titleMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pops[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u6708\u5ea6\u9700\u6c42\u9884\u6d4b\u51c6\u786e\u7387\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6708\u5ea6\u9700\u6c42\u9884\u6d4b\u51c6\u786e\u7387\u62a5\u8868", ".xlsx", titles, listExcel, pops, response);
    }

    @RequestMapping(value={"listExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void listExcel(@ModelAttribute(value="condition") PredictReportCondition con, Model model, HttpServletResponse response) throws Exception {
        Employee em = this.getCurrentEmployee();
        Page page = this.predictReportService.list(con, em, Constant.DEFAULT_ROWS);
        List dtos = page.getList();
        LinkedHashMap<String, String> titleMap = new LinkedHashMap<String, String>();
        titleMap.put("productNo", "\u4ea7\u54c1\u7f16\u7801");
        titleMap.put("productName", "\u4ea7\u54c1\u540d\u79f0");
        titleMap.put("productUnit", "\u5242\u578b");
        titleMap.put("productSubType", "\u4ea7\u54c1\u7c7b\u522b");
        titleMap.put("companyQuantity", "\u516c\u53f8\u9884\u6d4b\u6700\u7ec8\u503c");
        titleMap.put("companyRate", "\u516c\u53f8\u9884\u6d4b\u51c6\u786e\u6027(%)");
        titleMap.put("customerQuantity", "\u7ecf\u9500\u5546\u9884\u6d4b");
        titleMap.put("realQuantity", "\u5b9e\u9645\u53d1\u8d27\u91cf");
        titleMap.put("customerRate", "\u9884\u6d4b\u51c6\u786e\u6027(%)");
        ArrayList listExcel = new ArrayList();
        if (Beans.isNotEmpty((Object)dtos)) {
            for (PredictExcelDto dto : dtos) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                itemMap.put("productNo", dto.getProductNo());
                itemMap.put("productName", dto.getProductName());
                itemMap.put("productUnit", dto.getUnitName());
                itemMap.put("productSubType", dto.getSubTypeName());
                itemMap.put("companyQuantity", dto.getCompanyQuantity());
                itemMap.put("companyRate", dto.getCompanyRate());
                itemMap.put("customerQuantity", dto.getCustomerQuantity());
                itemMap.put("realQuantity", dto.getRealQuantity());
                itemMap.put("customerRate", dto.getCustomerRate());
                listExcel.add(itemMap);
            }
        }
        String[] titles = new String[titleMap.size()];
        String[] pops = new String[titleMap.size()];
        int i = 0;
        for (Map.Entry e : titleMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pops[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u6708\u5ea6\u9700\u6c42\u9884\u6d4b\u51c6\u786e\u7387\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6708\u5ea6\u9700\u6c42\u9884\u6d4b\u51c6\u786e\u7387\u62a5\u8868", ".xlsx", titles, listExcel, pops, response);
    }
}

