/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictReport;

import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PredictAdjustPartner;
import com.tcbj.crm.entity.PredictAdjustTotal;
import com.tcbj.crm.entity.PredictApplyItem;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.predictReport.PredictExcelDto;
import com.tcbj.crm.predictReport.PredictReportCondition;
import com.tcbj.crm.util.RequestHelper;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="predictReportService")
public class PredictReportService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private PredictApplyService predictApplyService;

    public Page list(PredictReportCondition con, Employee em, int pageSize) {
        Page page = new Page(null, 1, 10, 0);
        if (Beans.isEmpty((Object)con.getPredictDate())) {
            return page;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(con.getPredictDate());
        PredictConfig pc = this.getpredictConfig(con.getPredictDate(), em);
        if (Beans.isEmpty((Object)pc)) {
            return page;
        }
        page = this.companyList(pc, con, em, pageSize);
        List dtos = page.getList();
        Map<String, Double> monthQuantity = this.getMonthAverageShipmentByProduct(con.getPredictDate());
        if (Beans.isNotEmpty((Object)dtos)) {
            for (PredictExcelDto dto : dtos) {
                Double companyQuantity = null;
                companyQuantity = "0".equals(pc.getAllowAdjust()) ? this.getFinallyQuantityPartner(pc.getId(), dto.getPartnerId(), dto.getProductId(), em.getCurrentPartner().getOrganizationid(), String.valueOf(cal.get(2) + 1)) : this.getFinallyQuantityPartnerTotal(pc.getId(), dto.getProductId(), em.getCurrentPartner().getOrganizationid(), String.valueOf(cal.get(2) + 1));
                dto.setCompanyQuantity(companyQuantity);
                dto.setRealQuantity(monthQuantity.get(dto.getProductId()));
                DecimalFormat df = new DecimalFormat("#.00");
                String companyRate = companyQuantity == null || companyQuantity == 0.0 || dto.getRealQuantity() == null ? "" : df.format(dto.getRealQuantity() / companyQuantity * 100.0);
                dto.setCompanyRate(companyRate);
                String customerRate = dto.getCustomerQuantity() == null || dto.getCustomerQuantity() == 0.0 || dto.getRealQuantity() == null ? "" : df.format(dto.getRealQuantity() / dto.getCustomerQuantity() * 100.0);
                dto.setCompanyRate(customerRate);
            }
        }
        return page;
    }

    public Map<String, Object> getCustomerQuantity(String id, String orgId, String productId, String month) {
        String s = " select pa.product_Id,sum(pa.quantity) from CX_PREDICT_APPLY_ITEM pa where pa.config_Id = ? and pa.org_Id = ? and pa.product_Id = ? and pa.predict_month = ? group by pa.product_Id ";
        List list = this.baseDao.findBySql(s, new Object[]{id, orgId, productId, month});
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Beans.isNotEmpty((Object)list) && list.size() > 0) {
            result.put("customerQuantity", ((Object[])list.get(0))[1]);
        }
        return result;
    }

    public Double getFinallyQuantityPartner(String id, String partnerId, String productId, String orgId, String month) {
        String s = " from PredictAdjustPartner where configId = ? and partnerId = ? and productId = ? and orgId = ? and month = ? and adjustType = 'finality'  ";
        PredictAdjustPartner pa = (PredictAdjustPartner)this.baseDao.findFirstEntity(s, new Object[]{id, partnerId, productId, orgId, month}, PredictAdjustPartner.class);
        return Beans.isNotEmpty((Object)pa) ? pa.getQuantity() : null;
    }

    public Double getFinallyQuantityPartnerTotal(String id, String productId, String orgId, String month) {
        String s = " from PredictAdjustTotal where configId = ? and productId = ? and orgId = ? and month = ? and adjustType = 'finality'  ";
        PredictAdjustTotal pa = (PredictAdjustTotal)this.baseDao.findFirstEntity(s, new Object[]{id, productId, orgId, month}, PredictAdjustTotal.class);
        return Beans.isNotEmpty((Object)pa) ? pa.getQuantity() : null;
    }

    public PredictConfig getpredictConfig(Date predictDate, Employee em) {
        PredictConfig pc = new PredictConfig();
        int i = 1;
        while (i <= 6) {
            Date date = DateUtils.getDateBeforeMonth((Date)DateUtils.getStartTime((Date)predictDate), (int)i);
            ArrayList<Object> args = new ArrayList<Object>();
            StringBuilder hql = new StringBuilder(" select pc from PredictConfig pc where pc.predictType = 'A' and pc.state = '5' and pc.predictDate = ? and pc.orgId = ? ");
            args.add(date);
            args.add(em.getCurrentPartner().getOrganizationid());
            hql.append(" order by pc.lastUpdateDate desc ");
            pc = (PredictConfig)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), PredictConfig.class);
            if (Beans.isNotEmpty((Object)pc) && Beans.isNotEmpty((Object)pc.getId())) {
                return pc;
            }
            ++i;
        }
        return null;
    }

    public Page companyList(PredictConfig pc, PredictReportCondition con, Employee em, int pageSize) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" select pa from PredictApplyItem pa where pa.configId = ? and pa.orgId = ? ");
        args.add(pc.getId());
        args.add(em.getCurrentPartner().getOrganizationid());
        sb.append(" and pa.predictMonth = ? ");
        Calendar cal = Calendar.getInstance();
        cal.setTime(con.getPredictDate());
        args.add(String.valueOf(cal.get(2) + 1));
        if (Beans.isNotEmpty((Object)con.getProductId())) {
            sb.append(" and pa.productId = ? ");
            args.add(con.getProductId());
        }
        Page page = this.baseDao.search(sb.toString(), args.toArray(), pageSize, con.getPageno().intValue());
        List list = page.getList();
        ArrayList<PredictExcelDto> newlist = new ArrayList<PredictExcelDto>();
        HashMap<String, PredictExcelDto> dtoMap = new HashMap<String, PredictExcelDto>();
        for (PredictApplyItem predictApplyItem : list) {
            PredictExcelDto dto = (PredictExcelDto)dtoMap.get(predictApplyItem.getId());
            if (Beans.isEmpty((Object)dto)) {
                dto = new PredictExcelDto();
                dto.setProductId(predictApplyItem.getProductId());
                dto.setCustomerQuantity(predictApplyItem.getQuantity());
                dtoMap.put(dto.getProductId(), dto);
            }
            dtoMap.remove(dto.getProductId());
            dto.setCustomerQuantity(dto.getCustomerQuantity() + predictApplyItem.getQuantity());
            dtoMap.put(dto.getProductId(), dto);
        }
        for (Map.Entry entry : dtoMap.entrySet()) {
            newlist.add((PredictExcelDto)entry.getValue());
        }
        page.setList(newlist);
        return page;
    }

    public Page customerList(PredictReportCondition con, Employee em, int pageSize) {
        Page page = new Page(null, 1, 10, 0);
        if (Beans.isEmpty((Object)con.getPredictDate())) {
            return page;
        }
        PredictConfig pc = this.getCustomerPredictConfig(con.getPredictDate(), em);
        if (Beans.isEmpty((Object)pc)) {
            return page;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" select pa from PredictApplyItem pa where pa.configId = ? and pa.orgId = ? ");
        args.add(pc.getId());
        args.add(em.getCurrentPartner().getOrganizationid());
        sb.append(" and pa.applyerId = ? ");
        args.add(em.getCurrentPartner().getId());
        sb.append(" and pa.predictMonth = ? ");
        Calendar cal = Calendar.getInstance();
        cal.setTime(con.getPredictDate());
        args.add(String.valueOf(cal.get(2) + 1));
        if (Beans.isNotEmpty((Object)con.getProductId())) {
            sb.append(" and pa.productId = ? ");
            args.add(con.getProductId());
        }
        page = this.baseDao.search(sb.toString(), args.toArray(), pageSize, con.getPageno().intValue());
        List list = page.getList();
        ArrayList<PredictExcelDto> newlist = new ArrayList<PredictExcelDto>();
        Map<String, Double> monthQuantity = this.getMonthAverageShipmentByProduct(con.getPredictDate());
        for (PredictApplyItem apply : list) {
            PredictExcelDto dto = new PredictExcelDto();
            dto.setPartnerId(em.getCurrentPartner().getId());
            dto.setProductId(apply.getProductId());
            dto.setCustomerQuantity(apply.getQuantity());
            dto.setRealQuantity(monthQuantity.get(dto.getProductId()));
            DecimalFormat df = new DecimalFormat("#.00");
            String rate = apply.getQuantity() == null || apply.getMonthAverage() == null || apply.getQuantity() == 0.0 ? "" : df.format(apply.getMonthAverage() / apply.getQuantity() * 100.0);
            dto.setCustomerRate(rate);
            newlist.add(dto);
        }
        page.setList(newlist);
        return page;
    }

    public PredictConfig getCustomerPredictConfig(Date predictDate, Employee em) {
        PredictConfig pc = new PredictConfig();
        int i = 1;
        while (i <= 6) {
            Date date = DateUtils.getDateBeforeMonth((Date)DateUtils.getStartTime((Date)predictDate), (int)i);
            ArrayList<Object> args = new ArrayList<Object>();
            StringBuilder hql = new StringBuilder(" select pc from PredictConfig pc where pc.predictType = 'A' and pc.state = '5' and pc.predictDate = ? and pc.orgId = ? ");
            args.add(date);
            args.add(em.getCurrentPartner().getOrganizationid());
            hql.append(" and exists (select 1 from PredictConfigCustomerRegion pccr where pc.id = pccr.configId   and ( pccr.businessId = ? or pccr.businessId = ? or pccr.businessId = ? ))");
            args.add(em.getCurrentPartner().getId());
            args.add(Cache.getPartnerById(em.getCurrentPartner().getId()).getAreaCode());
            args.add(Cache.getPartnerById(em.getCurrentPartner().getId()).getBigAreaCode());
            hql.append(" order by pc.lastUpdateDate desc ");
            pc = (PredictConfig)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), PredictConfig.class);
            if (Beans.isNotEmpty((Object)pc) && Beans.isNotEmpty((Object)pc.getId())) {
                return pc;
            }
            ++i;
        }
        return null;
    }

    public Map<String, Double> getMonthAverageShipmentByProduct(Date month) {
        String preMonth = DateUtils.formartDate2((Date)month, (String)"yyyy-MM");
        HashMap<String, Double> result = new HashMap<String, Double>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String selectSql = " substr(FMATERIALNUMBER, instr(FMATERIALNUMBER, '.', -1) + 1)  as productNo, sum(FQTY) as quantity ";
        String whereSql = " where FBIZDATE = '" + preMonth + "' group by FMATERIALNUMBER";
        param.put("where", whereSql);
        param.put("sql", selectSql);
        param.put("currentPage", 1);
        param.put("pageSize", 1000);
        List rtn = (List)RequestHelper.getInstance().sendRequest(String.valueOf(ConfigFactory.get().get("eas_stock")) + "queryIssueQtyAmountNoCustomer", param);
        if (Beans.isNotEmpty((Object)rtn)) {
            for (Map stock : rtn) {
                Product p = Cache.getProductByNo(stock.get("PRODUCTNO").toString());
                if (!Beans.isNotEmpty((Object)p)) continue;
                result.put(p.getId(), Beans.isEmpty(stock.get("QUANTITY")) ? 0.0 : Double.valueOf(stock.get("QUANTITY").toString()));
            }
        }
        return result;
    }

    public Map<String, Double> getMonthAverageShipmentByProductAndPartner(String partnerId, Date month) {
        String partnerNo = Cache.getPartnerCSN(partnerId);
        String preMonth = DateUtils.formartDate2((Date)month, (String)"yyyy-MM");
        HashMap<String, Double> result = new HashMap<String, Double>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String selectSql = " substr(FMATERIALNUMBER, instr(FMATERIALNUMBER, '.', -1) + 1)  as productNo, sum(FQTY) as quantity ";
        String whereSql = " where FBIZDATE = '" + preMonth + "' and FCUSTOMERNUMBER = '" + partnerNo + "' group by FMATERIALNUMBER";
        param.put("where", whereSql);
        param.put("sql", selectSql);
        param.put("currentPage", 1);
        param.put("pageSize", 1000);
        List rtn = (List)RequestHelper.getInstance().sendRequest(String.valueOf(ConfigFactory.get().get("eas_stock")) + "queryIssueQtyAmountNoCustomer", param);
        if (Beans.isNotEmpty((Object)rtn)) {
            for (Map stock : rtn) {
                Product p = Cache.getProductByNo(stock.get("PRODUCTNO").toString());
                if (!Beans.isNotEmpty((Object)p)) continue;
                result.put(p.getId(), Beans.isEmpty(stock.get("QUANTITY")) ? 0.0 : Double.valueOf(stock.get("QUANTITY").toString()));
            }
        }
        return result;
    }
}

