/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.priceAdjust;

import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PrAdjdetail;
import com.tcbj.crm.entity.PriceAdjust;
import com.tcbj.crm.priceAdjust.PrAdjdetailCondition;
import com.tcbj.crm.priceAdjust.PriceAdjustCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceadjustService")
public class PriceAdjustService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;

    public PriceAdjust get(String id, Employee em) {
        PriceAdjust p = (PriceAdjust)this.baseDao.get(PriceAdjust.class, (Serializable)((Object)id));
        Object[] args = new Object[]{p.getId()};
        String regionids = this.personnelService.getFRegionsByUserId(em.getId());
        List list = this.baseDao.findEntity("from PrAdjdetail p,Customer c  where ( c.areaCode in (" + regionids + ") or c.bigAreaCode in (" + regionids + ") ) and p.adjustmentId = ? and p.applyerId = c.applyerId", args, PrAdjdetail.class);
        p.setPrAdjdetailList(list);
        return p;
    }

    public void save(PriceAdjust obj) {
        this.baseDao.save((Object)obj);
        try {
            List<PrAdjdetail> list = obj.getPrAdjdetailList();
            for (PrAdjdetail prAdjdetail : list) {
                prAdjdetail.setAdjustmentId(obj.getId());
                this.baseDao.save((Object)prAdjdetail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updatePriceAdjust(PriceAdjust pa) {
        this.baseDao.update((Object)pa);
    }

    public Page getList(int pageno, PriceAdjustCondition condition) {
        StringBuffer HQL = new StringBuffer();
        String regionids = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        HQL.append(" select o.id from PriceAdjust o, PrAdjdetail p ,Customer c where  ( c.areaCode in (" + regionids + ") or c.bigAreaCode in (" + regionids + ") ) and c.applyerId = p.applyerId  ");
        HQL.append(" and o.id = p.adjustmentId ");
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(condition.getAdjustmentName())) {
            HQL.append(" and o.adjustmentName like ? ");
            args.add("%" + condition.getAdjustmentName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append("and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotNull(condition.getStartDate())) {
            HQL.append(" and o.startDate >= ? ");
            args.add(condition.getStartDate());
        }
        if (StringUtils.isNotNull(condition.getEndDateHQL())) {
            HQL.append(" and o.startDate < ? ");
            args.add(condition.getEndDateHQL());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and p.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getProductId())) {
            HQL.append(" and p.productId = ? ");
            args.add(condition.getProductId());
        }
        if (StringUtils.isNotNull(condition.getPrice())) {
            HQL.append(" and p.price = ? ");
            args.add(condition.getPrice());
        }
        if (StringUtils.isNotNull(condition.getMarkUp())) {
            HQL.append(" and p.markUp = ? ");
            args.add(condition.getMarkUp());
        }
        if (StringUtils.isNotNull(condition.getDisCount())) {
            HQL.append(" and p.disCount = ? ");
            args.add(condition.getDisCount());
        }
        if (StringUtils.isNotEmpty(condition.getRemark())) {
            HQL.append(" and p.remark like ? ");
            args.add("%" + condition.getRemark() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getIsUse())) {
            if ("Y".equals(condition.getIsUse())) {
                HQL.append(" and o.startDate < ? and (o.endDate > ? or o.endDate is null) ");
                args.add(new Date());
                args.add(new Date());
            } else {
                HQL.append(" and o.endDate <= ? ");
                args.add(new Date());
            }
        }
        HQL.append("order by o.createDt desc ");
        List list = this.baseDao.findEntity(HQL.toString(), args.toArray(), Object.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object obj : list) {
            set.add((String)obj);
        }
        if (set.size() > 0) {
            String pf = "";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String cfr_ignored_0 = (String)iterator.next();
                pf = String.valueOf(pf) + "?,";
            }
            pf = pf.substring(0, pf.length() - 1);
            String hql = " from PriceAdjust p where p.id in ( " + pf + ") order by createDt desc";
            Page page = this.baseDao.search(hql, set.toArray(), Constant.DEFAULT_ROWS, pageno);
            return page;
        }
        return new Page(new ArrayList(), 1, Constant.DEFAULT_ROWS, 0);
    }

    public void update(PriceAdjust obj, Employee me) {
        this.baseDao.update((Object)obj);
        try {
            List<PrAdjdetail> list = obj.getPrAdjdetailList();
            for (PrAdjdetail pa : list) {
                pa.fillInitData(me);
                pa.setAdjustmentId(obj.getId());
                if (StringUtils.isNotEmpty(pa.getId())) {
                    this.baseDao.update((Object)pa);
                    continue;
                }
                this.baseDao.save((Object)pa);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete(String id) {
        PriceAdjust qyAllot = (PriceAdjust)this.baseDao.get(PriceAdjust.class, (Serializable)((Object)id));
        qyAllot.setEndDate(DateUtils.now());
        this.baseDao.update((Object)qyAllot);
    }

    public void delete(PriceAdjust obj) {
        Object[] args = new Object[]{obj.getId()};
        this.baseDao.delete((Object)obj);
        this.baseDao.executeHQL("delete PrAdjdetail where adjustmentId =?", args);
        this.baseDao.deleteAll(obj.getPrAdjdetailList());
    }

    public void deletePA(String id) {
        this.baseDao.deleteById(PrAdjdetail.class, (Serializable)((Object)id));
    }

    public List<PrAdjdetail> getList(String applyerId, String supplierId, Date findDate) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer HQL = new StringBuffer();
        HQL.append("from PriceAdjust p,PrAdjdetail a where a.adjustmentId = p.id ");
        if (StringUtils.isNotEmpty(supplierId)) {
            HQL.append(" and p.supplierId = ?");
            args.add(supplierId);
        }
        if (StringUtils.isNotEmpty(applyerId)) {
            HQL.append(" and a.applyerId = ?");
            args.add(applyerId);
        }
        HQL.append(" and p.startDate <= ? and nvl(p.endDate,?) >= ? ");
        args.add(findDate);
        args.add(DateUtils.getEndTime());
        args.add(findDate);
        HQL.append(" and a.startDate <= ? and nvl(a.endDate,?) >= ? ");
        args.add(findDate);
        args.add(DateUtils.getEndTime());
        args.add(findDate);
        HQL.append(" order by p.createDt desc ");
        List objects = this.baseDao.findEntity(HQL.toString(), args.toArray(), Object[].class);
        ArrayList<PrAdjdetail> list = new ArrayList<PrAdjdetail>();
        for (Object[] obj : objects) {
            list.add((PrAdjdetail)obj[1]);
        }
        return list;
    }

    public boolean isApplyer(String applyerId, String productId, Date startDate) {
        Page page;
        boolean isexist = false;
        StringBuffer HQL = new StringBuffer();
        HQL.append("from PrAdjdetail g where 1=1");
        ArrayList<Object> args = new ArrayList<Object>();
        if (startDate != null) {
            HQL.append("and g.startDate = ?");
            args.add(startDate);
        }
        if (StringUtils.isNotEmpty(applyerId)) {
            HQL.append("and g.applyerId = ?");
            args.add(applyerId);
        }
        if (StringUtils.isNotEmpty(productId)) {
            HQL.append("and g.productId = ?");
            args.add(productId);
        }
        if ((page = this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, 0)).getList().size() > 0) {
            isexist = true;
        }
        return isexist;
    }

    Page getPrAdjdetails(PrAdjdetailCondition con) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        String regionids = this.personnelService.getFRegionsByUserId(con.getEm().getId());
        sb.append("from PrAdjdetail p,Customer c where ( c.areaCode in (" + regionids + ") or c.bigAreaCode in (" + regionids + ") ) and p.applyerId = c.applyerId and p.adjustmentId = ? ");
        args.add(con.getId());
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            sb.append(" and p.applyerId=? ");
            args.add(con.getApplyerId());
        }
        if (StringUtils.isNotEmpty(con.getProductId())) {
            sb.append(" and p.productId=? ");
            args.add(con.getProductId());
        }
        Page pg = this.baseDao.search(sb.toString(), args.toArray(), con.getRowsize().intValue(), con.getPageno().intValue());
        List obs = pg.getList();
        ArrayList<PrAdjdetail> page = new ArrayList<PrAdjdetail>();
        for (Object[] ob : obs) {
            page.add((PrAdjdetail)ob[0]);
        }
        pg.setList(page);
        return pg;
    }

    public boolean validateName(String name, String id, String partnerId) {
        PriceAdjust pa;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sb.append("from PriceAdjust where supplierId = ? and adjustmentName = ? ");
        args.add(partnerId);
        args.add(name);
        if (StringUtils.isNotEmpty(id)) {
            sb.append(" and id != ? ");
            args.add(id);
        }
        return StringUtils.isNotNull(pa = (PriceAdjust)this.baseDao.findFirstEntity(sb.toString(), args.toArray(), PriceAdjust.class));
    }
}

