/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.product;

import com.tcbj.crm.base.BaseService;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PartnerProduct;
import com.tcbj.crm.entity.PartnerProductREL;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.product.HintNumber;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.util.ImportData;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ProductService")
public class ProductService
extends BaseService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    PartnerService partnerService;
    @Autowired
    Cache cache;

    public Product get(String id) {
        return (Product)this.baseDao.get(Product.class, (Serializable)((Object)id));
    }

    public PartnerProduct getPartnerProduct(String partnerId, String productId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from PartnerProduct where partnerId = ? and productId = ? ");
        args.add(partnerId);
        args.add(productId);
        PartnerProduct p = (PartnerProduct)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), PartnerProduct.class);
        return p;
    }

    public Page findPartners(ProductCondition con, String no, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Product where orgId='" + this.getCurrentEmployee().getCurrentPartner().getOrganizationid() + "' ");
        if (StringUtils.isNotBlank((String)no)) {
            HQL.append(" and no like ?");
            args.add("%" + no + "%");
        }
        if (con != null && StringUtils.isNotBlank((String)con.getProdname())) {
            HQL.append(" and name like ?");
            args.add("%" + con.getProdname() + "%");
        }
        if (con != null && StringUtils.isNotBlank((String)con.getSubType())) {
            HQL.append(" and subType = ?");
            args.add(con.getSubType());
        }
        if (con != null && StringUtils.isNotBlank((String)con.getBrand())) {
            HQL.append(" and brand = ?");
            args.add(con.getBrand());
        }
        HQL.append(" and status !='Inactive'");
        HQL.append(" and no is not null order by no ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page getProducts(String supplierId, String prodno, ProductCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(con.getEm().getId());
        args.add(supplierId);
        args.add(prodno);
        args.add(supplierId);
        StringBuffer sf = new StringBuffer();
        sf.append("select a,c from Customer a left join a.ppREL c with c.supplierId=? and c.productId=?  where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and  a.supplierId=? ");
        if (StringUtils.isNotEmpty((String)con.getProdname())) {
            sf.append(" and a.applyerName like ? ");
            args.add("%" + con.getProdname() + "%");
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflasedate())) {
            if ("true".equals(con.getTrueorflasedate())) {
                sf.append("and c.invalidDt is not null ");
            } else {
                sf.append("and c.invalidDt is null ");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflaseDisplay())) {
            if ("true".equals(con.getTrueorflaseDisplay())) {
                sf.append(" and c.isDisplay ='Y' ");
            } else {
                sf.append(" and c.isDisplay ='N' ");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getNo())) {
            String applyerCodes = con.getNo();
            String[] applyerCode = null;
            if (applyerCodes.contains(",")) {
                applyerCode = applyerCodes.split(",");
            } else if (applyerCodes.contains("\uff0c")) {
                applyerCode = applyerCodes.split("\uff0c");
            }
            if (applyerCode != null) {
                sf.append(" and a.applyerCode in ( ");
                int i = 0;
                while (i < applyerCode.length) {
                    sf.append(i == 0 ? "?" : ",?");
                    args.add(applyerCode[i]);
                    ++i;
                }
                sf.append(" )");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getSaleChannelTypeCode())) {
            sf.append(" and a.partnerChnlType = ? ");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty((String)con.getAreaCode())) {
            sf.append(" and a.areaCode = ? ");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty((String)con.getBigAreaCode())) {
            sf.append(" and a.bigAreaCode = ? ");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty((String)con.getBrand())) {
            sf.append(" and a.fax = ? ");
            args.add(con.getBrand());
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflase())) {
            if ("true".equals(con.getTrueorflase())) {
                sf.append(" and a.applyerId in (select d.applyerId from Customer d,PartnerProductREL e where d.applyerId=e.partnerId and e.supplierId=? and e.productId=?) ");
                args.add(supplierId);
                args.add(prodno);
            } else {
                sf.append(" and a.applyerId not in (select d.applyerId from Customer d,PartnerProductREL e where d.applyerId=e.partnerId and e.supplierId=? and e.productId=?) ");
                args.add(supplierId);
                args.add(prodno);
            }
        }
        sf.append(" and a.startdate <= ? and nvl(a.enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        sf.append(" order by a.bigAreaCode,a.areaCode ");
        Page page = this.baseDao.search(sf.toString(), args.toArray(), 500, pageno);
        return page;
    }

    public Page getProducts(String applyerId, ProductCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        Employee e = this.getCurrentEmployee();
        args.add(applyerId);
        args.add(e.getCurrentPartner().getId());
        hql.append(" from Product a left join a.ppREL c with c.partnerId=? and c.supplierId=? where  a.orgId='" + this.getCurrentEmployee().getCurrentPartner().getOrganizationid() + "' ");
        if (StringUtils.isNotEmpty((String)con.getSubType())) {
            hql.append("and a.subType = ?");
            args.add(con.getSubType());
        }
        if (StringUtils.isNotEmpty((String)con.getBrand())) {
            hql.append("and a.brand = ?");
            args.add(con.getBrand());
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflaseDisplay())) {
            if ("true".equals(con.getTrueorflaseDisplay())) {
                hql.append(" and c.isDisplay ='Y' ");
            } else {
                hql.append(" and c.isDisplay ='N' ");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflasedate())) {
            if ("true".equals(con.getTrueorflasedate())) {
                hql.append("and c.invalidDt is not null ");
            } else {
                hql.append("and c.invalidDt is null ");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getNo())) {
            if (con.getNo().indexOf(",") != -1 && con.getNo().split(",").length > 1) {
                String[] nos = con.getNo().split(",");
                int i = 0;
                while (i < nos.length) {
                    String no = nos[i];
                    no = no.trim().replaceAll("\n", "");
                    if (i == 0) {
                        hql.append(" and (upper(a.no)=upper('" + no + "')");
                    } else if (i == nos.length - 1) {
                        hql.append(" or upper(a.no)=upper('" + no + "'))");
                    } else {
                        hql.append(" or upper(a.no)=upper('" + no + "')");
                    }
                    ++i;
                }
            } else {
                hql.append("and upper(a.no) like ?");
                args.add("%" + con.getNo().toUpperCase() + "%");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getProdname())) {
            hql.append("and a.name like ?");
            args.add("%" + con.getProdname() + "%");
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflase())) {
            if ("true".equals(con.getTrueorflase())) {
                hql.append(" and a.id in (select d.id from Product d,PartnerProductREL e where d.id=e.productId and e.partnerId=? and e.supplierId=?) ");
                args.add(applyerId);
                args.add(e.getCurrentPartner().getId());
            } else {
                hql.append(" and a.id not in (select d.id from Product d,PartnerProductREL e where d.id=e.productId and e.partnerId=? and e.supplierId=?) ");
                args.add(applyerId);
                args.add(e.getCurrentPartner().getId());
            }
        }
        hql.append(" and a.no is not null order by a.no ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), 250, pageno);
        return page;
    }

    public Page getMyProducts(String id, String no, String prodname, ProductCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        hql.append("from Product a,PartnerProduct b,PartnerProductREL c where a.id=b.productId and c.partnerId=? and a.id=c.productId and  b.partnerId=c.partnerId ");
        if (StringUtils.isNotBlank((String)no)) {
            hql.append("and a.no like ?");
            args.add("%" + no + "%");
        }
        if (StringUtils.isNotBlank((String)prodname)) {
            hql.append("and a.name like ?");
            args.add("%" + prodname + "%");
        }
        if (StringUtils.isNotBlank((String)con.getSupplierId())) {
            hql.append("and c.supplierId = ?");
            args.add(con.getSupplierId());
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflasedate())) {
            if ("true".equals(con.getTrueorflasedate())) {
                hql.append("and c.invalidDt is not null ");
            } else {
                hql.append("and c.invalidDt is null ");
            }
        }
        hql.append(" order by a.no ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public List<Object[]> getMyProducts(String id, String applyerId, ProductCondition con) throws ParseException {
        StringBuffer hql = new StringBuffer();
        hql.append("select t3.Row_Id,t3.PRODNO,t3.ProdSpec,t3.ProdType,t3.SubType,t2.invalid_date,t2.creator_id,t2.create_dt,t3.Name,t3.UNITTYPE,t2.is_disaply from  CX_AWK_PRODLIST_VIEW t3, CX_DISTRIBU_REL T2,CX_DL_DISTRIBU T1  where t2.supplier_id(+)=? and t1.product_code_id=t2.product_id(+) and T1.dealer_id = ? and t2.partner_id(+)=? and t3.Row_Id=t1.product_code_id ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        args.add(id);
        args.add(applyerId);
        if (StringUtils.isNotEmpty((String)con.getProdname())) {
            hql.append(" and t3.NAME like ? ");
            args.add("%" + con.getProdname() + "%");
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflaseDisplay())) {
            if ("true".equals(con.getTrueorflaseDisplay())) {
                hql.append(" and t2.is_disaply ='Y' ");
            } else {
                hql.append(" and t2.is_disaply ='N' ");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getSubType())) {
            hql.append("and t3.subType = ?");
            args.add(con.getSubType());
        }
        if (StringUtils.isNotEmpty((String)con.getBrand())) {
            hql.append("and a.brand = ?");
            args.add(con.getBrand());
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflasedate())) {
            if ("true".equals(con.getTrueorflasedate())) {
                hql.append("and t2.INVALID_DATE is not null ");
            } else {
                hql.append("and t2.INVALID_DATE is null ");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getNo())) {
            if (con.getNo().indexOf(",") != -1 && con.getNo().split(",").length > 1) {
                String[] nos = con.getNo().split(",");
                int i = 0;
                while (i < nos.length) {
                    String no = nos[i];
                    no = no.trim().replaceAll("\n", "");
                    if (i == 0) {
                        hql.append(" and (upper(t3.ProdNo)=upper('" + no + "')");
                    } else if (i == nos.length - 1) {
                        hql.append(" or upper(t3.ProdNo)=upper('" + no + "'))");
                    } else {
                        hql.append(" or upper(t3.ProdNo)=upper('" + no + "')");
                    }
                    ++i;
                }
            } else {
                hql.append(" and upper(t3.ProdNo) like ? ");
                args.add("%" + con.getNo().toUpperCase() + "%");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflase())) {
            if ("true".equals(con.getTrueorflase())) {
                hql.append(" and t3.Row_Id in (select t3.row_id from  CX_AWK_PRODLIST_VIEW t3, CX_DISTRIBU_REL T2, CX_DL_DISTRIBU T1 where t2.supplier_id = ? and t1.product_code_id = t2.product_id and T1.dealer_id = ? and t2.partner_id = ? and t3.Row_Id = t1.product_code_id) ");
                args.add(id);
                args.add(id);
                args.add(applyerId);
            } else {
                hql.append(" and t3.Row_Id not in (select t3.row_id from  CX_AWK_PRODLIST_VIEW t3, CX_DISTRIBU_REL T2, CX_DL_DISTRIBU T1 where t2.supplier_id = ? and t1.product_code_id = t2.product_id and T1.dealer_id = ? and t2.partner_id = ? and t3.Row_Id = t1.product_code_id) ");
                args.add(id);
                args.add(id);
                args.add(applyerId);
            }
        }
        hql.append(" and t3.PRODNO is not null order by t3.PRODNO ");
        List list = this.baseDao.findBySql(hql.toString(), args.toArray());
        ArrayList<Object[]> prods = new ArrayList<Object[]>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Object[] obj : list) {
            Product prod = new Product();
            if (obj[0] != null) {
                prod.setId(obj[0].toString());
            }
            if (obj[1] != null) {
                prod.setNo(obj[1].toString());
            }
            if (obj[2] != null) {
                prod.setSpec(obj[2].toString());
            }
            if (obj[3] != null) {
                prod.setType(obj[3].toString());
            }
            if (obj[4] != null) {
                prod.setSubType(obj[4].toString());
            }
            if (obj[8] != null) {
                prod.setName(obj[8].toString());
            }
            if (obj[9] != null) {
                prod.setUnitCode(obj[9].toString());
            }
            PartnerProductREL ppRel = new PartnerProductREL();
            if (obj[5] != null) {
                ppRel.setInvalidDt(sdf.parse(obj[5].toString()));
            }
            if (obj[6] != null) {
                ppRel.setCreatorId(obj[6].toString());
            }
            if (obj[7] != null) {
                ppRel.setCreateDt(sdf.parse(obj[7].toString()));
            }
            if (obj[10] != null) {
                ppRel.setIsDisplay(obj[10].toString());
            }
            prods.add(new Object[]{prod, ppRel});
        }
        return prods;
    }

    public List<Object> getPartnerProducts(String applyId, String supplierId, boolean isvalid) {
        StringBuffer hql = new StringBuffer();
        Partner supplier = this.partnerService.getSimplePartner(supplierId);
        if (supplier.isOrg()) {
            hql.append(" from Product a ,PartnerProductREL c where a.id=c.productId and c.partnerId=? and c.supplierId=? ");
        } else {
            hql.append(" from Product a ,PartnerProductREL c,PartnerProduct b where a.id=c.productId and b.productId=a.id and b.partnerId=c.supplierId and c.partnerId=? and c.supplierId=? ");
        }
        if (isvalid) {
            hql.append(" and nvl(c.invalidDt,sysdate + 1) > sysdate ");
        }
        String orgId = this.getCurrentEmployee().getCurrentPartner().getOrganizationid();
        hql.append(" and orgId = '" + orgId + "' ");
        hql.append(" and a.status !='Inactive'");
        hql.append("  and a.no is not null order by a.no ");
        List rtns = this.baseDao.findEntity(hql.toString(), new Object[]{applyId, supplierId});
        for (Object rtn : rtns) {
            Object[] _rtn = (Object[])rtn;
            if (_rtn.length != 3) continue;
            Product p = (Product)_rtn[0];
            PartnerProduct pp = (PartnerProduct)_rtn[2];
            if (pp.getDivideQuantity() == null || pp.getDivideQuantity() == 0.0) continue;
            p.setMinUnit(pp.getDivideQuantity());
        }
        return rtns;
    }

    public List<Object> getPartnerProducts(String applyId, String supplierId) {
        return this.getPartnerProducts(applyId, supplierId, true);
    }

    public Map<String, Double> getParnterProductMaxLimits(String applyerId) {
        String hql = "from PartnerProduct where partnerId=? ";
        Object[] args = new Object[]{applyerId};
        List pps = this.baseDao.findEntity(hql, args, PartnerProduct.class);
        HashMap<String, Double> maxLimits = new HashMap<String, Double>();
        for (PartnerProduct p : pps) {
            maxLimits.put(p.getProductId(), p.getStockMax());
        }
        return maxLimits;
    }

    public Page getProductStock(String id, String no, String prodname, ProductCondition con, int pageno, Contact contact) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        hql.append("from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ");
        if (contact != null && StringUtils.isNotEmpty((String)contact.getPartnerOrgId())) {
            hql.append(" and a.orgId=? ");
            args.add(contact.getPartnerOrgId());
        }
        if (StringUtils.isNotBlank((String)no)) {
            hql.append(" and a.no like ? ");
            args.add("%" + no + "%");
        }
        if (StringUtils.isNotBlank((String)prodname)) {
            hql.append(" and a.name like ?");
            args.add("%" + prodname + "%");
        }
        if (con != null && StringUtils.isNotBlank((String)con.getSubType())) {
            hql.append("and a.subType = ?");
            args.add(con.getSubType());
        }
        if (con != null && StringUtils.isNotBlank((String)con.getBrand())) {
            hql.append(" and brand = ?");
            args.add(con.getBrand());
        }
        hql.append(" and status !='Inactive'");
        hql.append(" and a.no is not null order by a.no ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public <T> List<T> getProductPrice(String id, Class<T> cls) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        hql.append("from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ");
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), cls);
        return list;
    }

    public Page getProductPricesPage(String id, ProductCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Product a,PartnerProductREL b where a.id=b.productId and b.partnerId=? ");
        args.add(id);
        hql.append(" and a.subType in('PPRODUCT','PPACKEAGE','GPRODUCT','POTCPRODUCT','PSCPRODUCT','PTSPRODUCT') ");
        if (StringUtils.isNotEmpty((String)con.getProdname())) {
            hql.append(" and a.name like ? ");
            args.add("%" + con.getProdname() + "%");
        }
        if (StringUtils.isNotEmpty((String)con.getNo())) {
            hql.append(" and a.no like ? ");
            args.add("%" + con.getNo() + "%");
        }
        hql.append(" order by a.no ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), 50, pageno);
        return page;
    }

    public <T> List<T> getProductPrices(String id, Class<T> cls, ProductCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        hql.append("from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ");
        if (StringUtils.isNotEmpty((String)con.getProdname())) {
            hql.append(" and a.name like ? ");
            args.add("%" + con.getProdname() + "%");
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), cls);
        return list;
    }

    public List<Object[]> getPartnerProducts(String partnerId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        hql.append("from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ");
        args.add(partnerId);
        hql.append(" and a.orgId = ? order by a.no ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
    }

    public List<Object[]> getPartnerProducts2(String partnerId, String currentPartnerId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        hql.append("from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ");
        args.add(currentPartnerId);
        hql.append(" and a.orgId = ? order by a.no ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
    }

    public Page getPartnerProductsTCBJ(ProductCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Product a where orgId='" + this.getCurrentEmployee().getCurrentPartner().getOrganizationid() + "' ");
        hql.append(" and a.subType in ('PPRODUCT','KPRODUCT')");
        if (StringUtils.isNotEmpty((String)con.getProdname())) {
            hql.append(" and a.name like ? ");
            args.add("%" + con.getProdname() + "%");
        }
        if (StringUtils.isNotEmpty((String)con.getNo())) {
            hql.append(" and a.no like ? ");
            args.add("%" + con.getNo() + "%");
        }
        hql.append(" order by a.no ");
        return this.baseDao.search(hql.toString(), args.toArray(), 50, pageno);
    }

    public Product getCodeAndProduct(String code, String partnerId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Product a,PartnerProductREL b where a.id=b.productId and b.partnerId=? and a.no = ?");
        args.add(partnerId);
        args.add(code);
        Object[] obj = (Object[])this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Object[].class);
        if (obj != null) {
            return (Product)obj[0];
        }
        return null;
    }

    public boolean intoProduct(String id, String partnerId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? and a.id = ?");
        args.add(partnerId);
        args.add(id);
        Object[] obg = (Object[])this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Object[].class);
        if (obg != null) {
            Product product = (Product)obg[0];
            return com.tcbj.util.StringUtils.isNull(product);
        }
        return true;
    }

    public String getPartnerList(String id, Employee em) {
        String regions = this.personnelService.getFRegionsByUserId(em.getId());
        Object[] args = new Object[]{id};
        List list = this.baseDao.findEntity("from Customer a where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and a.supplierId=?", args, Customer.class);
        String sr = "";
        for (Customer db : list) {
            sr = String.valueOf(sr) + db.getApplyerId() + ":";
        }
        if (StringUtils.isNotEmpty((String)sr)) {
            sr = sr.substring(0, sr.length() - 1);
        }
        return sr;
    }

    public String getProductList(String id, Contact contact) {
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Product ";
        if (contact != null && StringUtils.isNotEmpty((String)contact.getPartnerOrgId())) {
            hql = String.valueOf(hql) + " where orgId = ? ";
            args.add(contact.getPartnerOrgId());
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Product.class);
        String sr = "";
        for (Product db : list) {
            sr = String.valueOf(sr) + db.getId() + ":";
        }
        if (StringUtils.isNotEmpty((String)sr)) {
            sr = sr.substring(0, sr.length() - 1);
        }
        return sr;
    }

    public void updateProduct(String[] ids, int pageno, String productId) throws Exception {
        int i = 0;
        while (i < ids.length) {
            Employee e = this.getCurrentEmployee();
            Object[] args = new Object[]{ids[i], productId};
            Object[] argsREL = new Object[]{e.getCurrentPartner().getId(), ids[i], productId};
            String partnerId = ids[i];
            PartnerProduct partnerProduct = null;
            PartnerProductREL ppREL = null;
            List list = this.baseDao.findEntity("from PartnerProduct where partnerId=? and productId=?", args, PartnerProduct.class);
            List listREL = this.baseDao.findEntity("from PartnerProductREL where supplierId=? and partnerId=? and productId=?", argsREL, PartnerProductREL.class);
            if (listREL.isEmpty()) {
                ppREL = new PartnerProductREL();
                ppREL.setPartnerId(partnerId);
                ppREL.setProductId(productId);
                ppREL.setSupplierId(e.getCurrentPartner().getId());
                ppREL.fillInitData(e);
            } else {
                ppREL = (PartnerProductREL)listREL.get(0);
                ppREL.updateLastData(e);
            }
            if (list.isEmpty()) {
                partnerProduct = new PartnerProduct();
                partnerProduct.setPartnerId(partnerId);
                partnerProduct.setProductId(productId);
                if (e.getCurrentPartner().getParPartnerId() == null) {
                    partnerProduct.setDivideQuantity(((Product)this.baseDao.get(Product.class, (Serializable)((Object)productId))).getMinUnit());
                } else {
                    PartnerProduct partnerProd = (PartnerProduct)this.baseDao.findEntity("from PartnerProduct a where a.productId=? and a.partnerId=? ", new Object[]{productId, e.getCurrentPartner().getId()}, PartnerProduct.class).get(0);
                    if (partnerProd.getDivideQuantity() != null) {
                        partnerProduct.setDivideQuantity(partnerProd.getDivideQuantity());
                    } else {
                        partnerProduct.setDivideQuantity(((Product)this.baseDao.get(Product.class, (Serializable)((Object)productId))).getMinUnit());
                    }
                }
                partnerProduct.fillInitData(e);
                this.baseDao.saveOrUpdate((Object)partnerProduct);
            }
            ppREL.setInvalidDt(null);
            this.baseDao.saveOrUpdate((Object)ppREL);
            ++i;
        }
    }

    public void updateProducts(String[] ids, int pageno, String dealerId) throws Exception {
        int i = 0;
        while (i < ids.length) {
            Employee e = this.getCurrentEmployee();
            Object[] args = new Object[]{dealerId, ids[i]};
            Object[] argsREL = new Object[]{e.getCurrentPartner().getId(), dealerId, ids[i]};
            String productId = ids[i];
            PartnerProduct partnerProduct = null;
            PartnerProductREL ppREL = null;
            List list = this.baseDao.findEntity("from PartnerProduct where partnerId=? and productId=?", args, PartnerProduct.class);
            List listREL = this.baseDao.findEntity("from PartnerProductREL where supplierId=? and partnerId=? and productId=?", argsREL, PartnerProductREL.class);
            if (listREL.isEmpty()) {
                ppREL = new PartnerProductREL();
                ppREL.setPartnerId(dealerId);
                ppREL.setProductId(productId);
                ppREL.setSupplierId(e.getCurrentPartner().getId());
                ppREL.fillInitData(e);
            } else {
                ppREL = (PartnerProductREL)listREL.get(0);
                ppREL.updateLastData(e);
            }
            if (list.isEmpty()) {
                partnerProduct = new PartnerProduct();
                partnerProduct.setPartnerId(dealerId);
                partnerProduct.setProductId(productId);
                if (e.getCurrentPartner().getParPartnerId() == null) {
                    partnerProduct.setDivideQuantity(((Product)this.baseDao.get(Product.class, (Serializable)((Object)productId))).getMinUnit());
                } else {
                    PartnerProduct partnerProd = (PartnerProduct)this.baseDao.findEntity("from PartnerProduct a where a.productId=? and a.partnerId=? ", new Object[]{productId, e.getCurrentPartner().getId()}, PartnerProduct.class).get(0);
                    if (partnerProd.getDivideQuantity() != null) {
                        partnerProduct.setDivideQuantity(partnerProd.getDivideQuantity());
                    } else {
                        partnerProduct.setDivideQuantity(((Product)this.baseDao.get(Product.class, (Serializable)((Object)productId))).getMinUnit());
                    }
                }
                partnerProduct.fillInitData(e);
                this.baseDao.saveOrUpdate((Object)partnerProduct);
            }
            ppREL.setInvalidDt(null);
            this.baseDao.saveOrUpdate((Object)ppREL);
            ++i;
        }
    }

    public void updateabateProduct(String[] id, int pageno, String prodno) throws Exception {
        int i = 0;
        while (i < id.length) {
            Employee e = this.getCurrentEmployee();
            Object[] args = new Object[]{e.getCurrentPartner().getId(), id[i], prodno};
            PartnerProductREL ppREL = null;
            List listREL = this.baseDao.findEntity("from PartnerProductREL where supplierId=? and partnerId=? and productId=?", args, PartnerProductREL.class);
            if (!listREL.isEmpty()) {
                ppREL = (PartnerProductREL)listREL.get(0);
                ppREL.setInvalidDt(DateUtils.now());
                ppREL.fillInitData(e);
                this.baseDao.saveOrUpdate((Object)ppREL);
            }
            ++i;
        }
    }

    public void updateabateProducts(String[] id, int pageno, String dealerId) throws Exception {
        int i = 0;
        while (i < id.length) {
            Employee e = this.getCurrentEmployee();
            Object[] args = new Object[]{e.getCurrentPartner().getId(), dealerId, id[i]};
            PartnerProductREL ppREL = null;
            List listREL = this.baseDao.findEntity("from PartnerProductREL where supplierId=? and partnerId=? and productId=?", args, PartnerProductREL.class);
            if (!listREL.isEmpty()) {
                ppREL = (PartnerProductREL)listREL.get(0);
                ppREL.setInvalidDt(DateUtils.now());
                ppREL.fillInitData(e);
                this.baseDao.saveOrUpdate((Object)ppREL);
            }
            ++i;
        }
    }

    public void updateCloseStock(String[] id, int pageno, String prodno, String flag) throws Exception {
        int i = 0;
        while (i < id.length) {
            Object[] arg;
            Employee e = this.getCurrentEmployee();
            Object[] args = null;
            args = StringUtils.isNotEmpty((String)flag) && "partner".equals(flag) ? (arg = new Object[]{e.getCurrentPartner().getId(), prodno, id[i]}) : (arg = new Object[]{e.getCurrentPartner().getId(), id[i], prodno});
            PartnerProductREL ppREL = null;
            List listREL = this.baseDao.findEntity("from PartnerProductREL where supplierId=? and partnerId=? and productId=?", args, PartnerProductREL.class);
            if (!listREL.isEmpty()) {
                ppREL = (PartnerProductREL)listREL.get(0);
                ppREL.setIsDisplay("N");
                ppREL.fillInitData(e);
                this.baseDao.saveOrUpdate((Object)ppREL);
            }
            ++i;
        }
    }

    public void updateOpenStock(String[] id, int pageno, String prodno, String flag) throws Exception {
        int i = 0;
        while (i < id.length) {
            Object[] arg;
            Employee e = this.getCurrentEmployee();
            Object[] args = null;
            args = StringUtils.isNotEmpty((String)flag) && "partner".equals(flag) ? (arg = new Object[]{e.getCurrentPartner().getId(), prodno, id[i]}) : (arg = new Object[]{e.getCurrentPartner().getId(), id[i], prodno});
            PartnerProductREL ppREL = null;
            List listREL = this.baseDao.findEntity("from PartnerProductREL where supplierId=? and partnerId=? and productId=?", args, PartnerProductREL.class);
            if (!listREL.isEmpty()) {
                ppREL = (PartnerProductREL)listREL.get(0);
                ppREL.setIsDisplay("Y");
                ppREL.fillInitData(e);
                this.baseDao.saveOrUpdate((Object)ppREL);
            }
            ++i;
        }
    }

    public void updateFindProduct(String id, Double min, Double max, Double divideQuantity, Date invalidDt) throws Exception {
        Employee e = this.getCurrentEmployee();
        PartnerProduct partnerProduct = (PartnerProduct)this.baseDao.get(PartnerProduct.class, (Serializable)((Object)id));
        partnerProduct.setStockMin(min);
        partnerProduct.setStockMax(max);
        partnerProduct.setDivideQuantity(divideQuantity);
        partnerProduct.setInvalidDt(invalidDt);
        partnerProduct.updateLastData(e);
        this.baseDao.update((Object)partnerProduct);
    }

    public void updateFindProductAll(List<PartnerProduct> partnerproducts) throws Exception {
        ArrayList<PartnerProduct> list = new ArrayList<PartnerProduct>();
        Date date = DateUtils.now();
        for (PartnerProduct pp : partnerproducts) {
            PartnerProduct partnerProduct = (PartnerProduct)this.baseDao.get(PartnerProduct.class, (Serializable)((Object)pp.getId()));
            partnerProduct.setStockMax(pp.getStockMax());
            partnerProduct.setStockMin(pp.getStockMin());
            partnerProduct.setDivideQuantity(pp.getDivideQuantity());
            partnerProduct.setInvalidDt(pp.getInvalidDt());
            partnerProduct.setLastUpdateDt(date);
            partnerProduct.setLastUpdatorId(this.getCurrentEmployee().getId());
            list.add(partnerProduct);
        }
        this.baseDao.update(list);
    }

    public List<Object> findProducts(String id) throws Exception {
        String hql = "from Product a left join a.pl b where a.no=?";
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        return this.baseDao.findEntity(hql, args.toArray());
    }

    public String getApplayName(String id) {
        return ((Customer)this.baseDao.get(Customer.class, (Serializable)((Object)id))).getApplyerName();
    }

    public String getProductName(String id) {
        return ((Product)this.baseDao.get(Product.class, (Serializable)((Object)id))).getName();
    }

    public List<Product> getByPartnerId(String partnerId) {
        String hql = "from PartnerProduct a,Product p where p.subType = 'PGIFT' and a.partnerId = ? and a.productId=p.id  and p.orgId= ? ";
        List list = this.baseDao.findEntity(hql, new Object[]{partnerId, partnerId}, Object[].class);
        ArrayList<Product> products = new ArrayList<Product>();
        for (Object[] objs : list) {
            products.add((Product)objs[1]);
        }
        return products;
    }

    public List<Product> getByPartnerIdTCBJ(EmployeePartner currentPartner) {
        String hql = "from Product p where p.subType = 'PGIFT' ";
        if (currentPartner != null) {
            hql = String.valueOf(hql) + "and p.orgId = '" + currentPartner.getId() + "' ";
        }
        List list = this.baseDao.findEntity(hql, Product.class);
        return list;
    }

    public List<Product> getNotGift(String partnerId) {
        String hql = "from PartnerProduct a,Product p where p.subType = 'PPRODUCT' and a.partnerId = ? and a.productId=p.id and p.orgId= ? ";
        List list = this.baseDao.findEntity(hql, new Object[]{partnerId, partnerId}, Object[].class);
        ArrayList<Product> products = new ArrayList<Product>();
        for (Object[] objs : list) {
            products.add((Product)objs[1]);
        }
        return products;
    }

    public List<Product> getNotGiftTCBJ(EmployeePartner currentPartner) {
        String hql = "from Product p where p.subType = 'PPRODUCT' ";
        if (currentPartner != null) {
            hql = String.valueOf(hql) + "and p.orgId = '" + currentPartner.getId() + "' ";
        }
        return this.baseDao.findEntity(hql, Product.class);
    }

    public void getExcel(HttpServletResponse response, HttpServletRequest request) {
        ImportData.print(this.baseDao, response, request);
    }

    public void updateInOutProductId(HttpServletResponse response) {
        ImportData.updateInOutProductId(this.baseDao, response);
    }

    public HintNumber getStatProduct(String partnerId) {
        List<HintNumber> list = this.getProductObjects(partnerId);
        HintNumber hin = new HintNumber();
        BigDecimal number = new BigDecimal(0);
        for (HintNumber objects : list) {
            BigDecimal b1 = new BigDecimal(Double.toString(objects.getStockMin()));
            BigDecimal b2 = new BigDecimal(Double.toString(objects.getCountmin()));
            BigDecimal b3 = new BigDecimal(b1.subtract(b2).doubleValue());
            number = number.add(b3);
        }
        hin.setCountmin(number.doubleValue());
        hin.setSize(list.size());
        return hin;
    }

    public List<HintNumber> getProductObjects(String partnerId) {
        StringBuffer sb = new StringBuffer();
        sb.append("select nvl(b.STOCK_MIN,0),nvl(b.STOCK_MAX,0),nvl(a.QUANTITY,0), p.NAME,p.PRODNO, p.PRODSPEC,nvl(b.STOCK_MIN,0)-nvl(a.QUANTITY,0) ");
        sb.append("from (SELECT CIS.ORG_ID, CIS.PRODUCT_ID, SUM(CIS.QUANTITY) QUANTITY ");
        sb.append(" FROM CX_INT_STANDING CIS group by CIS.ORG_ID, CIS.PRODUCT_ID) a,CX_DL_DISTRIBU b, CX_AWK_PRODLIST_VIEW p ");
        sb.append(" where p.Row_Id = b.product_code_id ");
        sb.append(" and b.product_code_id = a.PRODUCT_ID(+) ");
        sb.append(" and b.dealer_id = a.org_id(+) ");
        sb.append(" and b.dealer_id = '");
        sb.append(partnerId);
        sb.append("' and nvl(a.quantity, 0) < nvl(b.stock_min, 0) ");
        List hit = this.baseDao.findBySql(sb.toString());
        ArrayList<HintNumber> list = new ArrayList<HintNumber>();
        HintNumber hintNumber = null;
        for (Object[] objects : hit) {
            hintNumber = new HintNumber();
            Object[] object = new Object[7];
            object = objects;
            hintNumber.setCounts(((BigDecimal)object[6]).doubleValue());
            hintNumber.setStockMax(((BigDecimal)object[1]).doubleValue());
            hintNumber.setStockMin(((BigDecimal)object[0]).doubleValue());
            hintNumber.setEasNo((String)object[4]);
            hintNumber.setSpec((String)object[5]);
            hintNumber.setName((String)object[3]);
            hintNumber.setCountmin(((BigDecimal)object[2]).doubleValue());
            list.add(hintNumber);
        }
        return list;
    }

    public boolean isProduct(String code, String supplierId) {
        Product obj = this.getCodeAndProduct(code, supplierId);
        return !com.tcbj.util.StringUtils.isNotNull(obj);
    }

    public List<Product> getProducts(String name, String partnerId, String no, String type, Contact contact) {
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)partnerId));
        ArrayList<String> args = new ArrayList<String>();
        if (partner != null && partner.isOrg()) {
            String hql = "from Product where 1= 1 ";
            if (contact != null && StringUtils.isNotEmpty((String)contact.getPartnerOrgId())) {
                hql = String.valueOf(hql) + " and orgId = ? ";
                args.add(contact.getPartnerOrgId());
            }
            if (StringUtils.isNotEmpty((String)no)) {
                hql = String.valueOf(hql) + " and no like ? ";
                args.add("%" + no + "%");
            }
            if (StringUtils.isNotEmpty((String)type)) {
                hql = String.valueOf(hql) + " and orderProdType = ? ";
                args.add(type);
            }
            if (StringUtils.isNotEmpty((String)name)) {
                hql = String.valueOf(hql) + " and name like ? ";
                args.add("%" + name + "%");
            }
            List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Product.class);
            return list;
        }
        String hql = "from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ";
        args.add(partnerId);
        if (contact != null && StringUtils.isNotEmpty((String)contact.getPartnerOrgId())) {
            hql = String.valueOf(hql) + " and a.orgId = ? ";
            args.add(contact.getPartnerOrgId());
        }
        if (StringUtils.isNotEmpty((String)no)) {
            hql = String.valueOf(hql) + " and a.no like ? ";
            args.add("%" + no + "%");
        }
        if (StringUtils.isNotEmpty((String)name)) {
            hql = String.valueOf(hql) + " and a.name like ? ";
            args.add("%" + name + "%");
        }
        if (StringUtils.isNotEmpty((String)type)) {
            hql = String.valueOf(hql) + " and a.orderProdType = ? ";
            args.add(type);
        }
        hql = String.valueOf(hql) + " order by a.no ";
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<Product> result = new ArrayList<Product>();
        for (Object[] obj : list) {
            Product product = (Product)obj[0];
            result.add(product);
        }
        return result;
    }

    public void updateabateStockProduct(String id) {
        PartnerProduct partnerproduct = (PartnerProduct)this.baseDao.get(PartnerProduct.class, (Serializable)((Object)id));
        partnerproduct.setInvalidDt(DateUtils.now());
        partnerproduct.updateLastData(this.getCurrentEmployee());
        this.baseDao.update((Object)partnerproduct);
    }

    public List<Product> getProducts(ProductCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        EmployeePartner currentPartner = con.getEm().getCurrentPartner();
        if (con.getApplyId() != null && con.getSupplierId() != null) {
            hql.append(" from Product a ,PartnerProductREL c where a.id=c.productId and c.partnerId=? and c.supplierId=? and c.invalidDt is null ");
            args.add(con.getApplyId());
            args.add(con.getSupplierId());
        } else if (currentPartner.getParPartnerId() == null) {
            hql.append("from Product a where 1=1 ");
        } else {
            hql.append("from Product a,PartnerProduct b where a.id=b.productId  and b.partnerId=? ");
            args.add(currentPartner.getId());
        }
        if (currentPartner != null) {
            hql.append("and a.orgId = ? ");
            args.add(currentPartner.getId());
        }
        if (StringUtils.isNotBlank((String)con.getNo())) {
            hql.append("and a.no like ?");
            args.add("%" + con.getNo() + "%");
        }
        if (con != null && StringUtils.isNotBlank((String)con.getProdname())) {
            hql.append("and a.name like ?");
            args.add("%" + con.getProdname() + "%");
        }
        hql.append(" order by a.no ");
        if (currentPartner.getParPartnerId() == null) {
            return this.baseDao.findEntity(hql.toString(), args.toArray(), Product.class);
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<Product> products = new ArrayList<Product>();
        for (Object[] obj : list) {
            Product produc = (Product)obj[0];
            products.add(produc);
        }
        return products;
    }

    public List<PartnerProduct> getProductStock(String partnerId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select b from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ");
        args.add(partnerId);
        hql.append(" and (b.invalidDt >= ? or b.invalidDt is null) ");
        args.add(DateUtils.now());
        hql.append(" order by a.no ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), PartnerProduct.class);
    }

    public Page findProductPointsByPage(Employee me, ProductCondition con, int pageno) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        hql.append("from ProductGiftView a where a.orgId = ? ");
        params.add(me.getCurrentPartner().getOrganizationid());
        if (StringUtils.isNotEmpty((String)con.getNo())) {
            hql.append(" and a.no = ? ");
            params.add(con.getNo().trim());
        }
        if (StringUtils.isNotEmpty((String)con.getProdname())) {
            hql.append(" and a.name like ? ");
            params.add("%" + con.getProdname().trim() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), params.toArray(), 50, pageno);
        return page;
    }

    public List<Object> getPartnerProductsByProductNos(String applyId, String supplierId, boolean isvalid, List<String> productNos) {
        StringBuffer hql = new StringBuffer();
        Partner supplier = this.partnerService.getSimplePartner(supplierId);
        if (supplier.isOrg()) {
            hql.append(" from Product a ,PartnerProductREL c where a.id=c.productId and c.partnerId=? and c.supplierId=? ");
        } else {
            hql.append(" from Product a ,PartnerProductREL c,PartnerProduct b where a.id=c.productId and b.productId=a.id and b.partnerId=c.supplierId and c.partnerId=? and c.supplierId=? ");
        }
        if (isvalid) {
            hql.append(" and nvl(c.invalidDt,sysdate + 1) > sysdate ");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(applyId);
        args.add(supplierId);
        if (Beans.isNotEmpty(productNos)) {
            hql.append(" and a.no in (");
            int i = 0;
            while (i < productNos.size()) {
                hql.append("?");
                args.add(productNos.get(i));
                if (i == productNos.size() - 1) {
                    hql.append(")");
                } else {
                    hql.append(",");
                }
                ++i;
            }
        }
        hql.append(" order by a.no ");
        List rtns = this.baseDao.findEntity(hql.toString(), args.toArray());
        for (Object rtn : rtns) {
            Object[] _rtn = (Object[])rtn;
            if (_rtn.length != 3) continue;
            Product p = (Product)_rtn[0];
            PartnerProduct pp = (PartnerProduct)_rtn[2];
            if (pp.getDivideQuantity() == null || pp.getDivideQuantity() == 0.0) continue;
            p.setMinUnit(pp.getDivideQuantity());
        }
        return rtns;
    }

    public Page getProductStock(String id, String no, String prodname, ProductCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        hql.append("from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ");
        if (StringUtils.isNotBlank((String)no)) {
            hql.append(" and a.no like ? ");
            args.add("%" + no + "%");
        }
        if (StringUtils.isNotBlank((String)prodname)) {
            hql.append(" and a.name like ?");
            args.add("%" + prodname + "%");
        }
        if (con != null && StringUtils.isNotBlank((String)con.getSubType())) {
            hql.append("and a.subType = ?");
            args.add(con.getSubType());
        }
        hql.append(" order by a.no ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public Boolean isMutilEasAccount(String applyerId) {
        String idsByExtCode = this.cache.getExtCodeS(applyerId);
        int extCodeCount = idsByExtCode.split(",").length;
        if (extCodeCount > 1) {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT PRODUCT_CODE_ID,SUM(STOCK_MAX)   ").append(" FROM CX_DL_DISTRIBU WHERE DEALER_ID IN (").append(idsByExtCode).append(")").append(" AND  (INVALID_DATE >SYSDATE OR INVALID_DATE IS NULL) ").append(" AND STOCK_MAX > 0 AND ISLIMIT='0'  GROUP BY PRODUCT_CODE_ID ");
            List list = this.baseDao.findBySql(sql.toString());
            if (Beans.isNotEmpty((Object)list)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Double> getParnterProductMaxLimits(String applyerId, Boolean isMutilEas) {
        HashMap<String, Double> maxLimits = new HashMap<String, Double>();
        if (isMutilEas.booleanValue()) {
            String idsByExtCode = this.cache.getExtCodeS(applyerId);
            int extCodeCount = idsByExtCode.split(",").length;
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT PRODUCT_CODE_ID,SUM(STOCK_MAX)   ").append(" FROM CX_DL_DISTRIBU WHERE DEALER_ID IN (").append(idsByExtCode).append(")").append(" AND  (INVALID_DATE >SYSDATE OR INVALID_DATE IS NULL) ").append(" AND STOCK_MAX > 0 AND ISLIMIT='0'  GROUP BY PRODUCT_CODE_ID ");
            List list = this.baseDao.findBySql(sql.toString());
            for (Object[] objs : list) {
                maxLimits.put(objs[0].toString(), MathUtils.div((Double)((BigDecimal)objs[1]).doubleValue(), (Double)Double.valueOf(extCodeCount), (Integer)0));
            }
            return maxLimits;
        }
        String ids = this.cache.getRelatedIds(applyerId);
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT PRODUCT_CODE_ID,SUM(STOCK_MAX)   ").append(" FROM CX_DL_DISTRIBU WHERE DEALER_ID IN (").append(ids).append(")").append(" AND  (INVALID_DATE >SYSDATE OR INVALID_DATE IS NULL) ").append(" AND STOCK_MAX > 0 AND ISLIMIT='0'  GROUP BY PRODUCT_CODE_ID ");
        List list = this.baseDao.findBySql(sql.toString());
        for (Object[] objs : list) {
            maxLimits.put(objs[0].toString(), ((BigDecimal)objs[1]).doubleValue());
        }
        return maxLimits;
    }

    public List<Object[]> getPartnerProductsNew(String partnerId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        hql.append("from Product a,PartnerProductREL b where a.id=b.productId and b.partnerId=? order by a.no");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
    }
}

