/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productManage;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.UpdateRecord;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.productManage.ProductManageService;
import com.tcbj.crm.productManage.ProductManageSibelService;
import com.tcbj.crm.productManage.ProductType;
import com.tcbj.crm.productManage.ProductTypeService;
import com.tcbj.crm.updaterecord.UpdateRecordService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/productManage"})
public class ProductManageController
extends BaseController {
    @Autowired
    ProductManageService service;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    ProductManageSibelService productManageSibelService;
    @Autowired
    UpdateRecordService updateRecordService;
    @Autowired
    ProductTypeService productTypeService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ProductCondition con, String no, Model model) throws Exception {
        Employee me = this.getCurrentEmployee();
        Page product = null;
        if (me.getCurrentPartner().getParPartnerId() == null) {
            product = this.service.findPartners(con, pageno, Constant.DEFAULT_ROWS);
        } else {
            Contact contact = this.personnelService.get(me.getId());
            product = this.service.getProductStock(me.getCurrentPartner().getId(), con, pageno, Constant.DEFAULT_ROWS, contact);
        }
        model.addAttribute("page", (Object)product);
        model.addAttribute("no", (Object)no);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "productManage/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add(Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        model.addAttribute("pname", (Object)e);
        model.addAttribute("product", (Object)new Product());
        return "productManage/apply.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) throws Exception {
        Product product = this.service.findProductById(id);
        model.addAttribute("product", (Object)product);
        model.addAttribute("id", (Object)id);
        return "productManage/apply.ftl";
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model) {
        Product product = this.service.findProductById(id);
        model.addAttribute("product", (Object)product);
        return "productManage/look.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add(@Valid @RequestBody Product product, Model model, HttpServletRequest request) {
        String url = StringUtils.getConfigure("esb_addProduct");
        HashMap<String, String> param = new HashMap<String, String>();
        if (!StringUtils.isEmpty(product.getId())) {
            param.put("id", product.getId());
            url = StringUtils.getConfigure("esb_updateProduct");
        }
        param.put("name", product.getName());
        param.put("code", product.getNo());
        param.put("outCoding", product.getEasNo().trim());
        param.put("barCode", product.getBarCode());
        param.put("type", product.getTypeName());
        param.put("subType", product.getSubTypeName().trim());
        param.put("price", "" + product.getPrice());
        param.put("unit", product.getUnitName());
        param.put("saleUnit", "" + product.getMinUnit());
        param.put("description", product.getSpec());
        param.put("highlightFlg", product.getHighlightFlag());
        param.put("productFormulations", product.getUseTypeName());
        param.put("valuationFlg", product.getValuationFlag());
        param.put("status", product.getStatusName());
        param.put("extCode", product.getExtCode());
        param.put("source", "TCBJCRM");
        param.put("organization", StringUtils.getConfigure("esbOrgName"));
        param.put("brandName", product.getBrandName());
        String id = this.service.addOrUpdateProductToEasBy(url, param);
        try {
            String type = "ADD";
            if (!StringUtils.isEmpty(product.getId())) {
                type = "UPDATE";
            }
            this.updateRecordService.save(id, type, this.getCurrentEmployee(), "productManage", JSON.toJSONString((Object)product), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String del(String id, String status) {
        return "redirect:/productManage/list.do";
    }

    @RequestMapping(value={"/viewRecords.do"}, method={RequestMethod.GET})
    public String viewRecords(String id, Model model) {
        List<UpdateRecord> updateRecords = this.updateRecordService.getByCodeAndId("productManage", id, this.getCurrentEmployee());
        model.addAttribute("updateRecords", updateRecords);
        return "productManage/viewRecords.ftl";
    }

    @RequestMapping(value={"/lookUpdateRecord.do"}, method={RequestMethod.GET})
    public String lookUpdateRecord(String id, Model model) {
        UpdateRecord record = this.updateRecordService.get(id);
        String data = record.getOperationData();
        Product product = (Product)JSON.parseObject((String)data, Product.class);
        model.addAttribute("product", (Object)product);
        return "productManage/look.ftl";
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(@ModelAttribute(value="condition") ProductCondition con, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Employee me = this.getCurrentEmployee();
        Page product = null;
        if (me.getCurrentPartner().getParPartnerId() == null) {
            product = this.service.findPartners(con, 1, Integer.MAX_VALUE);
        } else {
            Contact contact = this.personnelService.get(me.getId());
            product = this.service.getProductStock(me.getCurrentPartner().getId(), con, 1, Integer.MAX_VALUE, contact);
        }
        File dir = new File(String.valueOf(StringUtils.getUploadPath()) + "productexcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ProductManageController.excels(product.getList(), dir.getPath(), String.valueOf(me.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    public static boolean excels(List<Product> products, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u54c1\u724c", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u7f16\u53f7", "\u4ea7\u54c1\u7c7b\u578b", "\u4ea7\u54c1\u5b50\u7c7b\u578b", "\u96f6\u552e\u4ef7", "\u6700\u5c0f\u5305\u88c5\u6570", "\u5916\u56f4\u7cfb\u7edf\u4ea7\u54c1\u7f16\u53f7", "\u521b\u5efa\u65f6\u95f4", "\u72b6\u6001"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        int rowIndex = 1;
        int i2 = 0;
        while (i2 < products.size()) {
            Product p = products.get(i2);
            String[] vals = new String[]{p.getBrandName(), p.getName(), p.getEasNo(), p.getTypeName(), p.getSubTypeName(), "" + p.getPrice(), "" + p.getMinUnit(), p.getExtCode(), DateUtils.formartDate2((Date)p.getCreateDt(), (String)"yyyy-MM-dd"), p.getStatusName()};
            row = sheet.createRow(rowIndex++);
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i2;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @RequestMapping(value={"/upload.do"}, method={RequestMethod.GET})
    public String upload() {
        return "productManage/upload.ftl";
    }

    @RequestMapping(value={"/upload.do"}, method={RequestMethod.POST})
    public String upload(HttpServletRequest request, Model model) {
        List<ProductType> productSubType;
        IUploadFile file;
        List<String> errorList;
        List<IUploadFile> fileList = this.uploadFile(request, "productManage");
        String rtn = null;
        List<Map<String, String>> productList = null;
        if (fileList.size() > 0 && (errorList = this.service.validateExcel(productList = this.service.readExcel((file = fileList.get(0)).getRealPath()), productSubType = this.productTypeService.findProductSubType("Product"))).size() > 0) {
            errorList.add(0, "\u6ce8\uff1a\u4ee5\u4e0b\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4ea7\u54c1\u672a\u8fdb\u884c\u65b0\u589e\u3002\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4e0a\u4f20");
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(errorList)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        final HashMap<String, String> param = new HashMap<String, String>();
        param.put("organization", StringUtils.getConfigure("esbOrgName"));
        param.put("jsonStr", JSON.toJSONString(productList));
        final HttpSession session = request.getSession();
        Thread thread = new Thread(){

            @Override
            public void run() {
                LinkedHashMap<String, Result> productExcelUploadMap = (LinkedHashMap<String, Result>)session.getAttribute("productExcelUpload");
                if (Beans.isEmpty((Object)session.getAttribute("productExcelUpload"))) {
                    productExcelUploadMap = new LinkedHashMap<String, Result>();
                    session.setAttribute("productExcelUpload", productExcelUploadMap);
                }
                String date = DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss");
                productExcelUploadMap.put(date, ProductManageController.this.getSuccessResult("\u6267\u884c\u4e2d..."));
                List<Object> errorList = new ArrayList();
                try {
                    errorList = ProductManageController.this.service.batchAddProduct(param);
                }
                catch (Exception e) {
                    productExcelUploadMap.put(date, ProductManageController.this.getSuccessResult("\u6267\u884c\u5931\u8d25!"));
                    e.printStackTrace();
                    return;
                }
                if (errorList.size() > 0) {
                    productExcelUploadMap.put(date, ProductManageController.this.getSuccessResult(errorList));
                } else {
                    productExcelUploadMap.put(date, ProductManageController.this.getSuccessResult("\u6267\u884c\u6210\u529f!"));
                }
            }
        };
        thread.start();
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/showError.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result showError(HttpServletRequest request) throws Exception {
        HashMap productExcelUploadMap = (HashMap)request.getSession().getAttribute("productExcelUpload");
        if (Beans.isEmpty((Object)productExcelUploadMap)) {
            productExcelUploadMap = new HashMap();
        }
        return this.getSuccessResult(productExcelUploadMap);
    }
}

