/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productManage;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseService;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.productManage.ProductType;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productManageService")
public class ProductManageService
extends BaseService {
    @Autowired
    private BaseDao baseDao;

    public Page findPartners(ProductCondition con, int pageno, int rows) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Product where orgId='" + this.getCurrentEmployee().getCurrentPartner().getOrganizationid() + "' ");
        if (StringUtils.isNotEmpty(con.getNo())) {
            HQL.append(" and no like ?");
            args.add("%" + con.getNo() + "%");
        }
        if (con != null && StringUtils.isNotEmpty(con.getProdname())) {
            HQL.append(" and name like ?");
            args.add("%" + con.getProdname() + "%");
        }
        if (con != null && StringUtils.isNotEmpty(con.getSubType())) {
            HQL.append(" and subType = ?");
            args.add(con.getSubType());
        }
        if (con != null && StringUtils.isNotEmpty(con.getEasNo())) {
            HQL.append(" and easNo = ?");
            args.add(con.getEasNo());
        }
        if (con != null && StringUtils.isNotEmpty(con.getBrand())) {
            HQL.append(" and brand = ?");
            args.add(con.getBrand());
        }
        if (con != null && StringUtils.isNotEmpty(con.getStatus())) {
            HQL.append(" and status = ?");
            args.add(con.getStatus());
        }
        HQL.append(" and no is not null order by createDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), rows, pageno);
    }

    public Page getProductStock(String id, ProductCondition con, int pageno, int rows, Contact contact) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        hql.append("select a from Product a,PartnerProduct b where a.id=b.productId and b.partnerId=? ");
        if (contact != null && StringUtils.isNotEmpty(contact.getPartnerOrgId())) {
            hql.append(" and a.orgId=? ");
            args.add(contact.getPartnerOrgId());
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and a.no like ? ");
            args.add("%" + con.getNo() + "%");
        }
        if (StringUtils.isNotEmpty(con.getProdname())) {
            hql.append(" and a.name like ?");
            args.add("%" + con.getProdname() + "%");
        }
        if (con != null && StringUtils.isNotEmpty(con.getSubType())) {
            hql.append("and a.subType = ?");
            args.add(con.getSubType());
        }
        if (con != null && StringUtils.isNotEmpty(con.getEasNo())) {
            hql.append(" and a.easNo = ?");
            args.add(con.getEasNo());
        }
        if (con != null && StringUtils.isNotEmpty(con.getBrand())) {
            hql.append(" and a.brand = ?");
            args.add(con.getBrand());
        }
        if (con != null && StringUtils.isNotEmpty(con.getStatus())) {
            hql.append(" and a.status = ?");
            args.add(con.getStatus());
        }
        hql.append(" and a.no is not null order by a.no ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rows, pageno);
        return page;
    }

    public Product findProductById(String id) {
        return (Product)this.baseDao.get(Product.class, (Serializable)((Object)id));
    }

    public String addOrUpdateProductToEasBy(String url, Map<String, String> param) {
        String result = EasRequestHelper.getInstance().sendBody(url, param);
        if (result == null) {
            throw new AppException("0010", "\u8c03\u7528ESB\u63a5\u53e3\u5931\u8d25");
        }
        Map data = (Map)JSON.parseObject((String)result, Map.class);
        if (!"00".equals(data.get("errorCode"))) {
            throw new AppException("0010", "\u8c03\u7528ESB\u63a5\u53e3\u5931\u8d25,\u539f\u56e0\uff1a" + data.get("errorMessage"));
        }
        Map sibeleData = (Map)data.get("returnObject");
        if ("00".equals(data.get("errorCode")) && !"100".equals(sibeleData.get("rtn"))) {
            throw new AppException("0010", "\u8c03\u7528Sieble\u63a5\u53e3\u5931\u8d25,\u539f\u56e0\uff1a" + sibeleData.get("rtnDesc"));
        }
        return (String)sibeleData.get("MemberId");
    }

    public List<String> validateExcel(List<Map<String, String>> productList, List<ProductType> productSubType) {
        ArrayList<String> messages = new ArrayList<String>();
        int line = 0;
        for (Map<String, String> product : productList) {
            ++line;
            if (StringUtils.isEmpty(product.get("name"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(product.get("brandName"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (Beans.isEmpty((Object)Cache.getItemType("TCBJ_PRODUCT_BRAND", product.get("brandName")))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u54c1\u724c\u4e0d\u6b63\u786e");
            }
            if (StringUtils.isEmpty(product.get("outCoding"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,ERP\u4ea7\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(product.get("type"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (!"\u4ea7\u54c1".equals(product.get("type"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u4ea7\u54c1\u7c7b\u578b\u53ea\u80fd\u4e3a\u4ea7\u54c1");
            }
            if (StringUtils.isEmpty(product.get("subType"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u4ea7\u54c1\u5b50\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                boolean result = true;
                for (ProductType productType : productSubType) {
                    if (!productType.getSubTypeName().equals(product.get("subType"))) continue;
                    result = false;
                    break;
                }
                if (result) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u4ea7\u54c1\u5b50\u7c7b\u578b\u4e0d\u6b63\u786e");
                }
            }
            if (StringUtils.isEmpty(product.get("price"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u96f6\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                try {
                    Double price = Double.parseDouble(product.get("price"));
                    if (price < 0.0) {
                        messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u96f6\u552e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                }
                catch (Exception exception) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u96f6\u552e\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57");
                }
            }
            if (StringUtils.isEmpty(product.get("saleUnit"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u6700\u5c0f\u5305\u88c5\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                try {
                    Double saleUnit = Double.parseDouble(product.get("saleUnit"));
                    if (saleUnit < 0.0) {
                        messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u6700\u5c0f\u5305\u88c5\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                }
                catch (Exception exception) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u6700\u5c0f\u5305\u88c5\u6570\u53ea\u80fd\u4e3a\u6570\u5b57");
                }
            }
            if (StringUtils.isEmpty(product.get("unit"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                this.validateParam("TCBJ_UNIT_TYPE", product.get("unit"), "\u5355\u4f4d", line, messages);
            }
            if (StringUtils.isEmpty(product.get("productFormulations"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u4ea7\u54c1\u5242\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                this.validateParam("TCBJ_PRODUCT_USE_TYPE", product.get("productFormulations"), "\u4ea7\u54c1\u5242\u578b", line, messages);
            }
            if (StringUtils.isEmpty(product.get("description"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u4ea7\u54c1\u89c4\u683c\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(product.get("highlightFlg"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u662f\u5426\u9ad8\u4eae\u663e\u793a\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                this.validateParam("YON", product.get("highlightFlg"), "\u662f\u5426\u9ad8\u4eae\u663e\u793a", line, messages);
            }
            if (StringUtils.isEmpty(product.get("valuationFlg"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u662f\u5426\u514d\u8d39\u8ba1\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                this.validateParam("YON", product.get("valuationFlg"), "\u662f\u5426\u514d\u8d39\u8ba1\u4ef7", line, messages);
            }
            if (StringUtils.isEmpty(product.get("status"))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            this.validateParam("TCBJ_STORE_RULE_STATUS", product.get("status"), "\u72b6\u6001", line, messages);
        }
        return messages;
    }

    private void validateParam(String type, String data, String Fieldname, int line, List<String> messages) {
        boolean result = true;
        List<Object> items = new ArrayList();
        items = Cache.getItems(type);
        for (DictionaryItem dictionaryItem : items) {
            if (!dictionaryItem.getVal().equals(data)) continue;
            result = false;
            break;
        }
        if (result) {
            messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d," + Fieldname + "\u4e0d\u6b63\u786e");
        }
    }

    public List<Map<String, String>> readExcel(String realPath) {
        List<Object> datas = new ArrayList();
        ArrayList<Map<String, String>> productList = new ArrayList<Map<String, String>>();
        datas = ExcelHandle.readExcel(realPath);
        for (List list : datas) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("name", (String)list.get(0));
            param.put("brandName", (String)list.get(1));
            param.put("outCoding", ((String)list.get(2)).trim());
            param.put("type", (String)list.get(3));
            param.put("subType", (String)list.get(4));
            param.put("price", (String)list.get(5));
            param.put("unit", (String)list.get(6));
            param.put("saleUnit", (String)list.get(7));
            param.put("barCode", (String)list.get(8));
            param.put("productFormulations", (String)list.get(9));
            param.put("description", (String)list.get(10));
            param.put("highlightFlg", (String)list.get(11));
            param.put("valuationFlg", (String)list.get(12));
            param.put("status", (String)list.get(13));
            param.put("extCode", (String)list.get(14));
            param.put("source", "TCBJCRM");
            param.put("organization", StringUtils.getConfigure("esbOrgName"));
            productList.add(param);
        }
        return productList;
    }

    public List<String> batchAddProduct(Map<String, String> param) {
        String url = StringUtils.getConfigure("esb_batchAddProduct");
        String result = EasRequestHelper.getInstance().sendBody(url, param);
        ArrayList<String> msg = new ArrayList<String>();
        if (result == null) {
            msg.add("\u8c03\u7528ESB\u63a5\u53e3\u5931\u8d25");
            return msg;
        }
        Map data = (Map)JSON.parseObject((String)result, Map.class);
        if ("01".equals(data.get("errorCode"))) {
            msg.add("\u8c03\u7528ESB\u63a5\u53e3\u5931\u8d25,\u539f\u56e0\uff1a" + data.get("errorMessage"));
            return msg;
        }
        List sibeleData = (List)data.get("returnObject");
        StringBuffer rtnEasCode = new StringBuffer();
        String rtnDesc = "";
        int i = 0;
        while (i < sibeleData.size()) {
            Map rtn = (Map)sibeleData.get(i);
            if ("110".equals(rtn.get("rtn"))) {
                rtnDesc = (String)rtn.get("rtnDesc");
                if (i % 10 == 0) {
                    rtnEasCode.append(rtn.get("easCode")).append(",").append("</br>");
                } else {
                    rtnEasCode.append(rtn.get("easCode")).append(",");
                }
            }
            ++i;
        }
        if (StringUtils.isNotEmpty(rtnEasCode.toString())) {
            msg.add("ERP\u4ea7\u54c1\u7f16\u53f7\u5206\u522b\u4e3a" + rtnEasCode + "\u7684\u4ea7\u54c1\u65b0\u589e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3asiebel\u62a5\u9519\uff1a" + rtnDesc);
        }
        return msg;
    }
}

