/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productManage;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.siebel.service.SiebelUtil;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.util.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="productManageSibelService")
public class ProductManageSibelService {
    private static String business = StringUtils.getBusiness();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addOrUpdateProductToSiebel(Product product) throws RuntimeException {
        String string;
        long now = System.currentTimeMillis();
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            System.out.println("---------------------");
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            now = System.currentTimeMillis() - now;
            System.out.println("-----------------------\u8fde\u63a5\u603b\u5171\u8017\u65f6\uff1a" + now);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            if (StringUtils.isBlank(product.getId())) {
                input.setProperty("ProcessName", "TCBJ_ProductAdd_WF");
            } else {
                input.setProperty("ProcessName", "TCBJ_ProductModify_WF");
            }
            String xml = this.parseProductAddOrUpdatexml(product);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new AppException("0010", e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addUserToSiebel(Employee employee) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Partner_ContactToUser_WF");
            input.setProperty("UserId", employee.getId());
            input.setProperty("LoginName", employee.getAccount());
            input.setProperty("Password", employee.getPassword());
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            System.out.println("trn==" + rtn);
            System.out.println("rtnDesc==" + rtnDesc);
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException em) {
            try {
                throw em;
                catch (Exception e) {
                    throw new AppException("0010", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updateUserToSiebel(Employee employee) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Partner_UpdateUser_WF");
            input.setProperty("UserId", employee.getId());
            input.setProperty("LoginName", employee.getAccount());
            input.setProperty("NewPassword", employee.getPassword());
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            System.out.println("trn==" + rtn);
            System.out.println("rtnDesc==" + rtnDesc);
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException em) {
            try {
                throw em;
                catch (Exception e) {
                    throw new AppException("0010", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String loginOut(Contact clv) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Contact_C_WF");
            String xml = this.loginOut1(clv);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new AppException("0010", e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    private String parseProductAddOrUpdatexml(Product p) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ProductList>");
        sb.append("<Product>");
        if (StringUtils.isNotBlank(p.getId())) {
            sb.append("<Id>" + p.getId() + "</Id>");
        } else {
            sb.append("<Id>NewRecord</Id>");
        }
        sb.append("<OrganizationId>" + StringUtils.getOrgId() + "</OrganizationId>");
        sb.append("<ProductName>" + p.getName() + "</ProductName>");
        sb.append("<EASCode>" + p.getEasNo() + "</EASCode>");
        sb.append("<Type>" + p.getType() + "</Type>");
        sb.append("<SubType>" + p.getSubType() + "</SubType>");
        sb.append("<Brand>" + StringUtils.getSystem() + "</Brand>");
        sb.append("<Price>" + p.getPrice() + "</Price>");
        sb.append("<UnitType>" + p.getUnitCode() + "</UnitType>");
        sb.append("<SaleUnit>" + p.getMinUnit() + "</SaleUnit>");
        sb.append("<BarCode>" + p.getBarCode() + "</BarCode>");
        sb.append("<Specification>" + p.getSpec() + "</Specification>");
        sb.append("<HighlightFlg>" + p.getHighlightFlag() + "</HighlightFlg>");
        sb.append("<UseType>" + p.getUseType() + "</UseType>");
        sb.append("<ValuationFlg>" + p.getValuationFlag() + "</ValuationFlg>");
        sb.append("<Status>\u53ef\u7528</Status>");
        sb.append("</Product>");
        sb.append("</ProductList>");
        String xml = sb.toString();
        System.out.println("---------xml----->>>>>>>-----" + xml);
        return xml;
    }

    private String loginOut1(Contact clv) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<ListOfContact><Contact>");
        sb.append("<Id>").append(clv.getId()).append("</Id>");
        sb.append("<Operation>").append(clv.getState()).append("</Operation>");
        if (StringUtils.isNotEmpty(clv.getPartnerId())) {
            sb.append("<ListOfPartner></ListOfPartner>");
        } else {
            sb.append("<ListOfStore></ListOfStore>");
        }
        sb.append("</Contact></ListOfContact>");
        String xml = sb.toString();
        System.out.println("---------xml----->>>>>>>-----" + xml);
        return xml;
    }
}

