/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productStock;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.entity.CustomerOperator;
import com.tcbj.crm.everydayManage.EverydayManageService;
import com.tcbj.crm.everydayManage.everydayManageCondition;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.productStock.ProductStockCondition;
import com.tcbj.crm.productStock.ProductStockService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/productStock"})
public class ProductStockController
extends BaseController {
    @Autowired
    ProductStockService productStockService;
    @Autowired
    private EverydayManageService everydayManageService;
    @Autowired
    BaseDao baseDao;
    @Autowired
    ProductService productService;

    @RequestMapping(value={"/forwordProductStock.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String forwordProductStock(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ProductStockCondition condition, Model model) {
        String orgId = "";
        Employee employee = this.getCurrentEmployee();
        EmployeePartner partner = employee.getCurrentPartner();
        if (partner == null) {
            throw new AppException("9210");
        }
        orgId = partner.getId();
        String productId = condition.getProductId();
        if (productId != null && productId != "") {
            Map<String, Object> productResult = this.productStockService.calculateGiftProductQuantitys_new(orgId, productId);
            model.addAttribute("productResult", productResult);
            Page orderResult = this.productStockService.findProductByNo(productId);
            model.addAttribute("orderResult", (Object)orderResult);
        } else {
            Page page = this.productStockService.getProductStock(pageno);
            model.addAttribute("page", (Object)page);
        }
        model.addAttribute("condition", (Object)condition);
        return "/productStock/productStockView.ftl";
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") everydayManageCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        Page page = this.productStockService.getlist(con, pageno, me);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("page", (Object)page);
        return "productStock/list.ftl";
    }

    @RequestMapping(value={"/save.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String saveCustomerNo(String customerNumber, String scanOrderNumber, String masterOuId, String newCustomerNo, Model model, CustomerOperator opt) throws ParseException {
        Employee employee = this.getCurrentEmployee();
        boolean flag = this.productStockService.updateCustomerNo(customerNumber, scanOrderNumber, masterOuId, newCustomerNo);
        if (flag) {
            opt.setCustomerId(customerNumber);
            opt.setCustomerName(employee.getAccount());
            opt.setOptDate(new Date());
            opt.setOptType("\u65b0\u589e");
            opt.setOptContent("\u7ecf\u9500\u5546\u4e0d\u5b58\u5728,\u91cd\u65b0\u8f93\u5165\u7ecf\u9500\u5546\u7f16\u7801");
            this.productStockService.save(opt);
        }
        return "redirect:/productStock/list.do";
    }

    @RequestMapping(value={"/delOutProduct.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String delOutProduct(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String scanOrderLineId, String scanOrderNumber, Model model, CustomerOperator opt, String productNo, String productName) throws ParseException {
        boolean flag = this.productStockService.delChildProduct(scanOrderLineId);
        Employee employee = this.getCurrentEmployee();
        if (flag) {
            opt.setCustomerName(employee.getAccount());
            opt.setOptDate(new Date());
            opt.setOptType("\u5220\u9664");
            opt.setOptContent("\u5220\u9664\u5546\u54c1");
            opt.setCustomerId(employee.getId());
            this.productStockService.save(opt);
            Page page = this.productStockService.JOBhandleApply(pageno);
            model.addAttribute("page", (Object)page);
        }
        return "redirect:/productStock/delOutProductList.do";
    }

    @RequestMapping(value={"/delOutProductList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String delOutProductList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String scanOrderId, String scanOrderNumber, String masterOuId, Model model, CustomerOperator opt, String productNo, String productName) throws ParseException {
        Page page = this.productStockService.fingChildProduct(scanOrderId, masterOuId, scanOrderNumber, productNo, productName, pageno);
        model.addAttribute("page", (Object)page);
        return "productStock/productList.ftl";
    }

    @RequestMapping(value={"/definedCoustomerForOrder.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String definedCoustomerForOrder(String ids, String scanOrderId, String masterOuId, String rowId, Model model, CustomerOperator opt) throws ParseException {
        boolean flag3 = false;
        Employee employee = this.getCurrentEmployee();
        if (rowId != null && rowId != "") {
            try {
                try {
                    boolean flag2;
                    boolean flag1 = this.productStockService.updateIsrepeatCustomerCheckCustomer(rowId, ids, scanOrderId);
                    if (flag1 && (flag2 = this.productStockService.updateIsrepeatCustomerCheckCustomer2(scanOrderId, masterOuId)) && (flag3 = this.productStockService.triggerOrderReturnHandle())) {
                        opt.setCustomerName(employee.getAccount());
                        opt.setOptDate(new Date());
                        opt.setOptType("\u6307\u5b9a\u7ecf\u9500\u5546");
                        opt.setOptContent("\u5546\u54c1\u5b58\u5728\u591a\u4e2a\u7ecf\u9500\u5546,\u9009\u4e2d\u6307\u5b9a\u7ecf\u9500\u5546");
                        opt.setCustomerId(employee.getId());
                        this.productStockService.save(opt);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.productStockService.updatebackCustmerCode(ids, rowId);
                }
            }
            finally {
                this.productStockService.updatebackCustmerCode(ids, rowId);
            }
        }
        return "redirect:/productStock/list.do";
    }

    @RequestMapping(value={"/JOBhandle.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String JOBhandle(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) throws ParseException {
        this.getCurrentEmployee();
        Page page = this.productStockService.JOBhandleApply(pageno);
        model.addAttribute("page", (Object)page);
        return "productStock/applyList.ftl";
    }

    @RequestMapping(value={"/backCheck.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String backCheck(String id, Model model) {
        if (id != null && id != "") {
            this.productStockService.orderApplyBackCheck(id);
        }
        return "redirect:/productStock/JOBhandle.do";
    }

    @RequestMapping(value={"/repairCustomer.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String repairCustomer(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String customerNumber, String scanOrderId, String masterOuId, String scanOrderNumber, Model model) throws ParseException {
        Page page = this.productStockService.findIsrepeatCustomerCheckCustomer(customerNumber, pageno);
        if (page.getList().size() > 1) {
            ArrayList<String> ids = new ArrayList<String>();
            int i = 0;
            while (i < page.getList().size()) {
                Partner p = (Partner)page.getList().get(i);
                ids.add(p.getId());
                ++i;
            }
            model.addAttribute("page", (Object)page);
            model.addAttribute("scanOrderId", (Object)scanOrderId);
            model.addAttribute("masterOuId", (Object)masterOuId);
            model.addAttribute("ids", ids);
            model.addAttribute("flag", (Object)ids.size());
            return "productStock/backOrderToCustomer.ftl";
        }
        model.addAttribute("customerNumber", (Object)customerNumber);
        model.addAttribute("scanOrderNumber", (Object)scanOrderNumber);
        model.addAttribute("masterOuId", (Object)masterOuId);
        return "productStock/add.ftl";
    }

    @RequestMapping(value={"/queryStockAccount.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String queryStockAccount(ProductStockCondition con, Model model) {
        if (Beans.isEmpty((Object)con.getProductCode())) {
            throw new AppException("0010", "\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = this.productStockService.queryStockAccount(con);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "productStock/queryStockAccount.ftl";
    }
}

