/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productStock;

import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.entity.CustomerOperator;
import com.tcbj.crm.entity.CxSaleOrderHeaderIface;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.everydayManage.everydayManageCondition;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.productStock.CxSaleOrderLineIface;
import com.tcbj.crm.productStock.ProductStockCondition;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.siebel.service.ScoreSiebelService;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productStockService")
public class ProductStockService
extends BaseController {
    @Autowired
    BaseDao baseDao;
    @Autowired
    ScoreSiebelService siebelService;
    @Autowired
    StockService stockService;
    @Autowired
    OrderApplyService orderApplyService;
    @Autowired
    ProductService productService;
    @Autowired
    PartnerService partnerService;
    @Autowired
    ScoreService scoreService;
    @Resource(name="newBaseDao")
    NewBaseDao newBaseDao;
    public Map<String, String> map1 = new HashMap<String, String>();

    public Page getProductStock(int pageno) {
        Page page = new Page();
        page.setCurrentPage(pageno);
        return page;
    }

    public Map<String, Object> calculateGiftProductQuantitys(String supplierId, String no, String name) {
        Map<String, Double> easMap = this.stockService.getQuantityByPartner(supplierId);
        Product product = Cache.getProduct(no);
        String productNo = product.getNo();
        Page p = new Page();
        String productId = product.getId() == null ? "" : product.getId();
        Double easQuantity = easMap.get(productId) == null ? 0.0 : easMap.get(productId);
        Map<String, Double> orderMap = this.findProductApplyedQuantitysForOrg(supplierId, no);
        Double orderNum = orderMap.get(productNo) == null ? 0.0 : orderMap.get(productNo);
        Map<String, Double> scoreMap = this.findProductGiftQuantity(supplierId, productNo);
        Double scoreNum = scoreMap.get(productNo) == null ? 0.0 : scoreMap.get(productNo);
        Double quantity = easQuantity - orderNum - scoreNum;
        ArrayList<LinkedHashMap<String, Object>> result = new ArrayList<LinkedHashMap<String, Object>>();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("eas", easQuantity);
        map.put("order", orderNum);
        map.put("score", scoreNum);
        map.put("quantity", quantity);
        map.put("productNo", productNo);
        map.put("name", product.getName());
        map.put("productId", productId);
        result.add(map);
        p.setCurrentPage(1);
        p.setCount(result.size());
        p.setList(result);
        return map;
    }

    public Map<String, Object> calculateGiftProductQuantitys_new(String supplierId, String productId) {
        Product product = Cache.getProduct(productId);
        Partner supplier = this.partnerService.getSimplePartner(supplierId);
        Map<String, Double> applyedQuantitys = supplier.isOrg() ? this.orderApplyService.findProductApplyedQuantitysForOrg(supplierId, null) : this.orderApplyService.findProductApplyedQuantitys(supplierId, null);
        Map<String, Double> scoreMap = this.scoreService.findProductGiftQuantity(supplierId);
        Map<String, Double> easMap = this.stockService.getQuantityByPartner(supplierId);
        Double applyedQuantity = applyedQuantitys.get(productId) == null ? 0.0 : applyedQuantitys.get(productId);
        Double scoreQuantity = scoreMap.get(productId) == null ? 0.0 : scoreMap.get(productId);
        Double easQuantity = easMap.get(productId) == null ? 0.0 : easMap.get(productId);
        Double actualQuantity = easQuantity - applyedQuantity - scoreQuantity;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("eas", easQuantity);
        map.put("order", applyedQuantity);
        map.put("score", scoreQuantity);
        map.put("quantity", actualQuantity);
        map.put("productNo", product.getNo());
        map.put("name", product.getName());
        map.put("productId", productId);
        return map;
    }

    private Map<String, Double> findProductApplyedQuantitysForOrg(String supplierId, String no) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select item.product_no, sum(item.ACT_QUANTITY)");
        sql.append(" from CX_INDENT_LINE             item,");
        sql.append(" CX_INDENT_Apply            apply,");
        sql.append(" cx_sale_order_header_iface cso");
        sql.append(" where item.INDENT_APPLY_ID = apply.ROW_ID");
        sql.append(" and cso.crm_order_id(+) = apply.ROW_ID");
        sql.append(" and apply.organization_id = '" + supplierId + "'");
        sql.append(" and apply.NATURE = '1'");
        sql.append(" and (cso.crm_order_id is null or ");
        sql.append("    (cso.source_system = 'CRM' and cso.target_system = 'EAS' and ");
        sql.append("    cso.type = '\u8ba2\u5355' and ");
        sql.append("    (cso.eas_iface_flag = '0' or cso.eas_iface_flag = '2' or ");
        sql.append("    (cso.eas_iface_flag = '1' and cso.order_status = '\u8d22\u52a1\u5220\u9664')))) ");
        sql.append(" and nvl(item.isscore, '0') != 'Y'");
        sql.append(" and (apply.INDENT_FLAG = '2' or apply.INDENT_FLAG = '3') ");
        if (StringUtils.isNotEmpty(no)) {
            sql.append(" and item.PRODUCT_ID='" + no + "' ");
        }
        sql.append(" group by item.product_no");
        List list = this.baseDao.findBySql(sql.toString());
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Map<String, Double> findProductGiftQuantity(String supplierId, String no) {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        StringBuilder hql = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        hql.append(" select item.productNo,sum(item.quantity) ");
        hql.append(" from ExchangeDetailTotal item,ExchangeOrder eOrder, Partner partner ");
        hql.append(" where item.orderId = eOrder.id ");
        if (supplierId != null) {
            hql.append(" and eOrder.supplierId = ? ");
            params.add(supplierId);
        }
        if (no != null) {
            hql.append(" and item.productNo = ? ");
            params.add(no);
        }
        hql.append(" AND partner.id=eOrder.shopId ");
        hql.append(" and partner.parentPartnerId = '").append(ConfigFactory.get().get("auto_orgId")).append("'");
        hql.append(" and (eOrder.state = 'Submitted' or eOrder.state = 'Approved' ) ");
        hql.append(" and eOrder.redeemType = 'SendByTCBJ' and eOrder.bh_membertype = '\u7ecf\u9500\u5546' ");
        hql.append(" group by item.productNo ");
        List itemOrders = this.baseDao.findEntity(hql.toString(), params.toArray());
        for (Object item : itemOrders) {
            Object[] obj = (Object[])item;
            map.put((String)obj[0], (Double)obj[1]);
        }
        return map;
    }

    public Page findProductByNo(String no) {
        StringBuilder sql = new StringBuilder();
        Cache.getProduct(no);
        sql.append(" select apply.indent_number,apply.INDENT_DATE, sum(item.ACT_QUANTITY),apply.INDENT_FLAG,apply.SOURCE,apply.DEALER_ID,apply.ROW_ID");
        sql.append(" from CX_INDENT_LINE             item,");
        sql.append(" CX_INDENT_Apply            apply,");
        sql.append(" cx_sale_order_header_iface cso");
        sql.append(" where item.INDENT_APPLY_ID = apply.ROW_ID");
        sql.append(" and cso.crm_order_id(+) = apply.ROW_ID");
        sql.append(" and apply.NATURE = '1'");
        sql.append(" and (cso.crm_order_id is null or ");
        sql.append("    (cso.source_system = 'CRM' and cso.target_system = 'EAS' and ");
        sql.append("    cso.type = '\u8ba2\u5355' and ");
        sql.append("    (cso.eas_iface_flag = '0' or cso.eas_iface_flag = '2' or ");
        sql.append("    (cso.eas_iface_flag = '1' and cso.order_status = '\u8d22\u52a1\u5220\u9664')))) ");
        sql.append(" and nvl(item.isscore, '0') != 'Y'");
        sql.append(" and (apply.INDENT_FLAG = '2' or apply.INDENT_FLAG = '3') ");
        if (StringUtils.isNotEmpty(no)) {
            sql.append(" and item.PRODUCT_ID='" + no + "' ");
        }
        sql.append(" group by apply.indent_number,apply.INDENT_DATE,apply.INDENT_FLAG,apply.SOURCE,apply.DEALER_ID,apply.ROW_ID");
        List list = this.baseDao.findBySql(sql.toString());
        ArrayList<ProductStockCondition> listArry = new ArrayList<ProductStockCondition>();
        int countQuantity = 0;
        for (Object[] rowData : list) {
            ProductStockCondition p = new ProductStockCondition();
            p.setNo(String.valueOf(rowData[0]));
            p.setDt((Date)rowData[1]);
            Double quantity = rowData[2] == null ? 0.0 : ((BigDecimal)rowData[2]).doubleValue();
            countQuantity = (int)((double)countQuantity + quantity);
            p.setQuantity(quantity);
            p.setState(this.orderState(String.valueOf(rowData[3])));
            p.setSource("\u5546\u54c1\u8ba2\u5355");
            String hql = "select c from Customer c where applyerId='" + String.valueOf(rowData[5]) + "'";
            Customer customer = (Customer)this.baseDao.findFirstEntity(hql.toString(), Customer.class);
            p.setName(customer.getApplyerName());
            p.setOrderId(String.valueOf(rowData[6]));
            listArry.add(p);
        }
        List<ProductStockCondition> giftOrder = this.findProductGiftByNo(no);
        if (giftOrder.size() > 0) {
            listArry.addAll(giftOrder);
        }
        Page page = new Page();
        page.setList(listArry);
        page.setCount(listArry.size());
        page.setPageSize(10);
        page.setCurrentPage(1);
        page.setPrePage(countQuantity);
        return page;
    }

    public List<ProductStockCondition> findProductGiftByNo(String no) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        hql.append("select  item.orderNo,eOrder.createDt,eOrder.supplierName, sum(item.quantity),eOrder.state,eOrder.id");
        hql.append(" from ExchangeDetailTotal item,ExchangeOrder eOrder, Partner partner ");
        hql.append(" where item.orderId = eOrder.id ");
        if (no != null) {
            hql.append(" and item.productId = ? ");
            params.add(no);
        }
        hql.append(" AND partner.id=eOrder.shopId ");
        hql.append(" and partner.parentPartnerId = '").append(ConfigFactory.get().get("auto_orgId")).append("'");
        hql.append(" and (eOrder.state = 'Submitted' or eOrder.state = 'Approved' ) ");
        hql.append(" and eOrder.redeemType = 'SendByTCBJ' and eOrder.bh_membertype = '\u7ecf\u9500\u5546' ");
        hql.append(" group by item.orderNo,eOrder.createDt,eOrder.supplierName,eOrder.state,eOrder.id ");
        List itemOrders = this.baseDao.findEntity(hql.toString(), params.toArray());
        ArrayList<ProductStockCondition> listArry = new ArrayList<ProductStockCondition>();
        for (Object item : itemOrders) {
            ProductStockCondition p = new ProductStockCondition();
            Object[] obj = (Object[])item;
            p.setNo(obj[0].toString());
            p.setDt((Date)obj[1]);
            p.setName(obj[2].toString());
            p.setQuantity((Double)obj[3]);
            p.setState(obj[4].toString());
            p.setSource("\u79ef\u5206\u8ba2\u5355");
            p.setOrderId(obj[5].toString());
            listArry.add(p);
        }
        return listArry;
    }

    public Page getlist(everydayManageCondition con, int pageno, Employee me) {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sql.append("select c.source_system , c.target_system , c.eas_order_id , c.eas_order_number , c.crm_order_id, c.crm_order_number , c.scan_order_id , c.scan_order_number , c.sfa_order_id , c.sfa_order_number , c.eas_process_msg , c.scan_process_msg , c.crm_process_msg , c.sfa_process_msg, c.oa_process_msg,c.customer_number ");
        sql.append(" from CX_SALE_ORDER_HEADER_IFACE c where c.org_id = ? ");
        args.add(me.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(con.getCrmOrderId())) {
            sql.append(" and c.crm_order_id = ? ");
            args.add(con.getCrmOrderId());
        }
        if (StringUtils.isNotEmpty(con.getCrmOrderNumber())) {
            sql.append(" and c.crm_order_number = ? ");
            args.add(con.getCrmOrderNumber());
        }
        if (StringUtils.isNotEmpty(con.getCrmIfaceFlag())) {
            if (con.getCrmIfaceFlag().equals("1")) {
                sql.append(" and c.crm_order_number = ?");
                args.add(con.getCrmIfaceFlag());
            }
        } else {
            sql.append(" and c.CRM_IFACE_FLAG = '2'");
        }
        if (StringUtils.isNotEmpty(con.getScanOrderId())) {
            sql.append(" and c.scan_order_id = ? ");
            args.add(con.getScanOrderId());
        }
        if (StringUtils.isNotEmpty(con.getScanOrderNumber())) {
            sql.append(" and c.scan_order_number = ? ");
            args.add(con.getScanOrderNumber());
        }
        sql.append(" and crm_process_msg is not null");
        sql.append(" order by c.LAST_UPDATE_DATE DESC ");
        Page page = this.baseDao.searchBySql(sql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, CxSaleOrderHeaderIface.class);
        List list = page.getList();
        ArrayList<CxSaleOrderHeaderIface> newList = new ArrayList<CxSaleOrderHeaderIface>();
        for (Object object : list) {
            Object[] obj = (Object[])object;
            CxSaleOrderHeaderIface c = new CxSaleOrderHeaderIface();
            c.setSourceSystem(obj[0] != null ? String.valueOf(obj[0]) : "");
            c.setTargetSystem(obj[1] != null ? String.valueOf(obj[1]) : "");
            c.setEasOrderId(obj[2] != null ? String.valueOf(obj[2]) : "");
            c.setEasOrderNumber(obj[3] != null ? String.valueOf(obj[3]) : "");
            c.setCrmOrderId(obj[4] != null ? String.valueOf(obj[4]) : "");
            c.setCrmOrderNumber(obj[5] != null ? String.valueOf(obj[5]) : "");
            c.setScanOrderId(obj[6] != null ? String.valueOf(obj[6]) : "");
            c.setScanOrderNumber(obj[7] != null ? String.valueOf(obj[7]) : "");
            c.setSfaOrderId(obj[8] != null ? String.valueOf(obj[8]) : "");
            c.setSfaOrderNumber(obj[9] != null ? String.valueOf(obj[9]) : "");
            c.setEasProcessMsg(obj[10] != null ? String.valueOf(obj[10]) : "");
            c.setScanProcessMsg(obj[11] != null ? String.valueOf(obj[11]) : "");
            c.setCrmProcessMsg(obj[12] != null ? String.valueOf(obj[12]) : "");
            c.setSfaProcessMsg(obj[13] != null ? String.valueOf(obj[13]) : "");
            c.setOaProcessMsg(obj[14] != null ? String.valueOf(obj[14]) : "");
            c.setCustomerNumber(obj[15] != null ? String.valueOf(obj[15]) : "");
            newList.add(c);
        }
        page.setList(newList);
        return page;
    }

    public boolean findIsExistCustomer(String customerNumber) {
        StringBuilder hql = new StringBuilder();
        boolean flag = false;
        try {
            List partner;
            if (StringUtils.isNotEmpty(customerNumber)) {
                hql.append(" from Partner p ");
                hql.append(" where SUBSTR(clientAppNo, INSTR(clientAppNo, '.', -1) + 1)  = '").append(customerNumber).append("'");
            }
            if ((partner = this.baseDao.findEntity(hql.toString(), Partner.class)).size() <= 0) {
                return flag;
            }
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean updateCustomerNo(String customerNumber, String scanOrderNumber, String masterOuId, String newCustomerNo) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        boolean flag = false;
        try {
            sql.append(" update CX_SALE_ORDER_HEADER_IFACE c set c.crm_iface_flag='0' ");
            if (StringUtils.isNotEmpty(newCustomerNo)) {
                sql.append(", c.customer_number =?");
                args.add(newCustomerNo);
            }
            if (StringUtils.isNotEmpty(customerNumber)) {
                sql.append(" where c.customer_number=?");
                args.add(customerNumber);
                if (StringUtils.isNotEmpty(scanOrderNumber)) {
                    sql.append(" and c.scan_order_number =?");
                    args.add(scanOrderNumber);
                }
                if (StringUtils.isNotEmpty(masterOuId)) {
                    sql.append(" and c.master_ou_id =?");
                    args.add(masterOuId);
                }
            }
            this.baseDao.executeSQL(sql.toString(), args.toArray());
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            e.printStackTrace();
        }
        return flag;
    }

    public Page fingChildProduct(String scanOrderId, String masterOuId, String scanOrderNumber, String productNo, String productName, int pageno) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sql.append("select item.scan_order_line_id,item.item_number,item.item_uom,item.order_quantity,item.ship_quantity ,item.sale_price ,item.created_by_name,item.last_update_date,item.scan_order_id from cx_sale_order_header_iface h,cx_sale_order_line_iface  item where h.scan_order_id = item.scan_order_id ");
        if (StringUtils.isNotEmpty(scanOrderId)) {
            sql.append(" and h.scan_order_id=?");
            args.add(scanOrderId);
        }
        if (StringUtils.isNotEmpty(masterOuId)) {
            sql.append(" and h.master_ou_id =?");
            args.add(masterOuId);
        }
        if (StringUtils.isNotEmpty(productNo)) {
            sql.append(" and item.item_number = ? ");
            args.add(productNo);
        }
        if (StringUtils.isNotEmpty(productName)) {
            sql.append(" and item.item_number in");
            sql.append(" (select prodno from CX_AWK_PRODLIST_VIEW where name like ? )");
            args.add("%" + productName + "%");
        }
        Page page = this.baseDao.searchBySql(sql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, CxSaleOrderLineIface.class);
        List list = page.getList();
        ArrayList<CxSaleOrderLineIface> orderItems = new ArrayList<CxSaleOrderLineIface>();
        for (Object object : list) {
            Object[] obj = (Object[])object;
            CxSaleOrderLineIface orderItem = new CxSaleOrderLineIface();
            orderItem.setScanOrderLineId(obj[0] != null ? String.valueOf(obj[0]) : "");
            orderItem.setItemNumber(obj[1] != null ? String.valueOf(obj[1]) : "");
            orderItem.setItemuUom(obj[2] != null ? String.valueOf(obj[2]) : "");
            orderItem.setOrderQuantity(obj[3] != null ? String.valueOf(obj[3]) : "");
            orderItem.setShipQuantity(obj[4] != null ? String.valueOf(obj[4]) : "");
            long obj5 = ((BigDecimal)obj[5]).intValue();
            orderItem.setSalePrice(String.valueOf(obj5));
            orderItem.setCreatedByName(obj[6] != null ? String.valueOf(obj[6]) : "");
            orderItem.setLastUpdateDate(obj[7] != null ? String.valueOf(obj[7]) : "");
            orderItem.setScanOrderId(obj[8] != null ? String.valueOf(obj[8]) : "");
            orderItems.add(orderItem);
        }
        page.setList(orderItems);
        return page;
    }

    public boolean delChildProduct(String scanOrderId) {
        StringBuilder sql = new StringBuilder();
        new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        boolean flag = false;
        try {
            if (StringUtils.isNotEmpty(scanOrderId)) {
                sql.append(" delete  from cx_sale_order_line_iface s  where s.scan_order_line_id=?");
                args.add(scanOrderId);
                this.baseDao.executeSQL(sql.toString(), args.toArray());
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        return flag;
    }

    public Page findIsrepeatCustomerCheckCustomer(String customerNumber, int pageno) throws ParseException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(customerNumber)) {
            sql.append(" select p.NAME,p.CSN,p.CREDITLEVEL,p.PROVINCE,p.CITY,p.CREATE_DT,p.CREATOR_ID,p.LASTUPDATE_DT,p.LASTUPDATOR_ID,p.ROW_ID  from cx_awk_partnerlist_view p where SUBSTR(p.externalcode, INSTR(p.externalcode, '.', -1) + 1)  = ?");
            args.add(customerNumber);
        }
        Page page = this.baseDao.searchBySql(sql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, Partner.class);
        List list = page.getList();
        ArrayList<Partner> lists = new ArrayList<Partner>();
        for (Object obj : list) {
            Object[] objs = (Object[])obj;
            Partner partner = new Partner();
            partner.setName(objs[0] != null ? String.valueOf(objs[0]) : "");
            partner.setNo(objs[1] != null ? String.valueOf(objs[1]) : "");
            partner.setCreditLevelCode(objs[2] != null ? String.valueOf(objs[2]) : "");
            partner.setProvinceCode(objs[3] != null ? String.valueOf(objs[3]) : "");
            partner.setCityCode(objs[4] != null ? String.valueOf(objs[4]) : "");
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Date objs5 = sf.parse(String.valueOf(objs[5]));
            partner.setCreateDt(objs5);
            partner.setCreatorId(objs[6] != null ? String.valueOf(objs[6]) : "");
            Date objs7 = sf.parse(String.valueOf(objs[7]));
            partner.setLastUpdateDt(objs7);
            partner.setLastUpdatorId(objs[8] != null ? String.valueOf(objs[8]) : "");
            partner.setId(objs[9] != null ? String.valueOf(objs[9]) : "");
            lists.add(partner);
        }
        page.setList(lists);
        return page;
    }

    public boolean triggerOrderReturnHandle() {
        Map<String, Object> objs = this.newBaseDao.executeProcedure("P_COMMIT", "F");
        for (String key : objs.keySet()) {
            if (!objs.get(key).toString().equals("true")) continue;
            return true;
        }
        return false;
    }

    public boolean updateIsrepeatCustomerCheckCustomer(String rowId, String ids, String scanOrderId) {
        boolean flag = false;
        try {
            Map<String, String> map = this.notDefinedRowId(ids, rowId);
            this.map1.putAll(map);
            for (String key : map.keySet()) {
                StringBuilder sql2 = new StringBuilder();
                sql2.append(" update S_ORG_EXT_X t1 set t1.attrib_07='' where t1.par_row_id ='").append(key).append("'");
                this.baseDao.executeSQL(sql2.toString());
            }
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            e.printStackTrace();
        }
        return flag;
    }

    public boolean updateIsrepeatCustomerCheckCustomer2(String scanOrderId, String masterOuId) {
        boolean flag = false;
        try {
            StringBuilder sql3 = new StringBuilder();
            sql3.append(" update CX_SALE_ORDER_HEADER_IFACE c set c.crm_iface_flag='0' where c.scan_order_id ='").append(scanOrderId).append("'");
            sql3.append(" and c.master_ou_id = '").append(masterOuId).append("'");
            this.baseDao.executeSQL(sql3.toString());
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            e.printStackTrace();
        }
        return flag;
    }

    public boolean updatebackCustmerCode(String ids, String rowId) {
        for (String key : this.map1.keySet()) {
            StringBuilder sql2 = new StringBuilder();
            sql2.append(" update S_ORG_EXT_X t1 set");
            sql2.append(" t1.attrib_07='").append(this.map1.get(key)).append("'");
            sql2.append(" where t1.par_row_id ='").append(key).append("'");
            this.baseDao.executeSQL(sql2.toString());
        }
        return true;
    }

    public Map<String, String> notDefinedRowId(String ids, String rowId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] idArray = ids.split(",");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < idArray.length) {
            if (Beans.isNotEmpty((Object)idArray[i])) {
                list.add(idArray[i]);
            }
            ++i;
        }
        Iterator strIterator = list.iterator();
        while (strIterator.hasNext()) {
            String string = (String)strIterator.next();
            if (!rowId.equals(string)) continue;
            strIterator.remove();
        }
        for (String id : list) {
            StringBuilder sql = new StringBuilder();
            sql.append("select t1.par_row_id, t1.attrib_07  from S_ORG_EXT_X t1 where t1.par_row_id = '").append(id).append("'");
            List objs = this.baseDao.findBySql(sql.toString());
            for (Object[] rowData : objs) {
                String parRowId = (String)rowData[0];
                String attrib_07 = (String)rowData[1];
                map.put(parRowId, attrib_07);
            }
        }
        return map;
    }

    public void save(CustomerOperator opt) {
        this.baseDao.save((Object)opt);
    }

    public Page JOBhandleApply(int pageno) throws ParseException {
        StringBuilder sql = new StringBuilder();
        ArrayList args = new ArrayList();
        sql.append("select t.INDENT_NUMBER,t.INDENT_DATE,t.COLLECT_NUMBER,t.SHIPPING_ADDRESS,t.CONTACTS,t.PHONE,t.ORDER_CONTACTS,t.ROW_ID from CX_INDENT_APPLY t where t.INDENT_FLAG !='2' and to_char(add_months(t.INDENT_DATE,-0), 'yyyy-mm-dd') between to_char(add_months(sysdate,-3), 'yyyy-mm-dd') and to_char(sysdate, 'yyyy-mm-dd')");
        Page page = this.baseDao.searchBySql(sql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, OrderApply.class);
        List list = page.getList();
        ArrayList<OrderApply> newList = new ArrayList<OrderApply>();
        for (Object object : list) {
            Object[] obj = (Object[])object;
            OrderApply apply = new OrderApply();
            apply.setNo(obj[0] != null ? String.valueOf(obj[0]) : "");
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Date objs1 = sf.parse(String.valueOf(obj[1]));
            apply.setDt(objs1);
            int obj2 = ((BigDecimal)obj[2]).intValue();
            apply.setQuantity(Double.parseDouble(String.valueOf(obj2)));
            apply.setShippingAddress(obj[3] != null ? String.valueOf(obj[3]) : "");
            apply.setContacts(obj[4] != null ? String.valueOf(obj[4]) : "");
            apply.setPhone(obj[5] != null ? String.valueOf(obj[5]) : "");
            apply.setOrderContacts(obj[6] != null ? String.valueOf(obj[6]) : "");
            apply.setId(obj[7] != null ? String.valueOf(obj[7]) : "");
            newList.add(apply);
        }
        page.setList(newList);
        page.setCount(newList.size());
        page.setMaxPage(pageno);
        return page;
    }

    public void orderApplyBackCheck(String id) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sql.append(" select * from cx_sale_order_header_iface item where item.crm_order_id='").append(id).append("'");
        args.add(id);
        List objs = this.baseDao.findBySql(sql.toString());
        if (objs.size() > 0) {
            this.orderApplyService.unRtnApprove(id);
        }
    }

    public List<OrderApply> JOBhandleApply() {
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.row_id  from cx_indent_apply a, cx_sale_order_header_iface t where a.row_id = t.crm_order_id ");
        sql.append(" and a.indent_flag = '3' and t.order_status = '\u8d22\u52a1\u5220\u9664' and a.nature = '1'");
        List list = this.baseDao.findBySql(sql.toString());
        String[] array = list.toArray(new String[list.size()]);
        StringBuilder param = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            if (i == array.length - 1) {
                param.append("'").append(array[i]).append("'");
            } else {
                param.append("'").append(array[i]).append(" ',");
            }
            ++i;
        }
        String sql2 = " from OrderApply a where a.id in(" + param.toString() + " )";
        List objs = this.baseDao.findEntity(sql2.toString(), OrderApply.class);
        return objs;
    }

    public String orderState(String code) {
        int intCode = Integer.valueOf(code);
        switch (intCode) {
            case 0: {
                return "\u8349\u7a3f";
            }
            case 2: {
                return "\u5f85\u5ba1\u6279";
            }
            case 3: {
                return "\u5ba1\u6279\u901a\u8fc7";
            }
            case 4: {
                return "\u8d22\u52a1\u901a\u8fc7";
            }
            case 5: {
                return "\u5df2\u53d1\u8d27";
            }
            case 6: {
                return "\u5df2\u6536\u8d27";
            }
            case 9: {
                return "\u5220\u9664";
            }
        }
        return null;
    }

    public List findCustomerNoById(String id) {
        return this.baseDao.findBySql(" select c.csn from cx_awk_partnerlist_view c where c.row_id='" + id + "'");
    }

    public Page queryStockAccount(ProductStockCondition con) {
        Product product = Cache.getProductByNo(con.getProductCode());
        HashMap<String, String> sendData = new HashMap<String, String>();
        sendData.put("fromRow", con.getPageno().toString());
        sendData.put("maxRows", String.valueOf(Constant.DEFAULT_ROWS));
        sendData.put("organization", ConfigFactory.get().get("prefix"));
        if (StringUtils.isNotEmpty(con.getProductCode())) {
            sendData.put("productId", product.getId());
        }
        if (StringUtils.isNotEmpty(con.getStorageId())) {
            sendData.put("warehouseId", con.getStorageId());
        }
        Map<String, Object> result = EasRequestHelper.getInstance().sendBodyToESB(String.valueOf(StringUtils.getEasStock()) + "inventoryApi/queryInventoryFlowDetail", sendData);
        Map returnObject = (Map)result.get("returnObject");
        List list = (List)returnObject.get("resultQuery");
        for (Map map : list) {
            map.put("productCode", product.getNo());
            map.put("productName", product.getName());
            map.put("warehouseName", Cache.getStorageName((String)map.get("warehouse_id")));
        }
        int count = Integer.valueOf(returnObject.get("count").toString());
        Page page = new Page(list, con.getPageno().intValue(), Constant.DEFAULT_ROWS, count);
        return page;
    }
}

