/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productSubType;

import com.tcbj.crm.entity.ProductTypeExtend;
import com.tcbj.crm.entity.SiebelLov;
import com.tcbj.crm.productSubType.ProductSubType;
import com.tcbj.crm.siebelLov.SiebelLovService;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productSubService")
public class ProductSubService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    SiebelLovService siebelLovService;

    private Object[] getQueryHql(ProductSubType condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> orgs = new ArrayList<String>();
        hql.append("from SiebelLov s, ProductTypeExtend p where s.id = p.siebelId and s.langId = ? and s.type = ? and p.isShow = ? and p.orgId = ? ");
        orgs.add("CHS");
        orgs.add("TCBJ_PRODUCT_SUB_TYPE");
        orgs.add("Y");
        orgs.add(StringUtils.getOrgId());
        if (StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and s.val like ? ");
            orgs.add("%" + condition.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getSiebelId())) {
            hql.append(" and s.id = ? ");
            orgs.add(condition.getSiebelId());
        }
        return new Object[]{hql.toString(), orgs.toArray()};
    }

    public Page findPage(ProductSubType condition, int pageno) {
        Object[] sqlAndParam = this.getQueryHql(condition);
        Page page = this.baseDao.search((String)sqlAndParam[0], (Object[])sqlAndParam[1], Constant.DEFAULT_ROWS, pageno);
        page.setList(this.mergeQuery(page.getList()));
        return page;
    }

    public List<ProductSubType> getList(ProductSubType condition) {
        Object[] sqlAndParam = this.getQueryHql(condition);
        List obj = this.baseDao.findEntity((String)sqlAndParam[0], (Object[])sqlAndParam[1], Object.class);
        return this.mergeQuery(obj);
    }

    private List<ProductSubType> mergeQuery(List list) {
        ArrayList<ProductSubType> productSubTypes = new ArrayList<ProductSubType>();
        for (Object obj : list) {
            Object[] data = (Object[])obj;
            ProductSubType productSubType = new ProductSubType((SiebelLov)data[0], (ProductTypeExtend)data[1]);
            productSubTypes.add(productSubType);
        }
        return productSubTypes;
    }

    public ProductSubType getProductSubType(String siebelId) {
        ProductSubType condition = new ProductSubType();
        condition.setSiebelId(siebelId);
        List<ProductSubType> list = this.getList(condition);
        return Beans.isEmpty(list) ? null : list.get(0);
    }

    public void updateProductSubType(ProductSubType productSubType) {
        SiebelLov lov = this.siebelLovService.getSiebelLov(productSubType.getSiebelId());
        lov.setLow(productSubType.getDiscount());
        this.baseDao.update((Object)lov);
        ProductTypeExtend productTypeExtend = (ProductTypeExtend)this.baseDao.get(ProductTypeExtend.class, (Serializable)((Object)productSubType.getId()));
        productTypeExtend.setIsShow(productSubType.getIsShow());
        this.baseDao.update((Object)productTypeExtend);
    }
}

