/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productionPlan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.ProductionPlan;
import com.tcbj.crm.entity.ProductionPlanItem;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.predictConfig.PredictConfigService;
import com.tcbj.crm.productionPlan.ProductionPlanCondition;
import com.tcbj.crm.productionPlan.ProductionPlanService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/productionPlan"})
public class ProductionPlanController
extends BaseController {
    @Autowired
    ProductionPlanService productionPlanService;
    @Autowired
    PredictConfigService predictConfigService;

    @RequestMapping(value={"/list.do"})
    public String list(ProductionPlanCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        con.setOrgId(em.getCurrentPartner().getOrganizationid());
        Page page = this.productionPlanService.list(con);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "productionPlan/list.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(Model model) {
        ProductionPlan productionPlan = null;
        productionPlan = new ProductionPlan();
        productionPlan.setState(TCBJEnum.ApplyState.draft.getValue());
        model.addAttribute("productionPlan", (Object)productionPlan);
        return "productionPlan/apply.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="id", required=true) String id, Model model) {
        Employee em = this.getCurrentEmployee();
        List<Object> configs = new ArrayList();
        ProductionPlan productionPlan = null;
        if (Beans.isNotEmpty((Object)id)) {
            productionPlan = this.productionPlanService.getProductionPlan(id, em);
            configs = this.productionPlanService.getPredictConfigByIds(productionPlan.getConfigId(), productionPlan.getOrgId());
        }
        model.addAttribute("items", (Object)JSON.toJSONStringWithDateFormat(productionPlan.getItems(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("configs", (Object)JSON.toJSONStringWithDateFormat(configs, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("productionPlan", (Object)productionPlan);
        model.addAttribute("edit", (Object)"false");
        model.addAttribute("isedit", (Object)"true");
        model.addAttribute("title", (Object)"\u4fee\u6539");
        model.addAttribute("planType", (Object)("A".equals(productionPlan.getPlanType()) ? "\u6708\u5ea6" : "\u8ffd\u52a0"));
        return "productionPlan/edit.ftl";
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.GET})
    public String approve(@RequestParam(value="id", required=true) String id, Model model) {
        Employee em = this.getCurrentEmployee();
        List<Object> configs = new ArrayList();
        ProductionPlan productionPlan = null;
        if (Beans.isNotEmpty((Object)id)) {
            productionPlan = this.productionPlanService.getProductionPlan(id, em);
            configs = this.productionPlanService.getPredictConfigByIds(productionPlan.getConfigId(), productionPlan.getOrgId());
        }
        model.addAttribute("items", (Object)JSON.toJSONStringWithDateFormat(productionPlan.getItems(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("configs", (Object)JSON.toJSONStringWithDateFormat(configs, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("productionPlan", (Object)productionPlan);
        model.addAttribute("edit", (Object)"true");
        model.addAttribute("approve", (Object)"true");
        model.addAttribute("title", (Object)"\u5ba1\u6279");
        model.addAttribute("planType", (Object)("A".equals(productionPlan.getPlanType()) ? "\u6708\u5ea6" : "\u8ffd\u52a0"));
        return "productionPlan/edit.ftl";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=true) String id, Model model) {
        Employee em = this.getCurrentEmployee();
        List<Object> configs = new ArrayList();
        ProductionPlan productionPlan = null;
        if (Beans.isNotEmpty((Object)id)) {
            productionPlan = this.productionPlanService.getProductionPlan(id, em);
            configs = this.productionPlanService.getPredictConfigByIds(productionPlan.getConfigId(), productionPlan.getOrgId());
        }
        model.addAttribute("items", (Object)JSON.toJSONStringWithDateFormat(productionPlan.getItems(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("configs", (Object)JSON.toJSONStringWithDateFormat(configs, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("productionPlan", (Object)productionPlan);
        model.addAttribute("edit", (Object)"false");
        model.addAttribute("title", (Object)"\u67e5\u770b");
        model.addAttribute("planType", (Object)("A".equals(productionPlan.getPlanType()) ? "\u6708\u5ea6" : "\u8ffd\u52a0"));
        return "productionPlan/edit.ftl";
    }

    private void fillMonths(PredictConfig config, Model model) {
        model.addAttribute("predictDate", (Object)config.getPredictDate());
        model.addAttribute("rollMonth", (Object)config.getRollMonth());
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result approve_do(@Valid @RequestBody ProductionPlan plan) {
        Employee em = this.getCurrentEmployee();
        this.productionPlanService.approveProductionPlan(plan, em);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_do(@Valid @RequestBody ProductionPlan plan) {
        Employee em = this.getCurrentEmployee();
        this.productionPlanService.saveOrUpdateProductionPlan(plan, em);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET})
    public String del(@RequestParam(value="id", required=true) String id) {
        Employee em = this.getCurrentEmployee();
        this.productionPlanService.del(id, em);
        return "redirect:/productionPlan/list.do";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody ProductionPlan plan) {
        Employee em = this.getCurrentEmployee();
        this.productionPlanService.saveOrUpdateProductionPlan(plan, em);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/getPredictApplys.do"}, method={RequestMethod.GET})
    @ResponseBody
    public String getPredictApplys(@RequestParam(value="data", required=false) String data) {
        Employee em = this.getCurrentEmployee();
        if (Beans.isNotEmpty((Object)data)) {
            List<ProductionPlanItem> list = this.productionPlanService.getProductionPlanItemsByIds(data, em);
            return JSON.toJSONString(list);
        }
        return null;
    }

    @RequestMapping(value={"/getPredictConfigs.do"})
    public String getPredictConfigs(@RequestParam(value="planType", required=true) String planType, @RequestParam(value="configIds", required=false) String configIds, Model model) {
        model.addAttribute("planType", (Object)planType);
        if (Beans.isNotEmpty((Object)configIds)) {
            model.addAttribute("configIds", (Object)configIds);
        }
        return "productionPlan/selectPredictConfig.ftl";
    }

    @RequestMapping(value={"/selectPredictConfig.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<PredictConfig> selectPredictConfig(@ModelAttribute(value="condition") PredictConfigCondition con, Model model) {
        try {
            if (Beans.isNotEmpty((Object)con.getConfigName())) {
                con.setConfigName(new String(con.getConfigName().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Employee em = this.getCurrentEmployee();
        con.setOrgId(em.getCurrentPartner().getOrganizationid());
        if ("A".equals(con.getPredictType())) {
            con.setState(TCBJEnum.ConfigTpye.adjustpass.getValue());
        } else {
            con.setState(TCBJEnum.ConfigTpye.going.getValue());
        }
        List<PredictConfig> list = this.productionPlanService.getPredictConfigs(con);
        List<PredictConfig> newlist = this.productionPlanService.replace(list, em);
        return newlist;
    }

    @RequestMapping(value={"/importData.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String importData(@RequestParam(value="configId", required=true) String configId, HttpServletRequest request, Model model) {
        Employee em = this.getCurrentEmployee();
        List<Object> errorMsg = new ArrayList<String>();
        ArrayList<ProductionPlanItem> items = new ArrayList();
        ArrayList<ProductionPlanItem> newitems = new ArrayList<ProductionPlanItem>();
        if (!Beans.isNotEmpty((Object)configId)) {
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            errorMsg.add("\u8bf7\u5148\u9009\u62e9\u9700\u6c42\u914d\u7f6e!");
            rtn.put("type", "fail");
            rtn.put("result", errorMsg);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        items = this.productionPlanService.getProductionPlanItemsByIds(configId, em);
        List<IUploadFile> filelist = this.uploadFile(request, "import");
        String url = "";
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        if (Beans.isNotEmpty(errorMsg = this.productionPlanService.readItemByExcel(url, items, newitems)) && errorMsg.size() > 0) {
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            rtn.put("type", "fail");
            rtn.put("result", errorMsg);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
            return "common/iframeRtn.ftl";
        }
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        rtn.put("type", "success");
        rtn.put("result", newitems);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(rtn)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/exportExcel.do"})
    public void exportExcel(@RequestParam(value="id", required=true) String id, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        List<ProductionPlanItem> products = this.productionPlanService.getProductionPlanItemsByIds(id, em);
        File dir = new File(String.valueOf(ConfigFactory.get().get("upload_base_path")) + "products");
        if (!dir.mkdirs()) {
            dir.mkdirs();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        HSSFRow row = sheet.createRow(0);
        List<String> ids = StringUtils.stringToList(id, ",");
        PredictConfig pc = this.predictConfigService.getPredictConfigById(ids.get(0), em);
        Calendar cal = Calendar.getInstance();
        cal.setTime(pc.getPredictDate());
        String nowMonth = String.valueOf(cal.get(1)) + "\u5e74" + (cal.get(2) + 1) + "\u6708";
        String nextMonth = pc.getRollMonth() > 3.0 ? String.valueOf(this.getMonthReal(cal.get(2) + 1 + 1)) + "-" + this.getMonthReal(cal.get(2) + 1 + 2) + "\u6708" : String.valueOf(this.getMonthReal(cal.get(2) + 1 + 1)) + "\u6708";
        String[] names = new String[]{"\u4ea7\u54c1\u7f16\u7801", "\u4ea7\u54c1\u540d\u79f0", "\u5b89\u5168\u5e93\u5b58", "\u5f53\u524d\u5373\u65f6\u5e93\u5b58\u91cf", String.valueOf(nowMonth) + "\u672a\u4ea4\u8ba1\u5212\uff08\u5305\u88c5\u4e2d\uff09", String.valueOf(nowMonth) + "\u8ffd\u52a0\u8ba1\u5212", String.valueOf(nextMonth) + "\u751f\u4ea7\u8ba1\u5212", "\u751f\u4ea7\u6279\u91cf"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < products.size()) {
            row = sheet.createRow(i + 1);
            ProductionPlanItem product = products.get(i);
            String[] vals = new String[]{product.getProductNo(), product.getProductName(), "", "", "", "", "", ""};
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream file = new FileOutputStream(String.valueOf(dir.getPath()) + "\\" + em.getCurrentPartner().getNo() + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls");
            wb.write((OutputStream)file);
            ExcelUtil.download(String.valueOf(dir.getPath()) + "\\" + em.getCurrentPartner().getNo() + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getMonthReal(int month) {
        return month > 12 ? month - 12 : month;
    }
}

