/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productionPlan;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.ProductionPlanItem;
import com.tcbj.crm.predictAdjust.PredictAdjustItem;
import com.tcbj.crm.predictAdjust.PredictAdjustService;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.predictConfig.PredictConfigService;
import com.tcbj.crm.productionPlan.ProductionPlanService;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/productionPlan"})
public class ProductionPlanExcelController
extends BaseController {
    @Autowired
    PredictAdjustService predictAdjustService;
    @Autowired
    PredictConfigService predictConfigService;
    @Autowired
    PredictApplyService predictApplyService;
    @Autowired
    ProductionPlanService productionPlanService;

    @RequestMapping(value={"/exportProductionPlanExcel.do"}, method={RequestMethod.GET})
    public void exportProductionPlanExcel(String planId, String configId, HttpServletResponse response) throws Exception {
        Employee em = this.getCurrentEmployee();
        List<PredictConfig> list = this.productionPlanService.getPredictConfigByIds(configId, em.getCurrentPartner().getOrganizationid());
        PredictConfig predictConfig = list.get(0);
        HashMap<String, PredictAdjustItem> map = new HashMap<String, PredictAdjustItem>();
        ArrayList<PredictAdjustItem> predictAdjustItems = new ArrayList<PredictAdjustItem>();
        LinkedList months = new LinkedList();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (PredictConfig pc : list) {
            List<String> monthstemp = this.getMonths(pc);
            set.addAll(monthstemp);
            List<PredictAdjustItem> items = this.predictAdjustService.getPredictAdjustItemByPredictConfig(pc, "product", null);
            Iterator<PredictAdjustItem> iterator = items.iterator();
            while (iterator.hasNext()) {
                PredictAdjustItem item = iterator.next();
                if (Beans.isEmpty(map.get(item.getProductId()))) {
                    map.put(item.getProductId(), item);
                    continue;
                }
                Map<String, Map<String, Double>> newMonthsQuantity = ((PredictAdjustItem)map.get(item.getProductId())).getMonthsQuantity();
                Map<String, Map<String, Double>> monthsQuantity = item.getMonthsQuantity();
                this.addMonthsQuantity(newMonthsQuantity, monthsQuantity);
            }
        }
        months.addAll(set);
        Collections.sort(months);
        for (String prodId : map.keySet()) {
            predictAdjustItems.add((PredictAdjustItem)map.get(prodId));
        }
        List<ProductionPlanItem> productionPlanItems = this.productionPlanService.getProductionPlanItemById(planId);
        HashMap<String, ProductionPlanItem> planItemMap = new HashMap<String, ProductionPlanItem>();
        for (ProductionPlanItem productionPlanItem : productionPlanItems) {
            planItemMap.put(productionPlanItem.getProductId(), productionPlanItem);
        }
        LinkedHashMap<String, String> titleNameMap = new LinkedHashMap<String, String>();
        titleNameMap.put("productEasNo", "\u4ea7\u54c1\u7f16\u7801(\u957f\u7f16\u7801)");
        titleNameMap.put("productNo", "\u4ea7\u54c1\u7f16\u7801(\u77ed\u7f16\u7801)");
        titleNameMap.put("productName", "\u4ea7\u54c1\u540d\u79f0");
        titleNameMap.put("productPrice", "\u4ea7\u54c1\u4ef7\u683c");
        titleNameMap.put("productUnit", "\u5355\u4f4d");
        titleNameMap.put("productType", "\u4ea7\u54c1\u7c7b\u578b");
        titleNameMap.put("monthAverage", "\u6708\u5747\u53d1\u8d27\u91cf");
        for (String month : months) {
            month = Integer.valueOf(month = month.substring(4)) > 9 ? month : month.substring(1);
            titleNameMap.put(String.valueOf(month) + "_finality", String.valueOf(month) + "\u6708\u4efd\uff08\u6700\u7ec8\u91cf\uff09");
        }
        for (String month : months) {
            month = Integer.valueOf(month = month.substring(4)) > 9 ? month : month.substring(1);
            titleNameMap.put(String.valueOf(month) + "_customer", String.valueOf(month) + "\u6708\u4efd\uff08\u5ba2\u6237\u9884\u6d4b\u503c\uff09");
        }
        String nowMonth = "";
        String nextMonth = "";
        String auditMonth = "";
        if (Beans.isNotEmpty((Object)predictConfig.getPredictDate())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(predictConfig.getPredictDate());
            nowMonth = String.valueOf(cal.get(1)) + "\u5e74" + (cal.get(2) + 1) + "\u6708";
            nextMonth = predictConfig.getRollMonth() > 3.0 ? String.valueOf(this.getMonthReal(cal.get(2) + 1 + 1)) + "-" + this.getMonthReal(cal.get(2) + 1 + 2) + "\u6708" : String.valueOf(this.getMonthReal(cal.get(2) + 1 + 1)) + "\u6708";
            auditMonth = predictConfig.getRollMonth() > 1.0 ? String.valueOf(this.getMonthReal(cal.get(2) + 1 + predictConfig.getRollMonth().intValue() - 1)) + "\u6708" : String.valueOf(this.getMonthReal(cal.get(2) + 1 + predictConfig.getRollMonth().intValue())) + "\u6708";
        }
        titleNameMap.put("safeQuantity", "\u5b89\u5168\u5e93\u5b58");
        titleNameMap.put("nowQuantity", "\u5f53\u524d\u5373\u65f6\u5e93\u5b58\u91cf");
        titleNameMap.put("packQuantity", String.valueOf(nowMonth) + "\u672a\u4ea4\u8ba1\u5212(\u5305\u88c5\u4e2d)");
        titleNameMap.put("additionQuantity", String.valueOf(nowMonth) + "\u8ffd\u52a0\u8ba1\u5212");
        titleNameMap.put("nextMonthQuantity", String.valueOf(nextMonth) + "\u751f\u4ea7\u8ba1\u5212");
        titleNameMap.put("productionBatch", "\u751f\u4ea7\u6279\u91cf");
        titleNameMap.put("nextNextMonthQuantity", String.valueOf(auditMonth) + "\u751f\u6210\u8ba1\u5212\u91cf(\u6700\u7ec8\u786e\u8ba4\u540e\u7684\u6570\u636e)");
        ArrayList listExcel = new ArrayList();
        for (PredictAdjustItem predictAdjustItem : predictAdjustItems) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            listExcel.add(itemMap);
            itemMap.put("productEasNo", predictAdjustItem.getProductEasNo());
            itemMap.put("productNo", predictAdjustItem.getProductNo());
            itemMap.put("productName", predictAdjustItem.getProductName());
            itemMap.put("productPrice", predictAdjustItem.getProductPrice());
            itemMap.put("productUnit", predictAdjustItem.getProductUnit());
            itemMap.put("productType", predictAdjustItem.getProductSubTypeName());
            itemMap.put("monthAverage", predictAdjustItem.getMonthAverage());
            Map<String, Map<String, Double>> monthsQuantity = predictAdjustItem.getMonthsQuantity();
            for (String month : monthsQuantity.keySet()) {
                Map<String, Double> quantitys = monthsQuantity.get(month);
                DecimalFormat df = new DecimalFormat("#");
                itemMap.put(String.valueOf(month) + "_finality", quantitys.get("finality") == null ? null : df.format(quantitys.get("finality")));
                itemMap.put(String.valueOf(month) + "_customer", quantitys.get("customer") == null ? null : df.format(quantitys.get("customer")));
            }
            ProductionPlanItem productionPlanItem = (ProductionPlanItem)planItemMap.get(predictAdjustItem.getProductId());
            if (productionPlanItem == null) continue;
            itemMap.put("safeQuantity", productionPlanItem.getSafeQuantity());
            itemMap.put("nowQuantity", productionPlanItem.getNowQuantity());
            itemMap.put("packQuantity", productionPlanItem.getPackQuantity());
            itemMap.put("additionQuantity", productionPlanItem.getAdditionQuantity());
            itemMap.put("nextMonthQuantity", productionPlanItem.getNextMonthQuantity());
            itemMap.put("productionBatch", productionPlanItem.getProductionBatch());
            itemMap.put("nextNextMonthQuantity", productionPlanItem.getFinallyQuantity());
        }
        String[] titles = new String[titleNameMap.size()];
        String[] pop = new String[titleNameMap.size()];
        int i = 0;
        for (Map.Entry e : titleNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u751f\u4ea7\u8ba1\u5212-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u751f\u4ea7\u8ba1\u5212", ".xls", titles, listExcel, pop, response);
    }

    private void addMonthsQuantity(Map<String, Map<String, Double>> newMonthsQuantity, Map<String, Map<String, Double>> monthsQuantity) {
        for (String key : monthsQuantity.keySet()) {
            if (Beans.isEmpty(newMonthsQuantity.get(key))) {
                newMonthsQuantity.put(key, monthsQuantity.get(key));
                continue;
            }
            Map<String, Double> monthQuantity = newMonthsQuantity.get(key);
            Double finality = monthQuantity.get("finality");
            Double customer = monthQuantity.get("customer");
            newMonthsQuantity.remove(key);
            monthQuantity.remove("finality");
            monthQuantity.remove("customer");
            finality = finality + monthsQuantity.get(key).get("finality");
            customer = customer + monthsQuantity.get(key).get("customer");
            monthQuantity.put("finality", finality);
            monthQuantity.put("customer", customer);
            newMonthsQuantity.put(key, monthQuantity);
        }
    }

    public List<String> getMonths(PredictConfig predictConfig) {
        ArrayList<String> months = new ArrayList<String>();
        String predictYear = DateUtils.formartDate((Date)predictConfig.getPredictDate(), (String)"yyyy");
        String predictMonth = DateUtils.formartDate((Date)predictConfig.getPredictDate(), (String)"MM");
        Double rollMonth = predictConfig.getRollMonth();
        if (Beans.isEmpty((Object)predictMonth) || Beans.isEmpty((Object)rollMonth)) {
            return months;
        }
        int i = 1;
        while ((double)i <= rollMonth) {
            Integer month = Integer.parseInt(predictMonth) + i;
            if (month > 12) {
                month = month - 12;
                months.add(String.valueOf(Integer.valueOf(predictYear) + 1) + "0" + month.toString());
            } else {
                months.add(month > 9 ? String.valueOf(predictYear) + month.toString() : String.valueOf(predictYear) + "0" + month.toString());
            }
            ++i;
        }
        return months;
    }

    private int getMonthReal(int month) {
        return month > 12 ? month - 12 : month;
    }
}

