/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.productionPlan;

import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.PredictAdditionApply;
import com.tcbj.crm.entity.PredictAdjustPartner;
import com.tcbj.crm.entity.PredictAdjustTotal;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.PredictConfigProduct;
import com.tcbj.crm.entity.ProductionPlan;
import com.tcbj.crm.entity.ProductionPlanItem;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.predictConfig.PredictConfigService;
import com.tcbj.crm.productionPlan.ProductionPlanCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Excels;
import com.tcbj.util.StringUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productionPlanService")
public class ProductionPlanService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    PredictConfigService predictConfigService;

    public Page list(ProductionPlanCondition con) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        sb.append(" from ProductionPlan p where 1=1 ");
        if (Beans.isNotEmpty((Object)con.getOrgId())) {
            sb.append(" and p.orgId = ?  ");
            args.add(con.getOrgId());
        }
        if (Beans.isNotEmpty((Object)con.getStartDate())) {
            sb.append(" and p.createDate > ?  ");
            args.add(con.getStartDate());
        }
        if (Beans.isNotEmpty((Object)con.getEndDate())) {
            sb.append(" and p.createDate < ?  ");
            args.add(con.getEndDate());
        }
        if (Beans.isNotEmpty((Object)con.getPlanNo())) {
            sb.append(" and p.planNo like ? ");
            args.add("%" + con.getPlanNo() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            sb.append(" and p.state = ? ");
            args.add(con.getState());
        }
        sb.append(" order by p.lastUpdateDate desc");
        return this.baseDao.search(sb.toString(), args.toArray(), Constant.DEFAULT_ROWS, con.getPageno().intValue());
    }

    public PredictConfig getPredictConfigById(String id, String orgId) {
        String s = " from PredictConfig  where id = ? and orgId = ? ";
        return (PredictConfig)this.baseDao.findFirstEntity(s, new Object[]{id, orgId}, PredictConfig.class);
    }

    public List<ProductionPlanItem> getListByConfigId(PredictConfig pc, String orgId) {
        List<Object> list = new ArrayList();
        list = "A".equals(pc.getPredictType()) ? this.getApplyList(pc, orgId) : this.getAdditionList(pc, orgId);
        return list;
    }

    private List<ProductionPlanItem> getApplyList(PredictConfig pc, String orgId) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" from PredictConfigProduct p where p.configId = ? and p.orgId = ? order by p.orderNum ");
        args.add(pc.getId());
        args.add(orgId);
        List list = this.baseDao.findEntity(sb.toString(), args.toArray(), PredictConfigProduct.class);
        ArrayList<ProductionPlanItem> newList = new ArrayList<ProductionPlanItem>();
        for (PredictConfigProduct pcp : list) {
            ProductionPlanItem p = new ProductionPlanItem();
            p.setProductId(pcp.getProductId());
            p.setOrderNum(pcp.getOrderNum());
            HashMap<String, String> predictMonths = new HashMap<String, String>();
            Double quantitys = this.getQuantitys(p.getProductId(), pc, orgId, predictMonths);
            p.setQuantitys(quantitys);
            p.setPredictMonths(predictMonths);
            newList.add(p);
        }
        return newList;
    }

    public Double getQuantitys(String productId, PredictConfig pc, String orgId, Map<String, String> predictMonths) {
        Double quantity;
        block5: {
            Object[] args;
            StringBuffer hql;
            block4: {
                hql = new StringBuffer();
                args = new Object[]{pc.getId(), productId, "finality", orgId};
                quantity = 0.0;
                if (!"1".equals(pc.getAllowAdjust())) break block4;
                hql.append(" select p from PredictAdjustTotal p,PredictConfig pc  ");
                hql.append("  where p.configId = pc.id and p.configId = ? and p.productId = ? and p.adjustType = ? and p.orgId = ? ");
                List list = this.baseDao.findEntity(hql.toString(), args, PredictAdjustTotal.class);
                if (!Beans.isNotEmpty((Object)list) || list.size() <= 0) break block5;
                for (PredictAdjustTotal p : list) {
                    quantity = quantity + p.getQuantity();
                    predictMonths.put(p.getMonth(), String.valueOf(new BigDecimal(p.getQuantity())));
                }
                break block5;
            }
            hql.append("select p from PredictAdjustPartner p,PredictConfig pc ");
            hql.append("  where p.configId = pc.id and p.configId = ? and p.productId = ? and p.adjustType = ? and p.orgId = ? ");
            List list = this.baseDao.findEntity(hql.toString(), args, PredictAdjustPartner.class);
            if (Beans.isNotEmpty((Object)list) && list.size() > 0) {
                for (PredictAdjustPartner p : list) {
                    quantity = quantity + p.getQuantity();
                    if (Beans.isEmpty((Object)predictMonths.get(p.getMonth()))) {
                        predictMonths.put(p.getMonth(), String.valueOf(p.getQuantity()));
                        continue;
                    }
                    Double month = Double.valueOf(predictMonths.get(p.getMonth()));
                    predictMonths.put(p.getMonth(), String.valueOf(new BigDecimal(p.getQuantity() + month)));
                }
            }
        }
        return quantity;
    }

    public Map<String, String> getPredictMonths(String productId, PredictConfig pc, String orgId) {
        HashMap<String, String> predictMonths = new HashMap<String, String>();
        StringBuffer hql = new StringBuffer();
        Object[] args = new Object[]{pc.getId(), productId, "finality", orgId};
        if ("1".equals(pc.getAllowAdjust())) {
            hql.append(" select p from PredictAdjustTotal p,PredictConfig pc  ");
            hql.append("  where p.configId = pc.id and p.configId = ? and p.productId = ? and p.adjustType = ? and p.orgId = ? ");
            List list = this.baseDao.findEntity(hql.toString(), args, PredictAdjustTotal.class);
            for (PredictAdjustTotal p : list) {
                predictMonths.put(p.getMonth(), String.valueOf(p.getQuantity()));
            }
        } else {
            hql.append("select p from PredictAdjustPartner p,PredictConfig pc ");
            hql.append("  where p.configId = pc.id and p.configId = ? and p.productId = ? and p.adjustType = ? and p.orgId = ? ");
            List list = this.baseDao.findEntity(hql.toString(), args, PredictAdjustPartner.class);
            for (PredictAdjustPartner p : list) {
                if (Beans.isEmpty(predictMonths.get(p.getMonth()))) {
                    predictMonths.put(p.getMonth(), String.valueOf(p.getQuantity()));
                    continue;
                }
                Double quantity = Double.valueOf((String)predictMonths.get(p.getMonth()));
                predictMonths.put(p.getMonth(), String.valueOf(p.getQuantity() + quantity));
            }
        }
        return predictMonths;
    }

    public List<ProductionPlanItem> getAdditionList(PredictConfig pc, String orgId) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" select pa.product_Id,p.order_Num,sum(pa.ADJUST_QUANTITY)   from CX_PREDICT_ADDITION_APPLY_ITEM pa,CX_PREDICT_CONFIG_PRODUCT p,CX_PREDICT_ADDITION_APPLY paa   where pa.product_Id = p.product_Id and paa.id = pa.APPLY_ID ");
        if (Beans.isNotEmpty((Object)pc.getId())) {
            sb.append(" and pa.config_Id = ? ");
            args.add(pc.getId());
        }
        if (Beans.isNotEmpty((Object)pc.getId())) {
            sb.append(" and p.config_Id = ? ");
            args.add(pc.getId());
        }
        if (Beans.isNotEmpty((Object)orgId)) {
            sb.append(" and pa.org_Id = ? ");
            args.add(orgId);
        }
        sb.append(" and paa.state != ? ");
        args.add("5");
        sb.append(" group by pa.product_Id,p.order_Num order by p.order_Num ");
        List list = this.baseDao.findBySql(sb.toString(), args.toArray());
        ArrayList<ProductionPlanItem> newList = new ArrayList<ProductionPlanItem>();
        for (Object[] obj : list) {
            ProductionPlanItem p = new ProductionPlanItem();
            p.setProductId(StringUtils.objToStr(obj[0]));
            p.setOrderNum(StringUtils.objToStr(obj[1]) == "" ? null : Double.valueOf(StringUtils.objToStr(obj[1])));
            p.setQuantitys(obj[2] == null ? 0.0 : Double.valueOf(StringUtils.objToStr(obj[2])));
            newList.add(p);
        }
        return newList;
    }

    public Date getDateAfterMonth(Date date, int i) {
        if (date == null) {
            date = DateUtils.now();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(2, now.get(2) + i);
        return now.getTime();
    }

    public List<PredictConfig> list(PredictConfigCondition con) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select config from PredictConfig config where 1=1 ");
        ArrayList<Object> args = new ArrayList<Object>();
        if (Beans.isNotEmpty((Object)con.getStartDate())) {
            sb.append(" and config.predictDate >= ?");
            args.add(con.getStartDate());
        }
        if (Beans.isNotEmpty((Object)con.getEndDate())) {
            sb.append(" and config.predictDate <= ?");
            args.add(con.getEndDate());
        }
        if (Beans.isNotEmpty((Object)con.getConfigNo())) {
            sb.append(" and config.configNo like ?");
            args.add("%" + con.getConfigNo().trim() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getConfigName())) {
            sb.append(" and config.configName like ?");
            args.add("%" + con.getConfigName().trim() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getPredictType())) {
            sb.append(" and config.predictType = ?");
            args.add(con.getPredictType());
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            sb.append(" and config.state = ?");
            args.add(con.getState());
        }
        if (Beans.isNotEmpty((Object)con.getOrgId())) {
            sb.append(" and config.orgId = ?");
            args.add(con.getOrgId());
        }
        sb.append(" order by config.lastUpdateDate desc ");
        return this.baseDao.findEntity(sb.toString(), args.toArray(), PredictConfig.class);
    }

    public void saveOrUpdateProductionPlan(ProductionPlan plan, Employee em) {
        if (Beans.isEmpty((Object)plan.getId())) {
            plan.setPlanNo(this.orderNoService.maxNoPredictConfig("SCJH"));
            plan.setOrgId(em.getCurrentPartner().getOrganizationid());
            plan.setCreateDate(new Date());
            plan.setCreator(em.getId());
            plan.setLastUpdateDate(new Date());
            this.baseDao.save((Object)plan);
            for (ProductionPlanItem item : plan.getItems()) {
                item.setPlanId(plan.getId());
                item.setCreateDate(new Date());
                item.setOrgId(em.getCurrentPartner().getOrganizationid());
            }
            this.baseDao.save(plan.getItems());
        } else {
            ProductionPlan prodPlan = this.getProductionPlan(plan.getId(), em);
            prodPlan.setPlanName(plan.getPlanName());
            prodPlan.setState(plan.getState());
            prodPlan.setRemark(plan.getRemark());
            prodPlan.setLastUpdateDate(new Date());
            this.baseDao.saveOrUpdate((Object)prodPlan);
            for (ProductionPlanItem item : plan.getItems()) {
                item.setPlanId(plan.getId());
                item.setCreateDate(new Date());
                item.setOrgId(em.getCurrentPartner().getOrganizationid());
            }
            this.baseDao.deleteAll(prodPlan.getItems());
            this.baseDao.save(plan.getItems());
        }
    }

    public Map<String, Double> getDouble(String configId, String orgId, Map<String, Map<String, String>> predictMonths) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        List<ProductionPlanItem> items = this.getListByConfigId(this.getPredictConfigById(configId, orgId), orgId);
        for (ProductionPlanItem p : items) {
            map.put(p.getProductId(), p.getQuantitys());
            predictMonths.put(p.getProductId(), p.getPredictMonths());
        }
        return map;
    }

    public List<ProductionPlanItem> getProductionPlanItemsByIds(String data, Employee em) {
        List<String> ids = StringUtils.stringToList(data, ",");
        HashMap<String, ProductionPlanItem> map = new HashMap<String, ProductionPlanItem>();
        ArrayList<ProductionPlanItem> list = new ArrayList<ProductionPlanItem>();
        for (String id : ids) {
            ArrayList<ProductionPlanItem> items = new ArrayList();
            PredictConfig pc = this.predictConfigService.getPredictConfigById(id, em);
            items = this.getListByConfigId(pc, em.getCurrentPartner().getOrganizationid());
            this.setItemsToMap(map, items, pc);
        }
        for (String prodId : map.keySet()) {
            list.add((ProductionPlanItem)map.get(prodId));
        }
        return list;
    }

    public void setItemsToMap(Map<String, ProductionPlanItem> map, List<ProductionPlanItem> items, PredictConfig pc) {
        for (ProductionPlanItem item : items) {
            ProductionPlanItem p = map.get(item.getProductId());
            if (Beans.isEmpty((Object)p)) {
                map.put(item.getProductId(), item);
                continue;
            }
            p.setQuantitys(p.getQuantitys() + item.getQuantitys());
            if ("A".equals(pc.getPredictType())) {
                this.addMonthQuantity(p.getPredictMonths(), item.getPredictMonths());
            }
            map.remove(item.getProductId());
            map.put(item.getProductId(), p);
        }
    }

    public void addMonthQuantity(Map<String, String> target, Map<String, String> source) {
        for (String sour : source.keySet()) {
            String tar = target.get(sour);
            if (Beans.isEmpty((Object)tar)) {
                target.put(sour, source.get(sour));
                continue;
            }
            target.remove(sour);
            Double quantity = Double.valueOf(tar) + Double.valueOf(source.get(sour));
            DecimalFormat df = new DecimalFormat("#");
            target.put(sour, df.format(quantity));
        }
    }

    public ProductionPlan getProductionPlan(String id, Employee em) {
        ProductionPlan plan = (ProductionPlan)this.baseDao.get(ProductionPlan.class, (Serializable)((Object)id));
        String hql = " from ProductionPlanItem p where p.planId = '" + id + "' and p.orgId = '" + em.getCurrentPartner().getOrganizationid() + "'";
        List items = this.baseDao.findEntity(hql, ProductionPlanItem.class);
        List<ProductionPlanItem> prodItems = this.getProductionPlanItemsByIds(plan.getConfigId(), em);
        HashMap<String, ProductionPlanItem> map = new HashMap<String, ProductionPlanItem>();
        for (ProductionPlanItem p : prodItems) {
            map.put(p.getProductId(), p);
        }
        for (ProductionPlanItem item : items) {
            if (!Beans.isNotEmpty(map.get(item.getProductId()))) continue;
            item.setQuantitys(((ProductionPlanItem)map.get(item.getProductId())).getQuantitys());
            item.setPredictMonths(((ProductionPlanItem)map.get(item.getProductId())).getPredictMonths());
        }
        if (Beans.isNotEmpty((Object)items)) {
            plan.setItems(items);
        }
        return plan;
    }

    public void del(String id, Employee em) {
        Object[] args = new Object[]{id, em.getCurrentPartner().getOrganizationid()};
        this.baseDao.executeHQL("delete ProductionPlanItem where planId = ? and orgId = ? ", args);
        this.baseDao.executeHQL("delete ProductionPlan where id = ? and orgId = ? ", args);
    }

    public void approveProductionPlan(ProductionPlan plan, Employee em) {
        ProductionPlan prodPlan = this.getProductionPlan(plan.getId(), em);
        prodPlan.setState(plan.getState());
        prodPlan.setLastUpdateDate(new Date());
        this.baseDao.saveOrUpdate((Object)prodPlan);
        for (ProductionPlanItem item : plan.getItems()) {
            item.setPlanId(plan.getId());
            item.setCreateDate(new Date());
            item.setOrgId(em.getCurrentPartner().getOrganizationid());
        }
        this.baseDao.deleteAll(prodPlan.getItems());
        this.baseDao.save(plan.getItems());
        if (prodPlan.getState().equals("2")) {
            List<PredictConfig> configs = this.getPredictConfigByIds(prodPlan.getConfigId(), em.getCurrentPartner().getOrganizationid());
            for (PredictConfig pc : configs) {
                pc.setState(TCBJEnum.ConfigTpye.produce.getValue());
                this.baseDao.saveOrUpdate((Object)pc);
            }
        }
    }

    public List<String> readItemByExcel(String url, List<ProductionPlanItem> items, List<ProductionPlanItem> newitems) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        try {
            String[] headers = new String[]{"productNo", "productName", "safeQuantity", "nowQuantity", "packQuantity", "additionQuantity", "nextMonthQuantity", "productionBatch"};
            List datas = Excels.readExcel((String)url, (InputStream)new FileInputStream(url), (String[])headers);
            if (Beans.isEmpty((Object)datas)) {
                errorMsgs.add("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u5bfc\u5165\u7684\u8868\u4e2d\u6ca1\u6709\u6570\u636e\u3002\u8bf7\u91cd\u65b0\u5bfc\u5165\uff01");
                return errorMsgs;
            }
            HashMap<String, ProductionPlanItem> mapItems = new HashMap<String, ProductionPlanItem>();
            for (ProductionPlanItem item : items) {
                mapItems.put(item.getProductNo(), item);
            }
            int j = 1;
            for (Map data : datas) {
                String productionBatch;
                String nextMonthQuantity;
                String additionQuantity;
                String packQuantity;
                String nowQuantity;
                String safeQuantity;
                String errorMsg = null;
                ++j;
                ProductionPlanItem item = null;
                if (Beans.isEmpty(data.get("productNo"))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                    errorMsgs.add(errorMsg);
                    continue;
                }
                item = (ProductionPlanItem)mapItems.get(data.get("productNo"));
                if (Beans.isEmpty((Object)item)) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u4ea7\u54c1\u7f16\u7801\u9519\u8bef\uff01";
                    errorMsgs.add(errorMsg);
                    continue;
                }
                String string = safeQuantity = data.get("safeQuantity") == "" ? "0" : data.get("safeQuantity");
                if (Beans.isEmpty((Object)safeQuantity)) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u5b89\u5168\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                } else if (!this.validNumber(String.valueOf(safeQuantity))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u5b89\u5168\u5e93\u5b58\u9700\u4e3a\u5408\u6cd5\u6570\u5b57\uff01";
                } else {
                    item.setSafeQuantity(StringUtils.subToBigDecimal(Double.valueOf(String.valueOf(safeQuantity)), 0));
                }
                String string2 = nowQuantity = data.get("nowQuantity") == "" ? "0" : data.get("nowQuantity");
                if (Beans.isEmpty((Object)nowQuantity)) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u5f53\u524d\u5e93\u5b58\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                } else if (!this.validNumber(String.valueOf(nowQuantity))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u5f53\u524d\u5e93\u5b58\u91cf\u9700\u4e3a\u5408\u6cd5\u6570\u5b57\uff01";
                } else {
                    item.setNowQuantity(StringUtils.subToBigDecimal(Double.valueOf(String.valueOf(nowQuantity)), 0));
                }
                String string3 = packQuantity = data.get("packQuantity") == "" ? "0" : data.get("packQuantity");
                if (Beans.isEmpty((Object)packQuantity)) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u672a\u4ea4\u8ba1\u5212(\u5305\u88c5\u4e2d)\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                } else if (!this.validNumber(String.valueOf(packQuantity))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u672a\u4ea4\u8ba1\u5212(\u5305\u88c5\u4e2d)\u9700\u4e3a\u5408\u6cd5\u6570\u5b57\uff01";
                } else {
                    item.setPackQuantity(StringUtils.subToBigDecimal(Double.valueOf(String.valueOf(packQuantity)), 0));
                }
                String string4 = additionQuantity = data.get("additionQuantity") == "" ? "0" : data.get("additionQuantity");
                if (Beans.isEmpty((Object)additionQuantity)) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u5f53\u6708\u8ffd\u52a0\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                } else if (!this.validNumber(String.valueOf(additionQuantity))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u5f53\u6708\u8ffd\u52a0\u8ba1\u5212\u9700\u4e3a\u5408\u6cd5\u6570\u5b57\uff01";
                } else {
                    item.setAdditionQuantity(StringUtils.subToBigDecimal(Double.valueOf(String.valueOf(additionQuantity)), 0));
                }
                String string5 = nextMonthQuantity = data.get("nextMonthQuantity") == "" ? "0" : data.get("nextMonthQuantity");
                if (Beans.isEmpty((Object)nextMonthQuantity)) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u4e0b\u4e2a\u6708\u751f\u4ea7\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                } else if (!this.validNumber(String.valueOf(nextMonthQuantity))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u4e0b\u4e2a\u6708\u751f\u4ea7\u8ba1\u5212\u9700\u4e3a\u5408\u6cd5\u6570\u5b57\uff01";
                } else {
                    item.setNextMonthQuantity(StringUtils.subToBigDecimal(Double.valueOf(String.valueOf(nextMonthQuantity)), 0));
                }
                String string6 = productionBatch = data.get("productionBatch") == "" ? "0" : data.get("productionBatch");
                if (Beans.isEmpty((Object)productionBatch)) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u751f\u4ea7\u6279\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                } else if (!this.validNumber(String.valueOf(productionBatch))) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u751f\u4ea7\u6279\u91cf\u9700\u4e3a\u5408\u6cd5\u6570\u5b57\uff01";
                } else if (String.valueOf(productionBatch).equals("0")) {
                    errorMsg = String.valueOf(errorMsg == null ? "" : errorMsg) + "\u7b2c" + j + "\u884c\u751f\u4ea7\u6279\u91cf\u4e0d\u80fd\u4e3a0";
                } else {
                    item.setProductionBatch(StringUtils.subToBigDecimal(Double.valueOf(String.valueOf(productionBatch)), 0));
                }
                if (Beans.isNotEmpty((Object)errorMsg)) {
                    errorMsgs.add(errorMsg);
                    continue;
                }
                newitems.add(item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorMsgs;
    }

    public boolean validNumber(String num) {
        try {
            String regex = "^(-)?[0-9][0-9]*(.[0-9]*)?$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(num);
            if (m.find()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<PredictConfig> replace(List<PredictConfig> list, Employee em) {
        ArrayList<PredictConfig> newlist = new ArrayList<PredictConfig>();
        for (PredictConfig pc : list) {
            List<ProductionPlan> plans;
            if ("A".equals(pc.getPredictType()) && (plans = this.getPlansByConfigId(pc.getId(), em.getCurrentPartner().getOrganizationid())).size() <= 0) {
                newlist.add(pc);
            }
            if (!"B".equals(pc.getPredictType())) continue;
            StringBuffer sb = new StringBuffer();
            ArrayList<String> args = new ArrayList<String>();
            sb.append(" from PredictAdditionApply p where p.state in (?,?) and p.configId = ? and p.orgId = ? ");
            args.add(Constant.PredictAdditionApplyState.waitApprove.value);
            args.add(Constant.PredictAdditionApplyState.approveNoPass.value);
            args.add(pc.getId());
            args.add(em.getCurrentPartner().getOrganizationid());
            List applys = this.baseDao.findEntity(sb.toString(), args.toArray(), PredictAdditionApply.class);
            String applyNos = "";
            if (applys.size() > 0) {
                for (PredictAdditionApply pa : applys) {
                    applyNos = String.valueOf(applyNos) + pa.getApplyNo() + "\uff1b";
                }
            }
            pc.setApplyNos(applyNos);
            StringBuilder hql = new StringBuilder();
            ArrayList<String> arg = new ArrayList<String>();
            hql.append(" from PredictAdditionApply p where p.state = ? and p.configId = ? and p.orgId = ? ");
            arg.add(Constant.PredictAdditionApplyState.approvePass.value);
            arg.add(pc.getId());
            arg.add(em.getCurrentPartner().getOrganizationid());
            List oaPassApplys = this.baseDao.findEntity(hql.toString(), arg.toArray(), PredictAdditionApply.class);
            List<ProductionPlan> plans2 = this.getPlansByConfigId(pc.getId(), em.getCurrentPartner().getOrganizationid());
            if (oaPassApplys.size() <= 0 || plans2.size() > 0) continue;
            newlist.add(pc);
        }
        return newlist;
    }

    public List<ProductionPlan> getPlansByConfigId(String configId, String orgId) {
        String s = " from ProductionPlan p where instr(p.configId, ?) > 0 and p.orgId = ? ";
        List plans = this.baseDao.findEntity(s, new Object[]{configId, orgId}, ProductionPlan.class);
        return plans;
    }

    public List<ProductionPlanItem> getProductionPlanItemByConfigId(String configId) {
        return this.baseDao.findEntity("select ppi from ProductionPlanItem ppi, ProductionPlan pp where pp.id = ppi.planId and pp.configId = ? ", new Object[]{configId}, ProductionPlanItem.class);
    }

    public List<ProductionPlanItem> getProductionPlanItemById(String planId) {
        return this.baseDao.findEntity("select ppi from ProductionPlanItem ppi where ppi.planId = ? ", new Object[]{planId}, ProductionPlanItem.class);
    }

    public List<PredictConfig> getPredictConfigs(PredictConfigCondition con) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select config from PredictConfig config where 1=1 ");
        ArrayList<String> args = new ArrayList<String>();
        if (Beans.isNotEmpty((Object)con.getPredictType())) {
            sb.append(" and config.predictType = ?");
            args.add(con.getPredictType());
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            sb.append(" and config.state = ?");
            args.add(con.getState());
        }
        if (Beans.isNotEmpty((Object)con.getOrgId())) {
            sb.append(" and config.orgId = ?");
            args.add(con.getOrgId());
        }
        sb.append(" order by config.lastUpdateDate desc ");
        List list = this.baseDao.findEntity(sb.toString(), args.toArray(), PredictConfig.class);
        return list;
    }

    public List<PredictConfig> getPredictConfigByIds(String configId, String orgId) {
        ArrayList<PredictConfig> list = new ArrayList<PredictConfig>();
        List<String> ids = StringUtils.stringToList(configId, ",");
        for (String id : ids) {
            list.add(this.getPredictConfigById(id, orgId));
        }
        return list;
    }
}

