/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.questionnaire;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.AuditService;
import com.tcbj.crm.entity.AuditInfo;
import com.tcbj.crm.entity.Questionnaire;
import com.tcbj.crm.entity.QuestionnaireDetail;
import com.tcbj.crm.entity.QuestionnairePublish;
import com.tcbj.crm.entity.QuestionnaireResult;
import com.tcbj.crm.entity.QuestionnaireResultDetail;
import com.tcbj.crm.entity.QuestionnaireUser;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.notice.NoticeService;
import com.tcbj.crm.questionnaire.QuestionnaireCondition;
import com.tcbj.crm.questionnaire.QuestionnaireService;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/questionnaire"})
public class QuestionnaireController
extends BaseController {
    @Autowired
    QuestionnaireService service;
    @Autowired
    AuditService auditService;
    @Autowired
    NoticeService noticeService;

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        this.loadQuestionnaire(id, model);
        EmployeePartner partner = this.getCurrentEmployee().getCurrentPartner();
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("startDate", (Object)DateUtils.formartDate((Date)new Date(), (String)"YYYY-MM-dd"));
        return "questionnaire/apply.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    public Result apply_do(@Valid @RequestBody Questionnaire questionnaire, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        me.getCurrentPartner().getId();
        boolean flag = this.service.validateQuestionnaireName(questionnaire.getPsqName(), questionnaire.getId(), me);
        if (!flag) {
            throw new AppException("4001", questionnaire.getPsqName());
        }
        questionnaire.setBelongsOrgId(me.getCurrentPartner().getId());
        questionnaire.fillInitData(me);
        if (questionnaire.isSave()) {
            questionnaire.setState(ShopEnum.ApproveState.draft.getValue());
        } else if (questionnaire.isToApprove()) {
            questionnaire.setState(ShopEnum.ApproveState.audit.getValue());
        }
        for (QuestionnaireDetail item : questionnaire.getQuestionnaireDetails()) {
            item.fillInitData(me);
        }
        this.service.saveOrUpdate(questionnaire);
        if (questionnaire.isToAudit() || questionnaire.isToApprove()) {
            AuditInfo auditInfo = new AuditInfo(questionnaire.getId(), "Questionnaire", questionnaire.getState(), null, me.getId(), DateUtils.now());
            this.auditService.add(auditInfo);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/applys.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") QuestionnaireCondition condition, String dis, Model model) {
        this.addType2Model(model);
        this.getCurrentEmployee();
        this.findQuestionnaires(condition, model, pageno);
        model.addAttribute("condition", (Object)condition);
        return "questionnaire/applys.ftl";
    }

    private void addType2Model(Model model) {
        List<DictionaryItem> psqTypeList = Cache.getItems("TCBJ_SURVEY_TYPE");
        model.addAttribute("psqTypeList", psqTypeList);
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.GET})
    public String approve(String psqId, Model model) {
        this.loadQuestionnaire(psqId, model);
        model.addAttribute("psqId", (Object)psqId);
        return "questionnaire/approve.ftl";
    }

    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=false) String id, Model model, String status) {
        this.service.del(id, status);
        return "redirect:applys.do";
    }

    private void findQuestionnaires(QuestionnaireCondition condition, Model model, int pageno) {
        Employee me = this.getCurrentEmployee();
        Page page = this.service.findQuestionnaires(condition, me, pageno);
        model.addAttribute("page", (Object)page);
    }

    private void addPublishSys2Model(Model model) {
        List<DictionaryItem> dicList = Cache.getItems("TCBJ_NOTICE_SYS");
        HashMap<String, String> m = new HashMap<String, String>();
        for (DictionaryItem dictionaryItem : dicList) {
            m.put(dictionaryItem.getName(), dictionaryItem.getVal());
        }
        model.addAttribute("sysFlag", m);
    }

    private Questionnaire loadQuestionnaire(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Questionnaire questionnaire = null;
        if (StringUtils.isEmpty(id)) {
            questionnaire = new Questionnaire();
            questionnaire.fillInitData(me);
        } else {
            questionnaire = this.service.get(id);
        }
        model.addAttribute("me", (Object)me);
        model.addAttribute("questionnaire", (Object)questionnaire);
        model.addAttribute("questionnaireDetailItems", (Object)JSON.toJSONString(questionnaire.getQuestionnaireDetails()));
        return questionnaire;
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        this.loadQuestionnaire(id, model);
        model.addAttribute("auditInfos", this.auditService.find(id));
        return "questionnaire/view.ftl";
    }

    @RequestMapping(value={"/publishSys.do"}, method={RequestMethod.GET})
    public String push(String psqId, Model model) {
        List<DictionaryItem> dicList = Cache.getItems("TCBJ_NOTICE_SYS");
        model.addAttribute("questionnaire", (Object)this.service.findQuestionnaireById(psqId));
        Map<String, QuestionnairePublish> map = this.service.findPublishSysById(psqId);
        model.addAttribute("questionnairePublish", map);
        model.addAttribute("sysFlag", dicList);
        return "questionnaire/publishSys.ftl";
    }

    @RequestMapping(value={"/addPushSys.do"}, method={RequestMethod.POST})
    public String push(QuestionnairePublish publishSys, String[] systemFlag, Model model) {
        try {
            Employee e = this.getCurrentEmployee();
            this.service.savePublishSys(e, publishSys, systemFlag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.redirect("/questionnaire/applys.do");
    }

    @RequestMapping(value={"/selectUser.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String selectUser(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") QuestionnaireCondition condition, String psqId, Model model, HttpServletRequest request) {
        Questionnaire psq = this.service.findQuestionnaireById(condition.getPsqId());
        Employee me = this.getCurrentEmployee();
        if (request.getMethod().toUpperCase().endsWith("GET")) {
            model.addAttribute("select", (Object)"select");
            model.addAttribute("condition", (Object)condition);
            model.addAttribute("questionnaire", (Object)psq);
            return "/questionnaire/selectUsers.ftl";
        }
        try {
            List<Contact> contactList = null;
            if ("inner".equals(condition.getFlag())) {
                contactList = this.noticeService.getInnerPerson(me, condition);
                model.addAttribute("flag", (Object)"inner");
            } else {
                contactList = this.noticeService.getOuterPerson(me, condition);
                model.addAttribute("flag", (Object)"outer");
            }
            List<QuestionnaireUser> listY = this.service.getSelectedList(psqId);
            HashMap<String, String> map = new HashMap<String, String>();
            for (QuestionnaireUser u : listY) {
                map.put(u.getUserId(), u.getUserId());
            }
            Iterator<Contact> iterator = contactList.iterator();
            while (iterator.hasNext()) {
                Contact emp = iterator.next();
                if (map.get(emp.getId()) == null) continue;
                iterator.remove();
            }
            model.addAttribute("questionnaire", (Object)psq);
            model.addAttribute("condition", (Object)condition);
            model.addAttribute("list", contactList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("inner".equals(condition.getFlag())) {
            model.addAttribute("condition", (Object)condition);
            return "/questionnaire/selectUsers.ftl";
        }
        model.addAttribute("condition", (Object)condition);
        return "questionnaire/selectOuter.ftl";
    }

    @RequestMapping(value={"/toSelectOuter.do"}, method={RequestMethod.GET})
    public String toSelectOuter(QuestionnaireCondition condition, Model model) {
        Questionnaire psq = this.service.findQuestionnaireById(condition.getPsqId());
        model.addAttribute("select", (Object)"select");
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("questionnaire", (Object)psq);
        return "questionnaire/selectOuter.ftl";
    }

    @RequestMapping(value={"/saveSelected.do"}, method={RequestMethod.POST})
    public String saveSelected(String[] userIds, String psqIdz) {
        try {
            Employee e = this.getCurrentEmployee();
            if (userIds != null) {
                this.service.saveSelectedUser(psqIdz, userIds, e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.redirect("/questionnaire/applys.do");
    }

    @RequestMapping(value={"/selectedUser.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String viewSelectedUser(QuestionnaireCondition condition, String psqId, Model model) {
        try {
            this.getCurrentEmployee();
            Questionnaire psq = this.service.findQuestionnaireById(psqId);
            List<Contact> list = this.service.getSelectedUser(psqId, condition);
            model.addAttribute("list", list);
            model.addAttribute("questionnaire", (Object)psq);
            model.addAttribute("condition", (Object)condition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "questionnaire/selectedUsers.ftl";
    }

    @RequestMapping(value={"/deleteuser.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String deleteUser(String psqId, String userIds, Model model) {
        Questionnaire psq = this.service.findQuestionnaireById(psqId);
        this.service.deletePsqUser(psqId, userIds);
        model.addAttribute("questionnaire", (Object)psq);
        return this.redirect("/questionnaire/selectedUser.do?psqId=" + psqId);
    }

    @RequestMapping(value={"/auditPSQ.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String auditPSQ(String psqId, String type, Model model) {
        Employee me = this.getCurrentEmployee();
        this.service.modifyPSQ(me, psqId, type);
        return this.redirect("/questionnaire/applys.do?dis=1&status=1");
    }

    @RequestMapping(value={"/myPsqs.do"}, method={RequestMethod.GET})
    public String myPsqs(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") QuestionnaireCondition condition, Model model) {
        Employee e = this.getCurrentEmployee();
        Page page = this.service.findMyQuestionnaires(condition, e, pageno);
        model.addAttribute("page", (Object)page);
        return "questionnaire/myQuestionnaires.ftl";
    }

    @RequestMapping(value={"/editPsq.do"}, method={RequestMethod.GET})
    public String editPsq(String psqId, Model model) {
        this.getCurrentEmployee();
        List<QuestionnaireDetail> detailList = this.service.getQuestionnaireDetail(psqId);
        model.addAttribute("psq", (Object)this.service.getSimpleQuestionnaire(psqId));
        model.addAttribute("detailList", detailList);
        return "questionnaire/fillPsq.ftl";
    }

    @RequestMapping(value={"/fillPsq.do"}, method={RequestMethod.POST})
    public String fillPsq(QuestionnaireResult resultDetail, String psqId, Model model) {
        Employee me = this.getCurrentEmployee();
        this.service.saveQuestionnaireResult(resultDetail, me, psqId);
        return this.redirect("/questionnaire/myPsqs.do");
    }

    @RequestMapping(value={"/viewMyPsq.do"}, method={RequestMethod.GET})
    public String viewPsq(String resutlId, Model model) {
        this.getCurrentEmployee();
        QuestionnaireResultDetail detail = this.service.getResultDetail(resutlId);
        model.addAttribute("detail", (Object)detail);
        return "questionnaire/psqView.ftl";
    }

    @RequestMapping(value={"/count.do"}, method={RequestMethod.GET})
    public String count(String resutlId, Model model) {
        this.loadEmp(model);
        return "questionnaire/count.ftl";
    }

    private void loadEmp(Model model) {
        Employee me = this.getCurrentEmployee();
        model.addAttribute("me", (Object)me);
    }

    @RequestMapping(value={"/count.do"}, method={RequestMethod.POST})
    public String countbyConent(String type, QuestionnaireCondition conditon, Model model) {
        List countResult = this.service.getCountByConent(conditon, "content");
        this.loadEmp(model);
        this.loadQuestionnaire(conditon, model);
        model.addAttribute("countResult", (Object)countResult);
        return "questionnaire/count.ftl";
    }

    private void loadQuestionnaire(QuestionnaireCondition condition, Model model) {
        Questionnaire questionnaire = this.service.findQuestionnaireById(condition.getPsqId());
        model.addAttribute("condition", (Object)condition);
        System.err.println(condition.getBelongsName());
        model.addAttribute("questionnaire", (Object)questionnaire);
    }

    @RequestMapping(value={"/countPersonType.do"}, method={RequestMethod.POST})
    public String countPersonType(String type, QuestionnaireCondition conditon, Model model) {
        List countResult = this.service.getCountByRoleType(conditon);
        this.loadQuestionnaire(conditon, model);
        this.loadEmp(model);
        model.addAttribute("countResult", (Object)countResult);
        return "questionnaire/count.ftl";
    }
}

