/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.questionnaire;

import com.tcbj.crm.entity.Questionnaire;
import com.tcbj.crm.entity.QuestionnaireDetail;
import com.tcbj.crm.entity.QuestionnairePublish;
import com.tcbj.crm.entity.QuestionnaireResult;
import com.tcbj.crm.entity.QuestionnaireResultDetail;
import com.tcbj.crm.entity.QuestionnaireUser;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.questionnaire.QuestionnaireCondition;
import com.tcbj.crm.questionnaire.vo.CountVo;
import com.tcbj.crm.questionnaire.vo.QuestionnaireVo;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="questionnaireService")
public class QuestionnaireService {
    @Autowired
    BaseDao baseDao;

    public void del(String id, String status) {
        if ("2".equals(status)) {
            String hql = " update Questionnaire set state ='9' where id=? ";
            this.baseDao.executeHQL(hql, new Object[]{id});
        } else {
            Object[] args = new Object[]{id};
            String hql = "delete QuestionnaireDetail where questionnaireId=?";
            this.baseDao.executeHQL(hql, args);
            hql = "delete Questionnaire where id=?";
            this.baseDao.executeHQL(hql, args);
        }
    }

    public Page findQuestionnaires(QuestionnaireCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Questionnaire q where state <> '9'   ");
        hql.append(" and q.belongsOrgId=? ");
        args.add(me.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getPsqName())) {
            hql.append(" and q.psqName like ? ");
            args.add("%" + condition.getPsqName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPsqType())) {
            hql.append(" and q.psqTypeCode= ? ");
            args.add(condition.getPsqType());
        }
        if (StringUtils.isNotEmpty(condition.getStatus())) {
            hql.append(" and q.state = ? ");
            args.add(condition.getStatus());
        }
        if (StringUtils.isNotEmpty(condition.getCreatorId())) {
            hql.append(" and q.creatorId =? ");
            args.add(condition.getCreatorId());
        }
        if (condition.getStartDate() != null) {
            hql.append(" and q.createDt >= to_date(?,'yyyy-MM-dd')");
            args.add(DateUtils.formartDate((Date)condition.getStartDate(), (String)"yyyy-MM-dd"));
        }
        if (condition.getEndDate() != null) {
            hql.append(" and q.createDt <= to_date(?,'yyyy-MM-dd')");
            args.add(DateUtils.formartDate((Date)DateUtils.getDateAfter((Date)condition.getEndDate(), (int)1), (String)"yyyy-MM-dd\t"));
        }
        hql.append(" and ( sysdate <= endDate  or endDate is null)");
        hql.append(" order by createDt desc,lastUpdateDt desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public List<QuestionnaireDetail> getQuestionnaireDetails(String id) {
        String hql = "from QuestionnaireDetail where questionnaireId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, QuestionnaireDetail.class);
    }

    public Questionnaire get(String id) {
        Questionnaire obj = (Questionnaire)this.baseDao.get(Questionnaire.class, (Serializable)((Object)id));
        obj.setQuestionnaireDetails(this.getQuestionnaireDetails(id));
        return obj;
    }

    public Questionnaire getSimpleQuestionnaire(String id) {
        return (Questionnaire)this.baseDao.get(Questionnaire.class, (Serializable)((Object)id));
    }

    public void saveOrUpdate(Questionnaire questionnaire) {
        List<QuestionnaireDetail> details = questionnaire.getQuestionnaireDetails();
        for (QuestionnaireDetail detail : details) {
            if (!StringUtils.isEmpty(detail.getPsqContent()) && !StringUtils.isEmpty(detail.getSortId())) continue;
            throw new AppException("4003");
        }
        if (StringUtils.isEmpty(questionnaire.getId())) {
            this.baseDao.save((Object)questionnaire);
            for (QuestionnaireDetail questionnaireDetail : questionnaire.getQuestionnaireDetails()) {
                questionnaireDetail.setQuestionnaireId(questionnaire.getId());
            }
            this.baseDao.save(questionnaire.getQuestionnaireDetails());
        } else {
            this.baseDao.update((Object)questionnaire);
            String hql = "delete from  QuestionnaireDetail qd where qd.questionnaireId=?";
            this.baseDao.executeHQL(hql, new Object[]{questionnaire.getId()});
            List<QuestionnaireDetail> newItemsQuestionnaireDetail = questionnaire.getQuestionnaireDetails();
            for (QuestionnaireDetail detail : newItemsQuestionnaireDetail) {
                detail.setQuestionnaireId(questionnaire.getId());
                this.baseDao.save((Object)detail);
            }
        }
    }

    public void updateState(String id, String state) {
        String hql = "update Questionnaire set state=? where id=?";
        Object[] args = new Object[]{state, id};
        this.baseDao.executeHQL(hql, args);
    }

    public Questionnaire findQuestionnaireById(String id) {
        if (StringUtils.isNotEmpty(id)) {
            return (Questionnaire)this.baseDao.get(Questionnaire.class, (Serializable)((Object)id));
        }
        throw new AppException("4004");
    }

    public Map<String, QuestionnairePublish> findPublishSysById(String id) {
        String hql = " from QuestionnairePublish where psqId=?";
        HashMap<String, QuestionnairePublish> result = new HashMap<String, QuestionnairePublish>();
        List list = this.baseDao.findEntity(hql, new Object[]{id}, QuestionnairePublish.class);
        for (QuestionnairePublish psqSys : list) {
            result.put(psqSys.getSysflagCode(), psqSys);
        }
        return result;
    }

    public void savePublishSys(Employee e, QuestionnairePublish publishSys, String[] systemFlag) {
        String hql = " delete from QuestionnairePublish where psqId=?";
        this.baseDao.executeHQL(hql, new Object[]{publishSys.getPsqId()});
        if (systemFlag != null) {
            String[] stringArray = systemFlag;
            int n = systemFlag.length;
            int n2 = 0;
            while (n2 < n) {
                String sysCode = stringArray[n2];
                QuestionnairePublish psdPublish = new QuestionnairePublish();
                psdPublish.fillInitData(e);
                psdPublish.setPsqId(publishSys.getPsqId());
                psdPublish.setSysflagCode(sysCode);
                psdPublish.setStartDate(publishSys.getStartDate());
                psdPublish.setEndDate(publishSys.getEndDate());
                this.baseDao.save((Object)psdPublish);
                ++n2;
            }
        }
    }

    public List<Employee> getOrgUser(String id, QuestionnaireCondition condition) {
        String hql = "from Employee p,Partner e,EmployeePartner t where p.id = t.personId and e.id = t.id ";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(condition.getContactName())) {
            hql = String.valueOf(hql) + " and p.name like ? ";
            args.add("%" + condition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getDealerId())) {
            hql = String.valueOf(hql) + " and e.id = ? ";
            args.add(condition.getDealerId());
        }
        if (StringUtils.isNotEmpty(condition.getPersontype())) {
            hql = String.valueOf(hql) + " and p.type = ? ";
            args.add(condition.getPersontype());
        }
        if (StringUtils.isNotEmpty(condition.getSaleChannelTypeCode())) {
            hql = String.valueOf(hql) + " and e.saleChannelTypeCode = ? ";
            args.add(condition.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql = String.valueOf(hql) + " and e.bigAreaCode = ? ";
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql = String.valueOf(hql) + " and e.areaCode = ? ";
            args.add(condition.getAreaCode());
        }
        List list = this.baseDao.findEntity(hql, args.toArray(), Object[].class);
        ArrayList<Employee> result = new ArrayList<Employee>();
        for (Object[] objs : list) {
            Employee e = (Employee)objs[0];
            e.setCurrentPartner((EmployeePartner)objs[2]);
            result.add(e);
        }
        return result;
    }

    public List<Contact> getSelectedUser(String psqId, QuestionnaireCondition condition) {
        Contact contact;
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("  from Contact c ,QuestionnaireUser n  ,EmployeePartner e  ");
        hql.append(" where n.userId = c.id and c.id = e.personId");
        hql.append(" and n.psqId = ? ");
        args.add(psqId);
        if (StringUtils.isNotEmpty(condition.getContactName())) {
            hql.append(" and  c.fullname like ?");
            args.add("%" + condition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPhone())) {
            hql.append(" and  c.phonenumber like ?");
            args.add("%" + condition.getPhone() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPersontype())) {
            hql.append(" and c.persontype = ? ");
            args.add(condition.getPersontype());
        }
        if (StringUtils.isNotEmpty(condition.getRoletype())) {
            hql.append(" and c.roletype = ? ");
            args.add(condition.getRoletype());
        }
        if (StringUtils.isNotEmpty(condition.getDealerId())) {
            hql.append(" and e.id =? ");
            args.add(condition.getDealerId());
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        for (Object[] obj : list) {
            contact = (Contact)obj[0];
            contact.setEmployeePartner((EmployeePartner)obj[2]);
            contactList.add(contact);
        }
        Iterator it = contactList.iterator();
        LinkedHashMap<String, Contact> map = new LinkedHashMap<String, Contact>();
        while (it.hasNext()) {
            contact = (Contact)it.next();
            map.put(contact.getId(), contact);
        }
        ArrayList<Contact> contactList2 = new ArrayList<Contact>();
        contactList2.addAll(map.values());
        return contactList2;
    }

    public void saveSelectedUser(String psqIdz, String[] userIds, Employee e) {
        String[] stringArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            QuestionnaireUser qu = new QuestionnaireUser();
            qu.fillInitData(e);
            qu.setPsqId(psqIdz);
            qu.setUserId(uid);
            this.baseDao.save((Object)qu);
            ++n2;
        }
    }

    public void deletePsqUser(String psqId, String userIds) {
        String hql = " DELETE FROM QuestionnaireUser where psqId=? and userId=?";
        ArrayList<String> args = new ArrayList<String>();
        args.add(psqId);
        args.add(userIds);
        this.baseDao.executeHQL(hql, args.toArray());
    }

    public void modifyPSQ(Employee me, String psqId, String type) {
        String hql = " update  Questionnaire set state =? where id=?";
        ArrayList<String> args = new ArrayList<String>();
        if ("Y".equals(type)) {
            args.add(ShopEnum.ApproveState.pass.getValue());
        } else {
            args.add(ShopEnum.ApproveState.notpass.getValue());
        }
        args.add(psqId);
        this.baseDao.executeHQL(hql, args.toArray());
    }

    public Page findMyQuestionnaires(QuestionnaireCondition condition, Employee e, int pageno) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sql.append("select distinct(t.row_id),t.psq_name,t.creator_id,t.psq_type_code,t.create_dt,t.start_date,t.end_date  from ( ");
        sql.append(" select pm.row_id ,pm.psq_name,pm.creator_id,pm.psq_type_code,pm.create_dt,pm.start_date,pm.end_date ");
        sql.append(" from cx_psq_main pm ,cx_psq_publish pp  ");
        sql.append(" where  pm.row_id = pp.psq_id and pm.state='2' AND pp.sysflag_code= 'CRM' ");
        sql.append(" and ( pm.belongs_org_id = ? or pm.belongs_org_id = ? )");
        args.add(e.getCurrentPartner().getId());
        args.add(e.getCurrentPartner().getParPartnerId());
        sql.append(" and (pm.end_date >= (sysdate + 1) or pm.end_date is null) ");
        sql.append(" union all ");
        sql.append("  select pm.row_id ,pm.psq_name,pm.creator_id,pm.psq_type_code,pm.create_dt,pm.start_date,pm.end_date  ");
        sql.append(" from cx_psq_main pm ,cx_psq_user pu");
        sql.append(" where pm.row_id = pu.psq_id and pm.state='2'  ");
        sql.append(" and (pm.end_date >= (sysdate + 1) or pm.end_date is null ) ");
        sql.append(" and pu.user_id=?  ) t");
        args.add(e.getId());
        sql.append(" where 1= 1 ");
        if (StringUtils.isNotEmpty(condition.getPsqName())) {
            sql.append(" and  t.psq_name like ? ");
            args.add("%" + condition.getPsqName() + "%");
        }
        sql.append(" order by t.create_dt desc ");
        Page page = this.baseDao.searchBySql(sql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, QuestionnaireVo.class);
        String hql = " select pr from  Questionnaire pm,QuestionnaireResult pr where pm.id=pr.psqId and pr.userId=? ";
        List detailList = this.baseDao.findEntity(hql, new Object[]{e.getId()}, QuestionnaireResult.class);
        HashMap<String, QuestionnaireResult> detailMap = new HashMap<String, QuestionnaireResult>();
        for (QuestionnaireResult detail : detailList) {
            if (!StringUtils.isNotEmpty(detail.getPsqId()) || !StringUtils.isNotEmpty(detail.getUserId())) continue;
            detailMap.put(String.valueOf(detail.getUserId()) + "_" + detail.getPsqId(), detail);
        }
        ArrayList<QuestionnaireVo> voList = new ArrayList<QuestionnaireVo>();
        for (Object obj : page.getList()) {
            QuestionnaireVo vo = new QuestionnaireVo();
            Object[] tempObj = new Object[10];
            tempObj = (Object[])obj;
            vo.setPsqId((String)tempObj[0]);
            vo.setPsqName((String)tempObj[1]);
            vo.setCreatorId((String)tempObj[2]);
            vo.setPsqTypeCode((String)tempObj[3]);
            vo.setCreateDt((Date)tempObj[4]);
            vo.setStatDate((Date)tempObj[5]);
            vo.setEndDate((Date)tempObj[6]);
            String tempKey = String.valueOf(e.getId()) + "_" + vo.getPsqId();
            QuestionnaireResult questionnaireResult = (QuestionnaireResult)detailMap.get(tempKey);
            if (questionnaireResult != null) {
                vo.setResultId(questionnaireResult.getId());
                vo.setFillUserId(e.getId());
                vo.setFilledDate(questionnaireResult.getFillinDate());
            }
            voList.add(vo);
        }
        page.setList(voList);
        return page;
    }

    public QuestionnaireResultDetail getResultDetail(String resutlId) {
        return (QuestionnaireResultDetail)this.baseDao.get(QuestionnaireResultDetail.class, (Serializable)((Object)resutlId));
    }

    public List<QuestionnaireDetail> getQuestionnaireDetail(String psqId) {
        String hql = " from QuestionnaireDetail where questionnaireId=? order by sortId asc";
        return this.baseDao.findEntity(hql, new Object[]{psqId}, QuestionnaireDetail.class);
    }

    public void saveQuestionnaireResult(QuestionnaireResult resultDetail, Employee me, String psqId) {
        QuestionnaireResult qr = new QuestionnaireResult();
        qr.fillInitData(me);
        qr.setFillinDate(DateUtils.now());
        qr.setPsqId(psqId);
        qr.setUserId(me.getId());
        this.baseDao.save((Object)qr);
        QuestionnaireResultDetail qrDetail = null;
        for (QuestionnaireResultDetail detail : resultDetail.getQuestionnaireResultDetails()) {
            qrDetail = new QuestionnaireResultDetail();
            qrDetail.fillInitData(me);
            qrDetail.setResultId(qr.getId());
            qrDetail.setPsqResultId(detail.getPsqResultId());
            String key = this.getKey(detail.getResult());
            if ("A".equals(key)) {
                qrDetail.setAnswerA(key);
            } else if ("B".equals(key)) {
                qrDetail.setAnswerB(key);
            } else if ("C".equals(key)) {
                qrDetail.setAnswerC(key);
            } else if ("D".equals(key)) {
                qrDetail.setAnswerD(key);
            } else if (StringUtils.isEmpty(key)) {
                qrDetail.setAnswerE("E");
            } else {
                qrDetail.setAnswerE(key);
            }
            this.baseDao.save((Object)qrDetail);
        }
    }

    public List getCountByConent(QuestionnaireCondition conditon, String type) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sql.append("select t.*,pd.result_a,pd.result_b,pd.result_c,pd.result_d,pd.result_e FROM (");
        sql.append(" SELECT M.ROW_ID, D.sort_id , M.PSQ_NAME,");
        sql.append("  SUM(DECODE(L.ANSWER_A, NULL, 0,1)) ANSWER_A, SUM(DECODE(L.ANSWER_B, NULL, 0,1)) ANSWER_B, ");
        sql.append("  SUM(DECODE(L.ANSWER_C, NULL, 0,1)) ANSWER_C,SUM(DECODE(L.ANSWER_D, NULL, 0,1)) ANSWER_D, ");
        sql.append("  SUM(DECODE(L.ANSWER_E, NULL, 0,1)) ANSWER_E ,");
        sql.append(" D.PSQ_CONTENT");
        sql.append("  FROM CX_PSQ_RESUTL H, CX_PSQ_MAIN M, CX_PQ_RUSDETAIL L, CX_PSQ_DETAIL D ");
        sql.append("  WHERE H.PSQ_ID = M.ROW_ID AND H.ROW_ID = L.RESULT_ID AND L.PSQ_RESULT_ID = D.ROW_ID  AND M.row_id = ? ");
        sql.append(" and M.BELONGS_ORG_ID =? ");
        sql.append("  GROUP BY M.ROW_ID, D.sort_id , M.PSQ_NAME ,D.PSQ_CONTENT");
        args.add(conditon.getPsqId());
        args.add(conditon.getBelongsId());
        sql.append(" )t,cx_psq_detail pd  ");
        sql.append(" WHERE t.row_id = pd.psq_id  and t.sort_id = pd.sort_id and pd.psq_id=? ");
        sql.append(" order by pd.sort_id asc ");
        args.add(conditon.getPsqId());
        List countList = this.baseDao.findBySql(sql.toString(), args.toArray());
        ArrayList<CountVo> voList = new ArrayList<CountVo>();
        CountVo vo = null;
        for (Object[] obj : countList) {
            vo = new CountVo();
            Object[] cfr_ignored_0 = new Object[15];
            vo.setPsqId((String)obj[0]);
            vo.setSortId((String)obj[1]);
            vo.setPsqName((String)obj[2]);
            vo.setResultA((BigDecimal)obj[3]);
            vo.setResultB((BigDecimal)obj[4]);
            vo.setResultC((BigDecimal)obj[5]);
            vo.setResultD((BigDecimal)obj[6]);
            vo.setResultE((BigDecimal)obj[7]);
            vo.setPsqContent((String)obj[8]);
            vo.setAnswerA((String)obj[9]);
            vo.setAnswerB((String)obj[10]);
            vo.setAnswerC((String)obj[11]);
            vo.setAnswerD((String)obj[12]);
            vo.setAnswerE((String)obj[13]);
            voList.add(vo);
        }
        return voList;
    }

    public List getCountByRoleType(QuestionnaireCondition conditon) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,pd.result_a,pd.result_b,pd.result_c,pd.result_d,pd.result_e FROM (");
        sql.append(" SELECT  M.ROW_ID, D.SORT_ID,  M.PSQ_NAME, D.PSQ_CONTENT, cv.RoleType, ");
        sql.append("   SUM(DECODE(L.ANSWER_A, NULL, 0, 1)) ANSWER_A, SUM(DECODE(L.ANSWER_B, NULL, 0, 1)) ANSWER_B, ");
        sql.append("  SUM(DECODE(L.ANSWER_C, NULL, 0, 1)) ANSWER_C,SUM(DECODE(L.ANSWER_D, NULL, 0, 1)) ANSWER_D, ");
        sql.append("   SUM(DECODE(L.ANSWER_E, NULL, 0, 1)) ANSWER_E ");
        sql.append(" from CX_PSQ_MAIN  M, CX_PSQ_DETAIL  D, CX_PSQ_RESUTL  H, CX_PQ_RUSDETAIL   L, cx_awk_contactlist_view cv  ");
        sql.append(" where H.PSQ_ID = M.ROW_ID  and h.row_id = l.result_id and m.row_id = d.psq_id ");
        sql.append("  and h.user_id = cv.Row_Id  and l.psq_result_id = d.row_id ");
        sql.append("  AND M.row_id = ? ");
        sql.append(" GROUP BY M.ROW_ID, M.PSQ_NAME, D.PSQ_CONTENT, cv.RoleType, D.sort_id ");
        sql.append(" )t,cx_psq_detail pd  ");
        sql.append(" WHERE t.row_id = pd.psq_id  and t.sort_id = pd.sort_id and pd.psq_id=? ");
        sql.append(" order by pd.sort_id asc ");
        List countList = this.baseDao.findBySql(sql.toString(), new Object[]{conditon.getPsqId(), conditon.getPsqId()});
        ArrayList<CountVo> voList = new ArrayList<CountVo>();
        CountVo vo = null;
        for (Object[] obj : countList) {
            vo = new CountVo();
            Object[] cfr_ignored_0 = new Object[15];
            vo.setPsqId((String)obj[0]);
            vo.setSortId((String)obj[1]);
            vo.setPsqName((String)obj[2]);
            vo.setPsqContent((String)obj[3]);
            vo.setRoleType((String)obj[4]);
            vo.setResultA((BigDecimal)obj[5]);
            vo.setResultB((BigDecimal)obj[6]);
            vo.setResultC((BigDecimal)obj[7]);
            vo.setResultD((BigDecimal)obj[8]);
            vo.setResultE((BigDecimal)obj[9]);
            vo.setAnswerA((String)obj[10]);
            vo.setAnswerB((String)obj[11]);
            vo.setAnswerC((String)obj[12]);
            vo.setAnswerD((String)obj[13]);
            vo.setAnswerE((String)obj[14]);
            voList.add(vo);
        }
        return voList;
    }

    public boolean validateQuestionnaireName(String psqName, String psqId, Employee me) {
        List list;
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Questionnaire where belongsOrgId=? and psqName=? ");
        args.add(me.getCurrentPartner().getId());
        args.add(psqName);
        if (StringUtils.isNotEmpty(psqId)) {
            hql.append(" and id <> ? ");
            args.add(psqId);
        }
        return (list = this.baseDao.findEntity(hql.toString(), args.toArray(), Questionnaire.class)).size() == 0;
    }

    public List<Contact> findPsqCreator(Employee me, String creatorId) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" select distinct(pc) from Contact pc ,Questionnaire q where pc.id=q.creatorId  and 1=1");
        hql.append(" and q.belongsOrgId =? ");
        args.add(me.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(creatorId)) {
            hql.append(" and and q.creatorId=?");
            args.add(creatorId);
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Contact.class);
    }

    public List<QuestionnaireUser> getSelectedList(String psqId) {
        String hql = " from QuestionnaireUser where psqId=? ";
        return this.baseDao.findEntity(hql, new Object[]{psqId}, QuestionnaireUser.class);
    }

    public List<Questionnaire> findPsqNames(Employee me, String belongsId) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from Questionnaire where belongsOrgId = ? and state='2' ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(belongsId);
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Questionnaire.class);
    }

    private String getKey(String str) {
        String temp = "";
        if (StringUtils.isNotEmpty(str) && str.length() == 2) {
            temp = str.substring(0, 1);
        }
        if (StringUtils.isNotEmpty(str) && str.length() > 2) {
            temp = str.substring(2);
        }
        return temp;
    }
}

