/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.region;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.dataSynchro.DataSynchroHandleService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.region.RegionCondition;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/region"})
public class RegionController
extends BaseController {
    @Autowired
    RegionService regionService;
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    Cache cache;
    @Autowired
    DataSynchroHandleService dataSynchroHandle;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(@RequestParam(value="orgId", required=false) String orgId, Model model, Region cm, HttpServletRequest request) {
        model.addAttribute("cm", (Object)cm);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("date", (Object)DateUtils.now());
        model.addAttribute("prefix", (Object)StringUtils.getPrefix());
        return "region/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add_post(@Valid @RequestBody Region region, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        this.validateName(region.getRegionName(), e.getCurrentPartner().getId(), null);
        this.validateNo(region.getRegionCode(), null);
        region.fillInitData(null, e);
        region.setOrgId(e.getCurrentPartner().getId());
        Region rg = this.regionService.get(region.getTreeId());
        if (rg == null) {
            region.setChannelCode(region.getTreeId());
        } else {
            region.setChannelCode(rg.getChannelCode());
        }
        region.setParentId(region.getTreeId());
        this.regionService.save(region);
        this.cache.initRegion();
        this.dataSynchroHandle.saveThread(region, Constant.CspDataSynchro.region_add.value, e);
        return this.getSuccessResult(region.getTreeId());
    }

    @RequestMapping(value={"/list.do"})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @RequestParam(value="orgId", required=false) String orgId, RegionCondition condition, String refresh, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        model.addAttribute("page", (Object)this.regionService.getList(pageno, condition, e.getCurrentPartner().getId(), orgId));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("pageno", (Object)pageno);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        model.addAttribute("refresh", (Object)refresh);
        return "region/list.ftl";
    }

    @RequestMapping(value={"/view.do"})
    public String view(String id, @RequestParam(value="orgId", required=false) String orgId, Model model) throws Exception {
        Region cm = this.regionService.get(id);
        model.addAttribute("cm", (Object)cm);
        model.addAttribute("orgId", (Object)orgId);
        return "region/view.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, @RequestParam(value="orgId", required=false) String orgId, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Region cxregionmain = this.regionService.get(id);
        String prefix = StringUtils.getPrefix();
        String regionCode = cxregionmain.getRegionCode();
        cxregionmain.setRegionCode(regionCode.replaceFirst(prefix, ""));
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("cxregionmain", (Object)cxregionmain);
        model.addAttribute("prefix", (Object)prefix);
        return "region/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody Region region, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Region cm = this.regionService.get(region.getId());
        Employee e = this.getCurrentEmployee();
        this.validateName(region.getRegionName(), e.getCurrentPartner().getId(), region.getId());
        this.validateNo(region.getRegionCode(), region.getId());
        region.fillInitData(cm, e);
        region.setOrgId(e.getCurrentPartner().getId());
        region.setChannelCode(cm.getChannelCode());
        region.setParentId(region.getTreeId());
        this.regionService.update(region);
        this.dataSynchroHandle.saveThread(region, Constant.CspDataSynchro.region_edit.value, e);
        return this.getSuccessResult(region.getTreeId());
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, Model model, @RequestParam(value="orgId", required=false) String orgId, HttpServletRequest request) {
        Region cm = this.regionService.get(id);
        cm.fillInitData(cm, this.getCurrentEmployee());
        cm.setEndDate(DateUtils.now());
        this.regionService.update(cm);
        this.dataSynchroHandle.saveThread(cm, Constant.CspDataSynchro.region_del.value, this.getCurrentEmployee());
        return "redirect:/region/list.do?refresh=1&orgId=" + orgId;
    }

    @RequestMapping(value={"/orgTree.do"}, method={RequestMethod.GET})
    public String orgTree(String orgId, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner p = this.personnelservice.getById(e.getCurrentPartner().getId());
        String tree = this.regionService.orgTree(orgId, p);
        model.addAttribute("tree", (Object)tree);
        model.addAttribute("orgId", (Object)orgId);
        return "/region/orgTree.ftl";
    }

    public void validateNo(String code, String id) throws Exception {
        boolean isExist = this.regionService.isCode(code, id);
        if (isExist) {
            throw new AppException("2102");
        }
    }

    public void validateName(String name, String orgId, String id) throws Exception {
        boolean isExist = this.regionService.isName(name, orgId, id);
        if (isExist) {
            throw new AppException("2101");
        }
    }

    @RequestMapping(value={"/ajaxGetChildNode.do"})
    public void ajaxGetChildNode(String id, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            Employee e = this.getCurrentEmployee();
            String result = this.regionService.getChildNodeTree(id, e.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"/welcome.do"})
    public String we(Model model) {
        return "/region/welcome.ftl";
    }

    @RequestMapping(value={"/look.do"})
    public String look(String id, @RequestParam(value="orgId", required=false) String orgId, Model model) throws Exception {
        Region cm = this.regionService.get(id);
        model.addAttribute("cm", (Object)cm);
        model.addAttribute("orgId", (Object)orgId);
        return "region/look.ftl";
    }
}

