/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.entity.MemberPointsTotal;
import com.tcbj.crm.report.Constant;
import com.tcbj.crm.shop.MemberPointsCondition;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="memberPointsReportService")
public class MemberPointsReportService {
    @Autowired
    private BaseDao baseDao;

    public Page queryAll(MemberPointsCondition con, int pageno, Contact ep, Employee em) {
        StringBuilder baseSql = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " REGION_.BIG_REGION_NAME,REGION_.REGION_NAME, REGION_.city,";
        select = String.valueOf(select) + " REGION_.p1 , REGION_.p1no ,REGION_.p2, REGION_.p2no, REGION_.p3,REGION_.p3no,REGION_.bh_no,REGION_.bh_name, ";
        select = String.valueOf(select) + " total_.total_points ,nvl(total_.total_num,0), ";
        select = String.valueOf(select) + " nvl(total_.new_points,0) ,nvl(total_.new_num,0),nvl(total_.old_points,0),nvl(total_.old_num,0), ";
        select = String.valueOf(select) + " nvl(exchange_.ex_qty,0),nvl(exchange_.ex_num,0),nvl(exchange_.ex_points,0)";
        this.baseDataSource(baseSql, args, con, em.getCurrentPartner().getId(), ep);
        sql.append(" SELECT  ");
        sql.append(String.valueOf(select) + " FROM");
        sql.append((CharSequence)baseSql);
        Page page2 = this.baseDao.searchBySql(sql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, null);
        List<MemberPointsTotal> memberPoints = this.convert(page2.getList());
        page2.setList(memberPoints);
        return page2;
    }

    private void queryAllMember(StringBuilder sql, MemberPointsCondition con) {
        String start = DateUtils.formartDate((Date)con.getStartDt(), (String)"yyyy-MM-dd");
        String end = DateUtils.formartDate((Date)con.getEndDt(), (String)"yyyy-MM-dd");
        StringBuilder sqlDate = new StringBuilder();
        sqlDate.append(" between to_date('").append(start).append("','yyyy-MM-dd') ");
        sqlDate.append(" and to_date('").append(end).append("','yyyy-MM-dd') ");
        sql.append(" select  ");
        sql.append(" sum(bh_gain_points) as total_points");
        sql.append(" ,count(distinct bh_memberid) as total_num ");
        sql.append(" ,sum(case when bh_first_points_date ").append((CharSequence)sqlDate);
        sql.append(" then bh_gain_points else 0 end) as new_points");
        sql.append(" ,count(distinct case when bh_first_points_date ").append((CharSequence)sqlDate);
        sql.append(" then bh_memberid end) as new_num");
        sql.append(",sum(case when bh_first_points_date<to_date('").append(start).append("','yyyy-MM-dd')");
        sql.append(" then bh_gain_points else 0 end) as old_points");
        sql.append(",count(distinct case when bh_first_points_date<to_date('").append(start).append("','yyyy-MM-dd')");
        sql.append(" then bh_memberid end) as old_num");
        sql.append(" ,bh_storeid from cx_awk_rpt_memberpointdetail ");
        sql.append(" where bh_pointtime ").append((CharSequence)sqlDate);
        sql.append(" group by bh_storeid ");
    }

    private void baseDataSource(StringBuilder sql, List<Object> args, MemberPointsCondition con, String userId, Contact ep) {
        Date startDt = con.getStartDt();
        Date endDt = con.getEndDt();
        StringBuilder sqlTotal = new StringBuilder();
        StringBuilder sqlExchange = new StringBuilder();
        this.queryExchangeMember(sqlExchange, startDt, endDt, args);
        this.queryAllMember(sqlTotal, con);
        sql.append(" rpt_regionInfo_v REGION_ , ");
        sql.append(" ( ");
        sql.append((CharSequence)sqlTotal);
        sql.append(" ) total_ ,");
        sql.append(" ( ");
        sql.append((CharSequence)sqlExchange);
        sql.append(" ) exchange_ ");
        sql.append(" WHERE ");
        sql.append(" REGION_.BH_STOREID = exchange_.bh_storeid(+) ");
        sql.append(" and REGION_.BH_STOREID = total_.bh_storeid(+) ");
        sql.append(" and REGION_.BIG_REGION_NAME is not null ");
        if (!"SysAdmin".equals(ep.getRoletype())) {
            String sql2 = "  select c.csn from cx_awk_rptpartner_forgw2  c where c.P1ID='" + userId + "'  ";
            sql.append("and REGION_.bh_no in (" + sql2 + ")");
        }
        sql.append(" and total_.total_num is not null ");
        if (StringUtils.isNotEmpty(con.getBigareaName())) {
            sql.append(" and REGION_.BIG_REGION_NAME like ? ");
            args.add("%" + con.getBigareaName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getCity())) {
            sql.append(" and REGION_.city like ? ");
            args.add("%" + con.getCity().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getAreaName())) {
            sql.append(" and REGION_.REGION_NAME like ? ");
            args.add("%" + con.getAreaName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getPertnerName())) {
            sql.append(" and ( REGION_.p1 like ? or REGION_.p2 like ? or REGION_.p3 like ? ) ");
            args.add("%" + con.getPertnerName().trim() + "%");
            args.add("%" + con.getPertnerName().trim() + "%");
            args.add("%" + con.getPertnerName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getPertnerCode())) {
            sql.append(" and ( REGION_.p1no like ? or REGION_.p2no like ? or REGION_.p3no like ? ) ");
            args.add("%" + con.getPertnerCode().trim() + "%");
            args.add("%" + con.getPertnerCode().trim() + "%");
            args.add("%" + con.getPertnerCode().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getStoreNo())) {
            sql.append(" and REGION_.bh_no like ? ");
            args.add("%" + con.getStoreNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getStoreName())) {
            sql.append(" and REGION_.bh_name like ? ");
            args.add("%" + con.getStoreName().trim() + "%");
        }
    }

    private List<MemberPointsTotal> convert(List<Object[]> list) {
        ArrayList<MemberPointsTotal> mps = new ArrayList<MemberPointsTotal>();
        Iterator<Object[]> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object[] objs;
            Object[] obj = objs = iterator.next();
            MemberPointsTotal mp = new MemberPointsTotal();
            int i = -1;
            if (obj[i + 1] != null) {
                mp.setBigareaName((String)obj[i + 1]);
            }
            if (obj[i + 2] != null) {
                mp.setAreaName((String)obj[i + 2]);
            }
            if (obj[i + 3] != null) {
                mp.setCity((String)obj[i + 3]);
            }
            if (obj[i + 4] != null) {
                mp.setPertnerName_1((String)obj[i + 4]);
            }
            if (obj[i + 5] != null) {
                mp.setPertnerCode_1((String)obj[i + 5]);
            }
            if (obj[i + 6] != null) {
                mp.setPertnerName_2((String)obj[i + 6]);
            }
            if (obj[i + 7] != null) {
                mp.setPertnerCode_2((String)obj[i + 7]);
            }
            if (obj[i + 8] != null) {
                mp.setPertnerName_3((String)obj[i + 8]);
            }
            if (obj[i + 9] != null) {
                mp.setPertnerCode_3((String)obj[i + 9]);
            }
            if (obj[i + 10] != null) {
                mp.setStoreNo((String)obj[i + 10]);
            }
            if (obj[i + 11] != null) {
                mp.setStoreName((String)obj[i + 11]);
            }
            if (obj[i + 12] != null) {
                mp.setTotalPoints(((BigDecimal)obj[i + 12]).toString());
            }
            if (obj[i + 13] != null) {
                mp.setTotalMemberNum(((BigDecimal)obj[i + 13]).toString());
            }
            if (obj[i + 14] != null) {
                mp.setNewOptions(((BigDecimal)obj[i + 14]).toString());
            }
            if (obj[i + 15] != null) {
                mp.setNewMemberNum(((BigDecimal)obj[i + 15]).toString());
            }
            if (obj[i + 16] != null) {
                mp.setOldOptions(((BigDecimal)obj[i + 16]).toString());
            }
            if (obj[i + 17] != null) {
                mp.setOldMemberNum(((BigDecimal)obj[i + 17]).toString());
            }
            if (obj[i + 18] != null) {
                mp.setExchangeQty(((BigDecimal)obj[i + 18]).toString());
            }
            if (obj[i + 19] != null) {
                mp.setExchangeNums(((BigDecimal)obj[i + 19]).toString());
            }
            if (obj[i + 20] != null) {
                mp.setExchangePoints(((BigDecimal)obj[i + 20]).toString());
            }
            mps.add(mp);
        }
        return mps;
    }

    private void queryOldMember(StringBuilder sql, Date startDt, Date endDt, List<Object> args) {
        sql.append(" select bh_storeno ,");
        sql.append("sum(bh_gain_points) as old_points,count(distinct bh_memberid) as old_num ");
        sql.append(" from cx_awk_rpt_memberpointdetail ");
        sql.append(" where bh_pointtime BETWEEN ? and ? ");
        sql.append(" and bh_first_points_date < ?");
        sql.append(" group by bh_storeid,bh_storeno,bh_stroename ");
        args.add(startDt);
        args.add(endDt);
        args.add(startDt);
    }

    private void queryNewMember(StringBuilder sql, Date startDt, Date endDt, List<Object> args) {
        sql.append(" select bh_storeno ,");
        sql.append(" sum(bh_gain_points) as new_points,count(distinct bh_memberid) as new_num");
        sql.append(" from cx_awk_rpt_memberpointdetail ");
        sql.append(" where bh_pointtime BETWEEN ? and ? ");
        sql.append(" and bh_first_points_date between ? and ? ");
        sql.append(" group by bh_storeid,bh_storeno,bh_stroename ");
        args.add(startDt);
        args.add(endDt);
        args.add(startDt);
        args.add(endDt);
    }

    private void queryExchangeMember(StringBuilder sql, Date startDt, Date endDt, List<Object> args) {
        sql.append("select bh_storeid, ");
        sql.append(" sum(qty) as ex_qty, count(distinct bh_memberid) as ex_num,sum(clerk_points) as ex_points ");
        sql.append(" from cx_awk_memberexchangedetail ");
        sql.append(" where bh_exchangetime BETWEEN ? and ? ");
        sql.append(" group by bh_storeid");
        args.add(startDt);
        args.add(endDt);
    }

    private void queryTotalMember(StringBuilder sql, Date startDt, Date endDt, List<Object> args) {
        sql.append(" select bh_storeno,");
        sql.append(" sum(bh_gain_points) as total_points,count(distinct bh_memberid) as total_num");
        sql.append(" from cx_awk_rpt_memberpointdetail ");
        sql.append(" where ");
        sql.append(" bh_pointtypeName = '\u4ea7\u54c1\u79ef\u5206' and ");
        sql.append(" bh_pointtime BETWEEN ? and ? ");
        sql.append(" group by bh_storeid,bh_storeno,bh_stroename ");
        args.add(startDt);
        args.add(endDt);
    }

    public List<MemberPointsTotal> getAllMemberPoints(MemberPointsCondition con, Employee em, Contact ep) {
        StringBuilder baseSql = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " REGION_.BIG_REGION_NAME,REGION_.REGION_NAME, REGION_.city,";
        select = String.valueOf(select) + " REGION_.p1 , REGION_.p1no ,REGION_.p2, REGION_.p2no, REGION_.p3,REGION_.p3no,REGION_.bh_no,REGION_.bh_name, ";
        select = String.valueOf(select) + " nvl(total_.total_points,0) ,nvl(total_.total_num,0), ";
        select = String.valueOf(select) + " nvl(total_.new_points,0) ,nvl(total_.new_num,0),nvl(total_.old_points,0),nvl(total_.old_num,0), ";
        select = String.valueOf(select) + " nvl(exchange_.ex_qty,0),nvl(exchange_.ex_num,0),nvl(exchange_.ex_points,0)";
        this.baseDataSource(baseSql, args, con, em.getCurrentPartner().getId(), ep);
        sql.append(" SELECT  ");
        sql.append(String.valueOf(select) + " FROM");
        sql.append((CharSequence)baseSql);
        List list = this.baseDao.findBySql(sql.toString(), args.toArray());
        List<MemberPointsTotal> memberPoints = this.convert(list);
        return memberPoints;
    }
}

