/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.report.MemberShopCondition;
import com.tcbj.crm.report.MemberShopService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/memberShop"})
public class MemberShopController
extends BaseController {
    @Autowired
    private MemberShopService service;
    @Autowired
    private PersonnelService personnelService;

    @RequestMapping(value={"/membershop.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findShopReport(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") MemberShopCondition con, Model model) throws Exception {
        if (con.getStartDate() == null || con.getEndDate() == null) {
            Date date = new Date();
            Calendar cd = Calendar.getInstance();
            cd.setTime(date);
            cd.add(5, -1);
            con.setStartDate(cd.getTime());
            con.setEndDate(date);
            return "report/membershop.ftl";
        }
        Employee em = this.getCurrentEmployee();
        Contact ep = this.personnelService.getReport(em.getId());
        Page memberShop = this.service.findShopReport(con, ep, pageno, em.getCurrentPartner().getId());
        model.addAttribute("memberShop", (Object)memberShop);
        model.addAttribute("condition", (Object)con);
        return "report/membershop.ftl";
    }

    @RequestMapping(value={"/contractListExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excel(MemberShopCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        Contact ep = this.personnelService.getReport(emp.getId());
        List<MemberShopCondition> list = this.service.getMemberScoreListBySerch(condition, ep, emp.getCurrentPartner().getId());
        if (list.size() >= 60000) {
            throw new AppException("5108");
        }
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "pactMain");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.service.excels(list, dir.getPath(), emp, response);
    }

    private void setYears(Model model) {
        int currentYear = Calendar.getInstance().get(1);
        ArrayList<Integer> years = new ArrayList<Integer>();
        int i = 0;
        while (i < 5) {
            years.add(++currentYear);
            ++i;
        }
        model.addAttribute("years", years);
    }
}

