/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.report.MemberShopCondition;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="memberShopService")
public class MemberShopService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private StorageService storageService;
    @Autowired
    OrderNoService orderNoService;

    public Page findShopReport(MemberShopCondition condition, Contact ep, int pageno, String proId) {
        Page page = this.baseDao.searchBySql(this.getSql(condition, ep, proId), null, Constant.DEFAULT_ROWS, pageno, null);
        new ArrayList();
        page.setList(this.objToList(page.getList()));
        return page;
    }

    public List<MemberShopCondition> getMemberScoreListBySerch(MemberShopCondition condition, Contact ep, String proId) {
        List listObj = this.baseDao.findBySql(this.getSql(condition, ep, proId));
        return this.objToList(listObj);
    }

    public List<MemberShopCondition> objToList(List<Object[]> listObj) {
        ArrayList<MemberShopCondition> listMember = new ArrayList<MemberShopCondition>();
        for (Object[] objects : listObj) {
            MemberShopCondition member = new MemberShopCondition();
            member.setStoreId(this.checkEmp(objects[0]));
            member.setBigareaName(this.checkEmp(objects[1]));
            member.setAreaName(this.checkEmp(objects[2]));
            member.setCity(this.checkEmp(objects[3]));
            member.setPertnerName_1(this.checkEmp(objects[4]));
            member.setPertnerCode_1(this.checkEmp(objects[5]));
            member.setPertnerName_2(this.checkEmp(objects[6]));
            member.setPertnerCode_2(this.checkEmp(objects[7]));
            member.setPertnerName_3(this.checkEmp(objects[8]));
            member.setPertnerCode_3(this.checkEmp(objects[9]));
            member.setStoreCode(this.checkEmp(objects[10]));
            member.setStoreName(this.checkEmp(objects[11]));
            String trueorflase = this.checkEmp(objects[12]);
            if ("true".equals(trueorflase)) {
                trueorflase = "\u662f";
            } else if ("false".equals(trueorflase)) {
                trueorflase = "\u5426";
            }
            member.setTrueorflase(trueorflase);
            String dateTrueorflaseString = this.checkEmp(objects[13]);
            dateTrueorflaseString = dateTrueorflaseString.length() > 10 ? dateTrueorflaseString.substring(0, 10) : dateTrueorflaseString;
            member.setTrueorflaseDate(dateTrueorflaseString);
            String trueorflasePoint = this.checkEmp(objects[14]);
            if ("true".equals(trueorflasePoint)) {
                trueorflasePoint = "\u662f";
            } else if ("false".equals(trueorflasePoint)) {
                trueorflasePoint = "\u5426";
            }
            member.setTrueorflasePoint(trueorflasePoint);
            String dateFirstString = this.checkEmp(objects[15]);
            dateFirstString = dateFirstString.length() > 10 ? dateFirstString.substring(0, 10) : dateFirstString;
            member.setFirstDate(dateFirstString);
            member.setManagerName(this.checkEmp(objects[16]));
            member.setMemberTelphone(this.checkEmp(objects[17]));
            member.setMemberCount(this.checkEmp(objects[18]));
            listMember.add(member);
        }
        return listMember;
    }

    public String getSql(MemberShopCondition condition, Contact ep, String proId) {
        String sql = "select c.csn from cx_awk_rptpartner_forgw2  c where c.P1ID='" + proId + "' ";
        new ArrayList();
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct s.BH_STOREID,e.BIG_REGION_NAME,e.REGION_NAME,e.city,e.p1,e.p1no,e.p2,e.p2no,e.p3,e.p3no,");
        sb.append(" e.bh_no,e.bh_name,");
        sb.append(" (CASE WHEN s.CLERK_NUM IS NULL THEN 'false' ELSE 'true' END )  AS ISCLERK,s.REGISTER_DT,");
        sb.append("(CASE WHEN s.BH_TOTAL_GAIN_POINTS IS NULL THEN 'false' ELSE 'true' END )  AS ISPOINTS,s.BH_FIRST_POINTS_DATE,");
        sb.append("e.bh_manager,e.bh_manager_telephone,s.clerk_num ");
        sb.append(" from CX_AWK_STORE_STAT s left join cx_awk_regionInfo_v e");
        sb.append(" on e.BH_STOREID=s.BH_STOREID ");
        sb.append(" where 1=1 ");
        if (!"SysAdmin".equals(ep.getRoletype())) {
            sb.append(" and exists (").append(sql).append(")");
        }
        if (condition != null) {
            if (!StringUtils.isEmpty(condition.getBigareaName())) {
                sb.append(" and e.BIG_REGION_NAME like '%").append(condition.getBigareaName()).append("%' ");
            }
            if (!StringUtils.isEmpty(condition.getAreaName())) {
                sb.append(" and e.REGION_NAME like '%").append(condition.getAreaName()).append("%' ");
            }
            if (!StringUtils.isEmpty(condition.getCity())) {
                sb.append(" and e.city like '%").append(condition.getCity()).append("%' ");
            }
            if (!StringUtils.isEmpty(condition.getSupperStoreName())) {
                sb.append(" and (e.p1 like '%").append(condition.getSupperStoreName()).append("%' or ");
                sb.append(" e.p2 like '%").append(condition.getSupperStoreName()).append("%' or");
                sb.append(" e.p3 like '%").append(condition.getSupperStoreName()).append("%')");
            }
            if (!StringUtils.isEmpty(condition.getSupperStoreCode())) {
                sb.append(" and (e.p1no like '%").append(condition.getSupperStoreCode()).append("%' or");
                sb.append(" e.p2no like '%").append(condition.getSupperStoreCode()).append("%' or");
                sb.append(" e.p3no like '%").append(condition.getSupperStoreCode()).append("%')");
            }
            if (!StringUtils.isEmpty(condition.getStoreCode())) {
                sb.append(" and s.BH_STORENO like '%").append(condition.getStoreCode()).append("%' ");
            }
            if (!StringUtils.isEmpty(condition.getStoreName())) {
                sb.append(" and s.BH_STORENAME like '%").append(condition.getStoreName()).append("%' ");
            }
            if (!StringUtils.isEmpty(condition.getTrueorflase())) {
                if ("true".equals(condition.getTrueorflase())) {
                    sb.append(" and s.CLERK_NUM IS NOT NULL");
                } else if ("false".equals(condition.getTrueorflase())) {
                    sb.append(" and s.CLERK_NUM IS NULL");
                }
            }
            if (!StringUtils.isEmpty(condition.getTrueorflasePoint())) {
                if ("true".equals(condition.getTrueorflasePoint())) {
                    sb.append(" and s.BH_TOTAL_GAIN_POINTS IS NOT NULL");
                } else if ("false".equals(condition.getTrueorflasePoint())) {
                    sb.append(" and s.BH_TOTAL_GAIN_POINTS IS NULL");
                }
            }
        }
        return sb.toString();
    }

    public String checkEmp(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    private Map<String, Object> convertArrayToMap(String[] keys, Object[] array) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Object value = null;
            if (array.length > i) {
                value = array[i];
            }
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public boolean excels(List<MemberShopCondition> list, String path, Employee emp, HttpServletResponse response) {
        String name = String.valueOf(emp.getCurrentPartner().getNo()) + "-\u4f1a\u5458\u5e97\u4fe1\u606f\u67e5\u8be2\u62a5\u8868-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls";
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u5927\u533a", "\u533a\u57df", "\u57ce\u5e02", "\u4e00\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e00\u7ea7\u7ecf\u9500\u5546", "\u4e8c\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e8c\u7ea7\u7ecf\u9500\u5546/\u8fde\u9501", "\u4e09\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e09\u7ea7\u7ecf\u9500\u5546/\u8fde\u9501", "\u4f1a\u5458\u5e97\u7f16\u7801", "\u4f1a\u5458\u5e97\u540d\u79f0", "\u662f\u5426\u6709\u6548\u4f1a\u5458\u5e97", "\u6709\u6548\u65e5\u671f", "\u662f\u5426\u79ef\u5206", "\u9996\u6b21\u79ef\u5206\u65e5\u671f", "\u5e97\u957f\u59d3\u540d", "\u95e8\u5e97\u8054\u7cfb\u7535\u8bdd", "\u5e97\u5458\u6570\u91cf"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            this.setRow(list.get(i), (Row)row, new PactMbo());
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void setRow(MemberShopCondition membershop, Row row, PactMbo pactMbo) {
        row.createCell(0).setCellValue(this.strEmp(membershop.getBigareaName()));
        row.createCell(1).setCellValue(this.strEmp(membershop.getAreaName()));
        row.createCell(2).setCellValue(this.strEmp(membershop.getCity()));
        row.createCell(3).setCellValue(this.strEmp(membershop.getPertnerCode_1()));
        row.createCell(4).setCellValue(this.strEmp(membershop.getPertnerName_1()));
        row.createCell(5).setCellValue(this.strEmp(membershop.getPertnerCode_2()));
        row.createCell(6).setCellValue(this.strEmp(membershop.getPertnerName_2()));
        row.createCell(7).setCellValue(this.strEmp(membershop.getPertnerCode_3()));
        row.createCell(8).setCellValue(this.strEmp(membershop.getPertnerName_3()));
        row.createCell(9).setCellValue(this.strEmp(membershop.getStoreCode()));
        row.createCell(10).setCellValue(this.strEmp(membershop.getStoreName()));
        row.createCell(11).setCellValue(this.strEmp(membershop.getTrueorflase()));
        row.createCell(12).setCellValue(this.strEmp(membershop.getTrueorflaseDate()));
        row.createCell(13).setCellValue(this.strEmp(membershop.getTrueorflasePoint()));
        row.createCell(14).setCellValue(this.strEmp(membershop.getFirstDate()));
        row.createCell(15).setCellValue(this.strEmp(membershop.getManagerName()));
        row.createCell(16).setCellValue(this.strEmp(membershop.getMemberTelphone()));
        row.createCell(17).setCellValue(this.strEmp(membershop.getMemberCount()));
    }

    public String strEmp(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public Double douEmp(Double dou) {
        if (dou == null) {
            return 0.0;
        }
        return dou;
    }
}

