/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.report.PartnerConcernCondition;
import com.tcbj.crm.report.PartnerConcernService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelLogicHandler;
import com.tcbj.util.ExcelUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/partnerConcern"})
public class PartnerConcernController
extends BaseController {
    @Autowired
    private PartnerConcernService service;

    @RequestMapping(value={"/partnerConcern.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findShopReport(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerConcernCondition con, Model model) throws Exception {
        if (con.getId() == null) {
            con.setId("-1");
            model.addAttribute("condition", (Object)con);
            return "report/partnerConcern.ftl";
        }
        Employee em = this.getCurrentEmployee();
        Page partnerConcern = this.service.findConcernReport(con, em, pageno);
        model.addAttribute("partnerConcern", (Object)partnerConcern);
        model.addAttribute("condition", (Object)con);
        return "report/partnerConcern.ftl";
    }

    @RequestMapping(value={"/partnerConcernExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excel(PartnerConcernCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        List<Map<String, Object>> list = this.service.getPartnerConcernBySerch(condition, emp);
        String[] titles = new String[]{"\u95e8\u5e97\u540d\u79f0", "\u95e8\u5e97\u7f16\u53f7", "\u5f00\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4", "\u5e97\u957f\u59d3\u540d", "\u5e97\u957f\u7535\u8bdd", "\u7701", "\u5e02", "\u53bf", "\u95e8\u5e97\u5730\u5740", "\u662f\u5426\u4f1a\u5458\u5e97", "\u9500\u552e\u6a21\u5f0f", "\u95e8\u5e97\u7c7b\u522b", "\u95e8\u5e97\u5b50\u7c7b\u578b", "\u4e00\u7ea7\u7ecf\u9500\u5546", "\u4e00\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e8c\u7ea7\u7ecf\u9500\u5546", "\u4e8c\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e09\u7ea7\u7ecf\u9500\u5546", "\u4e09\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u5927\u533a", "\u533a\u57df", "\u59d3\u540d", "\u5de5\u53f7", "\u89d2\u8272", "\u7535\u8bdd"};
        String[] pop = new String[]{"name", "csn", "startDate", "endDate", "smName", "smPhone", "tcbjProvinve", "tcbjCity", "tcbjCounty", "storeAddress", "storeFlag", "tcbjPromotionMode", "tcbjStoreType", "tcbjStoreSubType", "p1", "p1No", "p2", "p2No", "p3", "p3No", "dis", "reg", "fullName", "empNo", "roleType", "phoneNumber"};
        ExcelUtils.exportExcelNew("\u7ecf\u9500\u5546\u6240\u7ba1\u8f96\u7684\u95e8\u5e97\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u7ecf\u9500\u5546\u6240\u7ba1\u8f96\u7684\u95e8\u5e97\u62a5\u8868", ".xlsx", titles, list, pop, new ExcelLogicHandler(){

            @Override
            public void invoke(Object obj) {
                Map map = (Map)obj;
                if (Beans.isNotEmpty(map.get("roleType"))) {
                    map.put("roleType", Cache.getItemName("CONTACT_TYPE", map.get("roleType").toString()));
                }
                if (Beans.isNotEmpty(map.get("tcbjProvinve"))) {
                    map.put("tcbjProvinve", Cache.getItemName("STATE_ABBREV", map.get("tcbjProvinve").toString()));
                }
                if (Beans.isNotEmpty(map.get("tcbjCity"))) {
                    map.put("tcbjCity", Cache.getItemName("TCBJ_CITY", map.get("tcbjCity").toString()));
                }
                if (Beans.isNotEmpty(map.get("tcbjCounty"))) {
                    map.put("tcbjCounty", Cache.getItemName("COUNTY", map.get("tcbjCounty").toString()));
                }
                if (Beans.isNotEmpty(map.get("tcbjPromotionMode"))) {
                    map.put("tcbjPromotionMode", Cache.getItemName("TCBJ_PROMOTION_MODE", map.get("tcbjPromotionMode").toString()));
                }
                if (Beans.isNotEmpty(map.get("tcbjStoreType"))) {
                    map.put("tcbjStoreType", Cache.getItemName("TCBJ_STORE_TYPE", map.get("tcbjStoreType").toString()));
                }
                if (Beans.isNotEmpty(map.get("tcbjStoreSubType"))) {
                    map.put("tcbjStoreSubType", Cache.getItemName("TCBJ_STORE_SUBTYPE", map.get("tcbjStoreSubType").toString()));
                }
            }
        }, response);
    }

    private void setYears(Model model) {
        int currentYear = Calendar.getInstance().get(1);
        ArrayList<Integer> years = new ArrayList<Integer>();
        int i = 0;
        while (i < 5) {
            years.add(++currentYear);
            ++i;
        }
        model.addAttribute("years", years);
    }
}

