/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.report.PartnerConcernCondition;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="partnerConcernService")
public class PartnerConcernService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private StorageService storageService;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    @Qualifier(value="newBaseDao")
    NewBaseDao newBaseDao;

    public Page findConcernReport(PartnerConcernCondition con, Employee em, int pageno) {
        Page page = this.newBaseDao.findPageBySql(this.getSql(con, em), null, pageno, Constant.DEFAULT_ROWS);
        if (Beans.isNotEmpty((Object)page.getList())) {
            for (Object o : page.getList()) {
                Map m = (Map)o;
                if (Beans.isNotEmpty(m.get("roleType"))) {
                    m.put("roleType", Cache.getItemName("CONTACT_TYPE", m.get("roleType").toString()));
                }
                if (Beans.isNotEmpty(m.get("tcbjProvinve"))) {
                    m.put("tcbjProvinve", Cache.getItemName("STATE_ABBREV", m.get("tcbjProvinve").toString()));
                }
                if (Beans.isNotEmpty(m.get("tcbjCity"))) {
                    m.put("tcbjCity", Cache.getItemName("TCBJ_CITY", m.get("tcbjCity").toString()));
                }
                if (Beans.isNotEmpty(m.get("tcbjCounty"))) {
                    m.put("tcbjCounty", Cache.getItemName("COUNTY", m.get("tcbjCounty").toString()));
                }
                if (Beans.isNotEmpty(m.get("tcbjPromotionMode"))) {
                    m.put("tcbjPromotionMode", Cache.getItemName("TCBJ_PROMOTION_MODE", m.get("tcbjPromotionMode").toString()));
                }
                if (Beans.isNotEmpty(m.get("tcbjStoreType"))) {
                    m.put("tcbjStoreType", Cache.getItemName("TCBJ_STORE_TYPE", m.get("tcbjStoreType").toString()));
                }
                if (!Beans.isNotEmpty(m.get("tcbjStoreSubType"))) continue;
                m.put("tcbjStoreSubType", Cache.getItemName("TCBJ_STORE_SUBTYPE", m.get("tcbjStoreSubType").toString()));
            }
        }
        return page;
    }

    public List<Map<String, Object>> getPartnerConcernBySerch(PartnerConcernCondition condition, Employee em) {
        List<Map<String, Object>> listObj = this.newBaseDao.findBySql(this.getSql(condition, em));
        return listObj;
    }

    public String getSql(PartnerConcernCondition con, Employee em) {
        StringBuffer st = new StringBuffer();
        StringBuffer sp = new StringBuffer();
        if (con != null) {
            String no;
            int n;
            String name = con.getP1().trim();
            if (!StringUtils.isEmpty(name)) {
                String[] names;
                st.append(" IN (");
                String[] stringArray = names = name.split("[,\uff0c]");
                n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    st.append("'").append(string).append("',");
                    ++n2;
                }
                st.deleteCharAt(st.length() - 1);
                st.append(")");
            }
            if (!StringUtils.isEmpty(no = con.getP1No().trim())) {
                String[] nos;
                sp.append(" IN (");
                String[] stringArray = nos = no.split("[,\uff0c]");
                int n3 = nos.length;
                n = 0;
                while (n < n3) {
                    String string = stringArray[n];
                    sp.append("'").append(string).append("',");
                    ++n;
                }
                sp.deleteCharAt(sp.length() - 1);
                sp.append(")");
            }
        }
        String regions = this.personnelService.getFRegionsByUserId(em.getId());
        StringBuffer sb = new StringBuffer();
        sb.append("select e.bh_no \"csn\",e.bh_name \"name\",").append("e.bh_manager \"smName\",e.bh_manager_telephone \"smPhone\",").append(" stores.PRTNRSHP_START_DT \"startDate\",store_detial.PTSHP_END_DT \"endDate\",store_detial.X_PROVINCE \"tcbjProvinve\",").append(" store_detial.X_CITY \"tcbjCity\",store_detial.X_COUNTY \"tcbjCounty\",store_x.ATTRIB_52 \"storeAddress\",").append(" decode(store_detial.X_MEMSTORE_FLG,'Y','\u662f','\u5426') \"storeFlag\",store_detial.X_PROMT_MODE  \"tcbjPromotionMode\",").append(" store_detial.X_STORE_TYPE \"tcbjStoreType\",store_detial.X_STORE_SUBTYPE \"tcbjStoreSubType\",e.p1 \"p1\",").append(" e.p1no \"p1No\",e.p2 \"p2\",e.p2no \"p2No\",e.p3 \"p3\",e.p3no \"p3No\",e.BIG_REGION_NAME \"dis\",e.REGION_NAME \"reg\",").append(" contact.LAST_NAME \"fullName\",contact.emp_num \"empNo\",contact.Con_CD \"roleType\",contact.CELL_PH_NUM \"phoneNumber\" ").append(" from siebel.S_ORG_EXT stores left join siebel.S_ORG_PRTNR store_detial on stores.row_id = store_detial.par_row_id ").append(" left join siebel.S_ORG_EXT_X store_x on stores.row_id = store_x.par_row_id left join  RPT_REGIONINFO_V e on e.bh_no = stores.ou_num ").append(" left join  siebel.S_PARTY_PER per on per.party_id = stores.row_id,siebel.S_CONTACT  contact").append(" where per.person_id = contact.row_id ").append(" and stores.row_id in (select cn.Row_Id from CX_AWK_STORELIST_VIEW cn where (cn.districtId in (" + regions + ") or cn.regionId in (" + regions + ") )) ");
        if (st.length() > 0) {
            sb.append(" and  e.p1 ").append(st);
        }
        if (sp.length() > 0) {
            sb.append(" and e.p1No ").append(sp);
        }
        return sb.toString();
    }

    public boolean excels(List<PartnerConcernCondition> list, String path, Employee emp, HttpServletResponse response) {
        String name = String.valueOf(emp.getCurrentPartner().getNo()) + "-\u8425\u4e1a\u5458\u4fe1\u606f\u62a5\u8868-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls";
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u5927\u533a", "\u533a\u57df", "\u57ce\u5e02", "\u4e00\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e00\u7ea7\u7ecf\u9500\u5546", "\u4e8c\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e8c\u7ea7\u7ecf\u9500\u5546/\u8fde\u9501", "\u4e09\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e09\u7ea7\u7ecf\u9500\u5546/\u8fde\u9501", "\u4f1a\u5458\u5e97\u7f16\u7801", "\u4f1a\u5458\u5e97\u540d\u79f0", "\u8425\u4e1a\u5458\u59d3\u540d", "\u8425\u4e1a\u5458\u624b\u673a\u53f7\u7801", "\u804c\u4f4d", "\u5ba2\u6237\u79ef\u5206", "\u603b\u5ba2\u6237\u6570", "\u65b0\u5ba2\u6237\u6570"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            this.setRow(list.get(i), (Row)row, new PactMbo());
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void setRow(PartnerConcernCondition concern, Row row, PactMbo pactMbo) {
    }

    public String strEmp(Object str) {
        if (str == null) {
            return "";
        }
        return str.toString();
    }
}

