/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.score;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.base.BaseApplyController;
import com.tcbj.crm.score.ScoreCondition;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.crm.view.ExchangeOrder;
import com.tcbj.crm.view.ProductGiftView;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/exchangeOrder"})
public class ExchangeOrderController
extends BaseApplyController {
    @Autowired
    ScoreService service;

    @RequestMapping(value={"/myOrders.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String myOrders(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ScoreCondition condition, Model model) {
        condition.setApplyerId(this.getCurrentEmployee().getCurrentPartner().getId());
        Page page = this.service.getExchangeOrders(condition, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        return "score/myOrders.ftl";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        ExchangeOrder exchangeOrder = this.service.getExchangeOrderWithDetails(id);
        model.addAttribute("exchangeOrder", (Object)exchangeOrder);
        model.addAttribute("details", (Object)JSON.toJSONStringWithDateFormat(exchangeOrder.getDetails(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("isPartner", (Object)"true");
        return "score/view.ftl";
    }

    private void initDetails(ExchangeOrder order, List<ProductGiftView> products, String showStockFlag) {
        List<ExchangeDetail> details = order.getDetails();
        ArrayList<ExchangeDetail> newdetails = new ArrayList<ExchangeDetail>();
        for (ProductGiftView product : products) {
            ExchangeDetail detail2;
            boolean isExist = false;
            for (ExchangeDetail detail2 : details) {
                if (!detail2.getProductId().equals(product.getId())) continue;
                detail2.setRemainQuantity(product.getStockQuantity().toString());
                this.setShowStock(detail2, product, showStockFlag);
                newdetails.add(detail2);
                isExist = true;
                break;
            }
            if (isExist) continue;
            detail2 = new ExchangeDetail();
            detail2.setProductName(product.getName());
            detail2.setQuantity(0.0);
            detail2.setTransactionSubType(product.getCategory());
            detail2.setProductId(product.getId());
            detail2.setProductNo(product.getNo());
            detail2.setPoints(product.getPoints());
            detail2.setUnitName(product.getUnitName());
            detail2.setSpec(product.getSpec());
            detail2.setBarCode(product.getBarCode());
            detail2.setRemainQuantity(product.getStockQuantity().toString());
            this.setShowStock(detail2, product, showStockFlag);
            newdetails.add(detail2);
        }
        order.setDetails(newdetails);
    }

    private void setShowStock(ExchangeDetail detail, ProductGiftView product, String showStockFlag) {
        Double availableStock = product.getStockQuantity();
        String displayFlag = product.getIsDisplay();
        if ("Y".equals(showStockFlag)) {
            detail.setStockFlag(availableStock.toString());
        } else if ("N".equals(showStockFlag)) {
            detail.setStockFlag(availableStock > 0.0 ? "\u6709" : "\u65e0");
        }
        if ("N".equals(displayFlag)) {
            detail.setStockFlag("\u65e0");
            detail.setRemainQuantity("0");
        }
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        ExchangeOrder exchangeOrder = null;
        Customer customer = null;
        if (StringUtils.isEmpty((Object)id)) {
            exchangeOrder = new ExchangeOrder().init(me);
            customer = this._getCustomer(exchangeOrder.getShopId(), exchangeOrder.getSupplierId());
            this.initDetails(exchangeOrder, this.service.getActiveProducts(exchangeOrder.getShopId(), me.getCurrentPartner().getOrganizationid()), customer.getIsStockShow());
        } else {
            ExchangeOrder old = this.service.getExchangeOrder(id);
            if (old == null || old.getState() == null || !old.getState().equals("Draft")) {
                throw new AppException("3060");
            }
            exchangeOrder = this.service.getExchangeOrderWithDetails(id);
            customer = this._getCustomer(exchangeOrder.getShopId(), exchangeOrder.getSupplierId());
            this.initDetails(exchangeOrder, this.service.getActiveProducts(exchangeOrder.getShopId(), me.getCurrentPartner().getOrganizationid()), customer.getIsStockShow());
        }
        exchangeOrder.setMemberId(me.getCurrentPartner().getId());
        exchangeOrder.setSupplierId(me.getCurrentPartner().getOrganizationid());
        exchangeOrder.bindEditData(customer, me);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("exchangeOrder", (Object)exchangeOrder);
        model.addAttribute("details", (Object)JSON.toJSONStringWithDateFormat(exchangeOrder.getDetails(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "score/editOrder.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_do(@Valid @RequestBody ExchangeOrder order, String submitType, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        submitType = StringUtils.isEmpty((Object)submitType) || !submitType.equals("submit") ? "save" : "submit";
        order.init(me);
        this.assertProductAvailableStock(me.getCurrentPartner().getId(), order, me.getCurrentPartner().getOrganizationid());
        if (StringUtils.isEmpty((Object)order.getId())) {
            order.setState("Draft");
            String no = "JXS" + DateUtils.formartDate((Date)new Date(), (String)"yyyyMMddhhmmss");
            int i = (int)(Math.random() * 9000.0 + 1000.0);
            order.setNo(String.valueOf(no) + i);
            if (submitType.equals("submit")) {
                order.setState("Submitted");
            }
            this.service.addExchangeOrder(order, me);
        } else {
            ExchangeOrder old = this.service.getExchangeOrder(order.getId());
            if (old == null || old.getState() == null || !old.getState().equals("Draft")) {
                throw new AppException("3060");
            }
            if (submitType.equals("submit")) {
                order.setState("Submitted");
            } else {
                order.setState(old.getState());
            }
            this.service.updateExchangeOrder(order, me);
        }
        return this.getSuccessResult(null);
    }

    private void assertProductAvailableStock(String applyId, ExchangeOrder order, String supplierId) {
        List<ProductGiftView> scoreProducts = this.service.getActiveProducts(applyId, supplierId);
        if (order != null && order.getDetails().size() > 0) {
            for (ExchangeDetail detail : order.getDetails()) {
                if (scoreProducts == null || scoreProducts.size() <= 0) continue;
                for (ProductGiftView product : scoreProducts) {
                    if (!detail.getProductId().equals(product.getId()) || !detail.getProductId().equals(product.getId()) || !(detail.getQuantity() > product.getStockQuantity())) continue;
                    throw new AppException("3008", product.getName());
                }
            }
        }
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET})
    public String del(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        ExchangeOrder old = this.service.getExchangeOrder(id);
        if (old == null || old.getState() == null || !old.getState().equals("Draft")) {
            throw new AppException("3060");
        }
        if (!old.getShopId().equals(me.getCurrentPartner().getId())) {
            throw new AppException("0010", "\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u516c\u53f8\u521b\u5efa\u7684\u8ba2\u5355");
        }
        this.service.delExchangeOrder(id);
        return "redirect:myOrders.do?conscope=session";
    }

    @RequestMapping(value={"/selHistoryOrderProducts.do"}, method={RequestMethod.GET})
    public String selHistoryOrderProducts(Model model) {
        int year = DateUtils.getYear();
        int month = DateUtils.getMonth();
        model.addAttribute("startDt", (Object)DateUtils.getFirstDay((int)year, (int)month));
        model.addAttribute("endDt", (Object)DateUtils.getLastDay((int)year, (int)month));
        return "score/selHistoryOrderProducts.ftl";
    }

    @RequestMapping(value={"/selHistoryOrderProductDatas.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<ExchangeDetail> selHistoryOrderProductDatas(@RequestParam(value="startDt", required=false) Date startDt, @RequestParam(value="endDt", required=false) Date endDt, Model model) {
        if (startDt == null) {
            startDt = DateUtils.getFirstDay((int)DateUtils.getYear(), (int)DateUtils.getMonth());
        }
        if (endDt == null) {
            endDt = DateUtils.getLastDay((int)DateUtils.getYear(), (int)DateUtils.getMonth());
        }
        endDt = DateUtils.getDateWithOverTime((Date)endDt);
        return this.service.getShopExchangeOrders(this.getCurrentEmployee().getCurrentPartner().getId(), startDt, endDt);
    }

    @RequestMapping(value={"/ajaxGiftQuantitys.do"}, method={RequestMethod.POST})
    public void loadGiftProducts(Model model) {
    }
}

