/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.sendAdmin;

import com.alibaba.fastjson.JSON;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderDeliveryInformation;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.sendAdmin.SendAdminService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.Jsons;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sendAdmin"})
public class SendAdminControll
extends BaseController {
    @Autowired
    SendAdminService sendAdminService;

    @RequestMapping(value={"/list.do"})
    public String list(OrderApplyCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        con.setSupplierId(em.getCurrentPartner().getId());
        con.setCurrentPartnerId(em.getCurrentPartner().getId());
        con.setState(TCBJEnum.AuditState.billing.getValue());
        con.setEmployeeId(em.getId());
        con.setRegionFilter(true);
        List<OrderApply> orderApplys = this.sendAdminService.findOrderApplys(con);
        model.addAttribute("orderApplys", (Object)JSON.toJSONString(orderApplys));
        model.addAttribute("con", (Object)con);
        return "sendAdmin/list.ftl";
    }

    @RequestMapping(value={"apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply(@Validated @RequestBody String data) {
        Employee em = this.getCurrentEmployee();
        List orders = (List)Jsons.toListBean((String)data, OrderDeliveryInformation.class);
        this.sendAdminService.save(orders, em);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(OrderApplyCondition con, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        con.setSupplierId(em.getCurrentPartner().getId());
        con.setCurrentPartnerId(em.getCurrentPartner().getId());
        con.setState(TCBJEnum.AuditState.billing.getValue());
        con.setEmployeeId(em.getId());
        con.setRegionFilter(true);
        List<OrderApply> orderApplys = this.sendAdminService.findOrderApplys(con);
        File dir = new File(String.valueOf(ConfigFactory.get().get("upload_base_path")) + "sendAdmin_excel");
        if (!dir.mkdirs()) {
            dir.mkdirs();
        }
        this.excels(orderApplys, dir.getPath(), String.valueOf(this.getCurrentEmployee().getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    public boolean excels(List<OrderApply> orderApplys, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u8ba2\u5355\u7f16\u53f7", "\u627f\u8fd0\u5546", "\u627f\u8fd0\u5546\u7535\u8bdd", "\u8fd0\u5355\u53f7", "\u603b\u6570\u91cf", "\u603b\u7bb1\u6570", "\u62c6\u7bb1\u6570"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < orderApplys.size()) {
            row = sheet.createRow(i + 1);
            OrderApply apply = orderApplys.get(i);
            String[] vals = new String[]{apply.getNo(), "", "", "", "", "", ""};
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream file = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)file);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @RequestMapping(value={"/batchImport.do"}, method={RequestMethod.GET})
    public String batchImport() {
        return "sendAdmin/batchImport.ftl";
    }

    @RequestMapping(value={"/batchImport.do"}, method={RequestMethod.POST})
    public String btach(Model model, HttpServletRequest request, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        String rtn = null;
        ArrayList<OrderDeliveryInformation> list = new ArrayList<OrderDeliveryInformation>();
        List<AdjustStockUtil> msglist = this.getReadExcel(list, request);
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult("\u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\uff01"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSON(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() <= 0 && list.size() > 0) {
            this.sendAdminService.save(list, em);
            rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        }
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    public List<AdjustStockUtil> getReadExcel(List<OrderDeliveryInformation> list, HttpServletRequest request) {
        List<IUploadFile> file = this.uploadFile(request, "batchImport");
        List<List<Object>> readExcelList = new LinkedList<List<Object>>();
        String fileUrl = "";
        if (file.size() > 0) {
            fileUrl = file.get(0).getRealPath();
            readExcelList = ExcelHandle.readExcel(fileUrl);
        }
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        this.validateExcel(list, readExcelList, msglist);
        return msglist;
    }

    public void validateExcel(List<OrderDeliveryInformation> list, List<List<Object>> readExcelList, List<AdjustStockUtil> msglist) {
        Employee em = this.getCurrentEmployee();
        int j = 1;
        HashMap<String, Integer> orderAndNum = new HashMap<String, Integer>();
        for (List<Object> objlist : readExcelList) {
            OrderDeliveryInformation order = new OrderDeliveryInformation();
            String msg = "\u5728\u7b2c" + ++j + "\u884c\uff0c";
            boolean is = false;
            if ("".equals(objlist.get(0).toString()) || objlist.get(0).toString() == null) {
                msg = String.valueOf(msg) + "\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else if (!this.findOrderApplyByNo(objlist.get(0).toString())) {
                msg = String.valueOf(msg) + "\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728;";
                is = true;
            } else {
                OrderApply apply = this.sendAdminService.findOrderApplyByNo(em, objlist.get(0).toString());
                if ("4-1".equals(apply.getState())) {
                    order.setOrderId(apply.getId());
                } else {
                    msg = String.valueOf(msg) + "\u8ba2\u5355\u7f16\u53f7" + apply.getNo() + "\u4e0d\u662f\u5df2\u5f00\u5355\u72b6\u6001\u7684\u8ba2\u5355;";
                    is = true;
                }
                Integer num = (Integer)orderAndNum.get(apply.getId());
                if (Beans.isEmpty((Object)num)) {
                    orderAndNum.put(apply.getId(), j);
                } else {
                    msg = String.valueOf(msg) + "\u8ba2\u5355\u7f16\u53f7" + apply.getNo() + "\u4e0e\u7b2c" + num + "\u884c\u8ba2\u5355\u7f16\u53f7\u91cd\u590d;";
                    is = true;
                }
            }
            if ("".equals(objlist.get(1).toString()) || objlist.get(1).toString() == null) {
                msg = String.valueOf(msg) + "\u627f\u8fd0\u5546\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else {
                order.setExpressCompany(objlist.get(1).toString());
            }
            if ("".equals(objlist.get(2).toString()) || objlist.get(2).toString() == null) {
                msg = String.valueOf(msg) + "\u627f\u8fd0\u5546\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else {
                order.setExpressPhone(objlist.get(2).toString());
            }
            if ("".equals(objlist.get(3).toString()) || objlist.get(3).toString() == null) {
                msg = String.valueOf(msg) + "\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else {
                order.setCourierNumber(objlist.get(3).toString());
            }
            if ("".equals(objlist.get(4).toString()) || objlist.get(4).toString() == null) {
                msg = String.valueOf(msg) + "\u603b\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else if (!this.validNumber(objlist.get(4).toString())) {
                msg = String.valueOf(msg) + "\u603b\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570;";
                is = true;
            } else {
                order.setTotalQuantity(Integer.valueOf(objlist.get(4).toString()));
            }
            if ("".equals(objlist.get(5).toString()) || objlist.get(5).toString() == null) {
                msg = String.valueOf(msg) + "\u603b\u7bb1\u6570\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else if (!this.validNumber(objlist.get(5).toString())) {
                msg = String.valueOf(msg) + "\u603b\u7bb1\u6570\u5fc5\u987b\u4e3a\u6574\u6570;";
                is = true;
            } else {
                order.setTotalPackages(Integer.valueOf(objlist.get(5).toString()));
            }
            if ("".equals(objlist.get(6).toString()) || objlist.get(6).toString() == null) {
                msg = String.valueOf(msg) + "\u62c6\u7bb1\u6570\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else if (!this.validNumber(objlist.get(6).toString())) {
                msg = String.valueOf(msg) + "\u62c6\u7bb1\u6570\u5fc5\u987b\u4e3a\u6574\u6570;";
                is = true;
            } else {
                order.setPingPackages(Integer.valueOf(objlist.get(6).toString()));
            }
            if (is) {
                AdjustStockUtil asu = new AdjustStockUtil();
                asu.setMessage(msg);
                msglist.add(asu);
            }
            if (is) continue;
            list.add(order);
        }
    }

    private boolean findOrderApplyByNo(String no) {
        Employee em = this.getCurrentEmployee();
        OrderApply order = this.sendAdminService.findOrderApplyByNo(em, no);
        return Beans.isNotEmpty((Object)order);
    }

    public boolean validNumber(String num) {
        boolean flag = false;
        try {
            String regex = "^[1-9]+[0-9]*$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(num);
            if (m.find()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
}

