/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.sendAdmin;

import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyLocus;
import com.tcbj.crm.entity.OrderDeliveryInformation;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderApplyLocusService;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sendAdminService")
public class SendAdminService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    OrderApplyService orderApplyService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    OrderApplyLocusService orderApplyLocusService;

    public List<OrderApply> findOrderApplys(OrderApplyCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" select distinct o from OrderApply o,Partner p,PartnerRegion c where o.applyerId=p.id and p.id=c.applyerId ");
        if (Beans.isNotEmpty((Object)con.getNo())) {
            hql.append(" and o.no like ? ");
            args.add("%" + con.getNo() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getERPNumber())) {
            hql.append(" and o.ERPNumber like ? ");
            args.add("%" + con.getERPNumber() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getApplyerId())) {
            hql.append(" and c.applyerId = ? ");
            args.add(con.getApplyerId());
        }
        if (Beans.isNotEmpty((Object)con.getSupplierId())) {
            hql.append(" and o.supplierId = ? ");
            args.add(con.getSupplierId());
        }
        if (con.isRegionFilter()) {
            StringBuffer sb = new StringBuffer();
            hql.append("and (");
            String employeeId = con.getEmployeeId();
            String partnerIds = this.personnelService.getPartnerIds(employeeId);
            String regions = this.personnelService.getFRegionsByUserId(employeeId);
            if (!"'1-2-3'".equals(partnerIds)) {
                sb.append(" p.id in ( ");
                sb.append(partnerIds);
                sb.append(" ) ");
            }
            if (Beans.isNotEmpty((Object)sb.toString())) {
                sb.append(" or ");
            }
            sb.append(" c.districtId in ( ");
            sb.append(regions);
            sb.append(" ) or c.regionId in (");
            sb.append(regions);
            sb.append(" ) ");
            hql.append(sb.toString()).append(" ) ");
            hql.append(" and c.supplierId = ? ");
            args.add(con.getCurrentPartnerId());
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            hql.append(" and o.state = ? ");
            args.add(con.getState());
        }
        hql.append(" order by o.lastUpdateDt desc ");
        List orderApplys = this.baseDao.findEntity(hql.toString(), args.toArray(), OrderApply.class);
        return orderApplys;
    }

    public void save(List<OrderDeliveryInformation> orders, Employee em) {
        for (OrderDeliveryInformation order : orders) {
            this.orderApplyService.saveDeliveryInformation(order);
            this.orderApplyService.updateSended(order.getOrderId());
            this.orderApplyLocusService.saveOrderApplyLocus(order.getOrderId(), em, OrderApplyLocus.LocusType.sended.getValue(), "\u8ba2\u5355\u5df2\u53d1\u8d27");
        }
    }

    public OrderApply findOrderApplyByNo(Employee em, String no) {
        String s = " from OrderApply where no = ? and orgId = ? ";
        Object[] args = new Object[]{no, em.getCurrentPartner().getOrganizationid()};
        OrderApply apply = (OrderApply)this.baseDao.findFirstEntity(s, args, OrderApply.class);
        return apply;
    }
}

