/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.shop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.dataSynchro.DataSynchroHandleService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.MemberPointsTotal;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.entity.ShopAddress;
import com.tcbj.crm.entity.ShopContacts;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.report.MemberPointsReportService;
import com.tcbj.crm.shop.MemberPointsCondition;
import com.tcbj.crm.shop.PersonShopCondition;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.shop.ShopExcelVaildateService;
import com.tcbj.crm.shop.ShopReportCondition;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/shop"})
public class ShopController
extends BaseController {
    @Autowired
    private ShopService service;
    @Autowired
    private Cache cach;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    ShopExcelVaildateService excelVaildateService;
    @Autowired
    DataSynchroHandleService dataSynchroHandle;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private MemberPointsReportService memberPointsReportService;
    @Autowired
    private ProductService productService;
    static Map<String, String> errorMap = new LinkedHashMap<String, String>();

    @RequestMapping(value={"/myapplys.do"})
    public String myapplys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopCondition con, Model model) {
        this.getCurrentEmployee();
        model.addAttribute("condition", (Object)con);
        return this.findApplys(pageno, con, model);
    }

    private String findApplys(int pageno, ShopCondition condition, Model model) {
        Employee e = this.getCurrentEmployee();
        Page applys = this.service.findShopApplys(condition, e, pageno);
        model.addAttribute("startDate", (Object)DateUtils.now());
        model.addAttribute("shopApplys", (Object)applys);
        model.addAttribute("me", (Object)e);
        model.addAttribute((Object)condition);
        return "shop/applys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Shop shop = null;
        if (StringUtils.isEmpty(id)) {
            shop = new Shop();
            shop.initialize();
            shop.setShopNumber(this.orderNoService.saveBalanceShopNo("200001", true));
        } else {
            shop = this.service.getShopById(id);
        }
        this.getCurrentSalesman(model, me.getCurrentPartner().getId(), shop.getSalseManId());
        model.addAttribute("me", (Object)me);
        model.addAttribute("shop", (Object)shop);
        model.addAttribute("date", (Object)DateUtils.now());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shop.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shop.getContactses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "shop/apply.ftl";
    }

    private void getCurrentSalesman(Model model, String salseManId, String partnerId) {
        PartnerContact salseMan = this.service.getCurentSaleMan(partnerId, salseManId);
        model.addAttribute("salseMan", (Object)salseMan);
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody Shop shop, String type, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        boolean flag = this.service.validateShopName(me, shop);
        if (!flag) {
            throw new AppException("8005", shop.getShopName());
        }
        boolean flag2 = this.service.validateCilentNo(me, shop);
        if (!flag2) {
            throw new AppException("8006", shop.getOuterClientNo());
        }
        shop.setApproveState(type);
        shop.setApplyType(ShopEnum.ApplyType.add.getValue());
        this.saveOrUpdateShop(shop, me);
        return this.getSuccessResult(null);
    }

    private void saveOrUpdateShop(Shop shop, Employee me) {
        for (ShopAddress address : shop.getAddresses()) {
            address.setSiebelAddressId(address.getId());
            address.fillInitData(null, me);
        }
        for (ShopContacts contact : shop.getContactses()) {
            contact.setSiebelContactsId(contact.getId());
            contact.fillInitData(null, me);
        }
        shop.fillInitData(null, me);
        if (StringUtils.isEmpty(shop.getId())) {
            shop.setIsMenberShop("N");
            if (StringUtils.isEmpty(shop.getShopNumber()) || Beans.isNotEmpty((Object)this.service.getFirstShopByShopNo(shop.getShopNumber(), shop.getParentDealerId()))) {
                shop.setShopNumber(this.orderNoService.saveBalanceShopNo("200001", true));
            }
            this.service.add(shop, me, "CSP");
        } else {
            this.service.update(shop, me, "CSP");
        }
    }

    @RequestMapping(value={"/del"})
    @ResponseBody
    public Result del(String id, Model model) {
        this.service.del(id);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Shop shop = this.service.getShopById(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("shop", (Object)shop);
        this.getSalesName(model, shop.getSalseManId());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shop.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shop.getContactses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "shop/view.ftl";
    }

    @RequestMapping(value={"/audits.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String audits(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopCondition con, Model model) {
        if (!"dealing".equals(con.getAuditType()) && !"dealed".equals(con.getAuditType())) {
            throw new AppException("8001");
        }
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        Page audits = this.service.findShopAudits(con, pageno, me);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("me", (Object)me);
        model.addAttribute("audits", (Object)audits);
        return "shop/audits.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Shop shop = this.service.getShopById(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("shop", (Object)shop);
        this.getSalesName(model, shop.getSalseManId());
        model.addAttribute("prefix", (Object)StringUtils.getPrefix());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shop.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shop.getContactses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "shop/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(String id, String approveState, String opinion, String applyType, Model model) {
        if (!approveState.equals(ShopEnum.ApproveState.pass.getValue()) && !approveState.equals(ShopEnum.ApproveState.notpass.getValue())) {
            approveState = ShopEnum.ApproveState.notpass.getValue();
        }
        if (ShopEnum.ApplyType.add.getValue().equals(applyType)) {
            applyType = "insert";
        } else if (ShopEnum.ApplyType.edit.getValue().equals(applyType)) {
            applyType = "update";
        } else {
            throw new AppException("8002");
        }
        Employee me = this.getCurrentEmployee();
        this.service.saveAudit(id, approveState, me, opinion, applyType);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/auditNew.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(@Valid @RequestBody Shop shop, Model model) {
        if (shop == null) {
            throw new AppException("\u7a7a\u8868\u5355");
        }
        if (!ShopEnum.ApproveState.pass.getValue().equals(shop.getApproveState())) {
            shop.setApproveState(ShopEnum.ApproveState.notpass.getValue());
        }
        String type = "";
        if (ShopEnum.ApplyType.add.getValue().equals(shop.getApplyType())) {
            type = "insert";
        } else if (ShopEnum.ApplyType.edit.getValue().equals(shop.getApplyType())) {
            type = "update";
        } else {
            throw new AppException("8002");
        }
        Employee me = this.getCurrentEmployee();
        boolean flag = this.service.validateShopViewName(me.getCurrentPartner().getId(), shop.getSiebelShopId(), shop);
        if (!flag) {
            throw new AppException("8005", shop.getShopName());
        }
        boolean flag2 = this.service.validateSiebelCilentNo(me, shop.getOuterClientNo().trim(), shop.getSiebelShopId());
        if (!flag2) {
            throw new AppException("8006", shop.getOuterClientNo());
        }
        Shop s = this.service.saveAudit(shop, me, type);
        if (Beans.isNotEmpty((Object)s) && Beans.isNotEmpty((Object)s.getSiebelShopIdNew())) {
            this.dataSynchroHandle.sendThread(s.getSiebelShopId(), Constant.SiebelDataSynchro.store.value, me);
            this.dataSynchroHandle.saveThread(s, Constant.CspDataSynchro.shop_audit.value, me);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/findShopViews.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findShopViews(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isEmpty(me.getCurrentPartner().getParPartnerId())) {
            con.setIsOrg(true);
        } else {
            con.setIsOrg(false);
        }
        con.setPartnerId(me.getCurrentPartner().getId());
        Page shopViews = this.service.findShopViews(con, me, pageno);
        model.addAttribute("shopViews", (Object)shopViews);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "shop/finds.ftl";
    }

    @RequestMapping(value={"/viewShopView.do"}, method={RequestMethod.GET})
    public String viewPartner(@RequestParam(value="id", required=true) String id, Model model) {
        ShopView shopView = this.service.getShopView(id);
        model.addAttribute("shop", (Object)shopView);
        this.getSalesName(model, shopView.getSalseManId());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shopView.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shopView.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("hideaudit", (Object)"true");
        return "shop/view.ftl";
    }

    @RequestMapping(value={"/editShopView.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        ShopView shopView = this.service.getShopView(id);
        Employee me = this.getCurrentEmployee();
        this.getCurrentSalesman(model, me.getCurrentPartner().getId(), shopView.getSalseManId());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shopView.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shopView.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("shop", (Object)shopView);
        model.addAttribute("currentParnertName", (Object)Cache.getPartnerName(shopView.getParentDealerId()));
        return "shop/edit.ftl";
    }

    @RequestMapping(value={"/editShopView.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_do(@Valid @RequestBody Shop shop, BindingResult errors, HttpServletRequest request) {
        boolean flag;
        Employee me = this.getCurrentEmployee();
        shop.setSiebelShopId(shop.getId());
        if (StringUtils.isNotEmpty(shop.getOuterClientNo())) {
            shop.setOuterClientNo(shop.getOuterClientNo());
        }
        if (!(flag = this.service.validateShopName(me, shop))) {
            throw new AppException("8005", shop.getShopName());
        }
        boolean flag2 = this.service.validateCilentNo(me, shop);
        if (!flag2) {
            throw new AppException("8006", shop.getOuterClientNo());
        }
        shop.getDelIds();
        shop.fillInitData(null, me);
        shop.setApplyType(ShopEnum.ApplyType.edit.getValue());
        shop.setApproveState(ShopEnum.ApproveState.audit.getValue());
        this.service.add(shop, me, "CSP");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/findRecords.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findRecords(String id, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopCondition con, Model model) {
        Page shops = this.service.findShopRecords(con, id, pageno);
        model.addAttribute("shops", (Object)shops);
        model.addAttribute("condition", (Object)con);
        return "shop/records.ftl";
    }

    private void getSalesMan(Model model, Employee me) {
        String id = me.getCurrentPartner().getOrganizationid();
        if (StringUtils.isNotEmpty(id)) {
            List<Contact> contList = this.service.getSalesMan(id);
            model.addAttribute("contList", contList);
        }
    }

    private void getSalesName(Model model, String id) {
        String saleManName = "";
        if (StringUtils.isNotEmpty(id)) {
            saleManName = this.service.getSalesManName(id);
            model.addAttribute("saleManName", (Object)saleManName);
        }
    }

    @RequestMapping(value={"/shopExcel.do"}, method={RequestMethod.GET})
    public String toShopExcel(ShopCondition con, Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("con", (Object)con);
        return "shop/shopExcel.ftl";
    }

    @RequestMapping(value={"/shopExcel.do"}, method={RequestMethod.POST})
    public String shopBatch(ShopCondition con, Model model, HttpServletRequest request) throws Exception {
        Employee em = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "shop");
        String url = "";
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<Shop> list = new ArrayList<Shop>();
        ArrayList<AdjustStockUtil> msglist = new ArrayList();
        msglist = this.excelVaildateService.newReadShopByExcel(url, em, list);
        return this.excelReturn(con, list, msglist, filelist, model);
    }

    @RequestMapping(value={"/showError.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result showError(Model model) throws Exception {
        model.addAttribute("errorMap", errorMap);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sb = new StringBuffer("");
        Set<String> keys = errorMap.keySet();
        for (String key : keys) {
            sb.append("\u4e0a\u4f20\u65f6\u95f4\uff1a");
            sb.append(sdf.format(new Date(Long.valueOf(key))));
            sb.append("\u6267\u884c\u7ed3\u679c\uff1a");
            sb.append(errorMap.get(key));
        }
        return this.getSuccessResult(sb.toString());
    }

    public String excelReturn(ShopCondition con, final List<Shop> list, List<AdjustStockUtil> msglist, List<IUploadFile> filelist, Model model) {
        final Employee me = this.getCurrentEmployee();
        String rtn = null;
        if (list.size() < 1) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        Set<String> keys = errorMap.keySet();
        for (String key : keys) {
            errorMap.remove(key);
        }
        final String id = String.valueOf(System.currentTimeMillis());
        this.service.saveBalanceShopNew(list, me);
        Thread t = new Thread(){

            @Override
            public void run() {
                Map<String, Object> map = ShopController.this.service.shopToSiebel(list, me);
                String rtnStr = map.get("msg").toString();
                if (rtnStr != null && "".equals(rtnStr)) {
                    errorMap.put(id, "\u6267\u884c\u5b8c\u6210");
                    List listShop = (List)map.get("listShop");
                    for (Shop shop : listShop) {
                        ShopController.this.dataSynchroHandle.sendThread(shop.getSiebelShopId(), Constant.SiebelDataSynchro.store.value, me);
                    }
                    ShopController.this.dataSynchroHandle.saveThread(listShop, Constant.CspDataSynchro.shop_batchAdd.value, me);
                } else {
                    errorMap.put(id, rtnStr);
                }
            }
        };
        errorMap.put(id, "\u6267\u884c\u4e2d");
        t.start();
        rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/findShopReport.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findShopReport(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopReportCondition con, Model model) throws Exception {
        Employee me = this.getCurrentEmployee();
        Contact ep = this.personnelService.get(me.getId());
        Page shopViews = this.service.findShopReport(con, ep, pageno);
        model.addAttribute("shopViews", (Object)shopViews);
        model.addAttribute("condition", (Object)con);
        return "shop/report.ftl";
    }

    @RequestMapping(value={"/shopPoints.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String storeOptions(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") MemberPointsCondition con, Model model) throws Exception {
        Employee me = this.getCurrentEmployee();
        this.personnelService.getFRegionsByUserId(me.getId());
        if (con.getStartDt() == null) {
            Calendar ca = Calendar.getInstance();
            ca.add(2, 0);
            ca.set(5, 1);
            con.setStartDt(ca.getTime());
            con.setEndDt(new Date());
            model.addAttribute("con", (Object)con);
            return "shop/shopOptions.ftl";
        }
        if (con.getEndDt() == null) {
            con.setEndDt(new Date());
        }
        Contact ep = this.personnelService.getReport(me.getId());
        Page page = this.memberPointsReportService.queryAll(con, pageno, ep, me);
        model.addAttribute("shopPoints", (Object)page);
        model.addAttribute("con", (Object)con);
        return "shop/shopOptions.ftl";
    }

    @RequestMapping(value={"/export.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(MemberPointsCondition con, HttpServletRequest request, HttpServletResponse response) {
        try {
            Employee me = this.getCurrentEmployee();
            this.personnelService.getFRegionsByUserId(me.getId());
            Contact ep = this.personnelService.getReport(me.getId());
            List<MemberPointsTotal> excels = this.memberPointsReportService.getAllMemberPoints(con, me, ep);
            if (excels.size() >= 60000) {
                throw new AppException("5108");
            }
            String[] titles = new String[]{"\u5927\u533a", "\u533a\u57df", "\u57ce\u5e02", "\u4e00\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e00\u7ea7\u7ecf\u9500\u5546", "\u4e8c\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e8c\u7ea7\u7ecf\u9500\u5546", "\u4e09\u7ea7\u7ecf\u9500\u5546\u7f16\u7801", "\u4e09\u7ea7\u7ecf\u9500\u5546", "\u4f1a\u5458\u5e97\u7f16\u53f7", "\u4f1a\u5458\u5e97\u540d\u79f0", "\u603b\u79ef\u5206", "\u65b0\u5ba2\u79ef\u5206", "\u8001\u5ba2\u79ef\u5206", "\u603b\u5ba2\u6237\u6570", "\u65b0\u5ba2\u6570", "\u8001\u5ba2\u6570", "\u5151\u6362\u79ef\u5206", "\u5151\u6362\u5ba2\u6237\u6570", "\u5151\u6362\u7f50\u6570"};
            ExcelUtils.exportExcel("\u6c64\u81e3\u500d\u5065\u9879\u95e8\u5e97\u7ec8\u7aef\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u7ec8\u7aef\u62a5\u8868", titles, excels, response);
        }
        catch (Exception e) {
            throw new AppException("\u95e8\u5e97\u7ec8\u7aef\u62a5\u8868\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/personShop.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String personShop() {
        return "shop/personShop.ftl";
    }

    @RequestMapping(value={"/personShopExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void personShopExcel(@ModelAttribute(value="condition") PersonShopCondition con, Model model, HttpServletRequest request, HttpServletResponse response) {
        Employee me = this.getCurrentEmployee();
        List<PersonShopCondition> list = this.service.personShop(con);
        if (list.size() >= 60000) {
            throw new AppException("5108");
        }
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "shop");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.service.excels(list, dir.getPath(), me, response);
    }

    @RequestMapping(value={"/monthly.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String monthly() {
        return "shop/monthly.ftl";
    }

    @RequestMapping(value={"/monthlyExcel.do"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public Result monthly(Model model, HttpServletRequest request, HttpServletResponse response) throws DocumentException {
        this.productService.getExcel(response, request);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/contractListExcels.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excel(ShopCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Employee emp = this.getCurrentEmployee();
        this.personnelService.getReport(emp.getId());
        List<ShopCondition> list = null;
        if ("2".equals(condition.getFormSign())) {
            list = this.service.Shop(condition, emp);
        }
        if (list != null && list.size() >= 60000) {
            throw new AppException("5108");
        }
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "pactMain");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.service.excel(list, dir.getPath(), emp, response);
    }
}

