/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.shop;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Excels;
import com.tcbj.util.ValidataUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shopExcelVaildateService")
public class ShopExcelVaildateService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    ClientService clientService;
    @Autowired
    Cache cache;
    @Autowired
    PartnerService partnerService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    ShopService shopService;
    @Autowired
    RegionService regionService;
    private static final String FORMDATE = "MM/dd/yy";
    private static final String FORMDATE_2 = "yyyy-MM-dd";
    private final Logger LOG = LoggerFactory.getLogger(ShopExcelVaildateService.class);

    private String checkDate(String date) {
        try {
            Long.valueOf(date);
            return "\u65e5\u671f\u683c\u5f0f\u9519\u8bef";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public List<AdjustStockUtil> newReadShopByExcel(String filePath, Employee me, List<Shop> list) {
        List datas;
        ArrayList<AdjustStockUtil> megs;
        block81: {
            megs = new ArrayList<AdjustStockUtil>();
            String[] headers = new String[]{"applyerCode", "supplier", "applyer", "applyerPhone", "bigArea", "region", "province", "city", "area", "shopName", "shopType", "shopSubType", "phone", "address", "memberFlag", "sellSchema", "shopArea", "shopBrandArea", "longitude", "latitude", "clientCode", "clientLevel", "sellMemberCount", "shopCount", "acceptStock", "startDate", "endDate"};
            datas = Excels.readExcel((String)filePath, (InputStream)new FileInputStream(filePath), (String[])headers);
            if (!Beans.isEmpty((Object)datas)) break block81;
            return null;
        }
        try {
            Map<String, String> partnerMap = this.partnerService.findSubPartnersMap(me);
            Map<String, String> saleManMap = this.personnelService.getByOrgMap(me.getCurrentPartner().getOrganizationid());
            Map<String, String> regionMap = this.getRegionMap(me);
            Map<String, String> areaMap = this.getAreaMap(me);
            Map<String, String> provinceTypeMap = this.getItenMap("STATE_ABBREV");
            Map<String, String> cityTypeMap = this.getItenMap("TCBJ_CITY");
            Map<String, String> countyTypeMap = this.getItenMap("COUNTY");
            Map<String, String> stroreTypeMap = this.getItenMap("TCBJ_STORE_TYPE");
            Map<String, String> subTypeMap = this.getItenMap("TCBJ_STORE_SUBTYPE");
            Map<String, String> levelTypeMap = this.getItenMap("TCBJ_TERMIMAL_LEVEL");
            Map<String, String> modeTypeMap = this.getItenMap("TCBJ_PROMOTION_MODE");
            HashMap<String, String> selectTypeMap = new HashMap<String, String>();
            selectTypeMap.put("\u662f", "Y");
            selectTypeMap.put("\u5426", "N");
            String message = null;
            String result = null;
            Shop shop = null;
            int j = 1;
            for (Map data : datas) {
                shop = new Shop();
                result = null;
                message = ValidataUtils.validataMap(data.get("applyerCode"), partnerMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4e0a\u7ea7\u7ecf\u9500\u5546\u52a9\u8bb0\u7801 \uff1a" + message + ";";
                } else {
                    shop.setParentDealerId(partnerMap.get(data.get("applyerCode")));
                }
                message = null;
                if (data.get("applyer") == null) {
                    message = result = String.valueOf(result == null ? "" : result) + " \u4e1a\u52a1\u5458\u4e0d\u80fd\u4e3a\u7a7a;";
                }
                if (data.get("applyerPhone") == null) {
                    message = result = String.valueOf(result == null ? "" : result) + " \u4e1a\u52a1\u5458\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a;";
                }
                if (message == null) {
                    message = ValidataUtils.validataMap((Object)(data.get("applyer") + "_" + data.get("applyerPhone")), saleManMap);
                }
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4e1a\u52a1\u5458 \uff1a" + message + ";";
                } else {
                    shop.setSalseManId(saleManMap.get(data.get("applyer") + "_" + data.get("applyerPhone")));
                }
                message = ValidataUtils.validataMap(data.get("bigArea"), regionMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5927\u533a \uff1a" + message + ";";
                } else {
                    shop.setBigAreaId(regionMap.get(data.get("bigArea")));
                }
                message = ValidataUtils.validataMap(data.get("region"), areaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u533a\u57df \uff1a" + message + ";";
                } else {
                    shop.setAreaId(areaMap.get(data.get("region")));
                }
                String provinceId = data.get("province") != null ? data.get("province").toString() : null;
                String cityId = data.get("city") != null ? data.get("city").toString() : null;
                String countyId = data.get("area") != null ? data.get("area").toString() : null;
                DictionaryItem province = null;
                DictionaryItem city = null;
                DictionaryItem county = null;
                message = ValidataUtils.validataMap((Object)provinceId, provinceTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7701\u4efd \uff1a" + message + ";";
                } else {
                    province = Cache.getItem("STATE_ABBREV", provinceTypeMap.get(provinceId));
                    shop.setProvinceId(provinceTypeMap.get(provinceId));
                }
                message = ValidataUtils.validataMap((Object)cityId, cityTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02 \uff1a" + message + ";";
                } else {
                    city = Cache.getItem("TCBJ_CITY", cityTypeMap.get(cityId));
                    shop.setCityId(cityTypeMap.get(cityId));
                }
                message = ValidataUtils.validateMapOrNull((Object)countyId, countyTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u53bf\u57ce \uff1a" + message + ";";
                } else if (StringUtils.isNotEmpty((String)countyId)) {
                    county = Cache.getItem("COUNTY", countyTypeMap.get(countyId));
                    shop.setCountyId(countyTypeMap.get(countyId));
                }
                if (city != null && province != null && !city.getParName().equals(province.getName())) {
                    result = String.valueOf(result == null ? "" : result) + " \u7701\u4efd \uff1a" + provinceId + "\u4e0e\u57ce\u5e02" + cityId + "\u4e0d\u5339\u914d;";
                } else if (county != null && city != null && !county.getParName().equals(city.getName())) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02 \uff1a" + cityId + "\u4e0e\u53bf\u57ce" + countyId + "\u4e0d\u5339\u914d;";
                }
                message = this.validaShopName(me, data.get("shopName"), data.get("address"), data.get("outerClientNo"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u540d\u79f0 \uff1a" + message + ";";
                } else {
                    shop.setShopName(data.get("shopName").toString());
                }
                message = ValidataUtils.validataMap(data.get("shopType"), stroreTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u7c7b\u578b \uff1a" + message + ";";
                } else {
                    shop.setShopType(stroreTypeMap.get(data.get("shopType")));
                }
                message = ValidataUtils.validataMap(data.get("shopSubType"), subTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u5206\u7c7b \uff1a" + message + ";";
                } else {
                    shop.setShopClassify(subTypeMap.get(data.get("shopSubType")));
                }
                shop.setShopTel(data.get("phone") != null ? data.get("phone").toString() : null);
                shop.setAddressDetails(data.get("address") != null ? data.get("address").toString() : null);
                message = ValidataUtils.validataMap(data.get("memberFlag"), selectTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u662f\u5426\u4f1a\u5458\u5e97 \uff1a" + message + ";";
                } else {
                    shop.setIsMenberShop((String)selectTypeMap.get(data.get("memberFlag")));
                }
                message = ValidataUtils.validataMap(data.get("sellSchema"), modeTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4fc3\u9500\u6a21\u5f0f \uff1a" + message + ";";
                } else {
                    shop.setPromotionMode(modeTypeMap.get(data.get("sellSchema")));
                }
                message = ValidataUtils.validataDoubleOrNull(data.get("shopArea"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u95e8\u5e97\u603b\u9762\u79ef \uff1a" + message + ";";
                } else if (Beans.isNotEmpty(data.get("shopArea"))) {
                    shop.setShopTotalArea(Double.valueOf(data.get("shopArea").toString()));
                }
                message = ValidataUtils.validataDoubleOrNull(data.get("shopBrandArea"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u95e8\u5e97\u54c1\u724c\u9762\u79ef \uff1a" + message + ";";
                } else if (Beans.isNotEmpty(data.get("shopBrandArea"))) {
                    shop.setShopBrandArea(Double.valueOf(data.get("shopBrandArea").toString()));
                }
                message = this.validateLongIsNull(data.get("longitude"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u7ecf\u5ea6 \uff1a" + message + ";";
                } else if (Beans.isNotEmpty(data.get("longitude"))) {
                    shop.setLatitude(Long.valueOf(data.get("longitude").toString()));
                }
                message = this.validateLongIsNull(data.get("latitude"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u7eac\u5ea6 \uff1a" + message + ";";
                } else if (Beans.isNotEmpty(data.get("latitude"))) {
                    shop.setLongitude(Long.valueOf(data.get("latitude").toString()));
                }
                if (data.get("clientCode") != null && data.get("clientCode").toString().length() > 0) {
                    message = this.validateOutCilentNo(data.get("clientCode").toString());
                    if (message != null) {
                        result = String.valueOf(result == null ? "" : result) + "\u5916\u56f4\u5ba2\u6237\u7aef\u7f16\u53f7 \uff1a" + message + ";";
                    } else {
                        shop.setOuterClientNo(data.get("clientCode").toString());
                    }
                }
                if ((message = ValidataUtils.validataMap(data.get("clientLevel"), levelTypeMap)) != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7ec8\u7aef\u7b49\u7ea7 \uff1a" + message + ";";
                } else {
                    shop.setTerminalLevel(Beans.isEmpty(data.get("clientLevel")) ? "" : levelTypeMap.get(data.get("clientLevel")));
                }
                message = this.validateLongIsNull(data.get("sellMemberCount"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u4fc3\u9500\u4eba\u6570\uff1a" + message + ";";
                } else if (Beans.isNotEmpty(data.get("sellMemberCount"))) {
                    shop.setPromotionNumber(Long.valueOf(data.get("sellMemberCount").toString()));
                }
                message = this.validateLongIsNull(data.get("shopCount"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u4e13\u67dc\u4e2a\u6570\uff1a" + message + ";";
                } else if (Beans.isNotEmpty(data.get("shopCount"))) {
                    shop.setShoppeNumber(Long.valueOf(data.get("shopCount").toString()));
                }
                message = ValidataUtils.validateMapOrNull(data.get("acceptStock"), selectTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u662f\u5426\u9ed8\u8ba4\u63a5\u53d7\u5e93\u5b58 \uff1a" + message + ";";
                } else {
                    shop.setIsReceiveAllot(Beans.isEmpty(data.get("acceptStock")) ? "N" : (String)selectTypeMap.get(data.get("acceptStock")));
                }
                message = this.validateDate(data.get("startDate"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5f00\u59cb\u65f6\u95f4 \uff1a" + message + ";";
                } else {
                    message = this.checkDate(data.get("startDate").toString());
                    if (Beans.isNotEmpty((Object)message)) {
                        result = String.valueOf(result == null ? "" : result) + " \u5f00\u59cb\u65f6\u95f4\uff1a" + message + ";";
                    } else {
                        try {
                            shop.setStartDate(DateUtils.formDate((String)data.get("startDate").toString(), (String)FORMDATE_2));
                        }
                        catch (Exception exception) {
                            result = String.valueOf(result == null ? "" : result) + " \u5f00\u59cb\u65f6\u95f4\uff1a\u683c\u5f0f\u6709\u8bef;";
                        }
                    }
                }
                message = this.validateDateIsNull(data.get("endDate"));
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7ed3\u675f\u65f6\u95f4 \uff1a" + message + ";";
                } else {
                    message = this.checkDate(data.get("endDate").toString());
                    if (Beans.isNotEmpty((Object)message)) {
                        result = String.valueOf(result == null ? "" : result) + " \u7ed3\u675f\u65f6\u95f4\uff1a" + message + ";";
                    } else {
                        try {
                            shop.setEndDate(DateUtils.formDate((String)data.get("endDate").toString(), (String)FORMDATE_2));
                        }
                        catch (Exception exception) {
                            result = String.valueOf(result == null ? "" : result) + " \u7ed3\u675f\u65f6\u95f4\uff1a\u683c\u5f0f\u6709\u8bef;";
                        }
                    }
                }
                message = this.shopService.validateShopUnique(data.get("applyerCode") != null ? data.get("applyerCode").toString() : null, data.get("shopName") != null ? data.get("shopName").toString() : null, data.get("address") != null ? data.get("address").toString() : null);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u6d88\u606f \uff1a" + message + ";";
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                shop.fillInitData(null, me);
                list.add(shop);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            Shop t1 = null;
            Shop t2 = null;
            String s1 = null;
            String s2 = null;
            String clientNo1 = null;
            String clientNo2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getParentDealerId()) + t1.getShopName() + t1.getAddressDetails() + t1.getOuterClientNo();
                clientNo1 = t1.getOuterClientNo();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getParentDealerId()) + t2.getShopName() + t2.getAddressDetails() + t2.getOuterClientNo();
                    clientNo2 = t2.getOuterClientNo();
                    if (StringUtils.isNotEmpty((String)clientNo1) && StringUtils.isNotEmpty((String)clientNo2) && clientNo1 == clientNo2) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u5916\u56f4\u5ba2\u6237\u7aef\u7f16\u53f7\u91cd\u590d\uff1a" + clientNo1));
                    }
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            if (megs.size() > 0) {
                return megs;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    public List<AdjustStockUtil> readShopByExcel(String filePath, Employee me, List<Shop> list) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block67: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(filePath);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            int myCol = st.getColumns();
            myR = st.getRows();
            this.LOG.debug("//\u5217\u6570" + myCol + "//\u884c\u6570:" + myR);
            if (myR >= 2) break block67;
            return null;
        }
        try {
            Map<String, String> partnerMap = this.partnerService.findSubPartnersMap(me);
            Map<String, String> saleManMap = this.personnelService.getByOrgMap(me.getCurrentPartner().getOrganizationid());
            Map<String, String> regionMap = this.getRegionMap(me);
            Map<String, String> areaMap = this.getAreaMap(me);
            Map<String, String> provinceTypeMap = this.getItenMap("STATE_ABBREV");
            Map<String, String> cityTypeMap = this.getItenMap("TCBJ_CITY");
            Map<String, String> countyTypeMap = this.getItenMap("COUNTY");
            Map<String, String> stroreTypeMap = this.getItenMap("TCBJ_STORE_TYPE");
            Map<String, String> subTypeMap = this.getItenMap("TCBJ_STORE_SUBTYPE");
            Map<String, String> levelTypeMap = this.getItenMap("TCBJ_TERMIMAL_LEVEL");
            Map<String, String> modeTypeMap = this.getItenMap("TCBJ_PROMOTION_MODE");
            HashMap<String, String> selectTypeMap = new HashMap<String, String>();
            selectTypeMap.put("\u662f", "Y");
            selectTypeMap.put("\u5426", "N");
            String message = null;
            String result = null;
            Shop shop = null;
            int j = 1;
            while (j < myR) {
                shop = new Shop();
                result = null;
                message = ValidataUtils.validataMap((Object)st.getCell(0, j).getContents().trim(), partnerMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4e0a\u7ea7\u7ecf\u9500\u5546\u52a9\u8bb0\u7801 \uff1a" + message;
                } else {
                    shop.setParentDealerId(partnerMap.get(st.getCell(0, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)(String.valueOf(st.getCell(2, j).getContents().trim()) + "_" + st.getCell(3, j).getContents().trim()), saleManMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4e1a\u52a1\u5458 \uff1a" + message;
                } else {
                    shop.setSalseManId(saleManMap.get(String.valueOf(st.getCell(2, j).getContents().trim()) + "_" + st.getCell(3, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(4, j).getContents().trim(), regionMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5927\u533a \uff1a" + message;
                } else {
                    shop.setBigAreaId(regionMap.get(st.getCell(4, j).getContents()).trim());
                }
                message = ValidataUtils.validataMap((Object)st.getCell(5, j).getContents().trim(), areaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u533a\u57df \uff1a" + message;
                } else {
                    shop.setAreaId(areaMap.get(st.getCell(5, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(6, j).getContents().trim(), provinceTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7701\u4efd \uff1a" + message;
                } else {
                    shop.setProvinceId(provinceTypeMap.get(st.getCell(6, j).getContents()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(7, j).getContents().trim(), cityTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02 \uff1a" + message;
                } else {
                    shop.setCityId(cityTypeMap.get(st.getCell(7, j).getContents().trim()));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(8, j).getContents().trim(), countyTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u53bf\u57ce \uff1a" + message;
                } else if (StringUtils.isNotEmpty((String)st.getCell(8, j).getContents().trim())) {
                    shop.setCountyId(countyTypeMap.get(st.getCell(8, j).getContents().trim()));
                }
                message = this.validaShopName(me, st.getCell(9, j).getContents().trim(), st.getCell(13, j).getContents().trim(), st.getCell(20, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u540d\u79f0 \uff1a" + message;
                } else {
                    shop.setShopName(st.getCell(9, j).getContents().trim());
                }
                message = ValidataUtils.validataMap((Object)st.getCell(10, j).getContents().trim(), stroreTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u7c7b\u578b \uff1a" + message;
                } else {
                    shop.setShopType(stroreTypeMap.get(st.getCell(10, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(11, j).getContents().trim(), subTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u5206\u7c7b \uff1a" + message;
                } else {
                    shop.setShopClassify(subTypeMap.get(st.getCell(11, j).getContents().trim()));
                }
                shop.setShopTel(st.getCell(12, j).getContents().trim());
                shop.setAddressDetails(st.getCell(13, j).getContents().trim());
                message = ValidataUtils.validataMap((Object)st.getCell(14, j).getContents().trim(), selectTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u662f\u5426\u4f1a\u5458\u5e97 \uff1a" + message;
                } else {
                    shop.setIsMenberShop((String)selectTypeMap.get(st.getCell(14, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(15, j).getContents().trim(), modeTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4fc3\u9500\u6a21\u5f0f \uff1a" + message;
                } else {
                    shop.setPromotionMode(modeTypeMap.get(st.getCell(15, j).getContents().trim()));
                }
                message = ValidataUtils.validataDoubleOrNull((Object)st.getCell(16, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u95e8\u5e97\u603b\u9762\u79ef \uff1a" + message;
                } else if (StringUtils.isNotEmpty((String)st.getCell(16, j).getContents().trim())) {
                    shop.setShopTotalArea(Double.valueOf(st.getCell(16, j).getContents().trim()));
                }
                message = ValidataUtils.validataDoubleOrNull((Object)st.getCell(17, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u95e8\u5e97\u54c1\u724c\u9762\u79ef \uff1a" + message;
                } else if (StringUtils.isNotEmpty((String)st.getCell(17, j).getContents().trim())) {
                    shop.setShopBrandArea(Double.valueOf(st.getCell(17, j).getContents().trim()));
                }
                message = this.validateLongIsNull(st.getCell(18, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u7ecf\u5ea6 \uff1a" + message;
                } else if (StringUtils.isNotEmpty((String)st.getCell(18, j).getContents().trim())) {
                    shop.setLatitude(Long.valueOf(st.getCell(18, j).getContents().trim()));
                }
                message = this.validateLongIsNull(st.getCell(19, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u7eac\u5ea6 \uff1a" + message;
                } else if (StringUtils.isNotEmpty((String)st.getCell(19, j).getContents().trim())) {
                    shop.setLongitude(Long.valueOf(st.getCell(19, j).getContents().trim()));
                }
                message = this.validateOutCilentNo(st.getCell(20, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u5916\u56f4\u5ba2\u6237\u7aef\u7f16\u53f7 \uff1a" + message;
                } else {
                    shop.setOuterClientNo(st.getCell(20, j).getContents().trim());
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(21, j).getContents().trim(), levelTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7ec8\u7aef\u7b49\u7ea7 \uff1a" + message;
                } else {
                    shop.setTerminalLevel(StringUtils.isEmpty((String)st.getCell(21, j).getContents().trim()) ? "" : levelTypeMap.get(st.getCell(21, j).getContents().trim()));
                }
                message = this.validateLongIsNull(st.getCell(22, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u4fc3\u9500\u4eba\u6570\uff1a" + message;
                } else if (StringUtils.isNotEmpty((String)st.getCell(22, j).getContents().trim())) {
                    shop.setPromotionNumber(Long.valueOf(st.getCell(22, j).getContents().trim()));
                }
                message = this.validateLongIsNull(st.getCell(23, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u4e13\u67dc\u4e2a\u6570\uff1a" + message;
                } else if (StringUtils.isNotEmpty((String)st.getCell(23, j).getContents().trim())) {
                    shop.setShoppeNumber(Long.valueOf(st.getCell(23, j).getContents().trim()));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(24, j).getContents(), selectTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u662f\u5426\u9ed8\u8ba4\u63a5\u53d7\u5e93\u5b58 \uff1a" + message;
                } else {
                    shop.setIsReceiveAllot(StringUtils.isEmpty((String)st.getCell(24, j).getContents().trim()) ? "N" : (String)selectTypeMap.get(st.getCell(24, j).getContents()));
                }
                message = this.validateDate(st.getCell(25, j).getContents());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5f00\u59cb\u65f6\u95f4 \uff1a" + message;
                } else {
                    shop.setStartDate(DateUtils.formDate((String)st.getCell(25, j).getContents().trim(), (String)FORMDATE_2));
                }
                message = this.validateDateIsNull(st.getCell(26, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7ed3\u675f\u65f6\u95f4 \uff1a" + message;
                } else if (StringUtils.isNotEmpty((String)st.getCell(26, j).getContents().trim())) {
                    shop.setEndDate(DateUtils.formDate((String)st.getCell(26, j).getContents().trim(), (String)FORMDATE_2));
                }
                message = this.shopService.validateShopUnique(st.getCell(0, j).getContents().trim(), st.getCell(9, j).getContents().trim(), st.getCell(13, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u6d88\u606f \uff1a" + message;
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                list.add(shop);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            Shop t1 = null;
            Shop t2 = null;
            String s1 = null;
            String s2 = null;
            String clientNo1 = null;
            String clientNo2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getParentDealerId()) + t1.getShopName() + t1.getAddressDetails() + t1.getOuterClientNo();
                clientNo1 = t1.getOuterClientNo();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getParentDealerId()) + t2.getShopName() + t2.getAddressDetails() + t2.getOuterClientNo();
                    clientNo2 = t2.getOuterClientNo();
                    if (StringUtils.isNotEmpty((String)clientNo1) && StringUtils.isNotEmpty((String)clientNo2) && clientNo1 == clientNo2) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u5916\u56f4\u5ba2\u6237\u7aef\u7f16\u53f7\u91cd\u590d\uff1a" + clientNo1));
                    }
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            if (megs.size() > 0) {
                return megs;
            }
            rwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    private Map<String, String> getRegionMap(Employee me) {
        List<Region> list = this.regionService.getBigAreas(me.getCurrentPartner().getOrganizationid());
        HashMap<String, String> map = new HashMap<String, String>();
        for (Region r : list) {
            map.put(r.getRegionName(), r.getId());
        }
        return map;
    }

    private Map<String, String> getAreaMap(Employee me) {
        List<Region> list = this.regionService.getAreas(me.getCurrentPartner().getId());
        HashMap<String, String> map = new HashMap<String, String>();
        for (Region r : list) {
            map.put(r.getRegionName(), r.getId());
        }
        return map;
    }

    public String validateDateIsNull(Object object) {
        String s = (String)object;
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(FORMDATE);
            sdf.parse(s);
        }
        catch (Exception exception) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(FORMDATE_2);
                sdf.parse(s);
            }
            catch (ParseException parseException) {
                return "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef";
            }
        }
        return null;
    }

    public String validateDate(Object object) {
        String dateStr = (String)object;
        if (StringUtils.isEmpty((String)dateStr)) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(FORMDATE);
            sdf.parse(dateStr.trim());
        }
        catch (Exception exception) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(FORMDATE_2);
                sdf.parse(dateStr.trim());
            }
            catch (ParseException parseException) {
                return "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef";
            }
        }
        return null;
    }

    public String validateOutCilentNo(String outClientNo) {
        boolean flag = this.shopService.validateSiebelCilentNo(null, outClientNo, "");
        if (!flag) {
            return String.valueOf(outClientNo) + " \u5df2\u7ecf\u88ab\u5360\u7528";
        }
        return null;
    }

    private String validaShopName(Employee me, Object obj1, Object obj2, Object obj3) {
        String shopName = (String)obj1;
        String address = (String)obj2;
        String outerClientNo = (String)obj3;
        if (StringUtils.isEmpty((String)shopName)) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002";
        }
        Shop shop = new Shop();
        shop.setAddressDetails(address);
        shop.setOuterClientNo(outerClientNo);
        boolean flag = this.shopService.validateShopViewName(me.getCurrentPartner().getId(), "", shop);
        if (!flag) {
            return String.valueOf(shopName) + " \u5df2\u7ecf\u5b58\u5728";
        }
        return null;
    }

    private Map<String, String> getItenMap(String type) {
        List<DictionaryItem> items = Cache.getItems(type);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DictionaryItem dictionaryItem : items) {
            map.put(dictionaryItem.getVal(), dictionaryItem.getName());
        }
        return map;
    }

    public String validateLongIsNull(Object object) {
        if (object == null) {
            return null;
        }
        String s = String.valueOf(object).trim();
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        try {
            Long.parseLong(String.valueOf(object).trim());
        }
        catch (Exception exception) {
            return "\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002";
        }
        return null;
    }

    public static String str(String str) {
        if (str == null || "".equals(str.trim()) || "NULL".equals(str.toUpperCase())) {
            str = "";
        }
        return str.trim();
    }

    public void initMap(Map<String, String> cusMap, String partnerId, String userId) {
        List<Customer> list = this.clientService.findRegionApplys(partnerId, userId);
        for (Customer customer : list) {
            cusMap.put(customer.getApplyerCode(), customer.getApplyerId());
        }
    }
}

