/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.shop;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.dataSynchro.DataSynchroHandleService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.ContactRegion;
import com.tcbj.crm.entity.ContactShop;
import com.tcbj.crm.entity.PartnerAndShop;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.entity.ShopAddress;
import com.tcbj.crm.entity.ShopContacts;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.shop.PersonShopCondition;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.shop.ShopReportCondition;
import com.tcbj.crm.siebel.service.ShopSiebelService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.ShopAccountView;
import com.tcbj.crm.view.ShopView;
import com.tcbj.crm.view.ShopViewAddress;
import com.tcbj.crm.view.ShopViewContats;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="shopService")
public class ShopService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private StorageService storageService;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    DataSynchroHandleService dataSynchroHandle;
    private String organizationId = StringUtils.getOrgId();

    public Page findShopApplys(ShopCondition condition, Employee e, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append(" select s  from Shop s  where s.applyType=? ");
        if ("update".equals(condition.getApplyType())) {
            args.add(ShopEnum.ApplyType.edit.getValue());
        } else {
            args.add(ShopEnum.ApplyType.add.getValue());
        }
        HQL.append(" and ( sysdate <= s.endDate or s.endDate is null )");
        HQL.append(" and s.creatorId = ? ");
        args.add(e.getId());
        if (!StringUtils.isEmpty(condition.getName())) {
            HQL.append(" and s.shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getShopNumber())) {
            HQL.append(" and s.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
            HQL.append(" and s.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            HQL.append(" and s.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getShopType())) {
            HQL.append(" and s.shopType=? ");
            args.add(condition.getShopType());
        }
        if (StringUtils.isNotEmpty(condition.getProvinceId())) {
            HQL.append(" and s.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (StringUtils.isNotEmpty(condition.getCityId())) {
            HQL.append(" and s.cityId=? ");
            args.add(condition.getCityId());
        }
        if (StringUtils.isNotEmpty(condition.getCountyId())) {
            HQL.append(" and s.countyId=? ");
            args.add(condition.getCountyId());
        }
        HQL.append(" order by s.createDt desc,s.lastUpdateDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Shop getShopById(String id) {
        Shop shop = (Shop)this.baseDao.get(Shop.class, (Serializable)((Object)id));
        shop.setAddresses(this.getAdress(id));
        shop.setContactses(this.getContacts(id));
        shop.setParStrAssign(this.loadPartnerStrAssign(shop.getParentDealerId()));
        return shop;
    }

    public Shop sendShopById(Shop shopNew, Employee me) {
        String id = Beans.isEmpty((Object)shopNew.getId()) ? "" : shopNew.getId();
        Shop shop = (Shop)this.baseDao.get(Shop.class, (Serializable)((Object)id));
        List<ShopAddress> ListAddress = this.getAdress(id);
        List<ShopContacts> ListContacts = this.getContacts(id);
        HashMap<String, ShopAddress> mapAddress = new HashMap<String, ShopAddress>();
        for (ShopAddress address : ListAddress) {
            mapAddress.put(address.getId(), address);
        }
        for (ShopAddress address : shopNew.getAddresses()) {
            address.fillInitData((ShopAddress)mapAddress.get(address.getId()), me);
        }
        HashMap<String, ShopContacts> mapContacts = new HashMap<String, ShopContacts>();
        for (ShopContacts contact : ListContacts) {
            mapContacts.put(contact.getId(), contact);
        }
        for (ShopContacts contact : shopNew.getContactses()) {
            contact.fillInitData((ShopContacts)mapContacts.get(contact.getId()), me);
        }
        shopNew.fillInitData(shop, me);
        if (Beans.isEmpty((Object)id)) {
            return shopNew;
        }
        Beans.copy((Object)shop, (Object)shopNew);
        shop.setAddresses(shopNew.getAddresses());
        shop.setContactses(shopNew.getContactses());
        return shop;
    }

    private List<ShopContacts> getContacts(String id) {
        String hql = " from ShopContacts where shopId=? ";
        return this.baseDao.findEntity(hql, new Object[]{id}, ShopContacts.class);
    }

    private List<ShopAddress> getAdress(String id) {
        String hql = " from ShopAddress where shopId=? ";
        return this.baseDao.findEntity(hql, new Object[]{id}, ShopAddress.class);
    }

    public void add(Shop shop, Employee me, String sourceSystem) {
        shop.getId();
        this.baseDao.save((Object)shop);
        for (ShopAddress address : shop.getAddresses()) {
            if (StringUtils.isNotEmpty(address.getId())) {
                address.setSiebelAddressId(address.getId());
            }
            address.setShopId(shop.getId());
            address.fillInitData(me);
            this.baseDao.save((Object)address);
        }
        for (ShopContacts contacts : shop.getContactses()) {
            if (StringUtils.isNotEmpty(contacts.getId())) {
                contacts.setSiebelContactsId(contacts.getId());
            }
            contacts.setShopId(shop.getId());
            contacts.fillInitData(me);
            this.baseDao.save((Object)contacts);
        }
    }

    public boolean sendMessage(PartnerAndShop shop, String areaId, String applyType) {
        applyType = ShopEnum.ApplyType.add.getValue().equals(applyType) ? "\u65b0\u589e" : "\u4fee\u6539";
        String type = "partner".equals(shop.getType()) ? "\u5206\u9500\u5546/\u8fde\u9501\u603b\u5e97" : "\u95e8\u5e97";
        String msg = "\u8bf7\u60a8\u767b\u9646\u9500\u552e\u670d\u52a1\u5e73\u53f0\u5ba1\u6838\u5ba2\u6237\u65b0\u589e/\u4fee\u6539\u7684\u95e8\u5e97\u4fe1\u606f\uff1a\u7ecf\u9500\u5546\u540d\u79f0\u4e3a\uff1a" + Cache.getPartnerName(shop.getParentPartnerId());
        msg = String.valueOf(msg) + "\u3002" + type + "\uff1a" + shop.getName();
        msg = String.valueOf(msg) + "\u3002\u7f16\u53f7\uff1a" + shop.getNo();
        msg = String.valueOf(msg) + "\u3002\u7701\u4efd\uff1a" + shop.getProvince();
        msg = String.valueOf(msg) + "\u3002\u57ce\u5e02\uff1a" + shop.getCity();
        msg = String.valueOf(msg) + "\u3002\u5730\u5740\uff1a" + shop.getAddressDetails();
        msg = String.valueOf(msg) + "\u3002\u7533\u8bf7\u65f6\u95f4\u4e3a\uff1a" + DateUtils.formartDate2((Date)new Date(), (String)"yyyyMMdd");
        msg = String.valueOf(msg) + "\u3002\u8bf7\u5ba1\u6838\u7684\u65f6\u5019\u8865\u5145\u95e8\u5e97\u7c7b\u578b\u3001\u95e8\u5e97\u5b50\u7c7b\u578b\u7b49\u5fc5\u586b\u4fe1\u606f\uff0c\u4ee5\u4e0a\uff0c\u8bf7\u4e86\u89e3\uff01";
        Partner parentPartner = Cache.getPartner(shop.getParentPartnerId());
        Map<String, PartnerContact> employees = Cache.getEmployees();
        Customer customer = Cache.getCustomer(String.valueOf(parentPartner.getMasterOuId()) + "-" + parentPartner.getId());
        employees.get(customer.getCityManagerId());
        String cursor = "0";
        if ("0".equals(cursor)) {
            Region region = Cache.getRegions(areaId);
            Region parentRegion = Cache.getRegions(region.getParentId());
            String hql = "from ContactRegion where ";
            hql = Beans.isEmpty((Object)parentRegion) ? String.valueOf(hql) + "regionId = '" + areaId + "'" : String.valueOf(hql) + "regionId in ('" + areaId + "','" + parentRegion.getId() + "')";
            List ContactRegions = this.baseDao.findEntity(hql, new Object[0], ContactRegion.class);
            for (ContactRegion contactRegion : ContactRegions) {
                String areaManPhone;
                PartnerContact partnerContact = employees.get(contactRegion.getUserId());
                if (partnerContact == null || !"Company Area Man".equals(partnerContact.getDutyTypeCode()) || !StringUtils.isNotEmpty(areaManPhone = partnerContact.getMobile()) || !StringUtils.matchPhone(areaManPhone)) continue;
                String sql = "insert into sms_send(massID,phone,content,state,submit_time,sendtype,Username,Password,Biz_type) values(?,?,?,?,?,?,?,?,?)";
                Object[] args = new Object[]{UUIDUtils.getId(), areaManPhone, msg, "0", new Date(), "1", "admin", "123456", "1"};
                this.baseDao.executeSQL(sql, args);
                cursor = "2";
            }
        }
        if ("1".equals(cursor)) {
            return true;
        }
        return "2".equals(cursor);
    }

    public void update(Shop shop, Employee me, String sourceSystem) {
        Object[] args = new Object[]{shop.getId()};
        this.baseDao.update((Object)shop);
        this.baseDao.executeHQL("delete ShopAddress where shopId=?", args);
        this.baseDao.executeHQL("delete ShopContacts where shopId=?", args);
        for (ShopAddress address : shop.getAddresses()) {
            address.setShopId(shop.getId());
            address.fillInitData(me);
            this.baseDao.save((Object)address);
        }
        for (ShopContacts contact : shop.getContactses()) {
            contact.setShopId(shop.getId());
            contact.fillInitData(me);
            this.baseDao.save((Object)contact);
        }
    }

    public void del(String id) {
        Shop shop = (Shop)this.baseDao.get(Shop.class, (Serializable)((Object)id));
        if (!shop.getApproveState().equals(ShopEnum.ApproveState.draft.getValue())) {
            throw new AppException("2001");
        }
        Object[] args = new Object[]{shop.getId()};
        this.baseDao.executeHQL("delete ShopAddress where shopId=?", args);
        this.baseDao.executeHQL("delete ShopContacts where shopId=?", args);
        this.baseDao.executeHQL("delete Shop where id=?", args);
    }

    public Page findShopAudits(ShopCondition condition, int pageno, Employee me) {
        return this.getOrgManageShops(condition, pageno, me);
    }

    private Page getOrgManageShops(ShopCondition condition, int pageno, Employee me) {
        StringBuilder HQL = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(me.getId());
        HQL.append(" select s  from Shop s ,Region r  where s.areaId=r.id  ");
        HQL.append("  and s.areaId in ( ");
        HQL.append(regions);
        HQL.append(" )");
        if ("dealed".equals(condition.getAuditType())) {
            HQL.append(" and ( s.approveState= ? or s.approveState=?) and  s.startDate <= ? and ( ? < s.endDate or s.endDate is null) ");
            args.add(ShopEnum.ApproveState.pass.getValue());
            args.add(ShopEnum.ApproveState.notpass.getValue());
            args.add(new Date());
            args.add(new Date());
        }
        if (StringUtils.isNotEmpty(condition.getName())) {
            HQL.append(" and s.shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getShopNumber())) {
            HQL.append(" and s.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
            HQL.append(" and s.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            HQL.append(" and s.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getShopType())) {
            HQL.append(" and s.shopType=? ");
            args.add(condition.getShopType());
        }
        if (StringUtils.isNotEmpty(condition.getProvinceId())) {
            HQL.append(" and s.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (StringUtils.isNotEmpty(condition.getCityId())) {
            HQL.append(" and s.cityId=? ");
            args.add(condition.getCityId());
        }
        if (StringUtils.isNotEmpty(condition.getCountyId())) {
            HQL.append(" and s.countyId=? ");
            args.add(condition.getCountyId());
        }
        if ("dealing".equals(condition.getAuditType())) {
            HQL.append(" and s.approveState = ? and s.applyType in ( ?,? )");
            args.add(ShopEnum.ApproveState.audit.getValue());
            args.add(ShopEnum.ApplyType.add.getValue());
            args.add(ShopEnum.ApplyType.edit.getValue());
        }
        HQL.append(" order by s.createDt DESC,s.lastUpdateDt desc  ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    private Page getRegionManagerShops(ShopCondition condition, int pageno, Employee me) {
        StringBuilder HQL = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        Set<String> regions = this.personnelService.getRegionsByDutyType(me.getId());
        HQL.append(" select s  from Shop s ,Region r where s.areaId=r.id ");
        if (regions.size() > 0) {
            HQL.append("  and s.areaId in ( ");
            int i = 0;
            while (i < regions.size()) {
                HQL.append(i == 0 ? "?" : ",? ");
                ++i;
            }
            for (String id : regions) {
                args.add(id);
            }
            HQL.append(" )");
            HQL.append(" and  s.startDate <= ? and ( ? < s.endDate or s.endDate is null)");
            args.add(new Date());
            args.add(new Date());
            if ("dealing".equals(condition.getAuditType())) {
                HQL.append(" and s.approveState = ? and s.applyType in ( ?,? )");
                args.add(ShopEnum.ApproveState.audit.getValue());
                args.add(ShopEnum.ApplyType.add.getValue());
                args.add(ShopEnum.ApplyType.edit.getValue());
            }
            if ("dealed".equals(condition.getAuditType())) {
                HQL.append(" and ( s.approveState= ? or s.approveState=?)");
                args.add(ShopEnum.ApproveState.pass.getValue());
                args.add(ShopEnum.ApproveState.notpass.getValue());
            }
            if (StringUtils.isNotEmpty(condition.getName())) {
                HQL.append(" and s.shopName like ?");
                args.add("%" + condition.getName().trim() + "%");
            }
            if (StringUtils.isNotEmpty(condition.getShopNumber())) {
                HQL.append(" and s.shopNumber like ? ");
                args.add("%" + condition.getShopNumber() + "%");
            }
            if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
                HQL.append(" and s.bigAreaId=?");
                args.add(condition.getBigAreaId());
            }
            if (StringUtils.isNotEmpty(condition.getAreaId())) {
                HQL.append(" and areaId= ? ");
                args.add(condition.getAreaId());
            }
            if (StringUtils.isNotEmpty(condition.getShopType())) {
                HQL.append(" and s.shopType=? ");
                args.add(condition.getShopType());
            }
            if (StringUtils.isNotEmpty(condition.getProvinceId())) {
                HQL.append(" and s.provinceId=? ");
                args.add(condition.getProvinceId());
            }
            if (StringUtils.isNotEmpty(condition.getCityId())) {
                HQL.append(" and cityId=? ");
                args.add(condition.getCityId());
            }
            if (StringUtils.isNotEmpty(condition.getCountyId())) {
                HQL.append(" and s.countyId=? ");
                args.add(condition.getCountyId());
            }
            HQL.append(" order by s.createDt DESC,s.lastUpdateDt desc  ");
            return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        }
        return null;
    }

    public void saveAudit(String id, String approveState, Employee me, String approveRemark, String type) {
        String siebelId = null;
        if ("2".equals(approveState)) {
            Shop shop = this.getShopById(id);
            ShopSiebelService ss = new ShopSiebelService();
            siebelId = ss.addOrUpdateShopToSiebel(shop, type, me);
            if ("insert".equals(type)) {
                this.storageService.addStorage(siebelId, me);
            }
            String hql = "update Shop set approveState=?,approveRemark=?,auditorId=?,auditDate=?,siebelShopId=? where id=?";
            Object[] args = new Object[]{approveState, approveRemark, me.getId(), DateUtils.now(), siebelId, id};
            this.baseDao.executeHQL(hql, args);
            String hql2 = "update PartnerAndShop set approveState=?,approveRemark=?,auditorId=?,auditDate=?,siebelShopId=?,dssIfaceFlag=?,sfaIfaceFlag=? where crmId=?";
            Object[] args2 = new Object[]{approveState, approveRemark, me.getId(), DateUtils.now(), siebelId, "0", "0", id};
            this.baseDao.executeHQL(hql2, args2);
        } else {
            String hql = "update Shop set approveState=?,approveRemark=?,auditorId=?,auditDate=? where id=?";
            Object[] args = new Object[]{approveState, approveRemark, me.getId(), DateUtils.now(), id};
            this.baseDao.executeHQL(hql, args);
            String hql2 = "update PartnerAndShop set approveState=?,approveRemark=?,auditorId=?,auditDate=?,dssIfaceFlag=?,sfaIfaceFlag=? where crmId=?";
            Object[] args2 = new Object[]{approveState, approveRemark, me.getId(), DateUtils.now(), "0", "0", id};
            this.baseDao.executeHQL(hql2, args2);
        }
    }

    @Transactional
    public Shop saveAudit(Shop shopNew, Employee me, String type) {
        String siebelId = null;
        PartnerAndShop partnerAndShop = (PartnerAndShop)this.baseDao.findFirstEntity("from PartnerAndShop where no = ? and type = 'Store' and orgId = ? ", new Object[]{shopNew.getShopNumber(), StringUtils.getOrgId()}, PartnerAndShop.class);
        this.updateShopAndPar(shopNew, partnerAndShop, me);
        Shop shop = this.sendShopById(shopNew, me);
        if ("2".equals(shopNew.getApproveState())) {
            ShopSiebelService ss = new ShopSiebelService();
            try {
                siebelId = ss.addOrUpdateShopToSiebel(shop, type, me);
            }
            catch (Exception exception) {
                throw new AppException("8001");
            }
            if ("insert".equals(type)) {
                this.storageService.addStorage(siebelId, me);
            }
            shop.setSiebelShopId(siebelId);
            shop.setSiebelShopIdNew(siebelId);
        }
        this.baseDao.update((Object)shop);
        Object[] args = new Object[]{shop.getId()};
        this.baseDao.executeHQL("delete ShopAddress where shopId=?", args);
        this.baseDao.executeHQL("delete ShopContacts where shopId=?", args);
        for (ShopAddress address : shop.getAddresses()) {
            if (StringUtils.isNotEmpty(address.getId())) {
                address.setSiebelAddressId(address.getId());
            }
            address.setShopId(shop.getId());
            this.baseDao.save((Object)address);
        }
        for (ShopContacts contacts : shop.getContactses()) {
            if (StringUtils.isNotEmpty(contacts.getId())) {
                contacts.setSiebelContactsId(contacts.getId());
            }
            contacts.setShopId(shop.getId());
            this.baseDao.save((Object)contacts);
        }
        return shop;
    }

    private void updateShopAndPar(Shop shopNew, PartnerAndShop partnerAndShop, Employee me) {
        shopNew.setAuditDate(DateUtils.now());
        shopNew.setAuditorId(me.getId());
    }

    public Page findShopViews(ShopCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        String regions = this.personnelService.getFRegionsByUserId(me.getId());
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select c from ShopView c where c.orgId=?  ");
        args.add(this.organizationId);
        hql.append(" and not exists( select 1 from Shop s where s.siebelShopId = c.id and s.applyType='2' and s.approveState='1')");
        if (me.getCurrentPartner().isOrg()) {
            hql.append(" and ( c.salseManId=?  ");
            args.add(me.getId());
            hql.append(" or ( ");
            hql.append(" c.areaId in ( ");
            hql.append(regions);
            hql.append(")");
            hql.append(") )");
        } else {
            hql.append(" and c.parentDealerId=? ");
            args.add(me.getCurrentPartner().getId());
        }
        if (StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and c.shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getShopNumber())) {
            hql.append(" and c.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
            hql.append(" and c.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            hql.append(" and c.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getShopType())) {
            hql.append(" and c.shopType=? ");
            args.add(condition.getShopType());
        }
        if (StringUtils.isNotEmpty(condition.getProvinceId())) {
            hql.append(" and c.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (StringUtils.isNotEmpty(condition.getCityId())) {
            hql.append(" and c.cityId=? ");
            args.add(condition.getCityId());
        }
        if (StringUtils.isNotEmpty(condition.getCountyId())) {
            hql.append(" and c.countyId=? ");
            args.add(condition.getCountyId());
        }
        hql.append(" and ( c.endDate >= ? or c.endDate is null ) ");
        args.add(DateUtils.getStartTime());
        hql.append(" order by c.createDt desc ,c.lastUpdateDt desc ");
        System.out.println("-----hql-----" + hql.toString());
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<ShopView> temp = new ArrayList<ShopView>();
        for (ShopView shopView : page.getList()) {
            if (StringUtils.isNotEmpty(shopView.getParentDealerId())) {
                shopView.setParStrAssign(this.loadPartnerStrAssign(shopView.getParentDealerId()));
            }
            temp.add(shopView);
        }
        page.setList(temp);
        return page;
    }

    private String loadPartnerStrAssign(String partnertId) {
        if (StringUtils.isEmpty(partnertId)) {
            return null;
        }
        String sql = " select level, capv.Name from CX_AWK_PARTNERLIST_VIEW capv  where capv.Row_Id <> ? start with capv.Row_Id = ? connect by prior capv.ParPartnerId = capv.Row_Id order by level desc";
        List list = this.baseDao.findBySql(sql, new Object[]{partnertId, partnertId});
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)partnertId));
        ArrayList<Partner> paList = new ArrayList<Partner>();
        for (Object[] obj : list) {
            Partner p = new Partner();
            p.setName((String)obj[1]);
            paList.add(p);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < paList.size()) {
            sb.append(i % 2 == 0 ? ((Partner)paList.get(i)).getName() : "--->" + ((Partner)paList.get(i)).getName());
            ++i;
        }
        sb.append(StringUtils.isEmpty(sb.toString()) ? partner.getName() : "--->" + partner.getName());
        return sb.toString();
    }

    public ShopView getShopView(String siebelShopId) {
        ShopView shopView = (ShopView)this.baseDao.get(ShopView.class, (Serializable)((Object)siebelShopId));
        String hql = "from  ShopViewContats where shopId=? and isContact='Y'";
        String hql_1 = "  from ShopViewAddress  where shopId=?";
        String hql_2 = " from  ShopAccountView where partnerid=? and orgId=? ";
        ShopAccountView sav = (ShopAccountView)this.baseDao.findFirstEntity(hql_2, new Object[]{shopView.getId(), shopView.getParentDealerId()}, ShopAccountView.class);
        if (sav != null) {
            String shopId = sav.getId();
            shopView.setAddresses(this.baseDao.findEntity(hql_1, new Object[]{shopId}, ShopViewAddress.class));
        }
        shopView.setContacts(this.baseDao.findEntity(hql, new Object[]{siebelShopId}, ShopViewContats.class));
        shopView.setParStrAssign(this.loadPartnerStrAssign(shopView.getParentDealerId()));
        return shopView;
    }

    public Page findShopRecords(ShopCondition condition, String siebelId, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Shop where siebelShopId=?");
        args.add(siebelId);
        if (StringUtils.isNotEmpty(condition.getName())) {
            HQL.append(" and shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getShopNumber())) {
            HQL.append(" and shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
            HQL.append(" and bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            HQL.append(" and areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getShopType())) {
            HQL.append(" and shopType=? ");
            args.add(condition.getShopType());
        }
        if (StringUtils.isNotEmpty(condition.getProvinceId())) {
            HQL.append(" and provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (StringUtils.isNotEmpty(condition.getCityId())) {
            HQL.append(" and cityId=? ");
            args.add(condition.getCityId());
        }
        if (StringUtils.isNotEmpty(condition.getCountyId())) {
            HQL.append(" and countyId=? ");
            args.add(condition.getCountyId());
        }
        HQL.append(" order by createDt desc ,lastUpdateDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<Contact> getSalesMan(String id) {
        String hql = " from  Contact where partnerOrgId= ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, Contact.class);
    }

    public String getSalesManName(String salseManId) {
        Contact contact = (Contact)this.baseDao.get(Contact.class, (Serializable)((Object)salseManId));
        if (contact != null) {
            return contact.getFullname();
        }
        return "";
    }

    public Page getShops(ShopCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from ShopView s where 1=1 and orgId=? ");
        args.add(this.organizationId);
        if (StringUtils.isNotEmpty(con.getParentDealerId())) {
            HQL.append("and s.parentDealerId = ?");
            args.add(con.getParentDealerId());
        }
        if (StringUtils.isNotEmpty(con.getShopType())) {
            HQL.append("and s.shopType = ?");
            args.add(con.getShopType());
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append("and s.shopName like ?");
            args.add("%" + con.getName() + "%");
        }
        if (StringUtils.isNotEmpty(con.getShopNumber())) {
            HQL.append("and s.shopNumber = ?");
            args.add(con.getShopNumber());
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public ShopView getCodeByShop(String code, String supplierId) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from ShopView where parentDealerId=? and shopNumber = ? and orgId=? ");
        args.add(supplierId);
        args.add(code);
        args.add(this.organizationId);
        return (ShopView)this.baseDao.findFirstEntity(HQL.toString(), args.toArray(), ShopView.class);
    }

    public boolean isShop(String code, String supplierId) {
        return !StringUtils.isNotNull(this.getCodeByShop(code, supplierId));
    }

    public Long getDraftShopList(Employee me) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select Count(s) from Shop s where s.applyType=? and s.approveState=? and s.parentDealerId =?");
        ArrayList<String> args = new ArrayList<String>();
        args.add(ShopEnum.ApplyType.add.getValue());
        args.add(ShopEnum.ApproveState.draft.getValue());
        args.add(me.getCurrentPartner().getId());
        Long count = (Long)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Long.class);
        return count;
    }

    public Long getAuditShopCount(Employee me) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select Count(s) from Shop s where s.applyType in ( ?,? ) and s.approveState=? and s.parentDealerId =?");
        ArrayList<String> args = new ArrayList<String>();
        args.add(ShopEnum.ApplyType.add.getValue());
        args.add(ShopEnum.ApplyType.edit.getValue());
        args.add(ShopEnum.ApproveState.audit.getValue());
        args.add(me.getCurrentPartner().getId());
        Long count = (Long)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Long.class);
        return count;
    }

    public boolean isUpdateMeanwhile(String siebelId) {
        return false;
    }

    public String getShopNo() {
        String sql = " select cx_shop_no_seq.CURRVAL from dual ";
        List obj = this.baseDao.findBySql(sql);
        System.out.println("obj====" + obj.get(0));
        return String.valueOf(obj.get(0));
    }

    public boolean validateShopName(Employee me, Shop shop) {
        List shopList;
        String shopName = shop.getShopName();
        String siebelId = shop.getSiebelShopId();
        shop.getId();
        StringBuffer hql = new StringBuffer();
        hql.append(" from Shop where parentDealerId=? and shopName= ? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(me.getCurrentPartner().getId());
        args.add(shopName);
        if (StringUtils.isNotEmpty(siebelId)) {
            hql.append(" and siebelShopId <> ? ");
            args.add(siebelId);
        }
        return (shopList = this.baseDao.findEntity(hql.toString(), args.toArray(), Shop.class)).size() == 0;
    }

    public boolean validateCilentNo(Employee me, Shop shop) {
        String outClientNo = shop.getOuterClientNo().trim();
        String siebelId = shop.getSiebelShopId();
        String shopId = shop.getId();
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isEmpty(org.springframework.util.StringUtils.trimAllWhitespace((String)outClientNo))) {
            return true;
        }
        hql.append(" from Shop where  outerClientNo=? ");
        args.add(outClientNo);
        if (Beans.isNotEmpty((Object)siebelId)) {
            hql.append(" and siebelShopId <> ? ");
            args.add(siebelId);
        } else if (Beans.isNotEmpty((Object)shopId)) {
            hql.append(" and id <> ? ");
            args.add(shopId);
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Shop.class);
        return list.size() == 0;
    }

    public boolean validateShopViewName(String parentDealerId, String siebelId, Shop shop) {
        List shopList;
        String address = shop.getAddressDetails();
        String outerClientNo = shop.getOuterClientNo();
        StringBuffer hql = new StringBuffer();
        hql.append(" from ShopView where parentDealerId=? and shopName= ? and orgId=? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(parentDealerId);
        args.add(shop.getShopName());
        args.add(this.organizationId);
        if (StringUtils.isNotEmpty(address)) {
            hql.append(" and addressDetails = ? ");
            args.add(address);
        }
        if (StringUtils.isNotEmpty(outerClientNo)) {
            hql.append(" and outerClientNo = ? ");
            args.add(outerClientNo);
        }
        if (StringUtils.isNotEmpty(siebelId)) {
            hql.append(" and id<> ? ");
            args.add(siebelId);
        }
        return (shopList = this.baseDao.findEntity(hql.toString(), args.toArray(), ShopView.class)).size() == 0;
    }

    public boolean validateSiebelCilentNo(Employee me, String outClientNo, String siebelId) {
        List list;
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isEmpty(org.springframework.util.StringUtils.trimAllWhitespace((String)outClientNo))) {
            return true;
        }
        hql.append(" from ShopView where  outerClientNo=? and orgId=?");
        args.add(outClientNo);
        args.add(this.organizationId);
        if (Beans.isNotEmpty((Object)siebelId)) {
            hql.append(" and id<> ? ");
            args.add(siebelId);
        }
        return (list = this.baseDao.findEntity(hql.toString(), args.toArray(), ShopView.class)).size() == 0;
    }

    public PartnerContact getCurentSaleMan(String partnerId, String salseManId) {
        if (StringUtils.isNotEmpty(salseManId)) {
            String hql = " from PartnerContact where partnerId=? and id=? ";
            return (PartnerContact)this.baseDao.findFirstEntity(hql, new Object[]{partnerId, salseManId}, PartnerContact.class);
        }
        return null;
    }

    public Page getSelectShop(ShopCondition condition, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select c from ShopView c where 1=1 and orgId=? ");
        hql.append(" and c.id not in(select s.shopId from ContactShop s where s.userId = ? ) ");
        args.add(this.organizationId);
        args.add(condition.getUserId());
        if (StringUtils.isNotEmpty(condition.getName())) {
            condition.setName(condition.getName().replaceAll("\uff0c", ","));
            if (condition.getName().indexOf(",") != -1 && condition.getName().split(",").length > 1) {
                String[] nos = condition.getName().split(",");
                int i = 0;
                while (i < nos.length) {
                    String no = nos[i];
                    no = no.trim().replaceAll("\n", "");
                    if (i == 0) {
                        hql.append(" and ((upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%'))");
                    } else if (i == nos.length - 1) {
                        hql.append(" or (upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%')))");
                    } else {
                        hql.append(" or (upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%'))");
                    }
                    ++i;
                }
            } else {
                hql.append("and (c.shopName like ? or c.shopNumber like ?) ");
                args.add("%" + condition.getName().trim() + "%");
                args.add("%" + condition.getName().trim() + "%");
            }
        }
        if (StringUtils.isNotEmpty(condition.getShopNumber())) {
            hql.append(" and c.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
            hql.append(" and c.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            hql.append(" and c.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getShopType())) {
            hql.append(" and c.shopType=? ");
            args.add(condition.getShopType());
        }
        if (StringUtils.isNotEmpty(condition.getProvinceId())) {
            hql.append(" and c.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (StringUtils.isNotEmpty(condition.getCityId())) {
            hql.append(" and c.cityId=? ");
            args.add(condition.getCityId());
        }
        if (StringUtils.isNotEmpty(condition.getCountyId())) {
            hql.append(" and c.countyId=? ");
            args.add(condition.getCountyId());
        }
        hql.append(" and ( c.endDate >= ? or c.endDate is null ) ");
        args.add(DateUtils.getStartTime());
        hql.append(" order by shopNumber ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), pageno);
        return page;
    }

    public Page getPostShop(ShopCondition condition, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select c from ShopView c where 1=1 and orgId=? ");
        hql.append(" and c.id not in(select s.shopId from PostShop s where s.postId = ? ) ");
        args.add(this.organizationId);
        args.add(condition.getUserId());
        if (StringUtils.isNotEmpty(condition.getName())) {
            condition.setName(condition.getName().replaceAll("\uff0c", ","));
            if (condition.getName().indexOf(",") != -1 && condition.getName().split(",").length > 1) {
                String[] nos = condition.getName().split(",");
                int i = 0;
                while (i < nos.length) {
                    String no = nos[i];
                    no = no.trim().replaceAll("\n", "");
                    if (i == 0) {
                        hql.append(" and ((upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%'))");
                    } else if (i == nos.length - 1) {
                        hql.append(" or (upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%')))");
                    } else {
                        hql.append(" or (upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%'))");
                    }
                    ++i;
                }
            } else {
                hql.append("and (c.shopName like ? or c.shopNumber like ?) ");
                args.add("%" + condition.getName().trim() + "%");
                args.add("%" + condition.getName().trim() + "%");
            }
        }
        if (StringUtils.isNotEmpty(condition.getShopNumber())) {
            hql.append(" and c.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
            hql.append(" and c.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            hql.append(" and c.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getShopType())) {
            hql.append(" and c.shopType=? ");
            args.add(condition.getShopType());
        }
        if (StringUtils.isNotEmpty(condition.getProvinceId())) {
            hql.append(" and c.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (StringUtils.isNotEmpty(condition.getCityId())) {
            hql.append(" and c.cityId=? ");
            args.add(condition.getCityId());
        }
        if (StringUtils.isNotEmpty(condition.getCountyId())) {
            hql.append(" and c.countyId=? ");
            args.add(condition.getCountyId());
        }
        hql.append(" and ( c.endDate >= ? or c.endDate is null ) ");
        args.add(DateUtils.getStartTime());
        hql.append(" order by shopNumber ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), pageno);
        return page;
    }

    public String saveBatchShop(List<Shop> list, Employee me) {
        ShopSiebelService ss = new ShopSiebelService();
        for (Shop shop : list) {
            shop.setShopNumber(this.orderNoService.saveBalanceShopNo("200001", true));
        }
        String msg = ss.addShopToSiebel2(list, "insert", me);
        return msg;
    }

    public Map<String, Object> shopToSiebel(List<Shop> list, Employee me) {
        ShopSiebelService ss = new ShopSiebelService();
        Map<String, Object> map = ss.addShopToSiebel3(list, "insert", me);
        return map;
    }

    public String validateShopUnique(String partnerName, String shopName, String address) {
        List list;
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isEmpty(partnerName) || StringUtils.isEmpty(shopName)) {
            return "\u4e0a\u7ea7\u7ecf\u9500\u5546\u6216\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a\u3002";
        }
        hql.append(" from ShopView s where s.parPartnerName=? and s.shopName=? and orgId=? ");
        args.add(partnerName);
        args.add(shopName);
        args.add(this.organizationId);
        if (StringUtils.isNotEmpty(address)) {
            hql.append(" and s.addressDetails = ? ");
            args.add(address);
        }
        if ((list = this.baseDao.findEntity(hql.toString(), args.toArray(), ShopView.class)).size() > 0) {
            return "\u8be5\u95e8\u5e97\u5df2\u7ecf\u5b58\u5728\u3002";
        }
        return null;
    }

    public List<AdjustStockUtil> update(List<List<Object>> objs, Employee employee) {
        ArrayList<AdjustStockUtil> msgList = new ArrayList<AdjustStockUtil>();
        HashMap<String, String> shopListMap = new HashMap<String, String>();
        HashMap<String, String> partnerContactsMap = new HashMap<String, String>();
        ArrayList<ContactShop> list = new ArrayList<ContactShop>();
        ContactShop t = null;
        int line = 1;
        for (List<Object> item : objs) {
            String scdb;
            String csjl;
            String qyjl;
            ++line;
            String shopNumber = (String)item.get(0);
            if (StringUtils.isEmpty(shopNumber)) {
                msgList.add(new AdjustStockUtil("\u7b2c" + line + "\u884c\uff0c\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
            } else {
                ShopView shopView = (ShopView)this.baseDao.findFirstEntity("from ShopView where shopNumber = ? and orgId=? ", new Object[]{shopNumber, this.organizationId}, ShopView.class);
                if (shopView == null) {
                    msgList.add(new AdjustStockUtil("\u7b2c" + line + "\u884c\uff0c\u95e8\u5e97\u7f16\u53f7\u4e0d\u6b63\u786e\u3002"));
                } else {
                    shopListMap.put(shopView.getShopNumber(), shopView.getId());
                }
            }
            HashSet<String> set = new HashSet<String>();
            if (!StringUtils.isNotEmpty(shopNumber)) continue;
            String dqjl = (String)item.get(2);
            if (StringUtils.isNotEmpty(dqjl)) {
                PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{dqjl}, PartnerContact.class);
                if (partnerContact == null) {
                    msgList.add(new AdjustStockUtil("\u7b2c" + line + "\u884c\uff0c\u5927\u533a\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                } else {
                    set.add(dqjl);
                    partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                }
            }
            if (StringUtils.isNotEmpty(qyjl = (String)item.get(3))) {
                PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{qyjl}, PartnerContact.class);
                if (partnerContact == null) {
                    msgList.add(new AdjustStockUtil("\u7b2c" + line + "\u884c\uff0c\u533a\u57df\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                } else {
                    set.add(qyjl);
                    partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                }
            }
            if (StringUtils.isNotEmpty(csjl = (String)item.get(4))) {
                PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{csjl}, PartnerContact.class);
                if (partnerContact == null) {
                    msgList.add(new AdjustStockUtil("\u7b2c" + line + "\u884c\uff0c\u57ce\u5e02\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                } else {
                    set.add(csjl);
                    partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                }
            }
            if (StringUtils.isNotEmpty(scdb = (String)item.get(5))) {
                PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{scdb}, PartnerContact.class);
                if (partnerContact == null) {
                    msgList.add(new AdjustStockUtil("\u7b2c" + line + "\u884c\uff0c\u5e02\u573a\u4ee3\u8868\u4e0d\u6b63\u786e\u3002"));
                } else {
                    set.add(scdb);
                    partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                }
            }
            for (String name : set) {
                ContactShop contactShop = (ContactShop)this.baseDao.findFirstEntity("from ContactShop where userId = ? and shopId = ? ", new Object[]{partnerContactsMap.get(name), shopListMap.get(shopNumber)}, ContactShop.class);
                if (contactShop != null || !StringUtils.isNotEmpty((String)partnerContactsMap.get(name)) || shopListMap.get(shopNumber) == null || !StringUtils.isNotEmpty((String)shopListMap.get(shopNumber))) continue;
                t = new ContactShop();
                t.setShopId((String)shopListMap.get(shopNumber));
                t.setUserId((String)partnerContactsMap.get(name));
                t.setCreateDt(new Date());
                t.setStartDate(new Date());
                t.setLastUpdateDt(new Date());
                t.setLastUpdatorId("0-8");
                t.setCreatorId("0-8");
                list.add(t);
            }
        }
        if (msgList.size() > 0) {
            return msgList;
        }
        if (list.size() > 0) {
            this.baseDao.save(list);
            this.dataSynchroHandle.saveThread(list, Constant.CspDataSynchro.perShop_batchAdd.value, employee);
        }
        return msgList;
    }

    public Page findShopReport(ShopReportCondition condition, Contact ep, int pageno) {
        String shopNo = "";
        if (!"Order Manager".equals(ep.getRoletype())) {
            String hql = "select s from ContactShop c,ShopView s where c.shopId = s.id and c.userId = ? and s.orgId=? ";
            List shopList = this.baseDao.findEntity(hql, new Object[]{ep.getId(), this.organizationId}, ShopView.class);
            for (ShopView shopView : shopList) {
                shopNo = String.valueOf(shopNo) + "'" + shopView.getShopNumber() + "',";
            }
        }
        ArrayList args = new ArrayList();
        StringBuffer sb = new StringBuffer();
        sb.append(" select * from (SELECT b.bh_one_level_accountname as dealerName, b.bh_one_level_channelname as bigAreaName,  ");
        sb.append(" b.bh_two_level_channelname as areaName, b. bh_three_level_channelname as orgName,b.bh_no as shopNo, ");
        sb.append("  b.bh_name as shopName,b.bh_storeid as id, c.last_name AS personName, c.CELL_PH_NUM AS mobile, ");
        sb.append(" (case when CON_CD = 'Chain Manager' then  '\u8fde\u9501\u7ba1\u7406\u8005'  when CON_CD = 'City Manager' then  '\u57ce\u5e02\u7ecf\u7406'");
        sb.append(" when CON_CD = 'Consumer' then '\u6d88\u8d39\u8005'  when CON_CD = 'DataManager' then  '\u6570\u636e\u7ba1\u7406\u4eba\u5458'");
        sb.append(" when CON_CD = 'Distict Manager' then '\u5927\u533a\u7ecf\u7406'  when CON_CD = 'Order Manager' then  '\u8ba2\u5355\u4e13\u5458' ");
        sb.append(" when CON_CD = 'Purchase Manager' then   '\u91c7\u8d2d\u7ecf\u7406'  when CON_CD = 'Region Manager' then  '\u533a\u57df\u7ecf\u7406' ");
        sb.append(" when CON_CD = 'Sales Clerk' then   '\u5e97\u5458'  when CON_CD = 'Sales Promoter' then  '\u4fc3\u9500\u5458' ");
        sb.append(" when CON_CD = 'Store Manager' then  '\u5e97\u957f'   when CON_CD = 'SysAdmin' then 'SysAdmin'   else  ''  end)  ");
        sb.append("as duty,");
        sb.append("  b.bh_supper_storeno as multipleNo,  b.bh_supper_storename as multipleName, ");
        sb.append("  SUM(MEMACCRUEPOINTS) AS newMemAccruePoints, SUM(MEMNUM) as memAmount, SUM(NEWMEMNUM) as newMemAmount ");
        sb.append(" FROM ");
        sb.append(" ( ");
        sb.append(" SELECT BH_STOREID,  BH_STORE_CLERKID,  SUM(MEMACCRUEPOINTS) AS MEMACCRUEPOINTS,  0 AS MEMNUM, 0 AS NEWMEMNUM ");
        sb.append(" FROM CX_AWK_STORE_MEMBER_POINTS  WHERE CREATEDON BETWEEN to_date('").append(condition.getcDate());
        sb.append("','yyyyMMdd') AND to_date('").append(condition.geteDate()).append("','yyyyMMdd')");
        sb.append(" GROUP BY BH_STOREID, BH_STORE_CLERKID ");
        sb.append(" union all ");
        sb.append(" SELECT BH_STOREID,  BH_STORE_CLERKID, 0 AS MEMACCRUEPOINTS,  count(distinct bh_contactid) AS MEMNUM,   0 AS NEWMEMNUM ");
        sb.append(" FROM CX_AWK_STORE_MEMBER_detail  WHERE rtype = 1 and CREATEDON BETWEEN to_date('").append(condition.getcDate());
        sb.append("' , 'yyyyMMdd') AND  to_date('").append(condition.geteDate()).append("' , 'yyyyMMdd') ");
        sb.append(" GROUP BY BH_STOREID, BH_STORE_CLERKID");
        sb.append(" union all ");
        sb.append(" SELECT BH_STOREID,  BH_STORE_CLERKID,   0 AS MEMACCRUEPOINTS,   0 AS MEMNUM,   count(distinct bh_contactid) AS NEWMEMNUM");
        sb.append(" FROM CX_AWK_STORE_MEMBER_detail  WHERE rtype = 2 and CREATEDON BETWEEN to_date('").append(condition.getcDate());
        sb.append("' , 'yyyyMMdd') AND  to_date('").append(condition.geteDate()).append("' , 'yyyyMMdd') ");
        sb.append(" GROUP BY BH_STOREID, BH_STORE_CLERKID ");
        sb.append(" ) A ");
        sb.append(" LEFT OUTER JOIN ");
        sb.append(" ( SELECT ");
        sb.append(" (case  when NVL(CCSN, '9999') IN ('TCBJ', '9999') THEN (CASE  WHEN NVL(BCSN, '9999') IN ('TCBJ', '9999') THEN ANAME  ELSE  BNAME  END)   ELSE  CNAME  END) ");
        sb.append("AS bh_one_level_accountname, ");
        sb.append(" (CASE WHEN e.REGION_NAME = '\u4f70\u5065\u8425\u517b\u4e2d\u5fc3' THEN  '\u4f70\u5065'  WHEN e.REGION_NAME = '\u5b89\u5fbd\u533a' THEN 'TBC'   ELSE  e.REGION_NAME  END)");
        sb.append("as bh_one_level_channelname, ");
        sb.append(" (CASE WHEN d.REGION_NAME = '\u8425\u517b\u4e2d\u5fc3' THEN   '\u4f70\u5065'  WHEN d.REGION_NAME = '\u6e56\u5317\u4e00\u533a' THEN   '\u6e56\u53171\u533a'   WHEN d.REGION_NAME = '\u6e56\u5317\u4e8c\u533a' ");
        sb.append(" THEN  '\u6e56\u53172\u533a'   WHEN d.REGION_NAME = '\u56db\u5ddd\u4e00\u533a' THEN  '\u56db\u5ddd1\u533a'  WHEN d.REGION_NAME = '\u56db\u5ddd\u4e8c\u533a' THEN  '\u56db\u5ddd2\u533a'   ELSE   d.REGION_NAME    END)");
        sb.append("As bh_two_level_channelname,");
        sb.append(" city as bh_three_level_channelname,  csn as bh_no,   name as bh_name,   c.row_id as bh_storeid,  smname as bh_manager, ");
        sb.append(" smphone as bh_manager_telephone, position as bh_manager_position,  c.acsn as bh_supper_storeno,  c.aname as bh_supper_storename ");
        sb.append(" FROM cx_awk_rptpartner_forgw c  left outer JOIN S_ORG_PRTNR b   on c.row_id = b.par_ROW_ID  ");
        sb.append(" left outer join CX_REGION_MAIN e on b.X_DISTRICT_ID = e.ROW_ID ");
        sb.append(" left outer join CX_REGION_MAIN d  on b.X_REGION_ID = d.ROW_ID  ");
        sb.append(" ) B ");
        sb.append(" on A.BH_STOREID = B.bh_storeid ");
        sb.append(" left outer join S_CONTACT c  on a.BH_STORE_CLERKID = c.ROW_iD");
        sb.append(" GROUP BY b.bh_one_level_accountname,   b.bh_one_level_channelname, b.bh_two_level_channelname, ");
        sb.append(" b. bh_three_level_channelname, a.BH_STORE_CLERKID,b.bh_no,   b.bh_name,   b.bh_storeid, ");
        sb.append(" c.last_name,   c.CELL_PH_NUM,  c.CON_CD,   b.bh_supper_storeno,   b.bh_supper_storename");
        sb.append(") t1 where 1=1 ");
        if (!StringUtils.isEmpty(shopNo)) {
            shopNo = shopNo.substring(0, shopNo.length() - 1);
            sb.append(" and t1.shopNo in (").append(shopNo).append(") ");
        }
        if (!StringUtils.isEmpty(condition.getShopNo())) {
            sb.append(" and t1.shopNo like '%").append(condition.getShopNo()).append("%' ");
        }
        if (!StringUtils.isEmpty(condition.getShopName())) {
            sb.append(" and t1.shopName like '%").append(condition.getShopName()).append("%' ");
        }
        if (!StringUtils.isEmpty(condition.getBigAreaName())) {
            sb.append(" and t1.bigAreaName like '%").append(condition.getBigAreaName()).append("%' ");
        }
        if (!StringUtils.isEmpty(condition.getAreaName())) {
            sb.append(" and t1.areaName like '%").append(condition.getAreaName()).append("%' ");
        }
        if (!StringUtils.isEmpty(condition.getMultipleNo())) {
            sb.append(" and t1.multipleNo like '%").append(condition.getMultipleNo()).append("%' ");
        }
        if (!StringUtils.isEmpty(condition.getMultipleName())) {
            sb.append(" and t1.multipleName like '%").append(condition.getMultipleName()).append("%' ");
        }
        new ArrayList();
        Page page = this.baseDao.searchBySql(sb.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, null);
        ArrayList<ShopReportCondition> listReport = new ArrayList<ShopReportCondition>();
        List listObj = page.getList();
        for (Object[] objects : listObj) {
            ShopReportCondition report = new ShopReportCondition();
            report.setDealerName(this.checkEmp(objects[0]));
            report.setBigAreaName(this.checkEmp(objects[1]));
            report.setAreaName(this.checkEmp(objects[2]));
            report.setOrgName(this.checkEmp(objects[3]));
            report.setShopNo(this.checkEmp(objects[4]));
            report.setShopName(this.checkEmp(objects[5]));
            report.setId(this.checkEmp(objects[6]));
            report.setPersonName(this.checkEmp(objects[7]));
            report.setMobile(this.checkEmp(objects[8]));
            report.setDuty(this.checkEmp(objects[9]));
            report.setMultipleNo(this.checkEmp(objects[10]));
            report.setMultipleName(this.checkEmp(objects[11]));
            report.setIntegral(this.checkEmp(objects[12]));
            report.setCustomerMun(this.checkEmp(objects[13]));
            report.setCustomerMunNew(this.checkEmp(objects[14]));
            listReport.add(report);
        }
        page.setList(listReport);
        return page;
    }

    public String checkEmp(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    private Map<String, Object> convertArrayToMap(String[] keys, Object[] array) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Object value = null;
            if (array.length > i) {
                value = array[i];
            }
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public boolean excels(List<PersonShopCondition> list, String path, Employee emp, HttpServletResponse response) {
        String name = String.valueOf(emp.getCurrentPartner().getNo()) + "-\u4eba\u5e97\u5173\u7cfb\u8868-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls";
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u59d3\u540d", "\u5de5\u53f7", "\u624b\u673a\u53f7\u7801", "\u95e8\u5e97\u540d\u79f0", "\u95e8\u5e97\u7f16\u53f7", "\u95e8\u5e97\u5730\u5740", "\u4e0a\u7ea7\u7ecf\u9500\u5546"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            PersonShopCondition con = list.get(i);
            row.createCell(0).setCellValue(this.checkEmp(con.getFullName()));
            row.createCell(1).setCellValue(this.checkEmp(con.getEmpNo()));
            row.createCell(2).setCellValue(this.checkEmp(con.getPhoneNumber()));
            row.createCell(3).setCellValue(this.checkEmp(con.getName()));
            row.createCell(4).setCellValue(this.checkEmp(con.getCsn()));
            row.createCell(5).setCellValue(this.checkEmp(con.getFullAddress()));
            row.createCell(6).setCellValue(this.checkEmp(con.getParPartnerName()));
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public List<ShopCondition> Shop(ShopCondition condition, Employee me) throws ParseException {
        StringBuffer hql = new StringBuffer();
        String regions = this.personnelService.getFRegionsByUserId(me.getId());
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select c.shopNumber,c.shopName,c.bigAreaId,c.areaId,c.provinceId,c.cityId,c.countyId,c.parPartnerName,c.shopType,c.shopTotalArea,c.shopBrandArea,c.salseManId,c.shopTel,c.addressDetails,c.shopClassify,c.promotionMode,c.isMenberShop,c.promotionNumber,c.shoppeNumber,c.latitude,c.longitude,c.terminalLevel,c.outerClientNo,c.isReceiveAllot,c.startDate,c.endDate  from ShopView c where  ");
        hql.append("  c.orgId=?  ");
        args.add(this.organizationId);
        if (me.getCurrentPartner().isOrg()) {
            hql.append(" and ( c.salseManId=?  ");
            args.add(me.getId());
            hql.append(" or ( ");
            hql.append(" c.areaId in ( ");
            hql.append(regions);
            hql.append(")");
            hql.append(") )");
        } else {
            hql.append(" and c.parentDealerId=? ");
            args.add(me.getCurrentPartner().getId());
        }
        if (StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and c.shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getShopNumber())) {
            hql.append(" and c.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
            hql.append(" and c.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            hql.append(" and c.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getShopType())) {
            hql.append(" and c.shopType=? ");
            args.add(condition.getShopType());
        }
        if (StringUtils.isNotEmpty(condition.getProvinceId())) {
            hql.append(" and c.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (StringUtils.isNotEmpty(condition.getCityId())) {
            hql.append(" and c.cityId=? ");
            args.add(condition.getCityId());
        }
        if (StringUtils.isNotEmpty(condition.getCountyId())) {
            hql.append(" and c.countyId=? ");
            args.add(condition.getCountyId());
        }
        hql.append(" and ( c.endDate >= ? or c.endDate is null ) ");
        args.add(DateUtils.getStartTime());
        hql.append(" order by c.createDt desc ,c.lastUpdateDt desc ");
        List listPerson = this.baseDao.findEntity(hql.toString(), args.toArray(), ShopCondition.class);
        return listPerson;
    }

    public boolean excel(List<ShopCondition> list, String path, Employee emp, HttpServletResponse response) {
        String name = String.valueOf(emp.getCurrentPartner().getNo()) + "-\u95e8\u5e97\u67e5\u8be2\u8868-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls";
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u95e8\u5e97\u7f16\u53f7", "\u95e8\u5e97\u540d\u79f0", "\u5927\u533a", "\u533a\u57df", "\u7701", "\u5e02", "\u53bf", "\u4e0a\u7ea7\u7ecf\u9500\u5546", "\u95e8\u5e97\u7c7b\u578b", "\u95e8\u5e97\u603b\u9762\u79ef(m\u00b2)", "\u95e8\u5e97\u54c1\u724c\u9762\u79ef(m\u00b2)", "\u4e1a\u52a1\u5458", "\u8054\u7cfb\u7535\u8bdd", "\u8be6\u7ec6\u5730\u5740", "\u95e8\u5e97\u5206\u7c7b", "\u4fc3\u9500\u6a21\u5f0f", "\u662f\u5426\u4f1a\u5458\u5e97", "\u4fc3\u9500\u4eba\u5458\u6570", "\u4e13\u67dc\u4e2a\u6570", "\u7ecf\u5ea6", "\u7eac\u5ea6", "\u7ec8\u7aef\u7b49\u7ea7", "\u5916\u56f4\u5ba2\u6237\u7f16\u53f7", "\u8c03\u62d4\u5355\u662f\u5426\u63a5\u6536\u5e93\u5b58", "\u5f00\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        ShopCondition con = new ShopCondition();
        if (list != null) {
            int i2 = 0;
            while (i2 < list.size()) {
                row = sheet.createRow(i2 + 1);
                ShopCondition obj = list.get(i2);
                Object[] arr = (Object[])obj;
                if (arr[8] != null && arr[8].toString() != "") {
                    con.setShopType(arr[8].toString());
                }
                if (arr[2] != null && arr[2].toString() != "") {
                    con.setBigAreaId(arr[2].toString());
                }
                if (arr[3] != null && arr[3].toString() != "") {
                    con.setAreaId(arr[3].toString());
                }
                if (arr[4] != null && arr[4].toString() != "") {
                    con.setProvinceId(arr[4].toString());
                }
                if (arr[5] != null && arr[5].toString() != "") {
                    con.setCityId(arr[5].toString());
                }
                if (arr[6] != null && arr[6].toString() != "") {
                    con.setCountyId(arr[6].toString());
                }
                if (arr[11] != null && arr[11].toString() != "") {
                    con.setSalseManId(arr[11].toString());
                }
                if (arr[14] != null && arr[14].toString() != "") {
                    con.setShopClassify(arr[14].toString());
                }
                if (arr[15] != null && arr[15].toString() != "") {
                    con.setPromotionMode(arr[15].toString());
                }
                if (arr[16] != null && arr[16].toString() != "") {
                    con.setIsMenberShop(arr[16].toString());
                }
                if (arr[21] != null && arr[21].toString() != "") {
                    con.setTerminalLevel(arr[21].toString());
                }
                if (arr[23] != null && arr[23].toString() != "") {
                    con.setIsReceiveAllot(arr[23].toString());
                }
                if (arr[24] != null && arr[24].toString() != "") {
                    con.setStartDate((Date)arr[24]);
                }
                if (arr[25] != null && arr[25].toString() != "") {
                    con.setEndDate((Date)arr[25]);
                }
                row.createCell(0).setCellValue(this.checkEmp(arr[0]));
                row.createCell(1).setCellValue(this.checkEmp(arr[1]));
                if (arr[2] != null && arr[2].toString() != "") {
                    row.createCell(2).setCellValue(con.getBigAreaName());
                }
                if (arr[3] != null && arr[3].toString() != "") {
                    row.createCell(3).setCellValue(con.getAreaName());
                }
                if (arr[4] != null && arr[4].toString() != "") {
                    row.createCell(4).setCellValue(con.getProvinceName());
                }
                if (arr[5] != null && arr[5].toString() != "") {
                    row.createCell(5).setCellValue(con.getCityName());
                }
                if (arr[6] != null && arr[6].toString() != "") {
                    row.createCell(6).setCellValue(con.getCountyName());
                }
                row.createCell(7).setCellValue(this.checkEmp(arr[7]));
                if (arr[8] != null && arr[8].toString() != "") {
                    row.createCell(8).setCellValue(this.checkEmp(con.getShopTypeName()));
                }
                if (arr[9] != null && arr[9].toString() != "") {
                    row.createCell(9).setCellValue(this.checkEmp(con.getShopTotalArea()));
                }
                if (arr[10] != null && arr[10].toString() != "") {
                    row.createCell(10).setCellValue(this.checkEmp(arr[10]));
                }
                if (arr[11] != null && arr[11].toString() != "") {
                    row.createCell(11).setCellValue(this.checkEmp(con.getSalesName()));
                }
                if (arr[12] != null && arr[12].toString() != "") {
                    row.createCell(12).setCellValue(this.checkEmp(arr[12]));
                }
                if (arr[13] != null && arr[13].toString() != "") {
                    row.createCell(13).setCellValue(this.checkEmp(arr[13]));
                }
                if (arr[14] != null && arr[14].toString() != "") {
                    row.createCell(14).setCellValue(con.getShopClassifyName());
                }
                if (arr[15] != null && arr[15].toString() != "") {
                    row.createCell(15).setCellValue(con.getPromotionModeName());
                }
                if (arr[16] != null && arr[16].toString() != "") {
                    row.createCell(16).setCellValue(con.getIsMenberShopName());
                }
                if (arr[17] != null && arr[17].toString() != "") {
                    row.createCell(17).setCellValue(this.checkEmp(arr[17]));
                }
                if (arr[18] != null && arr[18].toString() != "") {
                    row.createCell(18).setCellValue(this.checkEmp(arr[18]));
                }
                if (arr[19] != null && arr[19].toString() != "") {
                    row.createCell(19).setCellValue(this.checkEmp(arr[19]));
                }
                if (arr[20] != null && arr[20].toString() != "") {
                    row.createCell(20).setCellValue(this.checkEmp(arr[20]));
                }
                if (arr[21] != null && arr[21].toString() != "") {
                    row.createCell(21).setCellValue(con.getTerminalLevelName());
                }
                if (arr[22] != null && arr[22].toString() != "") {
                    row.createCell(22).setCellValue(this.checkEmp(arr[22]));
                }
                if (arr[23] != null && arr[23].toString() != "") {
                    row.createCell(23).setCellValue(con.getIsReceiveAllotName());
                }
                if (arr[24] != null && arr[24].toString() != "") {
                    row.createCell(24).setCellValue(this.checkEmp(DateUtils.formartDate2((Date)con.getStartDate(), (String)"yyyy/MM/dd")));
                }
                if (arr[25] != null && arr[25].toString() != "") {
                    row.createCell(25).setCellValue(this.checkEmp(DateUtils.formartDate2((Date)con.getEndDate(), (String)"yyyy/MM/dd")));
                }
                ++i2;
            }
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public Shop getFirstShopByShopNo(String shopNo, String partnerId) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("select s from Shop s where s.shopNumber = ? ");
        args.add(shopNo);
        if (StringUtils.isNotEmpty(partnerId)) {
            hql.append(" and s.parentDealerId = ?");
            args.add(partnerId);
        }
        hql.append(" order by s.created desc ");
        return (Shop)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Shop.class);
    }

    public void saveBalanceAdd(Shop shop, Employee me, String sourceSystem) {
        shop.getId();
        this.baseDao.save((Object)shop);
        for (ShopAddress address : shop.getAddresses()) {
            if (StringUtils.isNotEmpty(address.getId())) {
                address.setSiebelAddressId(address.getId());
            }
            address.setShopId(shop.getId());
            address.fillInitData(me);
            this.baseDao.save((Object)address);
        }
        for (ShopContacts contacts : shop.getContactses()) {
            if (StringUtils.isNotEmpty(contacts.getId())) {
                contacts.setSiebelContactsId(contacts.getId());
            }
            contacts.setShopId(shop.getId());
            contacts.fillInitData(me);
            this.baseDao.save((Object)contacts);
        }
    }

    public List<PersonShopCondition> personShop(PersonShopCondition con) {
        String name;
        int n;
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct T2.FullName \u59d3\u540d,T2.EMPNO \u5de5\u53f7,T2.PhoneNumber \u624b\u673a\u53f7\u7801,T3.Name \u95e8\u5e97\u540d\u79f0,");
        sb.append(" T3.CSN \u95e8\u5e97\u7f16\u53f7,T3.fullAddress \u95e8\u5e97\u5730\u5740,T3.ParPartnerName \u4e0a\u7ea7\u7ecf\u9500\u5546   ");
        sb.append(" From cx_staff_shop t1,cx_awk_prtnr_contactlist_view t2, CX_AWK_STORELIST_VIEW T3  ");
        sb.append(" WHERE T1.SHOP_ID=T3.Row_Id AND T1.USER_ID=T2.Row_Id AND t3.enddate is null ");
        StringBuffer st = new StringBuffer();
        String no = con.getEmpNo().trim();
        if (!StringUtils.isEmpty(no)) {
            st.append(" and T2.EMPNO IN (");
            String[] nos = no.split("[,\uff0c]");
            String[] stringArray = nos;
            n = nos.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                st.append("'").append(string).append("',");
                ++n2;
            }
            st.deleteCharAt(st.length() - 1);
            st.append(")");
        }
        if (!StringUtils.isEmpty(name = con.getFullName().trim())) {
            String[] names;
            st.append(" and T2.FullName IN (");
            String[] stringArray = names = name.split("[,\uff0c]");
            int n3 = names.length;
            n = 0;
            while (n < n3) {
                String string = stringArray[n];
                st.append("'").append(string).append("',");
                ++n;
            }
            st.deleteCharAt(st.length() - 1);
            st.append(")");
        }
        sb.append(st);
        List listObj = this.baseDao.findBySql(sb.toString());
        ArrayList<PersonShopCondition> listPerson = new ArrayList<PersonShopCondition>();
        for (Object[] objects : listObj) {
            PersonShopCondition person = new PersonShopCondition();
            person.setFullName(this.checkEmp(objects[0]));
            person.setEmpNo(this.checkEmp(objects[1]));
            person.setPhoneNumber(this.checkEmp(objects[2]));
            person.setName(this.checkEmp(objects[3]));
            person.setCsn(this.checkEmp(objects[4]));
            person.setFullAddress(this.checkEmp(objects[5]));
            person.setParPartnerName(this.checkEmp(objects[6]));
            listPerson.add(person);
        }
        return listPerson;
    }

    public void saveBalanceShopNew(List<Shop> list, Employee me) {
        for (Shop shop : list) {
            shop.setShopNumber(this.orderNoService.saveBalanceShopNo("200001", true));
            shop.setApplyType(ShopEnum.ApplyType.add.getValue());
            shop.setApproveState(ShopEnum.ApproveState.pass.getValue());
            shop.setCreated(new Date());
            shop.setCreateDt(new Date());
            shop.setCreatedBy(me.getId());
            shop.setCreatorId(me.getId());
            shop.setLastUpd(new Date());
            shop.setLastUpdateDt(new Date());
            shop.setLastUpdatorId(me.getId());
            shop.setLastUpdBy(me.getId());
            shop.setModificationNum(0L);
            shop.setConflictId("0-1");
            this.saveBalanceAdd(shop, me, "CSP");
        }
    }

    public static class Test {
        private String employeeId;
        private String shopId;

        public String getEmployeeId() {
            return this.employeeId;
        }

        public void setEmployeeId(String employeeId) {
            this.employeeId = employeeId;
        }

        public String getShopId() {
            return this.shopId;
        }

        public void setShopId(String shopId) {
            this.shopId = shopId;
        }
    }
}

