/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.shoppeapply;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.ShoppeApply;
import com.tcbj.crm.entity.ShoppeApplyFile;
import com.tcbj.crm.entity.ShoppeApplyItem;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.shoppeapply.ShoppeApplyCondition;
import com.tcbj.crm.trainapply.ApplyService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShoppeApplyService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private ShopService shopService;
    @Autowired
    ApplyService applyService;

    public Page findShoppeApplys(ShoppeApplyCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from ShoppeApply s where s.state <> '9' and s.applyerId = ?  ");
        args.add(me.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getSubject())) {
            hql.append(" and s.subject like ? ");
            args.add("%" + condition.getSubject() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getState())) {
            hql.append(" and s.state = ?");
            args.add(condition.getState());
        }
        if (condition.getStartDate() != null) {
            hql.append(" and s.createTime >= to_date(?,'yyyy-MM-dd')");
            args.add(DateUtils.formartDate((Date)DateUtils.getDateBefore((Date)condition.getStartDate(), (int)1), (String)"yyyy-MM-dd"));
        }
        if (condition.getEndDate() != null) {
            hql.append(" and s.createTime <= to_date(?,'yyyy-MM-dd')");
            args.add(DateUtils.formartDate((Date)DateUtils.getDateAfter((Date)condition.getEndDate(), (int)1), (String)"yyyy-MM-dd"));
        }
        hql.append(" order by s.createTime desc , s.state desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public ShoppeApply getShoppeById(String id) {
        ShoppeApply shoppeApply = (ShoppeApply)this.baseDao.get(ShoppeApply.class, (Serializable)((Object)id));
        String hql1 = " from ShoppeApplyItem where applyId = ? ";
        String hql2 = " from ShoppeApplyFile where applyId=? ";
        shoppeApply.setShoppeApplyItmes(this.baseDao.findEntity(hql1, new Object[]{id}, ShoppeApplyItem.class));
        shoppeApply.setShoppeApplyFiles(this.baseDao.findEntity(hql2, new Object[]{id}, ShoppeApplyFile.class));
        return shoppeApply;
    }

    public List<ShoppeApplyItem> getShoppApplyItems(String applyId) {
        String hql = " from ShoppeApplyItem where applyId =? ";
        return this.baseDao.findEntity(hql, new Object[]{applyId}, ShoppeApplyItem.class);
    }

    public void saveShoppeApply(ShoppeApply shoppeApply, Employee me, List<IUploadFile> fileList) throws Exception {
        StringBuffer subject = new StringBuffer();
        Partner cfr_ignored_0 = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)me.getCurrentPartner().getId()));
        subject.append(me.getCurrentPartner().getName()).append(" " + Cache.getEmployeeName(shoppeApply.getPerson())).append(" " + DateUtils.formartDate((Date)new Date(), (String)"YYYYMMdd"));
        shoppeApply.setSubject(subject.toString());
        shoppeApply.setApplyerId(me.getCurrentPartner().getId());
        shoppeApply.setCreateTime(new Date());
        shoppeApply.setPerson(me.getId());
        this.baseDao.save((Object)shoppeApply);
        for (ShoppeApplyItem applyItem : shoppeApply.getShoppeApplyItmes()) {
            applyItem.setApplyId(shoppeApply.getId());
            this.baseDao.save((Object)applyItem);
        }
        for (IUploadFile file : fileList) {
            ShoppeApplyFile data = new ShoppeApplyFile();
            data.fillInitData(me);
            data.setApplyId(shoppeApply.getId());
            data.setFileName(file.getName());
            data.setSuffix(file.getSuffix());
            data.setPath(file.getWebPath());
            this.baseDao.save((Object)data);
        }
        this.applyService.addShoppeApply(shoppeApply, fileList);
    }

    public void delShoppeApply(String id) throws Exception {
        ShoppeApply shoppeApply = (ShoppeApply)this.baseDao.get(ShoppeApply.class, (Serializable)((Object)id));
        this.baseDao.delete((Object)shoppeApply);
        Object[] args = new Object[]{id};
        this.baseDao.executeHQL("delete ShoppeApplyItem where applyId=?", args);
        this.baseDao.executeHQL("delete ShoppeApplyFile where applyId=?", args);
    }

    public void updateShoppeApply(ShoppeApply shoppeApply, Employee me, List<IUploadFile> fileList) throws Exception {
        String[] fileids;
        shoppeApply.setApplyerId(me.getCurrentPartner().getId());
        shoppeApply.setCreateTime(new Date());
        this.baseDao.update((Object)shoppeApply);
        String[] stringArray = fileids = shoppeApply.getFileIds().split(",");
        int n = fileids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                this.baseDao.executeHQL("delete ShoppeApplyFile where id= ?", args);
            }
            ++n2;
        }
        String[] itemsIds = null;
        if (StringUtils.isNotEmpty(shoppeApply.getItmesIds())) {
            String[] stringArray2 = itemsIds = shoppeApply.getItmesIds().split(",");
            int n3 = itemsIds.length;
            n = 0;
            while (n < n3) {
                String id = stringArray2[n];
                this.baseDao.deleteById(ShoppeApplyItem.class, (Serializable)((Object)id));
                ++n;
            }
        }
        for (ShoppeApplyItem applyItem : shoppeApply.getShoppeApplyItmes()) {
            applyItem.setApplyId(shoppeApply.getId());
            this.baseDao.update((Object)applyItem);
        }
        for (IUploadFile file : fileList) {
            ShoppeApplyFile data = new ShoppeApplyFile();
            data.fillInitData(me);
            data.setApplyId(shoppeApply.getId());
            data.setFileName(file.getName());
            data.setSuffix(file.getSuffix());
            data.setPath(file.getWebPath());
            this.baseDao.save((Object)data);
        }
    }

    public void deleteFile(String id) {
        String hql = "delete from ShoppeApplyFile where id =? ";
        this.baseDao.executeHQL(hql, new Object[]{id});
    }

    public ShoppeApplyFile getShoppeApplyFileById(String id) {
        return (ShoppeApplyFile)this.baseDao.get(ShoppeApplyFile.class, (Serializable)((Object)id));
    }
}

