/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.siebel.service;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.tcbj.crm.entity.PartnerAddressRecord;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.siebel.service.SiebelUtil;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ClientSiebelService {
    private static String business = StringUtils.getBusiness();

    public String addOrUpdatePartnerToSiebel(PartnerRecord apply, Employee em) throws RuntimeException {
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_AccountOrganization_IU_WF");
            String xml = this.parsePartner2xml(apply, 1, em);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            return rowId;
        }
        catch (AppException es) {
            throw es;
        }
        catch (Exception e) {
            throw new AppException("0010", e.getMessage());
        }
    }

    private String parsePartner2xml(PartnerRecord pa, int flag, Employee em) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<ListOfChannelPartner><ChannelPartner>");
        sb.append("<Id>").append(pa.getId()).append("</Id>");
        sb.append("<ParentId>").append("</ParentId>");
        sb.append("<ListOfOrganization><Organization>");
        sb.append("<OrganizationId>").append(StringUtils.getOrgId()).append("</OrganizationId>");
        sb.append("<DistrictId>").append(pa.getBigAreaCode()).append("</DistrictId>");
        sb.append("<RegionId>").append(pa.getAreaCode()).append("</RegionId>");
        sb.append("<DistrictMan>").append(pa.getBigAreaManagerName()).append("</DistrictMan>");
        sb.append("<DistrictManId>").append(pa.getBigAreaManagerId()).append("</DistrictManId>");
        sb.append("<RegionMan>").append(pa.getAreaManagerName()).append("</RegionMan>");
        sb.append("<RegionManId>").append(pa.getAreaManagerId()).append("</RegionManId>");
        sb.append("<CityMan>").append(pa.getCityManagerName()).append("</CityMan>");
        if (StringUtils.isNotEmpty(pa.getCityManagerId())) {
            sb.append("<CityManId>").append(pa.getCityManagerId()).append("</CityManId>");
        } else {
            sb.append("<CityManId>").append("</CityManId>");
        }
        sb.append("<MktRep>").append(pa.getMarketManagerName()).append("</MktRep>");
        sb.append("<MktRepId>").append(pa.getMarketManagerId()).append("</MktRepId>");
        sb.append("<CurcyCode>").append(pa.getCurrencyCode()).append("</CurcyCode>");
        sb.append("<TaxCode>").append(pa.getSaleTaxName()).append("</TaxCode>");
        sb.append("<BillType>").append(pa.getInvoiceTypeName()).append("</BillType>");
        sb.append("<InvFrozenFlg>").append(pa.getIsInvoiceFreezed()).append("</InvFrozenFlg>");
        sb.append("<OrderFrozenFlg>").append(pa.getIsOrderFreezed()).append("</OrderFrozenFlg>");
        sb.append("<ShipFrozenFlg>").append(pa.getIsDeliveryFreezed()).append("</ShipFrozenFlg>");
        sb.append("<CrdtManFlg>").append(pa.getIsCreditManaged()).append("</CrdtManFlg>");
        sb.append("<OrgInvFlg>").append(pa.getIsStockShow()).append("</OrgInvFlg>");
        sb.append("<DefRcvFlg>").append(pa.getIsStockReceived()).append("</DefRcvFlg>");
        if (StringUtils.isEmpty(pa.getAdditionalRatio().toString())) {
            sb.append("<RepCalValue>").append("</RepCalValue>");
        } else {
            sb.append("<RepCalValue>").append(pa.getAdditionalRatio()).append("</RepCalValue>");
        }
        if (StringUtils.isEmpty(pa.getIsAdditionalCal().toString())) {
            sb.append("<RepCalFlg>").append("</RepCalFlg>");
        } else {
            sb.append("<RepCalFlg>").append(pa.getIsAdditionalCal()).append("</RepCalFlg>");
        }
        if (StringUtils.isEmpty(pa.getZdbhFlg())) {
            sb.append("<AutoReplenishFlg>").append("</AutoReplenishFlg>");
        } else {
            sb.append("<AutoReplenishFlg>").append(pa.getZdbhFlg()).append("</AutoReplenishFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getGiftCtrlMode())) {
            sb.append("<GiftCtrlMode>").append(pa.getGiftCtrlModeName()).append("</GiftCtrlMode>");
        } else {
            sb.append("<GiftCtrlMode>").append("</GiftCtrlMode>");
        }
        if (StringUtils.isNotEmpty(pa.gettHCJGiftBalance())) {
            sb.append("<THCJGiftBalance>").append(pa.gettHCJGiftBalance()).append("</THCJGiftBalance>");
        } else {
            sb.append("<THCJGiftBalance>").append("</THCJGiftBalance>");
        }
        sb.append("<ShipType>").append(pa.getDeliveryCodeName()).append("</ShipType>");
        sb.append("<DefRcvType>").append(pa.getStockReceiveTypeName()).append("</DefRcvType>");
        sb.append("<PartnerLevel>").append(pa.getPartnerLevelName()).append("</PartnerLevel>");
        sb.append("<CreditLvl>").append(pa.getCreditLevelName()).append("</CreditLvl>");
        sb.append("<OrderType>").append(pa.getOrderTypeName()).append("</OrderType>");
        sb.append("<RetOrderType>").append(pa.getRtnOrderTypeName()).append("</RetOrderType>");
        sb.append("<PurchaseMode>").append(pa.getPurchaseSaleName()).append("</PurchaseMode>");
        sb.append("<SettleMode>").append(pa.getSettlementModeName()).append("</SettleMode>");
        sb.append("<ShipPriority>").append(pa.getDeliveryLevelName()).append("</ShipPriority>");
        sb.append("<TrnsprtPeriod>").append(pa.getTransportOnlineCode()).append("</TrnsprtPeriod>");
        if (pa.getStartDt() == null) {
            sb.append("<StartDate></StartDate>");
        } else {
            sb.append("<StartDate>").append(DateUtils.formartDate((Date)pa.getStartDt(), (String)"MM/dd/yyyy")).append("</StartDate>");
        }
        if (pa.getEndDt() == null) {
            sb.append("<EndDate></EndDate>");
        } else {
            sb.append("<EndDate>").append(DateUtils.formartDate((Date)pa.getEndDt(), (String)"MM/dd/yyyy")).append("</EndDate>");
        }
        if (StringUtils.isNotEmpty(pa.getNothingCanOrderFlg())) {
            sb.append("<NothingCanOrderFlg>").append(pa.getNothingCanOrderFlg()).append("</NothingCanOrderFlg>");
        } else {
            sb.append("<NothingCanOrderFlg>").append("</NothingCanOrderFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getPackCtrlFlg())) {
            sb.append("<PackControlFlg>").append(pa.getPackCtrlFlg()).append("</PackControlFlg>");
        } else {
            sb.append("<PackControlFlg>").append("</PackControlFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getZxbzsFlg())) {
            sb.append("<ZXBZSFlag>").append(pa.getZxbzsFlg()).append("</ZXBZSFlag>");
        } else {
            sb.append("<ZXBZSFlag>").append("</ZXBZSFlag>");
        }
        if (StringUtils.isNotEmpty(pa.getPriceDecimalDigits())) {
            sb.append("<DecimalDigits>").append(pa.getPriceDecimalDigits()).append("</DecimalDigits>");
        } else {
            sb.append("<DecimalDigits>").append("</DecimalDigits>");
        }
        if (StringUtils.isNotEmpty(pa.getRelatedDelearId())) {
            sb.append("<RelatedPartnerId>").append(pa.getRelatedDelearId()).append("</RelatedPartnerId>");
        } else {
            sb.append("<RelatedPartnerId>").append("</RelatedPartnerId>");
        }
        List<PartnerAddressRecord> adList = pa.getAddresses();
        if (adList.size() > 0) {
            sb.append("<ListOfComAddress>");
            for (PartnerAddressRecord ad : adList) {
                sb.append("<ComAddress>");
                if (StringUtils.isNotEmpty(ad.getSiebelId())) {
                    sb.append("<Id>").append(ad.getSiebelId()).append("</Id>");
                } else {
                    sb.append("<Id>").append(String.valueOf(Math.random()).substring(0, 10)).append("</Id>");
                }
                sb.append("<Type>").append(ad.getAddressTypeName()).append("</Type>");
                sb.append("<Country>").append(ad.getCountryName()).append("</Country>");
                sb.append("<State>").append(ad.getProvinceName()).append("</State>");
                sb.append("<City>").append(ad.getCityName()).append("</City>");
                sb.append("<County>").append(ad.getCountyName()).append("</County>");
                sb.append("<StreetAddress>").append(ad.getAddress()).append("</StreetAddress>");
                sb.append("<PostalCode>").append(ad.getZip()).append("</PostalCode>");
                if (StringUtils.isEmpty(ad.getCityManagerId())) {
                    sb.append("<CityManId>").append("</CityManId>");
                } else {
                    sb.append("<CityManId>").append(ad.getCityManagerId()).append("</CityManId>");
                }
                if (ad.getStartDt() == null) {
                    sb.append("<StartDate></StartDate>");
                } else {
                    sb.append("<StartDate>").append(DateUtils.formartDate((Date)ad.getStartDt(), (String)"MM/dd/yyyy")).append("</StartDate>");
                }
                if (ad.getEndDt() == null) {
                    sb.append("<EndDate></EndDate>");
                } else {
                    sb.append("<EndDate>").append(DateUtils.formartDate((Date)ad.getEndDt(), (String)"MM/dd/yyyy")).append("</EndDate>");
                }
                sb.append("<DefPerId>").append(ad.getContactCode()).append("</DefPerId>");
                sb.append("<DefPerPhone>").append(ad.getContactPhone()).append("</DefPerPhone>");
                sb.append("<RcvDateType>").append(ad.getReceiveTimeName()).append("</RcvDateType>");
                if (StringUtils.isNotEmpty(ad.getHarvestWarehouse())) {
                    sb.append("<DefWareHouseId>").append(ad.getHarvestWarehouse()).append("</DefWareHouseId>");
                } else {
                    sb.append("<DefWareHouseId>").append("</DefWareHouseId>");
                }
                if (StringUtils.isNotEmpty(ad.getDisDelearId())) {
                    sb.append("<DisPartnerId>").append(ad.getDisDelearId()).append("</DisPartnerId>");
                } else {
                    sb.append("<DisPartnerId>").append("</DisPartnerId>");
                }
                sb.append("<CreatorId>").append(ad.getCreatorId()).append("</CreatorId>");
                sb.append("<CreateDt>").append(DateUtils.formartDate((Date)ad.getCreateDt(), (String)"MM/dd/yyyy")).append("</CreateDt>");
                sb.append("<LastUpdatorId>").append(ad.getLastUpdatorId()).append("</LastUpdatorId>");
                sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)ad.getLastUpdateDt(), (String)"MM/dd/yyyy")).append("</LastUpdateDt>");
                sb.append("</ComAddress>");
            }
            sb.append("</ListOfComAddress>");
        }
        sb.append("</Organization></ListOfOrganization></ChannelPartner></ListOfChannelPartner>");
        String xml = sb.toString();
        return xml;
    }
}

