/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.siebel.service;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.siebel.service.SiebelUtil;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.crm.view.ShopView;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Controller;

@Controller
public class ContactsSiebelService {
    private static String business = StringUtils.getBusiness();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addOrUpdateContactsToSiebel(Contact clv, List<PartnerShop> pts, List<ShopView> sps, String partner) throws RuntimeException {
        String string;
        long now = System.currentTimeMillis();
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            System.out.println("---------------------");
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            now = System.currentTimeMillis() - now;
            System.out.println("-----------------------\u8fde\u63a5\u603b\u5171\u8017\u65f6\uff1a" + now);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Contact_IU_WF");
            String xml = this.parseContacts2xml(clv, pts, sps, 1, partner);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new AppException("0010", e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String delContactsToSiebel(Contact clv) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Contact_IU_WF");
            String xml = this.parseContacts2xml(clv, null, null, 0, "");
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (Exception e) {
            try {
                throw new AppException("0010", e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String logOutContactsToSiebel(Contact clv) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Contact_IU_WF");
            String xml = this.parseContacts2xml(clv, null, null, 2, "");
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (Exception e) {
            try {
                throw new AppException("0010", e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addUserToSiebel(Employee employee) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Partner_ContactToUser_WF");
            input.setProperty("UserId", employee.getId());
            input.setProperty("LoginName", employee.getAccount());
            input.setProperty("Password", employee.getPassword());
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            System.out.println("trn==" + rtn);
            System.out.println("rtnDesc==" + rtnDesc);
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException em) {
            try {
                throw em;
                catch (Exception e) {
                    throw new AppException("0010", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updateUserToSiebel(Employee employee) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Partner_UpdateUser_WF");
            input.setProperty("UserId", employee.getId());
            input.setProperty("LoginName", employee.getAccount());
            input.setProperty("NewPassword", employee.getPassword());
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            System.out.println("trn==" + rtn);
            System.out.println("rtnDesc==" + rtnDesc);
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException em) {
            try {
                throw em;
                catch (Exception e) {
                    throw new AppException("0010", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String loginOut(Contact clv) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Contact_C_WF");
            String xml = this.loginOut1(clv);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new AppException("0010", e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    private String parseContacts2xml(Contact clv, List<PartnerShop> pts, List<ShopView> sps, int flag, String par) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<ListOfContact><Contact>");
        sb.append("<Id>").append(clv.getId()).append("</Id>");
        if (flag == 1) {
            if (clv.getState() == "insert") {
                sb.append("<Operation>").append(clv.getState()).append("</Operation>");
            } else {
                sb.append("<Operation>").append(clv.getState()).append("</Operation>");
            }
            if (StringUtils.isNotEmpty(clv.getExtphone())) {
                sb.append("<ExtPhone>").append(clv.getExtphone()).append("</ExtPhone>");
            } else {
                sb.append("<ExtPhone>").append("</ExtPhone>");
            }
            if (clv.getBirthdate() != null) {
                sb.append("<BirthDate>").append(DateUtils.formartDate((Date)clv.getBirthdate(), null)).append("</BirthDate>");
            }
            if (StringUtils.isNotEmpty(clv.getPartnerOrgId())) {
                sb.append("<OrganizationId>").append(StringUtils.getOrgId()).append("</OrganizationId>");
            } else {
                sb.append("<OrganizationId>").append("</OrganizationId>");
            }
            if (StringUtils.isNotEmpty(clv.getFullname())) {
                sb.append("<FullName>").append(clv.getFullname()).append("</FullName>");
            } else {
                sb.append("<FullName>").append("</FullName>");
            }
            if (StringUtils.isNotEmpty(clv.getPhonenumber())) {
                sb.append("<PhoneNumber>").append(clv.getPhonenumber()).append("</PhoneNumber>");
            } else {
                sb.append("<PhoneNumber>").append("</PhoneNumber>");
            }
            if (StringUtils.isNotEmpty(clv.getEducationalbg())) {
                sb.append("<EducationalBG>").append(clv.getEducationalbg()).append("</EducationalBG>");
            } else {
                sb.append("<EducationalBG>").append("</EducationalBG>");
            }
            if (StringUtils.isNotEmpty(clv.getEmail())) {
                sb.append("<Email>").append(clv.getEmail()).append("</Email>");
            } else {
                sb.append("<Email>").append("</Email>");
            }
            if (StringUtils.isNotEmpty(clv.getEmpno())) {
                sb.append("<EmpNo>").append(clv.getEmpno()).append("</EmpNo>");
            } else {
                sb.append("<EmpNo>").append("</EmpNo>");
            }
            if (StringUtils.isNotEmpty(clv.getFaxphone())) {
                sb.append("<FaxPhone>").append(clv.getFaxphone()).append("</FaxPhone>");
            } else {
                sb.append("<FaxPhone>").append("</FaxPhone>");
            }
            if (clv.getHiredate() == null) {
                sb.append("<HireDate></HireDate>");
            } else {
                sb.append("<HireDate>").append(DateUtils.formartDate((Date)clv.getHiredate(), null)).append("</HireDate>");
            }
            if (clv.getDimissiondate() == null) {
                sb.append("<DimissionDate></DimissionDate>");
            } else {
                sb.append("<DimissionDate>").append(DateUtils.formartDate((Date)clv.getDimissiondate(), null)).append("</DimissionDate>");
            }
            if (StringUtils.isNotEmpty(clv.getPrimaryphone())) {
                sb.append("<PrimaryPhone>").append(clv.getPrimaryphone()).append("</PrimaryPhone>");
            } else {
                sb.append("<PrimaryPhone>").append("</PrimaryPhone>");
            }
            if (StringUtils.isNotEmpty(clv.getIdnumber())) {
                sb.append("<IDNumber>").append(clv.getIdnumber()).append("</IDNumber>");
            } else {
                sb.append("<IDNumber>").append("</IDNumber>");
            }
            if (StringUtils.isNotEmpty(clv.getMf())) {
                if (clv.getMf().equals("\u7537") || clv.getMf().equals("\u5973")) {
                    sb.append("<MF>").append(clv.getMf()).append("</MF>");
                } else {
                    sb.append("<MF>").append(clv.getMfName()).append("</MF>");
                }
            } else {
                sb.append("<MF>").append("</MF>");
            }
            if (StringUtils.isNotEmpty(clv.getFamilyphone())) {
                sb.append("<FamilyPhone>").append(clv.getFamilyphone()).append("</FamilyPhone>");
            } else {
                sb.append("<FamilyPhone>").append("</FamilyPhone>");
            }
            if (StringUtils.isNotEmpty(clv.getAddress())) {
                sb.append("<Address>").append(clv.getAddress()).append("</Address>");
            } else {
                sb.append("<Address>").append("</Address>");
            }
            if (clv.getEnddate() == null) {
                sb.append("<EndDate></EndDate>");
            } else {
                sb.append("<EndDate>").append(DateUtils.formartDate((Date)clv.getEnddate(), null)).append("</EndDate>");
            }
            if (StringUtils.isNotEmpty(clv.getPersontype())) {
                sb.append("<PersonType>").append(clv.getPersontype()).append("</PersonType>");
            } else {
                sb.append("<PersonType>").append("</PersonType>");
            }
            if (StringUtils.isNotEmpty(clv.getQq())) {
                sb.append("<QQ>").append(clv.getQq()).append("</QQ>");
            } else {
                sb.append("<QQ>").append("</QQ>");
            }
            if (clv.getStartdate() == null) {
                sb.append("<StartDate></StartDate>");
            } else {
                sb.append("<StartDate>").append(DateUtils.formartDate((Date)clv.getStartdate(), null)).append("</StartDate>");
            }
            if (StringUtils.isNotEmpty(clv.getRoletype())) {
                sb.append("<RoleType>").append(clv.getRoletype()).append("</RoleType>");
            } else {
                sb.append("<RoleType>").append("</RoleType>");
            }
            if (StringUtils.isNotEmpty(par) || pts != null) {
                sb.append("<ListOfPartner>");
                for (PartnerShop partner : pts) {
                    sb.append("<Partner>");
                    sb.append("<Id>").append(partner.getId()).append("</Id>");
                    sb.append("<Name>").append(partner.getName()).append("</Name>");
                    sb.append("</Partner>");
                }
                sb.append("</ListOfPartner>");
            } else if (sps != null) {
                sb.append("<ListOfStore>");
                for (ShopView shop : sps) {
                    sb.append("<Store>");
                    sb.append("<Id>").append(shop.getId()).append("</Id>");
                    sb.append("</Store>");
                }
                sb.append("</ListOfStore>");
            }
        }
        if (flag == 0) {
            sb.append("<Operation>").append(clv.getState()).append("</Operation>");
            sb.append("<OrganizationId>").append(StringUtils.getOrgId()).append("</OrganizationId>");
            sb.append("<FullName>").append(clv.getFullname()).append("</FullName>");
            sb.append("<PhoneNumber>").append(clv.getPhonenumber()).append("</PhoneNumber>");
            sb.append("<EndDate>").append(DateUtils.formartDate((Date)new Date(), null)).append("</EndDate>");
        }
        if (flag == 2) {
            sb.append("<OrganizationId>").append(StringUtils.getOrgId()).append("</OrganizationId>");
            sb.append("<FullName>").append(clv.getFullname()).append("</FullName>");
            sb.append("<PhoneNumber>").append(clv.getPhonenumber()).append("</PhoneNumber>");
            sb.append("<Operation>").append(clv.getState()).append("</Operation>");
            if (StringUtils.isNotEmpty(clv.getPartnerId())) {
                sb.append("<ListOfPartner></ListOfPartner>");
            } else {
                sb.append("<ListOfStore></ListOfStore>");
            }
        }
        sb.append("</Contact></ListOfContact>");
        String xml = sb.toString();
        System.out.println("---------xml----->>>>>>>-----" + xml);
        return xml;
    }

    private String loginOut1(Contact clv) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<ListOfContact><Contact>");
        sb.append("<Id>").append(clv.getId()).append("</Id>");
        sb.append("<Operation>").append(clv.getState()).append("</Operation>");
        if (StringUtils.isNotEmpty(clv.getPartnerId())) {
            sb.append("<ListOfPartner></ListOfPartner>");
        } else {
            sb.append("<ListOfStore></ListOfStore>");
        }
        sb.append("</Contact></ListOfContact>");
        String xml = sb.toString();
        System.out.println("---------xml----->>>>>>>-----" + xml);
        return xml;
    }
}

