/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.siebel.service;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.tcbj.crm.entity.PartnerAddressRecord;
import com.tcbj.crm.entity.PartnerContactRecord;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.siebel.service.SiebelUtil;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class PartnerSiebelService {
    private static String business = StringUtils.getBusiness();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addOrUpdatePartnerToSiebel(PartnerRecord apply, int loop) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Partner_IU_WF");
            String xml = this.parsePartner2xml(apply, 1, loop);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException es) {
            try {
                throw es;
                catch (Exception e) {
                    throw new AppException("0010", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String delPartnerToSiebel(PartnerRecord apply) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Partner_IU_WF");
            String xml = this.parsePartner2xml(apply, 0, 0);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException es) {
            try {
                throw es;
                catch (Exception e) {
                    throw new AppException("0010", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updatePartPartnerToSiebel(PartnerRecord apply) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Partner_IU_WF");
            String xml = this.parsePartPartner2xml(apply);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new AppException("0010", e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    private String parsePartPartner2xml(PartnerRecord pa) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<ListOfChannelPartner><ChannelPartner>");
        sb.append("<Operation>update</Operation>");
        if (StringUtils.isNotEmpty(pa.getSiebelId())) {
            sb.append("<Id>").append(pa.getSiebelId()).append("</Id>");
        } else {
            sb.append("<Id>").append(pa.getId()).append("</Id>");
        }
        if (StringUtils.isEmpty(pa.getFax())) {
            sb.append("<FaxPhone>").append("</FaxPhone>");
        } else {
            sb.append("<FaxPhone>").append(pa.getFax()).append("</FaxPhone>");
        }
        if (StringUtils.isNotEmpty(pa.getPhone())) {
            sb.append("<CompanyPhone>").append(pa.getPhone()).append("</CompanyPhone>");
        } else {
            sb.append("<CompanyPhone>").append("</CompanyPhone>");
        }
        if (StringUtils.isNotEmpty(pa.getAddress())) {
            sb.append("<CompanyAddress>").append(pa.getAddress()).append("</CompanyAddress>");
        } else {
            sb.append("<CompanyAddress>").append("</CompanyAddress>");
        }
        if (StringUtils.isNotNull(pa.getParentPartnerId())) {
            sb.append("<ParentId>").append(pa.getParentPartnerId()).append("</ParentId>");
        } else {
            sb.append("<ParentId>").append("</ParentId>");
        }
        if (StringUtils.isNotEmpty(pa.getNo())) {
            sb.append("<CSN>").append(pa.getNo()).append("</CSN>");
        } else {
            sb.append("<CSN>").append("</CSN>");
        }
        if (StringUtils.isNotEmpty(pa.getIsReport())) {
            sb.append("<RprtFlg>").append(pa.getIsReport()).append("</RprtFlg>");
        } else {
            sb.append("<RprtFlg>").append("</RprtFlg>");
        }
        sb.append("<LastUpdatorId>").append(pa.getLastUpdatorId()).append("</LastUpdatorId>");
        sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)pa.getLastUpdateDt(), (String)"MM/dd/yyyy")).append("</LastUpdateDt>");
        List<PartnerContactRecord> cList = pa.getContacts();
        if (cList.size() > 0) {
            sb.append("<ListOfContact>");
            for (PartnerContactRecord c : cList) {
                sb.append("<Contact>");
                sb.append("<Id>").append(c.getId()).append("</Id>");
                if (StringUtils.isNotEmpty(c.getDutyTypeName())) {
                    sb.append("<RoleType>").append(c.getDutyTypeName()).append("</RoleType>");
                } else {
                    sb.append("<RoleType>").append("</RoleType>");
                }
                if (StringUtils.isNotEmpty(c.getContactName())) {
                    sb.append("<FullName>").append(c.getContactName()).append("</FullName>");
                } else {
                    sb.append("<FullName>").append("</FullName>");
                }
                if (StringUtils.isNotEmpty(c.getTel())) {
                    sb.append("<PrimaryPhone>").append(c.getTel()).append("</PrimaryPhone>");
                } else {
                    sb.append("<PrimaryPhone>").append("</PrimaryPhone>");
                }
                if (StringUtils.isNotEmpty(c.getMobile())) {
                    sb.append("<PhoneNumber>").append(c.getMobile()).append("</PhoneNumber>");
                } else {
                    sb.append("<PhoneNumber>").append("</PhoneNumber>");
                }
                if (StringUtils.isNotEmpty(pa.getFax())) {
                    sb.append("<FaxPhone>").append(c.getFax()).append("</FaxPhone>");
                } else {
                    sb.append("<FaxPhone>").append("</FaxPhone>");
                }
                if (StringUtils.isNotEmpty(c.getQq())) {
                    sb.append("<QQ>").append(c.getQq()).append("</QQ>");
                } else {
                    sb.append("<QQ>").append("</QQ>");
                }
                if (StringUtils.isNotEmpty(c.getEmail())) {
                    sb.append("<Email>").append(c.getEmail()).append("</Email>");
                } else {
                    sb.append("<Email>").append("</Email>");
                }
                if (StringUtils.isNotEmpty(c.getAddress())) {
                    sb.append("<Address>").append(c.getAddress()).append("</Address>");
                } else {
                    sb.append("<Address>").append("</Address>");
                }
                if (c.getStartDate() == null) {
                    sb.append("<StartDate></StartDate>");
                } else {
                    sb.append("<StartDate>").append(DateUtils.formartDate((Date)c.getStartDate(), (String)"MM/dd/yyyy")).append("</StartDate>");
                }
                if (c.getEndDate() == null) {
                    sb.append("<EndDate></EndDate>");
                } else {
                    sb.append("<EndDate>").append(DateUtils.formartDate((Date)c.getEndDate(), (String)"MM/dd/yyyy")).append("</EndDate>");
                }
                if ("N".equals(c.getIsContact())) {
                    sb.append("<IsContactFlg>N</IsContactFlg>");
                } else {
                    sb.append("<IsContactFlg>Y</IsContactFlg>");
                }
                sb.append("<LastUpdatorId>").append(c.getLastUpdatorId()).append("</LastUpdatorId>");
                sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)c.getLastUpdateDt(), (String)"MM/dd/yyyy")).append("</LastUpdateDt>");
                if (StringUtils.isNotNull(pa.getMasterOuId())) {
                    sb.append("<OrganizationId>").append(pa.getMasterOuId()).append("</OrganizationId>");
                } else {
                    sb.append("<OrganizationId>").append("</OrganizationId>");
                }
                sb.append("</Contact>");
            }
            sb.append("</ListOfContact>");
        }
        sb.append("</ChannelPartner></ListOfChannelPartner>");
        String xml = sb.toString();
        return xml;
    }

    private String parsePartner2xml(PartnerRecord pa, int flag, int loop) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<ListOfChannelPartner><ChannelPartner>");
        if (loop == 1) {
            sb.append("<Operation>update</Operation>");
            sb.append("<Id>").append(pa.getSiebelId()).append("</Id>");
        } else {
            sb.append("<Id>").append(pa.getSiebelId()).append("</Id>");
            sb.append("<Operation>insert</Operation>");
        }
        if (StringUtils.isNotEmpty(pa.getName())) {
            sb.append("<Name>").append(pa.getName()).append("</Name>");
        } else {
            sb.append("<Name>").append("</Name>");
        }
        if (StringUtils.isNotEmpty(pa.getShortName())) {
            sb.append("<Alias>").append(pa.getShortName()).append("</Alias>");
        } else {
            sb.append("<Alias>").append("</Alias>");
        }
        if (StringUtils.isNotEmpty(pa.getNo())) {
            sb.append("<CSN>").append(pa.getNo()).append("</CSN>");
        } else {
            sb.append("<CSN>").append("</CSN>");
        }
        if (StringUtils.isNotEmpty(pa.getClientAppNo())) {
            sb.append("<ExtCSN>").append(pa.getClientAppNo()).append("</ExtCSN>");
        } else {
            sb.append("<ExtCSN>").append("</ExtCSN>");
        }
        if (StringUtils.isNotEmpty(pa.getFax())) {
            sb.append("<FaxPhone>").append(pa.getFax()).append("</FaxPhone>");
        } else {
            sb.append("<FaxPhone>").append("</FaxPhone>");
        }
        if (StringUtils.isNotEmpty(pa.getPhone())) {
            sb.append("<CompanyPhone>").append(pa.getPhone()).append("</CompanyPhone>");
        } else {
            sb.append("<CompanyPhone>").append("</CompanyPhone>");
        }
        sb.append("<ParentId>").append(pa.getParentPartnerId()).append("</ParentId>");
        sb.append("<ParentName>").append(pa.getParentPartnerName()).append("</ParentName>");
        sb.append("<ParentCSN>").append(pa.getParentPartnerCSN()).append("</ParentCSN>");
        if (StringUtils.isNotEmpty(pa.getOrgTypeName())) {
            sb.append("<Category>").append(pa.getOrgTypeName()).append("</Category>");
        } else {
            sb.append("<Category>").append("</Category>");
        }
        if (StringUtils.isNotEmpty(pa.getCountryName())) {
            sb.append("<Country>").append(pa.getCountryName()).append("</Country>");
        } else {
            sb.append("<Country>").append("</Country>");
        }
        if (StringUtils.isNotEmpty(pa.getProvinceName())) {
            sb.append("<State>").append(pa.getProvinceName()).append("</State>");
        } else {
            sb.append("<State>").append("</State>");
        }
        if (StringUtils.isNotEmpty(pa.getCityName())) {
            sb.append("<City>").append(pa.getCityName()).append("</City>");
        } else {
            sb.append("<City>").append("</City>");
        }
        if (StringUtils.isEmpty(pa.getCountyName())) {
            sb.append("<County>").append("</County>");
        } else {
            sb.append("<County>").append(pa.getCountyName()).append("</County>");
        }
        if (StringUtils.isNotEmpty(pa.getAddress())) {
            sb.append("<CompanyAddress>").append(pa.getAddress()).append("</CompanyAddress>");
        } else {
            sb.append("<CompanyAddress>").append("</CompanyAddress>");
        }
        if (StringUtils.isNotEmpty(pa.getSaleChannelTypeCode())) {
            sb.append("<ChannelType>").append(pa.getSaleChannelTypeCode()).append("</ChannelType>");
        } else {
            sb.append("<ChannelType>").append("</ChannelType>");
        }
        if (StringUtils.isNotEmpty(pa.getTaxNo())) {
            sb.append("<TaxId>").append(pa.getTaxNo()).append("</TaxId>");
        } else {
            sb.append("<TaxId>").append("</TaxId>");
        }
        if (StringUtils.isNotEmpty(pa.getTaxRegistNo())) {
            sb.append("<TaxRgstNumber>").append(pa.getTaxRegistNo()).append("</TaxRgstNumber>");
        } else {
            sb.append("<TaxRgstNumber>").append("</TaxRgstNumber>");
        }
        if (StringUtils.isNotEmpty(pa.getIsReport())) {
            sb.append("<RprtFlg>").append(pa.getIsReport()).append("</RprtFlg>");
        } else {
            sb.append("<RprtFlg>").append("</RprtFlg>");
        }
        sb.append("<CreatorId>").append(pa.getCreatorId()).append("</CreatorId>");
        sb.append("<CreateDt>").append(DateUtils.formartDate((Date)pa.getCreateDt(), (String)"MM/dd/yyyy")).append("</CreateDt>");
        sb.append("<LastUpdatorId>").append(pa.getLastUpdatorId()).append("</LastUpdatorId>");
        sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)pa.getLastUpdateDt(), (String)"MM/dd/yyyy")).append("</LastUpdateDt>");
        sb.append("<ExternalId>").append(pa.getId()).append("</ExternalId>");
        sb.append("<ListOfOrganization><Organization>");
        sb.append("<OrganizationId>").append(StringUtils.getOrgId()).append("</OrganizationId>");
        if (StringUtils.isNotEmpty(pa.getBigAreaCode())) {
            sb.append("<DistrictId>").append(pa.getBigAreaCode()).append("</DistrictId>");
        } else {
            sb.append("<DistrictId>").append("</DistrictId>");
        }
        if (StringUtils.isNotEmpty(pa.getAreaCode())) {
            sb.append("<RegionId>").append(pa.getAreaCode()).append("</RegionId>");
        } else {
            sb.append("<RegionId>").append("</RegionId>");
        }
        if (StringUtils.isNotEmpty(pa.getBigAreaManagerName())) {
            sb.append("<DistrictMan>").append(pa.getBigAreaManagerName()).append("</DistrictMan>");
        } else {
            sb.append("<DistrictMan>").append("</DistrictMan>");
        }
        if (StringUtils.isNotEmpty(pa.getBigAreaManagerId())) {
            sb.append("<DistrictManId>").append(pa.getBigAreaManagerId()).append("</DistrictManId>");
        } else {
            sb.append("<DistrictManId>").append("</DistrictManId>");
        }
        if (StringUtils.isNotEmpty(pa.getAreaManagerName())) {
            sb.append("<RegionMan>").append(pa.getAreaManagerName()).append("</RegionMan>");
        } else {
            sb.append("<RegionMan>").append("</RegionMan>");
        }
        if (StringUtils.isNotEmpty(pa.getAreaManagerId())) {
            sb.append("<RegionManId>").append(pa.getAreaManagerId()).append("</RegionManId>");
        } else {
            sb.append("<RegionManId>").append("</RegionManId>");
        }
        if (StringUtils.isNotEmpty(pa.getCityManagerName())) {
            sb.append("<CityMan>").append(pa.getCityManagerName()).append("</CityMan>");
        } else {
            sb.append("<CityMan>").append("</CityMan>");
        }
        if (StringUtils.isNotEmpty(pa.getCityManagerId())) {
            sb.append("<CityManId>").append(pa.getCityManagerId()).append("</CityManId>");
        } else {
            sb.append("<CityManId>").append("</CityManId>");
        }
        if (StringUtils.isNotEmpty(pa.getMarketManagerName())) {
            sb.append("<MktRep>").append(pa.getMarketManagerName()).append("</MktRep>");
        } else {
            sb.append("<MktRep>").append("</MktRep>");
        }
        if (StringUtils.isNotEmpty(pa.getMarketManagerId())) {
            sb.append("<MktRepId>").append(pa.getMarketManagerId()).append("</MktRepId>");
        } else {
            sb.append("<MktRepId>").append("</MktRepId>");
        }
        if (StringUtils.isNotEmpty(pa.getCurrencyCode())) {
            sb.append("<CurcyCode>").append(pa.getCurrencyCode()).append("</CurcyCode>");
        } else {
            sb.append("<CurcyCode>").append("</CurcyCode>");
        }
        if (StringUtils.isNotEmpty(pa.getSaleTaxName())) {
            sb.append("<TaxCode>").append(pa.getSaleTaxName()).append("</TaxCode>");
        } else {
            sb.append("<TaxCode>").append("</TaxCode>");
        }
        if (StringUtils.isNotEmpty(pa.getInvoiceTypeName())) {
            sb.append("<BillType>").append(pa.getInvoiceTypeName()).append("</BillType>");
        } else {
            sb.append("<BillType>").append("</BillType>");
        }
        if (StringUtils.isNotEmpty(pa.getIsInvoiceFreezed())) {
            sb.append("<InvFrozenFlg>").append(pa.getIsInvoiceFreezed()).append("</InvFrozenFlg>");
        } else {
            sb.append("<InvFrozenFlg>").append("</InvFrozenFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getIsOrderFreezed())) {
            sb.append("<OrderFrozenFlg>").append(pa.getIsOrderFreezed()).append("</OrderFrozenFlg>");
        } else {
            sb.append("<OrderFrozenFlg>").append("</OrderFrozenFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getIsDeliveryFreezed())) {
            sb.append("<ShipFrozenFlg>").append(pa.getIsDeliveryFreezed()).append("</ShipFrozenFlg>");
        } else {
            sb.append("<ShipFrozenFlg>").append("</ShipFrozenFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getIsCreditManaged())) {
            sb.append("<CrdtManFlg>").append(pa.getIsCreditManaged()).append("</CrdtManFlg>");
        } else {
            sb.append("<CrdtManFlg>").append("</CrdtManFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getIsStockShow())) {
            sb.append("<OrgInvFlg>").append(pa.getIsStockShow()).append("</OrgInvFlg>");
        } else {
            sb.append("<OrgInvFlg>").append("</OrgInvFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getIsStockReceived())) {
            sb.append("<DefRcvFlg>").append(pa.getIsStockReceived()).append("</DefRcvFlg>");
        } else {
            sb.append("<DefRcvFlg>").append("</DefRcvFlg>");
        }
        if (StringUtils.isNotNull(pa.getAdditionalRatio())) {
            sb.append("<RepCalValue>").append(pa.getAdditionalRatio()).append("</RepCalValue>");
        } else {
            sb.append("<RepCalValue>").append("</RepCalValue>");
        }
        if (StringUtils.isNotEmpty(pa.getIsAdditionalCal())) {
            sb.append("<RepCalFlg>").append(pa.getIsAdditionalCal()).append("</RepCalFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getPartnerLevelName())) {
            sb.append("<PartnerLevel>").append(pa.getPartnerLevelName()).append("</PartnerLevel>");
        }
        if (StringUtils.isNotEmpty(pa.getCreditLevelName())) {
            sb.append("<CreditLvl>").append(pa.getCreditLevelName()).append("</CreditLvl>");
        }
        if (StringUtils.isNotEmpty(pa.getOrderTypeName())) {
            sb.append("<OrderType>").append(pa.getOrderTypeName()).append("</OrderType>");
        }
        if (StringUtils.isNotEmpty(pa.getRtnOrderTypeName())) {
            sb.append("<RetOrderType>").append(pa.getRtnOrderTypeName()).append("</RetOrderType>");
        }
        if (StringUtils.isNotEmpty(pa.getStockReceiveTypeName())) {
            sb.append("<DefRcvType>").append(pa.getStockReceiveTypeName()).append("</DefRcvType>");
        }
        if (StringUtils.isNotEmpty(pa.getPurchaseSaleName())) {
            sb.append("<PurchaseMode>").append(pa.getPurchaseSaleName()).append("</PurchaseMode>");
        }
        if (StringUtils.isNotEmpty(pa.getSettlementModeName())) {
            sb.append("<SettleMode>").append(pa.getSettlementModeName()).append("</SettleMode>");
        }
        if (StringUtils.isNotEmpty(pa.getDeliveryLevelName())) {
            sb.append("<ShipPriority>").append(pa.getDeliveryLevelName()).append("</ShipPriority>");
        }
        if (StringUtils.isNotEmpty(pa.getDeliveryCodeName())) {
            sb.append("<ShipType>").append(pa.getDeliveryCodeName()).append("</ShipType>");
        }
        if (StringUtils.isNotNull(pa.getTransportOnlineCode())) {
            sb.append("<TrnsprtPeriod>").append(pa.getTransportOnlineCode()).append("</TrnsprtPeriod>");
        } else {
            sb.append("<TrnsprtPeriod>").append("</TrnsprtPeriod>");
        }
        if (pa.getStartDt() == null) {
            sb.append("<StartDate></StartDate>");
        } else {
            sb.append("<StartDate>").append(DateUtils.formartDate((Date)pa.getStartDt(), (String)"MM/dd/yyyy")).append("</StartDate>");
        }
        if (pa.getEndDt() == null) {
            sb.append("<EndDate></EndDate>");
        } else {
            sb.append("<EndDate>").append(DateUtils.formartDate((Date)pa.getEndDt(), (String)"MM/dd/yyyy")).append("</EndDate>");
        }
        if (StringUtils.isNotEmpty(pa.getGiftCtrlMode())) {
            sb.append("<GiftCtrlMode>").append(pa.getGiftCtrlModeName()).append("</GiftCtrlMode>");
        } else {
            sb.append("<GiftCtrlMode>").append("</GiftCtrlMode>");
        }
        if (StringUtils.isNotEmpty(pa.gettHCJGiftBalance())) {
            sb.append("<THCJGiftBalance>").append(pa.gettHCJGiftBalance()).append("</THCJGiftBalance>");
        } else {
            sb.append("<THCJGiftBalance>").append("</THCJGiftBalance>");
        }
        if (StringUtils.isNotEmpty(pa.getNothingCanOrderFlg())) {
            sb.append("<NothingCanOrderFlg>").append(pa.getNothingCanOrderFlg()).append("</NothingCanOrderFlg>");
        } else {
            sb.append("<NothingCanOrderFlg>").append("</NothingCanOrderFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getPackCtrlFlg())) {
            sb.append("<PackControlFlg>").append(pa.getPackCtrlFlg()).append("</PackControlFlg>");
        } else {
            sb.append("<PackControlFlg>").append("</PackControlFlg>");
        }
        if (StringUtils.isNotEmpty(pa.getZxbzsFlg())) {
            sb.append("<ZXBZSFlag>").append(pa.getZxbzsFlg()).append("</ZXBZSFlag>");
        } else {
            sb.append("<ZXBZSFlag>").append("</ZXBZSFlag>");
        }
        if (StringUtils.isNotEmpty(pa.getPriceDecimalDigits())) {
            sb.append("<DecimalDigits>").append(pa.getPriceDecimalDigits()).append("</DecimalDigits>");
        } else {
            sb.append("<DecimalDigits>").append("</DecimalDigits>");
        }
        if (StringUtils.isNotEmpty(pa.getRelatedDelearId())) {
            sb.append("<RelatedPartnerId>").append(pa.getRelatedDelearId()).append("</RelatedPartnerId>");
        } else {
            sb.append("<RelatedPartnerId>").append("</RelatedPartnerId>");
        }
        List<PartnerAddressRecord> adList = pa.getAddresses();
        if (adList.size() > 0) {
            sb.append("<ListOfComAddress>");
            for (PartnerAddressRecord ad : adList) {
                sb.append("<ComAddress>");
                if (StringUtils.isNotEmpty(ad.getSiebelId())) {
                    sb.append("<Id>").append(ad.getSiebelId()).append("</Id>");
                } else {
                    sb.append("<Id>").append(String.valueOf(Math.random()).substring(0, 10)).append("</Id>");
                }
                if (StringUtils.isNotEmpty(ad.getAddressTypeName())) {
                    sb.append("<Type>").append(ad.getAddressTypeName()).append("</Type>");
                }
                if (StringUtils.isNotEmpty(ad.getCountryName())) {
                    sb.append("<Country>").append(ad.getCountryName()).append("</Country>");
                }
                if (StringUtils.isNotEmpty(ad.getProvinceName())) {
                    sb.append("<State>").append(ad.getProvinceName()).append("</State>");
                }
                if (StringUtils.isNotEmpty(ad.getCityName())) {
                    sb.append("<City>").append(ad.getCityName()).append("</City>");
                }
                if (StringUtils.isNotEmpty(ad.getCountyName())) {
                    sb.append("<County>").append(ad.getCountyName()).append("</County>");
                }
                if (StringUtils.isNotEmpty(ad.getAddress())) {
                    sb.append("<StreetAddress>").append(ad.getAddress()).append("</StreetAddress>");
                } else {
                    sb.append("<StreetAddress>").append("</StreetAddress>");
                }
                if (StringUtils.isEmpty(ad.getZip())) {
                    sb.append("<PostalCode>").append("</PostalCode>");
                } else {
                    sb.append("<PostalCode>").append(ad.getZip()).append("</PostalCode>");
                }
                if (StringUtils.isEmpty(ad.getCityManagerId())) {
                    sb.append("<CityManId>").append("</CityManId>");
                } else {
                    sb.append("<CityManId>").append(ad.getCityManagerId()).append("</CityManId>");
                }
                if (ad.getStartDt() == null) {
                    sb.append("<StartDate></StartDate>");
                } else {
                    sb.append("<StartDate>").append(DateUtils.formartDate((Date)ad.getStartDt(), (String)"MM/dd/yyyy")).append("</StartDate>");
                }
                if (ad.getEndDt() == null) {
                    sb.append("<EndDate></EndDate>");
                } else {
                    sb.append("<EndDate>").append(DateUtils.formartDate((Date)ad.getEndDt(), (String)"MM/dd/yyyy")).append("</EndDate>");
                }
                if (StringUtils.isNotEmpty(ad.getContactCode())) {
                    sb.append("<DefPerId>").append(ad.getContactCode()).append("</DefPerId>");
                }
                if (StringUtils.isNotEmpty(ad.getContactPhone())) {
                    sb.append("<DefPerPhone>").append(ad.getContactPhone()).append("</DefPerPhone>");
                }
                if (StringUtils.isNotEmpty(ad.getReceiveTimeName())) {
                    sb.append("<RcvDateType>").append(ad.getReceiveTimeName()).append("</RcvDateType>");
                }
                if (StringUtils.isNotEmpty(ad.getCityManagerId())) {
                    sb.append("<CityManId>").append(ad.getCityManagerId()).append("</CityManId>");
                } else {
                    sb.append("<CityManId>").append("</CityManId>");
                }
                if (StringUtils.isNotEmpty(ad.getHarvestWarehouse())) {
                    sb.append("<DefWareHouseId>").append(ad.getHarvestWarehouse()).append("</DefWareHouseId>");
                } else {
                    sb.append("<DefWareHouseId>").append("</DefWareHouseId>");
                }
                if (StringUtils.isNotEmpty(ad.getDisDelearId())) {
                    sb.append("<DisPartnerId>").append(ad.getDisDelearId()).append("</DisPartnerId>");
                } else {
                    sb.append("<DisPartnerId>").append("</DisPartnerId>");
                }
                sb.append("<CreatorId>").append(ad.getCreatorId()).append("</CreatorId>");
                sb.append("<CreateDt>").append(DateUtils.formartDate((Date)ad.getCreateDt(), (String)"MM/dd/yyyy")).append("</CreateDt>");
                sb.append("<LastUpdatorId>").append(ad.getLastUpdatorId()).append("</LastUpdatorId>");
                sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)ad.getLastUpdateDt(), (String)"MM/dd/yyyy")).append("</LastUpdateDt>");
                sb.append("</ComAddress>");
            }
            sb.append("</ListOfComAddress>");
        }
        sb.append("</Organization></ListOfOrganization>");
        List<PartnerContactRecord> cList = pa.getContacts();
        if (cList.size() > 0) {
            sb.append("<ListOfContact>");
            for (PartnerContactRecord c : cList) {
                sb.append("<Contact>");
                sb.append("<Id>").append(c.getId()).append("</Id>");
                if (StringUtils.isNotEmpty(c.getDutyTypeName())) {
                    sb.append("<RoleType>").append(c.getDutyTypeName()).append("</RoleType>");
                }
                if (StringUtils.isNotEmpty(c.getContactName())) {
                    sb.append("<FullName>").append(c.getContactName()).append("</FullName>");
                }
                if (StringUtils.isNotEmpty(c.getTel())) {
                    sb.append("<PrimaryPhone>").append(c.getTel()).append("</PrimaryPhone>");
                } else {
                    sb.append("<PrimaryPhone>").append("</PrimaryPhone>");
                }
                if (StringUtils.isNotEmpty(c.getMobile())) {
                    sb.append("<PhoneNumber>").append(c.getMobile()).append("</PhoneNumber>");
                }
                if (StringUtils.isNotEmpty(c.getFax())) {
                    sb.append("<FaxPhone>").append(c.getFax()).append("</FaxPhone>");
                } else {
                    sb.append("<FaxPhone>").append("</FaxPhone>");
                }
                if (StringUtils.isNotNull(pa.getMasterOuId())) {
                    sb.append("<OrganizationId>").append(pa.getMasterOuId()).append("</OrganizationId>");
                } else {
                    sb.append("<OrganizationId>").append("</OrganizationId>");
                }
                if (StringUtils.isNotEmpty(c.getQq())) {
                    sb.append("<QQ>").append(c.getQq()).append("</QQ>");
                } else {
                    sb.append("<QQ>").append("</QQ>");
                }
                if (StringUtils.isNotEmpty(c.getEmail())) {
                    sb.append("<Email>").append(c.getEmail()).append("</Email>");
                } else {
                    sb.append("<Email>").append("</Email>");
                }
                if (StringUtils.isNotEmpty(c.getAddress())) {
                    sb.append("<Address>").append(c.getAddress()).append("</Address>");
                } else {
                    sb.append("<Address>").append("</Address>");
                }
                if (c.getStartDate() == null) {
                    sb.append("<StartDate></StartDate>");
                } else {
                    sb.append("<StartDate>").append(DateUtils.formartDate((Date)c.getStartDate(), (String)"MM/dd/yyyy")).append("</StartDate>");
                }
                if (c.getEndDate() == null) {
                    sb.append("<EndDate></EndDate>");
                } else {
                    sb.append("<EndDate>").append(DateUtils.formartDate((Date)c.getEndDate(), (String)"MM/dd/yyyy")).append("</EndDate>");
                }
                if ("N".equals(c.getIsContact())) {
                    sb.append("<IsContactFlg>N</IsContactFlg>");
                } else {
                    sb.append("<IsContactFlg>Y</IsContactFlg>");
                }
                sb.append("<CreatorId>").append(c.getCreatorId()).append("</CreatorId>");
                sb.append("<CreateDt>").append(DateUtils.formartDate((Date)c.getCreateDt(), (String)"MM/dd/yyyy")).append("</CreateDt>");
                sb.append("<LastUpdatorId>").append(c.getLastUpdatorId()).append("</LastUpdatorId>");
                sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)c.getLastUpdateDt(), (String)"MM/dd/yyyy")).append("</LastUpdateDt>");
                sb.append("</Contact>");
            }
            sb.append("</ListOfContact>");
        }
        sb.append("</ChannelPartner></ListOfChannelPartner>");
        String xml = sb.toString();
        System.err.println("------------------->>>>>>>>>>>>>>>>>>>>" + xml);
        return xml;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updatePartnerShipFlag(String xml) throws RuntimeException {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_UpdPrtnShipFlg_WF");
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException es) {
            try {
                throw es;
                catch (Exception e) {
                    throw new AppException("0010", e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String batchAddToSiebel(List<PartnerRecord> list, int type) {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService("Workflow Process Manager");
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Partner_IU_WF");
            String xml = "";
            StringBuffer sBuffer = new StringBuffer("");
            int num = 0;
            int i = 0;
            while (true) {
                if (i >= list.size()) {
                    string = sBuffer.toString();
                    break;
                }
                long start = System.currentTimeMillis();
                System.out.println(start / 1000L * 60L);
                SiebelUtil.formatObject(list.get(i));
                xml = this.parsePartner2xml(list.get(i), 1, type);
                input.setProperty("InXml", xml);
                input.setProperty("Source", "TCBJCRM");
                businessService.invokeMethod("RunProcess", input, output);
                String rtn = output.getProperty("ErrCode");
                String rtnDesc = output.getProperty("ErrDesc");
                String rowId = output.getProperty("PrimaryRowId");
                if (!rtn.equals("100")) {
                    sBuffer.append(rtnDesc).append("\t");
                } else {
                    map.put("siebelId", rowId);
                }
                System.out.println(i);
                if (++num == 100) {
                    long end = System.currentTimeMillis() - start;
                    System.out.println(end / 1000L * 60L);
                    num = 0;
                    businessService.release();
                    dataBean.logoff();
                    dataBean = SiebelUtil.connect();
                    businessService = dataBean.getService("Workflow Process Manager");
                }
                ++i;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new AppException("0010", e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }
}

