/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.siebel.service;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.product.SecurityCodeEntity;
import com.tcbj.crm.siebel.service.SiebelUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/productSecurity"})
public class ProductSecuritySiebel {
    @RequestMapping(value={"/findSecurityCode.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findSecurityCode(Model model, SecurityCodeEntity securitycode) {
        if (StringUtils.isEmpty((String)securitycode.getDigitCode())) {
            return "/product/findsSecurity.ftl";
        }
        if (StringUtils.isEmpty((String)securitycode.getMobile())) {
            InetAddress addr = null;
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                throw new AppException("7000");
            }
            String ip = addr.getHostAddress().toString();
            securitycode.setMobile(ip);
        }
        SecurityCodeEntity returnEntity = this.securityCodeSiebel(securitycode);
        model.addAttribute("returnEntity", (Object)returnEntity);
        model.addAttribute("securitycode", (Object)securitycode);
        return "/product/findsSecurity.ftl";
    }

    public SecurityCodeEntity securityCodeSiebel(SecurityCodeEntity securityEntity) throws AppException {
        SiebelDataBean dataBean = SiebelUtil.connect();
        try {
            SiebelService businessService = dataBean.getService("TCBJ FW Check Service");
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("channelType", "3");
            input.setProperty("digitCode", securityEntity.getDigitCode());
            input.setProperty("factoryCode", "9008");
            input.setProperty("mobile", securityEntity.getMobile());
            input.setProperty("password", "tcbj_admin9008");
            input.setProperty("queryType", "1");
            businessService.invokeMethod("FW_GetProdInfoByCode", input, output);
            String SystemState = output.getProperty("systemState");
            SecurityCodeEntity siebelReturn = new SecurityCodeEntity();
            siebelReturn.setSystemState(SystemState);
            if ("000".equals(SystemState)) {
                return siebelReturn;
            }
            if ("003".equals(SystemState)) {
                return siebelReturn;
            }
            if ("004".equals(SystemState)) {
                return siebelReturn;
            }
            if ("005".equals(SystemState)) {
                return siebelReturn;
            }
            if ("006".equals(SystemState)) {
                return siebelReturn;
            }
            if ("007".equals(SystemState)) {
                return siebelReturn;
            }
            if ("008".equals(SystemState)) {
                return siebelReturn;
            }
            if ("101".equals(SystemState)) {
                return siebelReturn;
            }
            if ("102".equals(SystemState)) {
                throw new AppException("7102");
            }
            siebelReturn.setCuanhuoCode(output.getProperty("cuanhuoCode"));
            siebelReturn.setProductCode(output.getProperty("productCode"));
            siebelReturn.setProductDate(output.getProperty("productDate"));
            siebelReturn.setSendOrder(output.getProperty("sendOrder"));
            siebelReturn.setBrand(output.getProperty("brand"));
            siebelReturn.setDealer(output.getProperty("dealer"));
            siebelReturn.setMpagecode(output.getProperty("mpagecode"));
            return siebelReturn;
        }
        catch (SiebelException siebelException) {
            throw new AppException("7000");
        }
    }

    public static void main(String[] args) {
        ProductSecuritySiebel sb = new ProductSecuritySiebel();
        SecurityCodeEntity returns = sb.securityCodeSiebel(new SecurityCodeEntity());
        System.out.println(returns);
    }
}

