/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.siebel.service;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.siebel.service.SiebelUtil;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.crm.view.ExchangeOrder;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScoreSiebelService {
    private static String business = StringUtils.getBusiness();

    public String addScoreToSiebel(ExchangeOrder apply, Employee em) throws RuntimeException {
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_ExchangeOrderCreate_WF");
            String xml = this.addXml(apply, em);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "CSP");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            return rowId;
        }
        catch (AppException es) {
            throw es;
        }
        catch (Exception e) {
            throw new AppException("0010", e.getMessage());
        }
    }

    public String updateScoreToSiebel(ExchangeOrder apply) throws RuntimeException {
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_ExchangeOrderUpdate_WF");
            String xml = this.updateXml(apply);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "CSP");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            return rowId;
        }
        catch (AppException es) {
            throw es;
        }
        catch (Exception e) {
            throw new AppException("0010", e.getMessage());
        }
    }

    public String delScoreToSiebel(String id) throws RuntimeException {
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService(business);
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_ExcOrderDel_WF");
            input.setProperty("OrderId", id);
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            return rowId;
        }
        catch (AppException es) {
            throw es;
        }
        catch (Exception e) {
            throw new AppException("0010", e.getMessage());
        }
    }

    private String addXml(ExchangeOrder apply, Employee em) {
        List<ExchangeDetail> adList;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<RedeemReq>");
        sb.append("<MemberType>").append(apply.getMemberType()).append("</MemberType>");
        sb.append("<OfferId>").append(apply.getSupplierId()).append("</OfferId>");
        if (StringUtils.isNotEmpty(apply.getOrderPhone())) {
            sb.append("<MemberMobileNo>").append(apply.getOrderPhone()).append("</MemberMobileNo>");
        }
        if (StringUtils.isNotEmpty(apply.getOrderStatusName())) {
            sb.append("<DeliveryStatus>").append(apply.getOrderStatusName()).append("</DeliveryStatus>");
        }
        if (StringUtils.isNotEmpty(apply.getNo())) {
            sb.append("<SerialNumber>").append(apply.getNo()).append("</SerialNumber>");
        }
        if (StringUtils.isNotEmpty(apply.getShopNo())) {
            sb.append("<StoreNo>").append(apply.getShopNo()).append("</StoreNo>");
        }
        if (StringUtils.isNotEmpty(apply.getClerkMobileNo())) {
            sb.append("<ClerkMobileNo>").append(apply.getClerkMobileNo()).append("</ClerkMobileNo>");
        }
        if (StringUtils.isNotEmpty(apply.getPosNum())) {
            sb.append("<PosNum>").append(apply.getPosNum()).append("</PosNum>");
        }
        if (StringUtils.isNotEmpty(apply.getcSN())) {
            sb.append("<CSN>").append(apply.getcSN()).append("</CSN>");
        }
        if (StringUtils.isNotEmpty(apply.getChannelType())) {
            sb.append("<ChannelType>").append(apply.getChannelType()).append("</ChannelType>");
        }
        if (StringUtils.isNotEmpty(apply.getRedeemTypeName())) {
            sb.append("<RedeemType>").append(apply.getRedeemTypeName()).append("</RedeemType>");
        }
        if (StringUtils.isNotEmpty(apply.getReceiverName())) {
            sb.append("<ReceiverName>").append(apply.getReceiverName()).append("</ReceiverName>");
        }
        if (StringUtils.isNotEmpty(apply.getShippingAddress())) {
            sb.append("<ReceiverAddr>").append(apply.getShippingAddress()).append("</ReceiverAddr>");
        }
        if (StringUtils.isNotEmpty(apply.getPhone())) {
            sb.append("<ReceiverPhone>").append(apply.getPhone()).append("</ReceiverPhone>");
        }
        if (StringUtils.isNotEmpty(apply.getRemark())) {
            sb.append("<ReceiverComments>").append(apply.getRemark()).append("</ReceiverComments>");
        }
        if (StringUtils.isNotNull(apply.getDlvDate())) {
            sb.append("<DeliveryDate>").append(apply.getDlvDate()).append("</DeliveryDate>");
        }
        if (StringUtils.isNotEmpty(apply.getDeliveryPayFlag())) {
            sb.append("<DeliveryPayFlag>").append(apply.getDeliveryPayFlag()).append("</DeliveryPayFlag>");
        }
        if (StringUtils.isNotEmpty(apply.getComments())) {
            sb.append("<Comments>").append(apply.getComments()).append("</Comments>");
        }
        if (StringUtils.isNotEmpty(apply.getCampaignId())) {
            sb.append("<CampaignId>").append(apply.getCampaignId()).append("</CampaignId>");
        }
        if (StringUtils.isNotEmpty(apply.getExchangeOrderType())) {
            sb.append("<ExchangeOrderType>").append(apply.getExchangeOrderType()).append("</ExchangeOrderType>");
        }
        if ((adList = apply.getDetails()).size() > 0) {
            sb.append("<ProdList>");
            for (ExchangeDetail ad : adList) {
                sb.append("<ProdInfo>");
                sb.append("<BarCode>").append(ad.getBarCode()).append("</BarCode>");
                if (StringUtils.isNotEmpty(ad.getSecurityCode())) {
                    sb.append("<SecurityCode>").append(ad.getSecurityCode()).append("</SecurityCode>");
                } else {
                    sb.append("<SecurityCode>").append("</SecurityCode>");
                }
                sb.append("<Quantity>").append(ad.getQuantity()).append("</Quantity>");
                sb.append("</ProdInfo>");
            }
            sb.append("</ProdList>");
        }
        sb.append("</RedeemReq>");
        String xml = sb.toString();
        System.err.println("------------------->>>>>>>>>>>>>>>>>>>>" + xml);
        return xml;
    }

    private String updateXml(ExchangeOrder apply) {
        List<ExchangeDetail> adList;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<RedeemReq>");
        sb.append("<SerialNumber>").append(apply.getNo()).append("</SerialNumber>");
        if (StringUtils.isNotEmpty(apply.getShopNo())) {
            sb.append("<StoreNo>").append(apply.getShopNo()).append("</StoreNo>");
        }
        if (StringUtils.isNotEmpty(apply.getClerkMobileNo())) {
            sb.append("<ClerkMobileNo>").append(apply.getClerkMobileNo()).append("</ClerkMobileNo>");
        }
        if (StringUtils.isNotEmpty(apply.getPosNum())) {
            sb.append("<PosNum>").append(apply.getPosNum()).append("</PosNum>");
        }
        if (StringUtils.isNotEmpty(apply.getcSN())) {
            sb.append("<CSN>").append(apply.getcSN()).append("</CSN>");
        }
        if (StringUtils.isNotEmpty(apply.getOrderStatusName())) {
            sb.append("<DeliveryStatus>").append(apply.getOrderStatusName()).append("</DeliveryStatus>");
        }
        if (StringUtils.isNotEmpty(apply.getChannelType())) {
            sb.append("<ChannelType>").append(apply.getChannelType()).append("</ChannelType>");
        }
        if (StringUtils.isNotEmpty(apply.getRedeemTypeName())) {
            sb.append("<RedeemType>").append(apply.getRedeemTypeName()).append("</RedeemType>");
        }
        if (StringUtils.isNotEmpty(apply.getReceiverName())) {
            sb.append("<ReceiverName>").append(apply.getReceiverName()).append("</ReceiverName>");
        }
        if (StringUtils.isNotEmpty(apply.getShippingAddress())) {
            sb.append("<ReceiverAddr>").append(apply.getShippingAddress()).append("</ReceiverAddr>");
        }
        if (StringUtils.isNotEmpty(apply.getPhone())) {
            sb.append("<ReceiverPhone>").append(apply.getPhone()).append("</ReceiverPhone>");
        }
        if (StringUtils.isNotEmpty(apply.getRemark())) {
            sb.append("<ReceiverComments>").append(apply.getRemark()).append("</ReceiverComments>");
        }
        if (StringUtils.isNotNull(apply.getDlvDate())) {
            sb.append("<DeliveryDate>").append(DateUtils.formartDate((Date)apply.getDlvDate(), (String)"MM/dd/yyyy")).append("</DeliveryDate>");
        }
        if (StringUtils.isNotEmpty(apply.getDeliveryPayFlag())) {
            sb.append("<DeliveryPayFlag>").append(apply.getDeliveryPayFlag()).append("</DeliveryPayFlag>");
        }
        if (StringUtils.isNotEmpty(apply.getComments())) {
            sb.append("<Comments>").append(apply.getComments()).append("</Comments>");
        }
        if (StringUtils.isNotEmpty(apply.getCampaignId())) {
            sb.append("<CampaignId>").append(apply.getCampaignId()).append("</CampaignId>");
        }
        if (StringUtils.isNotEmpty(apply.getExchangeOrderType())) {
            sb.append("<ExchangeOrderType>").append(apply.getExchangeOrderType()).append("</ExchangeOrderType>");
        }
        if ((adList = apply.getDetails()).size() > 0) {
            sb.append("<ProdList>");
            for (ExchangeDetail ad : adList) {
                sb.append("<ProdInfo>");
                sb.append("<ItemId>").append(ad.getId()).append("</ItemId>");
                if (StringUtils.isNotEmpty(ad.getBarCode())) {
                    sb.append("<BarCode>").append(ad.getBarCode()).append("</BarCode>");
                }
                if (StringUtils.isNotEmpty(ad.getSecurityCode())) {
                    sb.append("<SecurityCode>").append(ad.getSecurityCode()).append("</SecurityCode>");
                } else {
                    sb.append("<SecurityCode>").append("</SecurityCode>");
                }
                sb.append("<Quantity>").append(ad.getQuantity()).append("</Quantity>");
                sb.append("</ProdInfo>");
            }
            sb.append("</ProdList>");
        }
        sb.append("</RedeemReq>");
        String xml = sb.toString();
        System.err.println("------------------->>>>>>>>>>>>>>>>>>>>" + xml);
        return xml;
    }
}

