/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.siebel.service;

import com.siebel.data.SiebelDataBean;
import com.tcbj.crm.siebel.service.SiebelConnectionObject;
import com.tcbj.util.BeanMap;
import com.tcbj.util.Beans;
import com.tcbj.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public class SiebelUtil {
    private static Stack<SiebelConnectionObject> stack;
    private static int MAX_TIME;
    private static AtomicInteger failedTime;

    static {
        String[] urlArray;
        stack = new Stack();
        MAX_TIME = 3;
        failedTime = new AtomicInteger(0);
        String urls = StringUtils.getConfigure("siebelUrl");
        String user = StringUtils.getConfigure("siebelUser");
        String pass = StringUtils.getConfigure("siebelPwd");
        String[] stringArray = urlArray = urls.split(",");
        int n = urlArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI u;
            String url = stringArray[n2];
            try {
                u = new URI(url);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("init siebel connection error");
            }
            SiebelConnectionObject sco = new SiebelConnectionObject(u, user, pass);
            stack.push(sco);
            ++n2;
        }
    }

    public static SiebelDataBean connect() {
        try {
            SiebelConnectionObject connection = stack.peek();
            SiebelDataBean dataBean = new SiebelDataBean();
            dataBean.login(connection.getUri().toString(), connection.getUser(), connection.getPass(), "chs");
            failedTime.set(0);
            return dataBean;
        }
        catch (Exception exception) {
            SiebelConnectionObject broken = stack.pop();
            stack.add(0, broken);
            if (stack.size() > 0 && failedTime.addAndGet(1) <= MAX_TIME) {
                return SiebelUtil.connect();
            }
            failedTime.set(0);
            throw new RuntimeException("connect siebel failed");
        }
    }

    public static String formatXmlConent(String content) {
        String result = "";
        result = content.replace("<", "&lt;");
        result = content.replace(">", "&gt;");
        result = content.replace("&", "&amp;");
        return result;
    }

    public static <T> void formatObject(T object) {
        BeanMap bean = new BeanMap(object);
        for (String key : bean.keySet()) {
            Object v = bean.get((Object)key);
            if (!Beans.isNotEmpty((Object)v) || !String.class.isAssignableFrom(v.getClass())) continue;
            String vStr = v.toString();
            vStr = SiebelUtil.formatXmlConent(vStr);
            bean.put((Object)key, (Object)vStr);
        }
    }
}

