/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.specialRule;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.specialRule.SpecialRuleService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/specialRule"})
public class SpecialRuleController
extends BaseController {
    @Autowired
    SpecialRuleService service;
    @Autowired
    ProductService productService;

    @RequestMapping(value={"/findProduct.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findProduct(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ProductCondition con, String no, Model model) {
        Employee me = this.getCurrentEmployee();
        if (me.getCurrentPartner().getParPartnerId() == null) {
            Page product = this.productService.findPartners(con, no, pageno);
            model.addAttribute("page", (Object)product);
        } else {
            Page product = this.productService.getProductStock(me.getCurrentPartner().getId(), con.getNo(), con.getProdname(), con, pageno);
            model.addAttribute("partners", (Object)product);
        }
        model.addAttribute("no", (Object)no);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "/specialRule/finds.ftl";
    }

    @RequestMapping(value={"/allotPartners.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String allotProduct(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, ProductCondition con) {
        con.setEm(this.getCurrentEmployee());
        Page product = this.service.getCustomers(this.getCurrentEmployee().getCurrentPartner().getId(), id, con, pageno);
        String plist = this.productService.getPartnerList(this.getCurrentEmployee().getCurrentPartner().getId(), this.getCurrentEmployee());
        Product prod = this.productService.get(id);
        model.addAttribute("partners", (Object)product);
        model.addAttribute("name", (Object)prod.getName());
        model.addAttribute("no", (Object)prod.getNo());
        model.addAttribute("prodno", (Object)id);
        model.addAttribute("plist", (Object)plist);
        model.addAttribute("con", (Object)con);
        return "specialRule/allot.ftl";
    }

    @RequestMapping(value={"/allotProduct.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String allotProductsbmit(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, String prodno) {
        String[] sr = id.split(":");
        try {
            this.service.updateProduct(sr, pageno, prodno, this.getCurrentEmployee());
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/abateProduct.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String abateProductsbmit(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, String prodno) {
        String[] sr = id.split(":");
        try {
            this.service.updateabateProduct(sr, pageno, prodno, this.getCurrentEmployee());
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }
}

