/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.specialRule;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PartnerProduct;
import com.tcbj.crm.entity.ProductPartnerRule;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="specialRuleService")
public class SpecialRuleService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    Cache cache;

    public Page getCustomers(String supplierId, String prodno, ProductCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(con.getEm().getId());
        args.add(supplierId);
        args.add(prodno);
        args.add(supplierId);
        StringBuffer sf = new StringBuffer();
        sf.append("from Customer a left join a.ppRule c with c.supplierId=? and c.productId=? where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and a.supplierId=? ");
        if (StringUtils.isNotEmpty((String)con.getProdname())) {
            sf.append(" and a.applyerName like ? ");
            args.add("%" + con.getProdname() + "%");
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflasedate())) {
            if ("true".equals(con.getTrueorflasedate())) {
                sf.append("and c.invalidDt is not null ");
            } else {
                sf.append("and c.invalidDt is null ");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getNo())) {
            String applyerCodes = con.getNo();
            String[] applyerCode = null;
            if (applyerCodes.contains(",")) {
                applyerCode = applyerCodes.split(",");
            } else if (applyerCodes.contains("\uff0c")) {
                applyerCode = applyerCodes.split("\uff0c");
            }
            if (applyerCode != null) {
                sf.append(" and a.applyerCode in ( ");
                int i = 0;
                while (i < applyerCode.length) {
                    sf.append(i == 0 ? "?" : ",?");
                    args.add(applyerCode[i]);
                    ++i;
                }
                sf.append(" )");
            }
        }
        if (StringUtils.isNotEmpty((String)con.getSaleChannelTypeCode())) {
            sf.append(" and a.partnerChnlType = ? ");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty((String)con.getAreaCode())) {
            sf.append(" and a.areaCode = ? ");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty((String)con.getBigAreaCode())) {
            sf.append(" and a.bigAreaCode = ? ");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty((String)con.getTrueorflasedate())) {
            if ("true".equals(con.getTrueorflase())) {
                sf.append(" and a.applyerId in (select d.applyerId from Customer d,ProductPartnerRule e where d.applyerId=e.partnerId and e.supplierId=? and e.productId=?) ");
                args.add(supplierId);
                args.add(prodno);
            } else {
                sf.append(" and a.applyerId not in (select d.applyerId from Customer d,ProductPartnerRule e where d.applyerId=e.partnerId and e.supplierId=? and e.productId=?) ");
                args.add(supplierId);
                args.add(prodno);
            }
        }
        sf.append(" and a.startdate <= ? and nvl(a.enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        sf.append(" order by a.bigAreaCode,a.areaCode ");
        Page page = this.baseDao.search(sf.toString(), args.toArray(), 500, pageno);
        return page;
    }

    public void updateProduct(String[] ids, int pageno, String productId, Employee em) throws Exception {
        int i = 0;
        while (i < ids.length) {
            Object[] args = new Object[]{ids[i], productId};
            Object[] argsRule = new Object[]{em.getCurrentPartner().getId(), ids[i], productId};
            String partnerId = ids[i];
            PartnerProduct partnerProduct = null;
            ProductPartnerRule ppRule = null;
            List list = this.baseDao.findEntity("from PartnerProduct where partnerId=? and productId=?", args, PartnerProduct.class);
            List listRule = this.baseDao.findEntity("from ProductPartnerRule where supplierId=? and partnerId=? and productId=?", argsRule, ProductPartnerRule.class);
            if (listRule.isEmpty()) {
                ppRule = new ProductPartnerRule();
                ppRule.setPartnerId(partnerId);
                ppRule.setProductId(productId);
                ppRule.setSupplierId(em.getCurrentPartner().getId());
                ppRule.fillInitData(em);
            } else {
                ppRule = (ProductPartnerRule)listRule.get(0);
                ppRule.updateLastData(em);
            }
            if (list.isEmpty()) {
                partnerProduct = new PartnerProduct();
                partnerProduct.setPartnerId(partnerId);
                partnerProduct.setProductId(productId);
                if (em.getCurrentPartner().getParPartnerId() == null) {
                    partnerProduct.setDivideQuantity(((Product)this.baseDao.get(Product.class, (Serializable)((Object)productId))).getMinUnit());
                } else {
                    PartnerProduct partnerProd = (PartnerProduct)this.baseDao.findEntity("from PartnerProduct a where a.productId=? and a.partnerId=? ", new Object[]{productId, em.getCurrentPartner().getId()}, PartnerProduct.class).get(0);
                    if (partnerProd.getDivideQuantity() != null) {
                        partnerProduct.setDivideQuantity(partnerProd.getDivideQuantity());
                    } else {
                        partnerProduct.setDivideQuantity(((Product)this.baseDao.get(Product.class, (Serializable)((Object)productId))).getMinUnit());
                    }
                }
                partnerProduct.fillInitData(em);
                this.baseDao.saveOrUpdate((Object)partnerProduct);
            }
            ppRule.setInvalidDt(null);
            this.baseDao.saveOrUpdate((Object)ppRule);
            ++i;
        }
    }

    public void updateabateProduct(String[] id, int pageno, String prodno, Employee e) throws Exception {
        int i = 0;
        while (i < id.length) {
            Object[] args = new Object[]{e.getCurrentPartner().getId(), id[i], prodno};
            ProductPartnerRule ppRule = null;
            List listRule = this.baseDao.findEntity("from ProductPartnerRule where supplierId=? and partnerId=? and productId=?", args, ProductPartnerRule.class);
            if (!listRule.isEmpty()) {
                ppRule = (ProductPartnerRule)listRule.get(0);
                ppRule.setInvalidDt(DateUtils.now());
                ppRule.fillInitData(e);
                this.baseDao.saveOrUpdate((Object)ppRule);
            }
            ++i;
        }
    }

    public List<ProductPartnerRule> getProductPartnerRuleByPartnerId(String partnerId) {
        String ids = this.cache.getRelatedIds(partnerId);
        List ppRule = this.baseDao.findEntity("from ProductPartnerRule where partnerId in (" + ids + ") and (invalidDt >= ? or invalidDt is null)", new Object[]{new Date()}, ProductPartnerRule.class);
        return ppRule;
    }

    public Map<String, ProductPartnerRule> getExcProductMapByPartnerId(String partnerId) {
        List<ProductPartnerRule> ppRule = this.getProductPartnerRuleByPartnerId(partnerId);
        HashMap<String, ProductPartnerRule> exclProduct = new HashMap<String, ProductPartnerRule>();
        for (ProductPartnerRule rule : ppRule) {
            exclProduct.put(rule.getProductId(), rule);
        }
        return exclProduct;
    }
}

