/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.systemFunction;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.EmployeeService;
import com.tcbj.crm.entity.SystemFunction;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.function.FunctionService;
import com.tcbj.crm.systemFunction.SystemFunctionService;
import com.tcbj.util.StringUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/systemFunction"})
public class SystemFunctionController
extends BaseController {
    @Autowired
    EmployeeService service;
    @Autowired
    SystemFunctionService systemFunctionService;
    @Autowired
    private FunctionService functionService;

    @RequestMapping(value={"/rootList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String rootList(String name, Model model) {
        List<SystemFunction> list = this.systemFunctionService.getRootList(name);
        model.addAttribute("function", list);
        return "systemFunction/rootList.ftl";
    }

    @RequestMapping(value={"/childList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String childList(String parentId, String name, Model model) {
        if (StringUtils.isEmpty(parentId)) {
            throw new AppException("0010", "\u5fc5\u987b\u6307\u5b9a\u7236\u529f\u80fd\uff01");
        }
        List<SystemFunction> list = this.systemFunctionService.getChildList(parentId, name);
        model.addAttribute("parentId", (Object)parentId);
        model.addAttribute("function", list);
        return "systemFunction/childList.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add() {
        return "systemFunction/add.ftl";
    }

    @RequestMapping(value={"/addChild.do"}, method={RequestMethod.GET})
    public String add(String parentId, Model model) throws Exception {
        if (!StringUtils.isNotEmpty(parentId)) {
            throw new AppException("0010", "\u7236\u529f\u80fdID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        model.addAttribute("parentId", (Object)parentId);
        model.addAttribute("parentName", (Object)this.systemFunctionService.findById(parentId).getFunctionName());
        return "systemFunction/addChild.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result save(@Valid @RequestBody SystemFunction function, Model model) {
        this.storageCode(null, function.getFunctionInvoking(), function.getFutureType());
        function.setRowId(UUID.randomUUID().toString().replace("-", ""));
        function.setCreated(new Date());
        this.systemFunctionService.save(function);
        Cache.addSystemFunction(function);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        if (StringUtils.isNotNull(id)) {
            SystemFunction function = this.systemFunctionService.findById(id);
            model.addAttribute("function", (Object)function);
        }
        return "systemFunction/update.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String update(SystemFunction function, String involve, Model model) throws IOException {
        this.storageCode(function.getRowId(), function.getFunctionInvoking(), function.getFutureType());
        this.systemFunctionService.update(function);
        if (StringUtils.isNotEmpty(involve) && "true".equals(involve)) {
            this.systemFunctionService.updateChilds(function.getRowId(), function.getFutureState());
        }
        if (StringUtils.isEmpty(function.getParentId())) {
            return this.redirect("/systemFunction/rootList.do");
        }
        return this.redirect("/systemFunction/childList.do?parentId=" + function.getParentId());
    }

    @RequestMapping(value={"/validateDel.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String validateDel(String id, Model model) {
        boolean isExist = this.systemFunctionService.haveChild(id);
        return String.valueOf(isExist);
    }

    @RequestMapping(value={"/deleteFunctions.do"})
    public String deleteFunctions(String id, Model model) {
        SystemFunction function = this.systemFunctionService.findById(id);
        if (function == null) {
            new AppException("0010", "\u8be5\u6570\u636e\u5df2\u88ab\u5220\u9664\uff01");
        }
        this.systemFunctionService.deleteAll(function);
        if (StringUtils.isEmpty(function.getParentId())) {
            return this.redirect("/systemFunction/rootList.do");
        }
        return this.redirect("/systemFunction/childList.do?parentId=" + function.getParentId());
    }

    public void storageCode(String id, String url, String futureType) {
        boolean vaildate = this.systemFunctionService.validata(id, url, futureType);
        if (!vaildate) {
            throw new AppException("0010", "\u5df2\u5b58\u5728\u76f8\u540c\u529f\u80fdURL\u548c\u76f8\u540c\u8bf7\u6c42\u7c7b\u578b\u7684\u529f\u80fd\uff01");
        }
    }
}

