/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.systemFunction;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.SystemFunction;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="systemFunctionService")
public class SystemFunctionService {
    @Autowired
    private BaseDao baseDao;

    public List<SystemFunction> getRootList(String name) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from SystemFunction where 1=1 ");
        hql.append(" and parentId is null");
        if (StringUtils.isNotEmpty(name)) {
            hql.append(" and ");
            hql.append(" ( ");
            hql.append(" functionName like ? ");
            hql.append(" ) ");
            args.add("%" + name + "%");
        }
        hql.append(" order by created asc ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), SystemFunction.class);
    }

    public SystemFunction findById(String id) {
        return (SystemFunction)this.baseDao.get(SystemFunction.class, (Serializable)((Object)id));
    }

    public List<SystemFunction> getChildList(String parentId, String name) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from SystemFunction where 1=1 ");
        if (StringUtils.isNotEmpty(parentId)) {
            hql.append(" and parentId = ?");
            args.add(parentId);
        }
        if (StringUtils.isNotEmpty(name)) {
            hql.append(" and ");
            hql.append(" ( ");
            hql.append(" functionName like ? ");
            hql.append(" ) ");
            args.add("%" + name + "%");
        }
        hql.append(" order by created asc ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), SystemFunction.class);
    }

    public void save(SystemFunction function) {
        this.baseDao.save((Object)function);
    }

    public void delete(String id) {
        this.baseDao.deleteById(SystemFunction.class, (Serializable)((Object)id));
    }

    public void update(SystemFunction function) {
        this.baseDao.update((Object)function);
        Cache.updateSystemFunction(function);
    }

    public boolean haveChild(String id) {
        boolean isExist = false;
        List list = this.baseDao.findEntity("from SystemFunction where parentId = ?", new Object[]{id});
        if (list.size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public void deleteAll(SystemFunction function) {
        List<SystemFunction> list = new ArrayList();
        list = this.baseDao.findEntity("from SystemFunction where parentId = ?", new Object[]{function.getRowId()}, SystemFunction.class);
        list.add(function);
        this.baseDao.deleteAll(list);
        Cache.deleteSystemFunction(list);
    }

    public boolean validata(String id, String url, String futureType) {
        boolean result = true;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" from SystemFunction where 1=1");
        sb.append(" and functionInvoking = ? ");
        args.add(url);
        sb.append(" and futureType in ( ");
        sb.append("?");
        args.add(futureType);
        if (!"GET_POST".equals(futureType)) {
            sb.append(", ? ");
            args.add("GET_POST");
        } else {
            sb.append(" , ? , ?");
            args.add("GET");
            args.add("POST");
        }
        sb.append(")");
        List list = this.baseDao.findEntity(sb.toString(), args.toArray(), SystemFunction.class);
        if (list != null && list.size() > 0 && !((SystemFunction)list.get(0)).getRowId().equals(id)) {
            result = false;
        }
        return result;
    }

    public void updateChilds(String parentId, String futureState) {
        List list = this.baseDao.findEntity("from SystemFunction where parentId = ?", new Object[]{parentId}, SystemFunction.class);
        if (list != null && list.size() > 0) {
            ArrayList<SystemFunction> temp = new ArrayList<SystemFunction>();
            for (SystemFunction systemFunction : list) {
                systemFunction.setFutureState(futureState);
                temp.add(systemFunction);
            }
            this.baseDao.update(temp);
            for (SystemFunction systemFunction : temp) {
                Cache.updateSystemFunction(systemFunction);
            }
        }
    }
}

