/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.target;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.EmployeeMatchCustomer;
import com.tcbj.crm.entity.Target;
import com.tcbj.crm.entity.TargetRate;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.target.EmployeeMatchCustomerCondition;
import com.tcbj.crm.target.TargetCondition;
import com.tcbj.crm.target.TargetService;
import com.tcbj.crm.target.TargetViewEx;
import com.tcbj.crm.target.TargetWrap;
import com.tcbj.crm.targetrate.TargetRateService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/target"})
public class TargetController
extends BaseController {
    @Autowired
    TargetService targetService;
    @Autowired
    TargetRateService targetRateService;

    @RequestMapping(value={"/queryByCustomer.do"}, method={RequestMethod.GET})
    public String query(Model model) {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        if (emp.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        return "target/queryByCustomer2.ftl";
    }

    private void setYears(Model model) {
        int currentYear = Calendar.getInstance().get(1);
        ArrayList<Integer> years = new ArrayList<Integer>();
        int i = 0;
        while (i < 5) {
            years.add(++currentYear);
            ++i;
        }
        model.addAttribute("years", years);
    }

    @RequestMapping(value={"/queryByCustomer.do"}, method={RequestMethod.POST})
    public String query(TargetCondition condition, Model model, @RequestParam(value="pageNo", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(condition.getYear())) {
            condition.setYear(String.valueOf(DateUtils.getYear()));
        }
        List list = this.targetService.queryByCustomer(condition, emp, pageNo, rowsize).getList();
        model.addAttribute("datas", (Object)JSON.toJSONString((Object)list));
        model.addAttribute("list", (Object)list);
        condition.setYear(String.valueOf(Integer.valueOf(condition.getYear()) + 1));
        model.addAttribute("condition", (Object)condition);
        return "target/queryByCustomer2.ftl";
    }

    @RequestMapping(value={"/newQueryByCustomer.do"})
    @ResponseBody
    public Page query(TargetCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(condition.getYear())) {
            condition.setYear(String.valueOf(DateUtils.getYear()));
        }
        Page page = this.targetService.queryByCustomer(condition, emp, pageno, rowsize);
        return page;
    }

    @RequestMapping(value={"/exportCustomer.do"}, method={RequestMethod.POST})
    public void exportCustomer(TargetCondition condition, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNo", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(condition.getYear())) {
            condition.setYear(String.valueOf(DateUtils.getYear()));
        }
        List list = this.targetService.queryByCustomer(condition, emp, pageNo, rowsize).getList();
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "target");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        TargetService.exportCustomer(list, dir.getPath(), String.valueOf(emp.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    @RequestMapping(value={"/queryByBigarea.do"}, method={RequestMethod.GET})
    public String queryBigarea(Model model) {
        this.setYears(model);
        Employee em = this.getCurrentEmployee();
        if (em.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        return "target/queryByBigarea.ftl";
    }

    @RequestMapping(value={"/queryByBigarea.do"}, method={RequestMethod.POST})
    public String queryBigarea(TargetCondition condition, Model model, @RequestParam(value="pageNo", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        this.setYears(model);
        model.addAttribute("condition", (Object)condition);
        Employee emp = this.getCurrentEmployee();
        List list = this.targetService.queryByBigarea(condition, emp, pageNo, rowsize).getList();
        model.addAttribute("list", (Object)list);
        model.addAttribute("datas", (Object)JSON.toJSONString((Object)list));
        Page page = new Page();
        page.setList(list);
        return "target/queryByBigarea.ftl";
    }

    @RequestMapping(value={"/newQueryByBigarea.do"})
    @ResponseBody
    public Page queryBigarea(TargetCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        Employee emp = this.getCurrentEmployee();
        Page page = this.targetService.queryByBigarea(condition, emp, pageno, rowsize);
        return page;
    }

    @RequestMapping(value={"/queryBySalesman.do"}, method={RequestMethod.GET})
    public String queryBySalesman(Model model) {
        this.setYears(model);
        Employee em = this.getCurrentEmployee();
        if (em.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        return "target/queryBySalesman.ftl";
    }

    @RequestMapping(value={"/queryBySalesman.do"}, method={RequestMethod.POST})
    public String queryBySalesman(TargetCondition condition, Model model, @RequestParam(value="pageNo", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        this.setYears(model);
        model.addAttribute("condition", (Object)condition);
        Employee emp = this.getCurrentEmployee();
        List list = this.targetService.queryBySalesman(condition, emp, pageNo, rowsize).getList();
        model.addAttribute("list", (Object)list);
        model.addAttribute("datas", (Object)JSON.toJSONString((Object)list));
        return "target/queryBySalesman.ftl";
    }

    @RequestMapping(value={"/newQueryBySalesman.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page queryBySalesman(TargetCondition condition, @RequestParam(value="pageNo", required=false, defaultValue="1") int pageno, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        Employee emp = this.getCurrentEmployee();
        Page list = this.targetService.queryBySalesman(condition, emp, pageno, Integer.MAX_VALUE);
        return list;
    }

    @RequestMapping(value={"/queryByAllTarget.do"}, method={RequestMethod.GET})
    public String queryByAllTarget(Model model) {
        Employee em = this.getCurrentEmployee();
        if (em.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        TargetCondition con = new TargetCondition();
        con.setYear(String.valueOf(DateUtils.getYear()));
        model.addAttribute("condition", (Object)con);
        return "target/queryByAllTarget.ftl";
    }

    @RequestMapping(value={"/queryByAllTarget.do"}, method={RequestMethod.POST})
    public String queryByAllTarget(TargetCondition condition, Model model, @RequestParam(value="pageNo", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(condition.getYear())) {
            condition.setYear(String.valueOf(DateUtils.getYear()));
        }
        List<TargetWrap> listNew = this.setAllTarget(condition, emp, pageNo, rowsize);
        model.addAttribute("datas", (Object)JSON.toJSONString(listNew));
        model.addAttribute("list", listNew);
        model.addAttribute("condition", (Object)condition);
        return "target/queryByAllTarget.ftl";
    }

    @RequestMapping(value={"/newQueryByAllTarget.do"})
    @ResponseBody
    public List<TargetWrap> queryByAllTarget(TargetCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(condition.getYear())) {
            condition.setYear(String.valueOf(DateUtils.getYear()));
        }
        List<TargetWrap> listNew = this.setAllTarget(condition, emp, pageno, Integer.MAX_VALUE);
        return listNew;
    }

    @RequestMapping(value={"viewEmclist.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String view_emc(EmployeeMatchCustomerCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        Page page = this.targetService.getCustomerMatchPerson(con, em);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "target/viewEmployeeMatchCustomer.ftl";
    }

    @RequestMapping(value={"editEmployeeMatchCustomer.do"}, method={RequestMethod.GET})
    public String batch_emc() {
        return "target/batchEmc.ftl";
    }

    @RequestMapping(value={"getEmployeeMatchCustomerPage.do"}, method={RequestMethod.GET})
    @ResponseBody
    public Page getEmployeeMatchCustomerPage(EmployeeMatchCustomerCondition con) {
        Employee em = this.getCurrentEmployee();
        con.setPageSize(con.getRowsize());
        return this.targetService.getCustomerMatchPerson(con, em);
    }

    @RequestMapping(value={"editBatchEmployeeMatchCustomer.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result editEmployeeMatchCustomer(@Valid @RequestBody EmployeeMatchCustomerCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        List<EmployeeMatchCustomer> emcList = con.getEmcList();
        List<String> messages = this.targetService.saveBatch(emcList, em);
        if (messages.size() > 0) {
            return this.getSuccessResult(messages);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/batchEditPersonTarget.do"}, method={RequestMethod.GET})
    public String batch_person(TargetCondition condition, Model model) {
        this.setYears(model);
        return "target/batchPersonTarget.ftl";
    }

    @RequestMapping(value={"/getPersonTargetPage.do"}, method={RequestMethod.GET})
    @ResponseBody
    public Page getTargetPage2(TargetCondition condition, Model model) {
        Employee emp = this.getCurrentEmployee();
        return this.targetService.getTargetPageByPerson(condition, emp);
    }

    @RequestMapping(value={"/personList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list2(TargetCondition condition, Model model) {
        model.addAttribute("condition", (Object)condition);
        Employee emp = this.getCurrentEmployee();
        condition.setType(condition.getTargetType());
        Page page = this.targetService.getTargetByNewPersonForPage(condition, emp);
        model.addAttribute("page", (Object)page);
        return "target/viewPersonList.ftl";
    }

    @RequestMapping(value={"/personListExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void personListExcel(TargetCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) {
        model.addAttribute("condition", (Object)condition);
        Employee emp = this.getCurrentEmployee();
        condition.setRowsize(Integer.MAX_VALUE);
        List list = this.targetService.getTargetByNewPersonForPage(condition, emp).getList();
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "target");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        TargetService.excelsPerson(list, dir.getPath(), "\u4eba\u5458\u76ee\u6807\u62a5\u8868-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    @RequestMapping(value={"/customerList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(TargetCondition condition, Model model) {
        this.setYears(model);
        model.addAttribute("condition", (Object)condition);
        Employee emp = this.getCurrentEmployee();
        if (emp.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        Page page = this.targetService.getTargetPageByCustomer(condition, emp);
        model.addAttribute("page", (Object)page);
        return "target/viewCustomerList.ftl";
    }

    @RequestMapping(value={"/customerListExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excel(TargetCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        List<Target> list = this.targetService.getTargetListByCustomer(condition, emp);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "target");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        TargetService.excels(list, dir.getPath(), "\u5ba2\u6237\u76ee\u6807\u62a5\u8868-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    @RequestMapping(value={"/editTarget.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result edit_post_grd(@Valid @RequestBody TargetCondition condition) throws Exception {
        Employee me = this.getCurrentEmployee();
        String delIds = condition.getDelIds();
        List<Target> targetList = condition.getTargetList();
        this.targetService.update(targetList, delIds, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPersonTarget.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result editPersonTarget(@Valid @RequestBody TargetCondition condition) throws Exception {
        Employee me = this.getCurrentEmployee();
        String delIds = condition.getDelIds();
        List<Target> targetList = condition.getTargetList();
        this.targetService.updatePersonTarget(targetList, delIds, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/batchEditCustomerTarget.do"}, method={RequestMethod.GET})
    public String batch_customer(TargetCondition condition, Model model) {
        this.setYears(model);
        Employee em = this.getCurrentEmployee();
        if (em.isInnerPerson()) {
            model.addAttribute("hidd", (Object)"false");
        } else {
            model.addAttribute("hidd", (Object)"true");
        }
        return "target/batchTarget.ftl";
    }

    @RequestMapping(value={"/getTargetRate.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getTargetRate(TargetCondition condition) {
        Employee me = this.getCurrentEmployee();
        TargetRate targetRate = this.targetRateService.getTargetRate(me.getCurrentPartner().getId(), Long.parseLong(condition.getYear()), condition.getChannelType(), condition.getTargetType());
        if (targetRate == null) {
            throw new AppException("9220");
        }
        Double[] ms = new Double[12];
        Double all = condition.getAll();
        Double m1 = MathUtils.m2((Double)(all * targetRate.getM1() / 100.0), (int)2);
        Double m2 = MathUtils.m2((Double)(all * targetRate.getM2() / 100.0), (int)2);
        Double m3 = MathUtils.m2((Double)(all * targetRate.getM3() / 100.0), (int)2);
        Double m4 = MathUtils.m2((Double)(all * targetRate.getM4() / 100.0), (int)2);
        Double m5 = MathUtils.m2((Double)(all * targetRate.getM5() / 100.0), (int)2);
        Double m6 = MathUtils.m2((Double)(all * targetRate.getM6() / 100.0), (int)2);
        Double m7 = MathUtils.m2((Double)(all * targetRate.getM7() / 100.0), (int)2);
        Double m8 = MathUtils.m2((Double)(all * targetRate.getM8() / 100.0), (int)2);
        Double m9 = MathUtils.m2((Double)(all * targetRate.getM9() / 100.0), (int)2);
        Double m10 = MathUtils.m2((Double)(all * targetRate.getM10() / 100.0), (int)2);
        Double m11 = MathUtils.m2((Double)(all * targetRate.getM11() / 100.0), (int)2);
        Double m12 = MathUtils.m2((Double)(all - (m1 + m2 + m3 + m4 + m5 + m6 + m7 + m8 + m9 + m10 + m11)), (int)2);
        ms[0] = m1;
        ms[1] = m2;
        ms[2] = m3;
        ms[3] = m4;
        ms[4] = m5;
        ms[5] = m6;
        ms[6] = m7;
        ms[7] = m8;
        ms[8] = m9;
        ms[9] = m10;
        ms[10] = m11;
        ms[11] = m12;
        return this.getSuccessResult(ms);
    }

    @RequestMapping(value={"/getCustomerTargetPage.do"}, method={RequestMethod.GET})
    @ResponseBody
    public Page getCustomerTargetPage(TargetCondition condition, Model model) {
        Employee emp = this.getCurrentEmployee();
        return this.targetService.getTargetPageByCustomer(condition, emp);
    }

    @RequestMapping(value={"/getTargetPageByPerson.do"}, method={RequestMethod.GET})
    @ResponseBody
    public Page getTargetPageByPerson(TargetCondition condition, Model model) {
        Employee emp = this.getCurrentEmployee();
        return this.targetService.getTargetPageByPerson(condition, emp);
    }

    @RequestMapping(value={"/viewPersonList.do"}, method={RequestMethod.GET})
    public String viewPersonList(TargetCondition condition, Model model) {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        Page page = this.targetService.getTargetPageByCustomer(condition, emp);
        model.addAttribute("page", (Object)page);
        return "target/viewPersonList.ftl";
    }

    public List<TargetViewEx> TargetToViewEx(List<TargetWrap> targetList) {
        ArrayList<TargetViewEx> targetFile = new ArrayList<TargetViewEx>();
        for (TargetWrap targetWrap : targetList) {
            TargetViewEx viewEx = new TargetViewEx();
            Target target = targetWrap.getTarget();
            viewEx.setTypeName(target.getTypeName());
            viewEx.setYear(target.getYear().toString());
            viewEx.setBrandName(target.getBrandName());
            viewEx.setSaleChannelTypeName(target.getChannelName());
            viewEx.setBigAreaName(target.getBigAreaName());
            viewEx.setAreaName(target.getAreaName());
            viewEx.setCustomerName(target.getCustomerName());
            viewEx.setM1(this.vIsNull(target.getM1()));
            viewEx.setM2(this.vIsNull(target.getM2()));
            viewEx.setM3(this.vIsNull(target.getM3()));
            viewEx.setM4(this.vIsNull(target.getM4()));
            viewEx.setM5(this.vIsNull(target.getM5()));
            viewEx.setM6(this.vIsNull(target.getM6()));
            viewEx.setM7(this.vIsNull(target.getM7()));
            viewEx.setM8(this.vIsNull(target.getM8()));
            viewEx.setM9(this.vIsNull(target.getM9()));
            viewEx.setM10(this.vIsNull(target.getM10()));
            viewEx.setM11(this.vIsNull(target.getM11()));
            viewEx.setM12(this.vIsNull(target.getM12()));
            viewEx.setM1Data(targetWrap.getM1Data().toString());
            viewEx.setM2Data(targetWrap.getM2Data().toString());
            viewEx.setM3Data(targetWrap.getM3Data().toString());
            viewEx.setM4Data(targetWrap.getM4Data().toString());
            viewEx.setM5Data(targetWrap.getM5Data().toString());
            viewEx.setM6Data(targetWrap.getM6Data().toString());
            viewEx.setM7Data(targetWrap.getM7Data().toString());
            viewEx.setM8Data(targetWrap.getM8Data().toString());
            viewEx.setM9Data(targetWrap.getM9Data().toString());
            viewEx.setM10Data(targetWrap.getM10Data().toString());
            viewEx.setM11Data(targetWrap.getM11Data().toString());
            viewEx.setM12Data(targetWrap.getM12Data().toString());
            viewEx.setM1Progress(targetWrap.getM1Progress());
            viewEx.setM2Progress(targetWrap.getM2Progress());
            viewEx.setM3Progress(targetWrap.getM3Progress());
            viewEx.setM4Progress(targetWrap.getM4Progress());
            viewEx.setM5Progress(targetWrap.getM5Progress());
            viewEx.setM6Progress(targetWrap.getM6Progress());
            viewEx.setM7Progress(targetWrap.getM7Progress());
            viewEx.setM8Progress(targetWrap.getM8Progress());
            viewEx.setM9Progress(targetWrap.getM9Progress());
            viewEx.setM10Progress(targetWrap.getM10Progress());
            viewEx.setM11Progress(targetWrap.getM11Progress());
            viewEx.setM12Progress(targetWrap.getM12Progress());
            targetFile.add(viewEx);
        }
        return targetFile;
    }

    @RequestMapping(value={"/export.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exprotExcel(TargetCondition condition, Model model, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNo", required=false, defaultValue="1") int pageNo, @RequestParam(value="rowsize", required=false, defaultValue="20") int rowsize) {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(condition.getYear())) {
            condition.setYear(String.valueOf(DateUtils.getYear()));
        }
        List<TargetViewEx> excelDatas = this.TargetToViewEx(this.setAllTarget(condition, emp, pageNo, Integer.MAX_VALUE));
        String[] titles = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5e74\u4efd", "\u54c1\u724c", "\u6e20\u9053", "\u5927\u533a", "\u533a\u57df", "\u5ba2\u6237", "1\u6708\u76ee\u6807", "1\u6708\u5b9e\u9645", "1\u6708\u5b8c\u6210\u7387", "2\u6708\u76ee\u6807", "2\u6708\u5b9e\u9645", "2\u6708\u5b8c\u6210\u7387", "3\u6708\u76ee\u6807", "3\u6708\u5b9e\u9645", "3\u6708\u5b8c\u6210\u7387", "4\u6708\u76ee\u6807", "4\u6708\u5b9e\u9645", "4\u6708\u5b8c\u6210\u7387", "5\u6708\u76ee\u6807", "5\u6708\u5b9e\u9645", "5\u6708\u5b8c\u6210\u7387", "6\u6708\u76ee\u6807", "6\u6708\u5b9e\u9645", "6\u6708\u5b8c\u6210\u7387", "7\u6708\u76ee\u6807", "7\u6708\u5b9e\u9645", "7\u6708\u5b8c\u6210\u7387", "8\u6708\u76ee\u6807", "8\u6708\u5b9e\u9645", "8\u6708\u5b8c\u6210\u7387", "9\u6708\u76ee\u6807", "9\u6708\u5b9e\u9645", "9\u6708\u5b8c\u6210\u7387", "10\u6708\u76ee\u6807", "10\u6708\u5b9e\u9645", "10\u6708\u5b8c\u6210\u7387", "11\u6708\u76ee\u6807", "11\u6708\u5b9e\u9645", "11\u6708\u5b8c\u6210\u7387", "12\u6708\u76ee\u6807", "12\u6708\u5b9e\u9645", "12\u6708\u5b8c\u6210\u7387"};
        try {
            ExcelUtils.exportExcel("\u76ee\u6807\u5b8c\u6210\u60c5\u51b5\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u76ee\u6807\u5b8c\u6210\u60c5\u51b5", titles, excelDatas, response);
        }
        catch (Exception e) {
            throw new AppException("\u76ee\u6807\u5b8c\u6210\u60c5\u51b5\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    public List<TargetWrap> setAllTarget(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        List<TargetWrap> listCus = this.targetService.queryByTarget(condition, emp, "0", pageNo, rowsize);
        List<TargetWrap> listObj = this.targetService.queryByTarget(condition, emp, "1", pageNo, rowsize);
        List<TargetWrap> lisTarea = this.targetService.queryByTarget(condition, emp, "2", pageNo, rowsize);
        List<TargetWrap> listBig = this.targetService.queryByTarget(condition, emp, "3", pageNo, rowsize);
        List<TargetWrap> listChan = this.targetService.queryByTarget(condition, emp, "4", pageNo, rowsize);
        List<TargetWrap> listAll = this.targetService.queryByTarget(condition, emp, "5", pageNo, rowsize);
        ArrayList<TargetWrap> listNew = new ArrayList<TargetWrap>();
        for (TargetWrap targeAll : listAll) {
            String objId;
            Target obj;
            listNew.add(targeAll);
            Target all = targeAll.getTarget();
            String allId = all.getYear() + all.getType() + all.getBrand();
            for (TargetWrap targeChan : listChan) {
                Target chan = targeChan.getTarget();
                String chanId = chan.getYear() + chan.getType() + chan.getBrand();
                if (!chanId.equals(allId)) continue;
                listNew.add(targeChan);
                chan.setObjectType("");
                chan.setProductSubType("");
                chan.setProductType("");
                chan.setAreaId("");
                chan.setBigareaId("");
            }
            for (TargetWrap targeBig : listBig) {
                Target big = targeBig.getTarget();
                String bigId = big.getYear() + big.getType() + big.getBrand();
                if (!bigId.equals(allId)) continue;
                listNew.add(targeBig);
                big.setObjectType("");
                big.setAreaId("");
                big.setProductSubType("");
                big.setProductType("");
            }
            for (TargetWrap targeTae : lisTarea) {
                Target tar = targeTae.getTarget();
                String tarId = tar.getYear() + tar.getType() + tar.getBrand();
                if (!tarId.equals(allId)) continue;
                listNew.add(targeTae);
                tar.setObjectType("");
                tar.setProductSubType("");
                tar.setProductType("");
            }
            for (TargetWrap targeObj : listObj) {
                targeObj.getM1Data();
                obj = targeObj.getTarget();
                objId = obj.getYear() + obj.getType() + obj.getBrand();
                if (!objId.equals(allId)) continue;
                listNew.add(targeObj);
                obj.setProductSubType("");
                obj.setProductType("");
            }
            for (TargetWrap targeObj : listCus) {
                targeObj.getM1Data();
                obj = targeObj.getTarget();
                objId = obj.getYear() + obj.getType() + obj.getBrand();
                if (!StringUtils.isNotEmpty(obj.getProductSubType()) && !StringUtils.isNotEmpty(obj.getProductType()) || !(String.valueOf(objId) + obj.getProductSubType()).equals(String.valueOf(allId) + all.getProductSubType()) && !(String.valueOf(objId) + obj.getProductType()).equals(String.valueOf(allId) + all.getProductType())) continue;
                listNew.add(targeObj);
            }
            all.setObjectType("");
            all.setAreaId("");
            all.setBigareaId("");
            all.setChannelId("");
            all.setProductSubType("");
            all.setProductType("");
        }
        return listNew;
    }

    public String vIsNull(Double value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

